/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ttyaccess.h"
#include "smspdu.h"
#include "memtypes.h"
#include "scmxx_opt.h"
#include "timeincl.h"

#include <stdlib.h>
#include <stdio.h>

//from keypad.c
int keypad_dial_number (char* number);
//from dial.c
void dial (char* number, int wait);
void hangup ();

//from lock.c
int lock_get_status (const char* lock);
int lock_enable (const char* lock, const char* password);
int lock_disable (const char* lock, const char* password);
void lock_toggle (const char* lock, const char* password);
void lock_print_list (FILE* fd, unsigned int full);

//from action.c
int phone_init (int reset, struct tty_access* hw);
int command_echo (int enable);
int verbose_errors (int enable);
int pbook_select_mem (char* mem);
int sms_select_mem (char* mem, struct slot_range* r,
		    int* current_fill);
void set_smsc (char* smsnr);
void set_time ();
int  set_charset(char *charset);
char* get_revision ();
char* get_phoneserial ();
char* get_simserial ();
char* get_simid ();
char* get_operator ();
char* get_smsc ();
char* get_charset ();
char* get_battery ();
char* get_signal_ber ();
struct tm* get_time ();
char* get_netstatus (unsigned int* areacode_p, unsigned int* cellid_p);
void info (char* file, int misc, int mem, int lock);

//from s35_files.c
void file_transfer_manage (int   action, char** files,
			   char* outfile, char* pipe,
			   char* mem, int slot);
void file_delete (char* ftype, int slot);
int file_detect_free_slot (char* ftype, int minimum, int maximum);
void file_send (char* file, char* ftype, int slot);
void file_get (char* file, char* pipe,
	       char* ftype, unsigned long slot,
	       unsigned long count, unsigned long total);

//from s35_pbook.c
void pbook_manage (int action, char* outfile,
		   char** files, struct parameters* myparams);
int pbook_get_ranges (char* mem, int write, unsigned int* min,
		      unsigned int* max, int* nrlen, int* txtlen);

//from s35_sms.c
void sms_manage (int action, char** files,
		 char* outfile, char* pipe,
		 struct parameters* myparams,
		 struct smsopts* mysmsopts);
void sms_delete_slot (int smsslot);
void sms_delete_all (struct sms_slot_data** slist);
void sms_send_slot (int smsslot, char* smsnumber);
void sms_send_pdu (struct sms_pdu_raw* tpdu, int direct);
void sms_send_pdus (struct sms_pdu_raw** pdu, int direct);
void sms_send_pdu_all (struct sms_slot_data** slist, char* number, int direct);
struct sms_pdu_raw** sms_pdu_create (char* file, char* text, char* number,
				     struct smsopts* mysmsopts);
int sms_get (struct sms_slot_data** slist, size_t ssize, int slot, int mark_read);
void sms_print (FILE* filefd, char* pipe, struct sms* data);
void sms_print_all (char* file, char* pipe, struct sms_slot_data** slist,
		    char* sort_mode);
void sms_get_direct (char* file, char* pipe);
