# Singularity

[![Build Status](https://travis-ci.org/sylabs/singularity.svg?branch=master)](https://travis-ci.org/sylabs/singularity)
[![CircleCI](https://circleci.com/gh/sylabs/singularity/tree/master.svg?style=svg)](https://circleci.com/gh/sylabs/singularity/tree/master)
[![Go Report Card](https://goreportcard.com/badge/github.com/sylabs/singularity)](https://goreportcard.com/report/github.com/sylabs/singularity)

- [Guidelines for Contributing](CONTRIBUTING.md)
- [Pull Request Template](.github/PULL_REQUEST_TEMPLATE.md)
- [Project License](LICENSE.md)
- [Documentation](https://www.sylabs.io/docs/)
- [Citation](http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0177459)

Singularity is an open source container platform designed to be simple, fast, and secure. Singularity is optimized for [EPC](https://www.sylabs.io/2018/09/singularity-is-enterprise-performance-computing/) and HPC workloads, allowing untrusted users to run untrusted containers in a trusted way.

Check out [who is using Singularity](https://www.sylabs.io/singularity/whos-using-singularity/) and some [use cases of Singularity](https://sylabs.io/case-studies) on our website.

## Getting Started with Singularity

To install Singularity from source, see the [installation instructions](INSTALL.md). For other installation options, see [our website](https://www.sylabs.io/guides/3.0/user-guide/installation.html).

For system administrators, see the [administrator documentation](https://www.sylabs.io/guides/3.0/admin-guide/).

For users, see the [user documentation](https://www.sylabs.io/guides/3.5/user-guide/).

## Contributing to Singularity

Community contributions are always greatly appreciated. To start developing Singularity, check out the [guidelines for contributing](CONTRIBUTING.md).

We also welcome contributions to our [user docs](https://github.com/sylabs/singularity-userdocs) and [admin docs](https://github.com/sylabs/singularity-admindocs).

## Support

To get help with Singularity, check out the [Community Portal](https://www.sylabs.io/singularity/community/).

For additional support, [contact us](https://www.sylabs.io/contact/) to receive more information.

## Cite as:

```
Kurtzer GM, Sochat V, Bauer MW (2017) Singularity: Scientific containers for mobility of compute. PLoS ONE 12(5): e0177459. https://doi.org/10.1371/journal.pone.0177459
```

We also have a Zenodo citation:

```
Kurtzer, Gregory M.. (2016). Singularity 2.1.2 - Linux application and environment
containers for science. 10.5281/zenodo.60736

https://doi.org/10.5281/zenodo.60736
```

## License

_Unless otherwise noted, this project is licensed under a 3-clause BSD license found in the [license file](LICENSE.md)._
