/* zeitgeist-datahub.c generated by valac 0.16.0, the Vala compiler
 * generated from zeitgeist-datahub.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <zeitgeist.h>
#include "config.h"


#define TYPE_DATA_HUB_SERVICE (data_hub_service_get_type ())
#define DATA_HUB_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB_SERVICE, DataHubService))
#define IS_DATA_HUB_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB_SERVICE))
#define DATA_HUB_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATA_HUB_SERVICE, DataHubServiceIface))

typedef struct _DataHubService DataHubService;
typedef struct _DataHubServiceIface DataHubServiceIface;

#define TYPE_DATA_HUB_SERVICE_PROXY (data_hub_service_proxy_get_type ())
typedef GDBusProxy DataHubServiceProxy;
typedef GDBusProxyClass DataHubServiceProxyClass;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;
typedef struct _DataHubPrivate DataHubPrivate;

#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;

#define TYPE_RECENT_DOCUMENTS_KDE (recent_documents_kde_get_type ())
#define RECENT_DOCUMENTS_KDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDE))
#define RECENT_DOCUMENTS_KDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDEClass))
#define IS_RECENT_DOCUMENTS_KDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_DOCUMENTS_KDE))
#define IS_RECENT_DOCUMENTS_KDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_DOCUMENTS_KDE))
#define RECENT_DOCUMENTS_KDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_DOCUMENTS_KDE, RecentDocumentsKDEClass))

typedef struct _RecentDocumentsKDE RecentDocumentsKDE;
typedef struct _RecentDocumentsKDEClass RecentDocumentsKDEClass;

#define TYPE_TELEPATHY_OBSERVER (telepathy_observer_get_type ())
#define TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserver))
#define TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))
#define IS_TELEPATHY_OBSERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TELEPATHY_OBSERVER))
#define IS_TELEPATHY_OBSERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TELEPATHY_OBSERVER))
#define TELEPATHY_OBSERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TELEPATHY_OBSERVER, TelepathyObserverClass))

typedef struct _TelepathyObserver TelepathyObserver;
typedef struct _TelepathyObserverClass TelepathyObserverClass;

#define TYPE_DOWNLOADS_DIRECTORY_MONITOR (downloads_directory_monitor_get_type ())
#define DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor))
#define DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))
#define IS_DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define IS_DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define DOWNLOADS_DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))

typedef struct _DownloadsDirectoryMonitor DownloadsDirectoryMonitor;
typedef struct _DownloadsDirectoryMonitorClass DownloadsDirectoryMonitorClass;

#define TYPE_DESKTOP_LAUNCH_LISTENER (desktop_launch_listener_get_type ())
#define DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener))
#define DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))
#define IS_DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_LAUNCH_LISTENER))
#define IS_DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_LAUNCH_LISTENER))
#define DESKTOP_LAUNCH_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))

typedef struct _DesktopLaunchListener DesktopLaunchListener;
typedef struct _DesktopLaunchListenerClass DesktopLaunchListenerClass;
typedef struct _DataHubStartDataProvidersData DataHubStartDataProvidersData;
typedef struct _Block1Data Block1Data;
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
typedef struct _DataHubBatchInsertEventsData DataHubBatchInsertEventsData;

struct _DataHubServiceIface {
	GTypeInterface parent_iface;
	gchar** (*get_data_providers) (DataHubService* self, int* result_length1, GError** error);
};

struct _DataHub {
	GObject parent_instance;
	DataHubPrivate * priv;
};

struct _DataHubClass {
	GObjectClass parent_class;
};

struct _DataHubPrivate {
	ZeitgeistLog* zg_log;
	ZeitgeistDataSourceRegistry* registry;
	GMainLoop* main_loop;
	GList* providers;
	GList* sources_info;
	GPtrArray* queued_events;
	guint idle_id;
	gint _return_code;
};

struct _DataHubStartDataProvidersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DataHub* self;
	ZeitgeistDataSourceRegistry* _tmp0_;
	ZeitgeistDataSourceRegistry* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* sources;
	guint i;
	gboolean _tmp3_;
	gboolean _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GPtrArray* _tmp7_;
	guint _tmp8_;
	GPtrArray* _tmp9_;
	guint _tmp10_;
	void* _tmp11_;
	ZeitgeistDataSource* _tmp12_;
	GError* err;
	GError* _tmp13_;
	const gchar* _tmp14_;
	RecentManagerGtk* _tmp15_;
	RecentDocumentsKDE* _tmp16_;
	RecentDocumentsKDE* _tmp17_;
	TelepathyObserver* _tmp18_;
	TelepathyObserver* _tmp19_;
	DownloadsDirectoryMonitor* _tmp20_;
	DownloadsDirectoryMonitor* _tmp21_;
	gboolean _tmp22_;
	DesktopLaunchListener* _tmp23_;
	GList* _tmp24_;
	GList* prov_collection;
	GList* prov_it;
	DataProvider* prov;
	gboolean enabled;
	gint64 timestamp;
	GList* _tmp25_;
	GList* src_collection;
	GList* src_it;
	ZeitgeistDataSource* _tmp26_;
	ZeitgeistDataSource* src;
	ZeitgeistDataSource* _tmp27_;
	const gchar* _tmp28_;
	DataProvider* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	ZeitgeistDataSource* _tmp32_;
	gint64 _tmp33_;
	DataProvider* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	DataProvider* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	DataProvider* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	DataProvider* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	GPtrArray* _tmp46_;
	ZeitgeistDataSource* _tmp47_;
	ZeitgeistDataSource* _tmp48_;
	ZeitgeistDataSource* ds;
	ZeitgeistDataSourceRegistry* _tmp49_;
	ZeitgeistDataSource* _tmp50_;
	ZeitgeistDataSource* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	GError* reg_err;
	GError* _tmp54_;
	const gchar* _tmp55_;
	DataProvider* _tmp56_;
	gboolean _tmp57_;
	DataProvider* _tmp58_;
	gint64 _tmp59_;
	DataProvider* _tmp60_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	DataHub * self;
	GPtrArray* all_events;
	gpointer _async_data_;
};

struct _DataHubBatchInsertEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DataHub* self;
	Block1Data* _data1_;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint _tmp8_;
	guint elements_pushed;
	GPtrArray* _tmp9_;
	GPtrArray* ptr_arr;
	guint i;
	gboolean _tmp10_;
	gboolean _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GPtrArray* _tmp15_;
	GPtrArray* _tmp16_;
	guint _tmp17_;
	gconstpointer _tmp18_;
	ZeitgeistLog* _tmp19_;
	GPtrArray* _tmp20_;
	GArray* _tmp21_;
	GArray* _tmp22_;
	GError* err;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GPtrArray* _tmp25_;
	guint _tmp26_;
	GError * _inner_error_;
};


static gpointer data_hub_parent_class = NULL;
static DataHubServiceIface* data_hub_data_hub_service_parent_iface = NULL;

GType data_hub_service_proxy_get_type (void) G_GNUC_CONST;
guint data_hub_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType data_hub_service_get_type (void) G_GNUC_CONST;
gchar** data_hub_service_get_data_providers (DataHubService* self, int* result_length1, GError** error);
static void data_hub_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** data_hub_service_proxy_get_data_providers (DataHubService* self, int* result_length1, GError** error);
static void data_hub_service_proxy_data_hub_service_interface_init (DataHubServiceIface* iface);
static void _dbus_data_hub_service_get_data_providers (DataHubService* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void data_hub_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* data_hub_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean data_hub_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _data_hub_service_unregister_object (gpointer user_data);
GType data_hub_get_type (void) G_GNUC_CONST;
GType data_provider_get_type (void) G_GNUC_CONST;
#define DATA_HUB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_HUB, DataHubPrivate))
enum  {
	DATA_HUB_DUMMY_PROPERTY,
	DATA_HUB_RETURN_CODE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define DATA_HUB_UNIQUE_NAME "org.gnome.zeitgeist.datahub"
#define DATA_HUB_OBJECT_PATH "/org/gnome/zeitgeist/datahub"
DataHub* data_hub_new (void);
DataHub* data_hub_construct (GType object_type);
static void data_hub_data_source_registered (DataHub* self, ZeitgeistDataSource* ds);
static void data_hub_start_data_providers_data_free (gpointer _data);
static void data_hub_start_data_providers (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void data_hub_start_data_providers_finish (DataHub* self, GAsyncResult* _res_);
static gboolean data_hub_start_data_providers_co (DataHubStartDataProvidersData* _data_);
static void _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered (ZeitgeistDataSourceRegistry* _sender, ZeitgeistDataSource* source, gpointer self);
static void data_hub_start_data_providers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub);
GType recent_manager_gtk_get_type (void) G_GNUC_CONST;
RecentDocumentsKDE* recent_documents_kde_new (DataHub* datahub, GError** error);
RecentDocumentsKDE* recent_documents_kde_construct (GType object_type, DataHub* datahub, GError** error);
GType recent_documents_kde_get_type (void) G_GNUC_CONST;
TelepathyObserver* telepathy_observer_new (DataHub* datahub, GError** error);
TelepathyObserver* telepathy_observer_construct (GType object_type, DataHub* datahub, GError** error);
GType telepathy_observer_get_type (void) G_GNUC_CONST;
DownloadsDirectoryMonitor* downloads_directory_monitor_new (DataHub* datahub, GError** error);
DownloadsDirectoryMonitor* downloads_directory_monitor_construct (GType object_type, DataHub* datahub, GError** error);
GType downloads_directory_monitor_get_type (void) G_GNUC_CONST;
DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub);
DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub);
GType desktop_launch_listener_get_type (void) G_GNUC_CONST;
const gchar* data_provider_get_unique_id (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
static void data_hub_items_available (DataHub* self, DataProvider* prov, GPtrArray* events);
static void _data_hub_items_available_data_provider_items_available (DataProvider* _sender, GPtrArray* events, gpointer self);
void data_provider_set_last_timestamp (DataProvider* self, gint64 value);
void data_provider_start (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
static void __lambda8_ (DataHub* self, ZeitgeistEvent* e);
static void ___lambda8__gfunc (gconstpointer data, gpointer self);
static gboolean ___lambda9_ (DataHub* self);
static void data_hub_insert_events (DataHub* self);
static gboolean ____lambda9__gsource_func (gpointer self);
void data_hub_batch_insert_events (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void data_hub_batch_insert_events_finish (DataHub* self, GAsyncResult* _res_);
static void data_hub_batch_insert_events_data_free (gpointer _data);
static gboolean data_hub_batch_insert_events_co (DataHubBatchInsertEventsData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda10_ (Block1Data* _data1_, ZeitgeistEvent* e);
static void ___lambda10__gfunc (gconstpointer data, gpointer self);
static void _g_object_unref_gdestroy_notify (void* data);
static void data_hub_batch_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void data_hub_run (DataHub* self);
static void __lambda11_ (DataHub* self, GDBusConnection* conn);
static void ___lambda11__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda12_ (DataHub* self);
static void ___lambda12__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda13_ (DataHub* self);
static void data_hub_set_return_code (DataHub* self, gint value);
void data_hub_quit (DataHub* self);
static void ___lambda13__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static gchar** data_hub_real_get_data_providers (DataHubService* base, int* result_length1, GError** error);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
gint data_hub_main (gchar** args, int args_length1);
gint data_hub_get_return_code (DataHub* self);
static GObject * data_hub_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _data_hub___lambda14_ (DataHub* self);
static void __data_hub___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void data_hub_finalize (GObject* obj);
static void _vala_data_hub_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_data_hub_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _data_hub_service_dbus_arg_info_get_data_providers_result = {-1, "result", "as"};
static const GDBusArgInfo * const _data_hub_service_dbus_arg_info_get_data_providers_in[] = {NULL};
static const GDBusArgInfo * const _data_hub_service_dbus_arg_info_get_data_providers_out[] = {&_data_hub_service_dbus_arg_info_get_data_providers_result, NULL};
static const GDBusMethodInfo _data_hub_service_dbus_method_info_get_data_providers = {-1, "GetDataProviders", (GDBusArgInfo **) (&_data_hub_service_dbus_arg_info_get_data_providers_in), (GDBusArgInfo **) (&_data_hub_service_dbus_arg_info_get_data_providers_out)};
static const GDBusMethodInfo * const _data_hub_service_dbus_method_info[] = {&_data_hub_service_dbus_method_info_get_data_providers, NULL};
static const GDBusSignalInfo * const _data_hub_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _data_hub_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _data_hub_service_dbus_interface_info = {-1, "org.gnome.zeitgeist.datahub", (GDBusMethodInfo **) (&_data_hub_service_dbus_method_info), (GDBusSignalInfo **) (&_data_hub_service_dbus_signal_info), (GDBusPropertyInfo **) (&_data_hub_service_dbus_property_info)};
static const GDBusInterfaceVTable _data_hub_service_dbus_interface_vtable = {data_hub_service_dbus_interface_method_call, data_hub_service_dbus_interface_get_property, data_hub_service_dbus_interface_set_property};

gchar** data_hub_service_get_data_providers (DataHubService* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DATA_HUB_SERVICE_GET_INTERFACE (self)->get_data_providers (self, result_length1, error);
}


static void data_hub_service_base_init (DataHubServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType data_hub_service_get_type (void) {
	static volatile gsize data_hub_service_type_id__volatile = 0;
	if (g_once_init_enter (&data_hub_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataHubServiceIface), (GBaseInitFunc) data_hub_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType data_hub_service_type_id;
		data_hub_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "DataHubService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (data_hub_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) data_hub_service_proxy_get_type);
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.datahub");
		g_type_set_qdata (data_hub_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) data_hub_service_register_object);
		g_once_init_leave (&data_hub_service_type_id__volatile, data_hub_service_type_id);
	}
	return data_hub_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DataHubServiceProxy, data_hub_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DATA_HUB_SERVICE, data_hub_service_proxy_data_hub_service_interface_init) )
static void data_hub_service_proxy_class_init (DataHubServiceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = data_hub_service_proxy_g_signal;
}


static void data_hub_service_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void data_hub_service_proxy_init (DataHubServiceProxy* self) {
}


static gchar** data_hub_service_proxy_get_data_providers (DataHubService* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.datahub", "GetDataProviders");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void data_hub_service_proxy_data_hub_service_interface_init (DataHubServiceIface* iface) {
	iface->get_data_providers = data_hub_service_proxy_get_data_providers;
}


static void _dbus_data_hub_service_get_data_providers (DataHubService* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	int _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = data_hub_service_get_data_providers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void data_hub_service_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetDataProviders") == 0) {
		_dbus_data_hub_service_get_data_providers (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* data_hub_service_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean data_hub_service_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint data_hub_service_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_data_hub_service_dbus_interface_info), &_data_hub_service_dbus_interface_vtable, data, _data_hub_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _data_hub_service_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


DataHub* data_hub_construct (GType object_type) {
	DataHub * self = NULL;
	self = (DataHub*) g_object_new (object_type, NULL);
	return self;
}


DataHub* data_hub_new (void) {
	return data_hub_construct (TYPE_DATA_HUB);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void data_hub_data_source_registered (DataHub* self, ZeitgeistDataSource* ds) {
	GList* _tmp0_;
	GList* iter;
	GList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ds != NULL);
	_tmp0_ = self->priv->sources_info;
	iter = _tmp0_;
	while (TRUE) {
		GList* _tmp1_;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		const gchar* _tmp4_ = NULL;
		ZeitgeistDataSource* _tmp5_;
		const gchar* _tmp6_ = NULL;
		GList* _tmp7_;
		GList* _tmp8_;
		_tmp1_ = iter;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = _tmp2_->data;
		_tmp4_ = zeitgeist_data_source_get_unique_id ((ZeitgeistDataSource*) _tmp3_);
		_tmp5_ = ds;
		_tmp6_ = zeitgeist_data_source_get_unique_id (_tmp5_);
		if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
			break;
		}
		_tmp7_ = iter;
		_tmp8_ = _tmp7_->next;
		iter = _tmp8_;
	}
	_tmp9_ = iter;
	if (_tmp9_ != NULL) {
		GList* _tmp10_;
		ZeitgeistDataSource* _tmp11_;
		ZeitgeistDataSource* _tmp12_;
		_tmp10_ = iter;
		_tmp11_ = ds;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (_tmp10_->data);
		_tmp10_->data = _tmp12_;
	} else {
		ZeitgeistDataSource* _tmp13_;
		ZeitgeistDataSource* _tmp14_;
		_tmp13_ = ds;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		self->priv->sources_info = g_list_prepend (self->priv->sources_info, _tmp14_);
	}
}


static void data_hub_start_data_providers_data_free (gpointer _data) {
	DataHubStartDataProvidersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DataHubStartDataProvidersData, _data_);
}


static void data_hub_start_data_providers (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DataHubStartDataProvidersData* _data_;
	DataHub* _tmp0_;
	_data_ = g_slice_new0 (DataHubStartDataProvidersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, data_hub_start_data_providers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, data_hub_start_data_providers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	data_hub_start_data_providers_co (_data_);
}


static void data_hub_start_data_providers_finish (DataHub* self, GAsyncResult* _res_) {
	DataHubStartDataProvidersData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered (ZeitgeistDataSourceRegistry* _sender, ZeitgeistDataSource* source, gpointer self) {
	data_hub_data_source_registered (self, source);
}


static void data_hub_start_data_providers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DataHubStartDataProvidersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	data_hub_start_data_providers_co (_data_);
}


static void _data_hub_items_available_data_provider_items_available (DataProvider* _sender, GPtrArray* events, gpointer self) {
	data_hub_items_available (self, _sender, events);
}


static gboolean data_hub_start_data_providers_co (DataHubStartDataProvidersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->registry;
		g_signal_connect_object (_data_->_tmp0_, "source-registered", (GCallback) _data_hub_data_source_registered_zeitgeist_data_source_registry_source_registered, _data_->self, 0);
		_data_->_tmp1_ = _data_->self->priv->registry;
		_data_->_state_ = 1;
		zeitgeist_data_source_registry_get_data_sources (_data_->_tmp1_, NULL, data_hub_start_data_providers_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = zeitgeist_data_source_registry_get_data_sources_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		_data_->sources = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp3_ = TRUE;
				while (TRUE) {
					_data_->_tmp4_ = _data_->_tmp3_;
					if (!_data_->_tmp4_) {
						_data_->_tmp5_ = _data_->i;
						_data_->i = _data_->_tmp5_ + 1;
					}
					_data_->_tmp3_ = FALSE;
					_data_->_tmp6_ = _data_->i;
					_data_->_tmp7_ = _data_->sources;
					_data_->_tmp8_ = _data_->_tmp7_->len;
					if (!(_data_->_tmp6_ < _data_->_tmp8_)) {
						break;
					}
					_data_->_tmp9_ = _data_->sources;
					_data_->_tmp10_ = _data_->i;
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = g_ptr_array_index (_data_->_tmp9_, _data_->_tmp10_);
					_data_->_tmp12_ = _g_object_ref0 (ZEITGEIST_IS_DATA_SOURCE (_data_->_tmp11_) ? ((ZeitgeistDataSource*) _data_->_tmp11_) : NULL);
					_data_->self->priv->sources_info = g_list_prepend (_data_->self->priv->sources_info, _data_->_tmp12_);
				}
			}
		}
		_g_ptr_array_free0 (_data_->sources);
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = _data_->err;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("zeitgeist-datahub.vala:103: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->err);
	}
	__finally7:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp15_ = recent_manager_gtk_new (_data_->self);
	_data_->self->priv->providers = g_list_prepend (_data_->self->priv->providers, (DataProvider*) _data_->_tmp15_);
	_data_->_tmp16_ = recent_documents_kde_new (_data_->self, &_data_->_inner_error_);
	_data_->_tmp17_ = _data_->_tmp16_;
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->providers = g_list_prepend (_data_->self->priv->providers, (DataProvider*) _data_->_tmp17_);
	_data_->_tmp18_ = telepathy_observer_new (_data_->self, &_data_->_inner_error_);
	_data_->_tmp19_ = _data_->_tmp18_;
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->providers = g_list_prepend (_data_->self->priv->providers, (DataProvider*) _data_->_tmp19_);
	if (DOWNLOADS_MONITOR_ENABLED) {
		_data_->_tmp20_ = downloads_directory_monitor_new (_data_->self, &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp20_;
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->self->priv->providers = g_list_prepend (_data_->self->priv->providers, (DataProvider*) _data_->_tmp21_);
	}
	_data_->_tmp22_ = FALSE;
	_data_->_tmp22_ = GLIB_CHECK_VERSION ((guint) 2, (guint) 28, (guint) 0);
	if (_data_->_tmp22_) {
		_data_->_tmp23_ = desktop_launch_listener_new (_data_->self);
		_data_->self->priv->providers = g_list_prepend (_data_->self->priv->providers, (DataProvider*) _data_->_tmp23_);
	}
	_data_->_tmp24_ = _data_->self->priv->providers;
	{
		_data_->prov_collection = _data_->_tmp24_;
		for (_data_->prov_it = _data_->prov_collection; _data_->prov_it != NULL; _data_->prov_it = _data_->prov_it->next) {
			_data_->prov = (DataProvider*) _data_->prov_it->data;
			{
				_data_->enabled = TRUE;
				_data_->timestamp = (gint64) 0;
				_data_->_tmp25_ = _data_->self->priv->sources_info;
				{
					_data_->src_collection = _data_->_tmp25_;
					for (_data_->src_it = _data_->src_collection; _data_->src_it != NULL; _data_->src_it = _data_->src_it->next) {
						_data_->_tmp26_ = _g_object_ref0 ((ZeitgeistDataSource*) _data_->src_it->data);
						_data_->src = _data_->_tmp26_;
						{
							_data_->_tmp27_ = _data_->src;
							_data_->_tmp28_ = NULL;
							_data_->_tmp28_ = zeitgeist_data_source_get_unique_id (_data_->_tmp27_);
							_data_->_tmp29_ = _data_->prov;
							_data_->_tmp30_ = data_provider_get_unique_id (_data_->_tmp29_);
							_data_->_tmp31_ = _data_->_tmp30_;
							if (g_strcmp0 (_data_->_tmp28_, _data_->_tmp31_) == 0) {
								_data_->_tmp32_ = _data_->src;
								_data_->_tmp33_ = 0LL;
								_data_->_tmp33_ = zeitgeist_data_source_get_timestamp (_data_->_tmp32_);
								_data_->timestamp = _data_->_tmp33_;
								_g_object_unref0 (_data_->src);
								break;
							}
							_g_object_unref0 (_data_->src);
						}
					}
				}
				_data_->_tmp34_ = _data_->prov;
				_data_->_tmp35_ = data_provider_get_register (_data_->_tmp34_);
				_data_->_tmp36_ = _data_->_tmp35_;
				if (_data_->_tmp36_) {
					_data_->_tmp37_ = _data_->prov;
					_data_->_tmp38_ = data_provider_get_unique_id (_data_->_tmp37_);
					_data_->_tmp39_ = _data_->_tmp38_;
					_data_->_tmp40_ = _data_->prov;
					_data_->_tmp41_ = data_provider_get_name (_data_->_tmp40_);
					_data_->_tmp42_ = _data_->_tmp41_;
					_data_->_tmp43_ = _data_->prov;
					_data_->_tmp44_ = data_provider_get_description (_data_->_tmp43_);
					_data_->_tmp45_ = _data_->_tmp44_;
					_data_->_tmp46_ = g_ptr_array_new ();
					_data_->_tmp47_ = zeitgeist_data_source_new_full (_data_->_tmp39_, _data_->_tmp42_, _data_->_tmp45_, _data_->_tmp46_);
					_data_->_tmp48_ = g_object_ref_sink (_data_->_tmp47_);
					_data_->ds = _data_->_tmp48_;
					{
						_data_->_tmp49_ = _data_->self->priv->registry;
						_data_->_tmp50_ = _data_->ds;
						_data_->_tmp51_ = _g_object_ref0 (_data_->_tmp50_);
						_data_->_state_ = 2;
						zeitgeist_data_source_registry_register_data_source (_data_->_tmp49_, _data_->_tmp51_, NULL, data_hub_start_data_providers_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp52_ = FALSE;
						_data_->_tmp52_ = zeitgeist_data_source_registry_register_data_source_finish (_data_->_tmp49_, _data_->_res_, &_data_->_inner_error_);
						_data_->_tmp53_ = _data_->_tmp52_;
						if (_data_->_inner_error_ != NULL) {
							goto __catch8_g_error;
						}
						_data_->enabled = _data_->_tmp53_;
					}
					goto __finally8;
					__catch8_g_error:
					{
						_data_->reg_err = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp54_ = _data_->reg_err;
						_data_->_tmp55_ = _data_->_tmp54_->message;
						g_warning ("zeitgeist-datahub.vala:153: %s", _data_->_tmp55_);
						_g_error_free0 (_data_->reg_err);
					}
					__finally8:
					if (_data_->_inner_error_ != NULL) {
						_g_object_unref0 (_data_->ds);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_g_object_unref0 (_data_->ds);
				}
				_data_->_tmp56_ = _data_->prov;
				g_signal_connect_object (_data_->_tmp56_, "items-available", (GCallback) _data_hub_items_available_data_provider_items_available, _data_->self, 0);
				_data_->_tmp57_ = _data_->enabled;
				if (_data_->_tmp57_) {
					_data_->_tmp58_ = _data_->prov;
					_data_->_tmp59_ = _data_->timestamp;
					data_provider_set_last_timestamp (_data_->_tmp58_, _data_->_tmp59_);
					_data_->_tmp60_ = _data_->prov;
					data_provider_start (_data_->_tmp60_);
				}
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __lambda8_ (DataHub* self, ZeitgeistEvent* e) {
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	g_return_if_fail (e != NULL);
	_tmp0_ = self->priv->queued_events;
	_tmp1_ = e;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


static void ___lambda8__gfunc (gconstpointer data, gpointer self) {
	__lambda8_ (self, data);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gboolean ___lambda9_ (DataHub* self) {
	gboolean result = FALSE;
	data_hub_insert_events (self);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ____lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda9_ (self);
	return result;
}


static void data_hub_items_available (DataHub* self, DataProvider* prov, GPtrArray* events) {
	DataProvider* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GPtrArray* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prov != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = prov;
	_tmp1_ = data_provider_get_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = events;
	g_ptr_array_foreach (_tmp3_, ___lambda8__gfunc, self);
	_tmp5_ = self->priv->queued_events;
	_tmp6_ = g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		guint _tmp8_;
		_tmp8_ = self->priv->idle_id;
		_tmp4_ = _tmp8_ == ((guint) 0);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		guint _tmp10_ = 0U;
		_tmp10_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda9__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->idle_id = _tmp10_;
	}
}


static void data_hub_insert_events (DataHub* self) {
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->queued_events;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("zeitgeist-datahub.vala:184: Inserting %u events", (guint) _tmp2_);
	data_hub_batch_insert_events (self, NULL, NULL);
	_tmp3_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->queued_events);
	self->priv->queued_events = _tmp3_;
}


static void data_hub_batch_insert_events_data_free (gpointer _data) {
	DataHubBatchInsertEventsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DataHubBatchInsertEventsData, _data_);
}


void data_hub_batch_insert_events (DataHub* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DataHubBatchInsertEventsData* _data_;
	DataHub* _tmp0_;
	_data_ = g_slice_new0 (DataHubBatchInsertEventsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, data_hub_batch_insert_events);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, data_hub_batch_insert_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	data_hub_batch_insert_events_co (_data_);
}


void data_hub_batch_insert_events_finish (DataHub* self, GAsyncResult* _res_) {
	DataHubBatchInsertEventsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DataHub * self;
		self = _data1_->self;
		_g_ptr_array_unref0 (_data1_->all_events);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda10_ (Block1Data* _data1_, ZeitgeistEvent* e) {
	DataHub * self;
	GPtrArray* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	self = _data1_->self;
	g_return_if_fail (e != NULL);
	_tmp0_ = _data1_->all_events;
	_tmp1_ = e;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


static void ___lambda10__gfunc (gconstpointer data, gpointer self) {
	__lambda10_ (self, data);
}


static void _g_object_unref_gdestroy_notify (void* data) {
	g_object_unref (data);
}


static void data_hub_batch_insert_events_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DataHubBatchInsertEventsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	data_hub_batch_insert_events_co (_data_);
}


static gboolean data_hub_batch_insert_events_co (DataHubBatchInsertEventsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_data_->_data1_->all_events = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->queued_events;
	g_ptr_array_foreach (_data_->_tmp1_, ___lambda10__gfunc, _data_->_data1_);
	while (TRUE) {
		_data_->_tmp2_ = _data_->_data1_->all_events;
		_data_->_tmp3_ = g_ptr_array_get_length (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		if (!(_data_->_tmp4_ > 0)) {
			break;
		}
		_data_->_tmp5_ = _data_->_data1_->all_events;
		_data_->_tmp6_ = g_ptr_array_get_length (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = 0U;
		_data_->_tmp8_ = MIN ((guint) _data_->_tmp7_, (guint) 100);
		_data_->elements_pushed = _data_->_tmp8_;
		_data_->_tmp9_ = g_ptr_array_new_with_free_func (_g_object_unref_gdestroy_notify);
		_data_->ptr_arr = _data_->_tmp9_;
		{
			_data_->i = (guint) 0;
			{
				_data_->_tmp10_ = TRUE;
				while (TRUE) {
					_data_->_tmp11_ = _data_->_tmp10_;
					if (!_data_->_tmp11_) {
						_data_->_tmp12_ = _data_->i;
						_data_->i = _data_->_tmp12_ + 1;
					}
					_data_->_tmp10_ = FALSE;
					_data_->_tmp13_ = _data_->i;
					_data_->_tmp14_ = _data_->elements_pushed;
					if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
						break;
					}
					_data_->_tmp15_ = _data_->ptr_arr;
					_data_->_tmp16_ = _data_->_data1_->all_events;
					_data_->_tmp17_ = _data_->i;
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = g_ptr_array_index (_data_->_tmp16_, _data_->_tmp17_);
					g_ptr_array_add (_data_->_tmp15_, (ZeitgeistEvent*) _data_->_tmp18_);
				}
			}
		}
		{
			_data_->_tmp19_ = _data_->self->priv->zg_log;
			_data_->_tmp20_ = _data_->ptr_arr;
			_data_->ptr_arr = NULL;
			_data_->_state_ = 1;
			zeitgeist_log_insert_events_from_ptrarray (_data_->_tmp19_, _data_->_tmp20_, NULL, data_hub_batch_insert_events_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = zeitgeist_log_insert_events_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp22_ = _data_->_tmp21_;
			_g_array_free0 (_data_->_tmp22_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
		}
		goto __finally9;
		__catch9_g_error:
		{
			_data_->err = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp23_ = _data_->err;
			_data_->_tmp24_ = _data_->_tmp23_->message;
			g_warning ("zeitgeist-datahub.vala:211: Error during inserting events: %s", _data_->_tmp24_);
			_g_error_free0 (_data_->err);
		}
		__finally9:
		if (_data_->_inner_error_ != NULL) {
			_g_ptr_array_free0 (_data_->ptr_arr);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp25_ = _data_->_data1_->all_events;
		_data_->_tmp26_ = _data_->elements_pushed;
		g_ptr_array_remove_range (_data_->_tmp25_, (guint) 0, _data_->_tmp26_);
		_g_ptr_array_free0 (_data_->ptr_arr);
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __lambda11_ (DataHub* self, GDBusConnection* conn) {
	GDBusConnection* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	_tmp0_ = conn;
	data_hub_service_register_object (DATA_HUB_SERVICE (self), _tmp0_, DATA_HUB_OBJECT_PATH, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda11__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda11_ (self, connection);
}


static void __lambda12_ (DataHub* self) {
	data_hub_start_data_providers (self, NULL, NULL);
}


static void ___lambda12__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda12_ (self);
}


static void __lambda13_ (DataHub* self) {
	g_warning ("zeitgeist-datahub.vala:228: %s", "Unable to get name \"org.gnome.zeitgeist.datahub\"" " on the bus!");
	data_hub_set_return_code (self, 1);
	data_hub_quit (self);
}


static void ___lambda13__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda13_ (self);
}


void data_hub_run (DataHub* self) {
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, DATA_HUB_UNIQUE_NAME, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda11__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda11__gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((___lambda12__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda12__gbus_name_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((___lambda13__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda13__gbus_name_lost_callback, g_object_ref (self), g_object_unref)));
	_tmp0_ = self->priv->main_loop;
	g_main_loop_run (_tmp0_);
}


void data_hub_quit (DataHub* self) {
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	self->priv->providers = NULL;
	_tmp0_ = self->priv->main_loop;
	g_main_loop_quit (_tmp0_);
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** actors;
	gint actors_length1;
	gint _actors_size_;
	GList* _tmp1_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	actors = _tmp0_;
	actors_length1 = 0;
	_actors_size_ = actors_length1;
	_tmp1_ = self->priv->sources_info;
	{
		GList* src_collection = NULL;
		GList* src_it = NULL;
		src_collection = _tmp1_;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			ZeitgeistDataSource* src = NULL;
			src = (ZeitgeistDataSource*) src_it->data;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_;
				gboolean _tmp6_;
				ZeitgeistDataSource* _tmp7_;
				GPtrArray* _tmp8_ = NULL;
				GPtrArray* template_arr;
				GPtrArray* _tmp9_;
				_tmp3_ = only_enabled;
				if (_tmp3_) {
					ZeitgeistDataSource* _tmp4_;
					gboolean _tmp5_ = FALSE;
					_tmp4_ = src;
					_tmp5_ = zeitgeist_data_source_is_enabled (_tmp4_);
					_tmp2_ = !_tmp5_;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp6_ = _tmp2_;
				if (_tmp6_) {
					continue;
				}
				_tmp7_ = src;
				_tmp8_ = zeitgeist_data_source_get_event_templates (_tmp7_);
				template_arr = _tmp8_;
				_tmp9_ = template_arr;
				if (_tmp9_ != NULL) {
					{
						guint i;
						i = (guint) 0;
						{
							gboolean _tmp10_;
							_tmp10_ = TRUE;
							while (TRUE) {
								gboolean _tmp11_;
								guint _tmp13_;
								GPtrArray* _tmp14_;
								guint _tmp15_;
								GPtrArray* _tmp16_;
								guint _tmp17_;
								void* _tmp18_ = NULL;
								ZeitgeistEvent* event_template;
								ZeitgeistEvent* _tmp19_;
								const gchar* _tmp20_ = NULL;
								const gchar* actor;
								gboolean _tmp21_ = FALSE;
								const gchar* _tmp22_;
								gboolean _tmp24_;
								_tmp11_ = _tmp10_;
								if (!_tmp11_) {
									guint _tmp12_;
									_tmp12_ = i;
									i = _tmp12_ + 1;
								}
								_tmp10_ = FALSE;
								_tmp13_ = i;
								_tmp14_ = template_arr;
								_tmp15_ = _tmp14_->len;
								if (!(_tmp13_ < _tmp15_)) {
									break;
								}
								_tmp16_ = template_arr;
								_tmp17_ = i;
								_tmp18_ = g_ptr_array_index (_tmp16_, _tmp17_);
								event_template = ZEITGEIST_IS_EVENT (_tmp18_) ? ((ZeitgeistEvent*) _tmp18_) : NULL;
								_tmp19_ = event_template;
								_tmp20_ = zeitgeist_event_get_actor (_tmp19_);
								actor = _tmp20_;
								_tmp22_ = actor;
								if (_tmp22_ != NULL) {
									const gchar* _tmp23_;
									_tmp23_ = actor;
									_tmp21_ = g_strcmp0 (_tmp23_, "") != 0;
								} else {
									_tmp21_ = FALSE;
								}
								_tmp24_ = _tmp21_;
								if (_tmp24_) {
									gchar** _tmp25_;
									gint _tmp25__length1;
									const gchar* _tmp26_;
									gchar* _tmp27_;
									_tmp25_ = actors;
									_tmp25__length1 = actors_length1;
									_tmp26_ = actor;
									_tmp27_ = g_strdup (_tmp26_);
									_vala_array_add3 (&actors, &actors_length1, &_actors_size_, _tmp27_);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp28_ = actors;
	_tmp28__length1 = actors_length1;
	if (result_length1) {
		*result_length1 = _tmp28__length1;
	}
	result = _tmp28_;
	return result;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** data_hub_real_get_data_providers (DataHubService* base, int* result_length1, GError** error) {
	DataHub * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** arr;
	gint arr_length1;
	gint _arr_size_;
	GList* _tmp1_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	self = (DataHub*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp0_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	_tmp1_ = self->priv->providers;
	{
		GList* provider_collection = NULL;
		GList* provider_it = NULL;
		provider_collection = _tmp1_;
		for (provider_it = provider_collection; provider_it != NULL; provider_it = provider_it->next) {
			DataProvider* _tmp2_;
			DataProvider* provider = NULL;
			_tmp2_ = _g_object_ref0 ((DataProvider*) provider_it->data);
			provider = _tmp2_;
			{
				gchar** _tmp3_;
				gint _tmp3__length1;
				DataProvider* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp3_ = arr;
				_tmp3__length1 = arr_length1;
				_tmp4_ = provider;
				_tmp5_ = data_provider_get_unique_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_vala_array_add4 (&arr, &arr_length1, &_arr_size_, _tmp7_);
				_g_object_unref0 (provider);
			}
		}
	}
	_tmp8_ = arr;
	_tmp8__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


gint data_hub_main (gchar** args, int args_length1) {
	gint result = 0;
	DataHub* _tmp0_;
	DataHub* hub;
	gint _tmp1_;
	g_set_prgname ("zeitgeist-datahub");
	_tmp0_ = data_hub_new ();
	hub = _tmp0_;
	data_hub_run (hub);
	_tmp1_ = hub->priv->_return_code;
	result = _tmp1_;
	_g_object_unref0 (hub);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return data_hub_main (argv, argc);
}


gint data_hub_get_return_code (DataHub* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_return_code;
	result = _tmp0_;
	return result;
}


static void data_hub_set_return_code (DataHub* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_return_code = _tmp0_;
	g_object_notify ((GObject *) self, "return-code");
}


static void _data_hub___lambda14_ (DataHub* self) {
	ZeitgeistLog* _tmp0_;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = self->priv->zg_log;
	_tmp1_ = zeitgeist_log_is_connected (_tmp0_);
	if (!_tmp1_) {
		g_debug ("zeitgeist-datahub.vala:60: Zeitgeist-daemon disappeared from the bus, " \
"exitting...");
		data_hub_quit (self);
	}
}


static void __data_hub___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_data_hub___lambda14_ (self);
}


static GObject * data_hub_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DataHub * self;
	GPtrArray* _tmp0_;
	GMainLoop* _tmp1_;
	ZeitgeistLog* _tmp2_;
	ZeitgeistLog* _tmp3_;
	ZeitgeistDataSourceRegistry* _tmp4_;
	parent_class = G_OBJECT_CLASS (data_hub_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DATA_HUB (obj);
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	self->priv->providers = NULL;
	__g_list_free__g_object_unref0_0 (self->priv->sources_info);
	self->priv->sources_info = NULL;
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->queued_events);
	self->priv->queued_events = _tmp0_;
	_tmp1_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp1_;
	_tmp2_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp2_;
	_tmp3_ = self->priv->zg_log;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::connected", (GCallback) __data_hub___lambda14__g_object_notify, self, 0);
	_tmp4_ = zeitgeist_data_source_registry_new ();
	_g_object_unref0 (self->priv->registry);
	self->priv->registry = _tmp4_;
	return obj;
}


static void data_hub_class_init (DataHubClass * klass) {
	data_hub_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DataHubPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_data_hub_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_data_hub_set_property;
	G_OBJECT_CLASS (klass)->constructor = data_hub_constructor;
	G_OBJECT_CLASS (klass)->finalize = data_hub_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DATA_HUB_RETURN_CODE, g_param_spec_int ("return-code", "return-code", "return-code", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void data_hub_data_hub_service_interface_init (DataHubServiceIface * iface) {
	data_hub_data_hub_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_data_providers = (gchar** (*)(DataHubService*, int*, GError**)) data_hub_real_get_data_providers;
}


static void data_hub_instance_init (DataHub * self) {
	self->priv = DATA_HUB_GET_PRIVATE (self);
	self->priv->idle_id = (guint) 0;
	self->priv->_return_code = 0;
}


static void data_hub_finalize (GObject* obj) {
	DataHub * self;
	self = DATA_HUB (obj);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->registry);
	_g_main_loop_unref0 (self->priv->main_loop);
	__g_list_free__g_object_unref0_0 (self->priv->providers);
	__g_list_free__g_object_unref0_0 (self->priv->sources_info);
	_g_ptr_array_unref0 (self->priv->queued_events);
	G_OBJECT_CLASS (data_hub_parent_class)->finalize (obj);
}


GType data_hub_get_type (void) {
	static volatile gsize data_hub_type_id__volatile = 0;
	if (g_once_init_enter (&data_hub_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataHubClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_hub_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataHub), 0, (GInstanceInitFunc) data_hub_instance_init, NULL };
		static const GInterfaceInfo data_hub_service_info = { (GInterfaceInitFunc) data_hub_data_hub_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType data_hub_type_id;
		data_hub_type_id = g_type_register_static (G_TYPE_OBJECT, "DataHub", &g_define_type_info, 0);
		g_type_add_interface_static (data_hub_type_id, TYPE_DATA_HUB_SERVICE, &data_hub_service_info);
		g_once_init_leave (&data_hub_type_id__volatile, data_hub_type_id);
	}
	return data_hub_type_id__volatile;
}


static void _vala_data_hub_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DataHub * self;
	self = DATA_HUB (object);
	switch (property_id) {
		case DATA_HUB_RETURN_CODE:
		g_value_set_int (value, data_hub_get_return_code (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_data_hub_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DataHub * self;
	self = DATA_HUB (object);
	switch (property_id) {
		case DATA_HUB_RETURN_CODE:
		data_hub_set_return_code (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



