package ONVIF::Device::Types::PTZPositionFilter;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MinPosition_of :ATTR(:get<MinPosition>);
my %MaxPosition_of :ATTR(:get<MaxPosition>);
my %EnterOrExit_of :ATTR(:get<EnterOrExit>);

__PACKAGE__->_factory(
    [ qw(        MinPosition
        MaxPosition
        EnterOrExit

    ) ],
    {
        'MinPosition' => \%MinPosition_of,
        'MaxPosition' => \%MaxPosition_of,
        'EnterOrExit' => \%EnterOrExit_of,
    },
    {
        'MinPosition' => 'ONVIF::Device::Types::PTZVector',
        'MaxPosition' => 'ONVIF::Device::Types::PTZVector',
        'EnterOrExit' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'MinPosition' => 'MinPosition',
        'MaxPosition' => 'MaxPosition',
        'EnterOrExit' => 'EnterOrExit',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::PTZPositionFilter

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PTZPositionFilter from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MinPosition


=item * MaxPosition


=item * EnterOrExit




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::PTZPositionFilter
   MinPosition =>  { # ONVIF::Device::Types::PTZVector
     PanTilt => ,
     Zoom => ,
   },
   MaxPosition =>  { # ONVIF::Device::Types::PTZVector
     PanTilt => ,
     Zoom => ,
   },
   EnterOrExit =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

