/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

/**
 *
 * A stub implementation for a Container's ServletConfig object.
 * At present, we only implement the getServletContext() method to deliver
 * the "application scope" to the "servlet".
 * The intent is that if at a later point we implement the WMS for a Container, 
 * we can extend this class from a J2EE ServletConfig object to mimimize refactoring.

 * @author brownrigg
 * @version $Id: WMSServletConfig.java 3309 2007-10-16 17:25:45Z rick $
 */
public class WMSServletConfig {
    
    public WMSServletConfig() {        
    }
    
    public WMSServletContext getServletContext() { return WMSServletContext.inst(); }
    
}
