/*
 * FLUENDO S.A.
 * Copyright (C) <2005 - 2011>  <support@fluendo.com>
 */

#ifndef __FLUMP3DEC_H__
#define __FLUMP3DEC_H__

#include "gst-compat.h"
#include "mp3tl.h"

G_BEGIN_DECLS

#define GST_FLUMP3DEC_TYPE \
  (gst_flump3dec_get_type())
#define GST_FLUMP3DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_FLUMP3DEC_TYPE,GstFluMp3Dec))
#define GST_FLUMP3DEC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_FLUMP3DEC_TYPE,GstPluginTemplate))
#define IS_GST_FLUMP3DEC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_FLUMP3DEC_TYPE))
#define IS_GST_FLUMP3DEC_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_FLUMP3DEC_TYPE))

typedef struct GstFluMp3Dec GstFluMp3Dec;
typedef struct GstFluMp3DecClass GstFluMp3DecClass;

struct GstFluMp3Dec
{
  GstElement element;

  GstPad *sinkpad, *srcpad;

  Bit_stream_struc *bs;
  mp3tl *dec;

  guint rate;
  guint channels;
  guint bytes_per_sample;
  gboolean need_discont;

  GstClockTime next_ts;
  GstClockTime last_dec_ts;
  GstClockTime in_ts;

  /* Segment */
  GstSegment segment;

  /* VBR tracking */
  guint avg_bitrate;
  guint64 bitrate_sum;
  guint frame_count;

  guint last_posted_bitrate;

  gboolean bad;
  GstBuffer *pending_frame;

  /* Xing header info */
  guint32 xing_flags;
  guint32 xing_frames;
  GstClockTime xing_total_time;
  guint32 xing_bytes;
  guchar xing_seek_table[100];
  guint32 xing_vbr_scale;
};

struct GstFluMp3DecClass
{
  GstElementClass parent;
};

GType gst_flump3dec_get_type (void);

G_END_DECLS

#endif
