#!/bin/sh
# Ensure that cp --debug works as documented

# Copyright (C) 2023 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ cp

touch file || framework_failure_
cp --debug file file.cp >cp.out || fail=1
grep 'copy offload:.*reflink:.*sparse detection:' cp.out || fail=1
cp --debug --attributes-only file file.cp >cp.out || fail=1
returns_ 1 grep 'copy offload:.*reflink:.*sparse detection:' cp.out || fail=1

touch file.cp || framework_failure_
cp --debug --update=none file file.cp >cp.out || fail=1
grep 'skipped' cp.out || fail=1

Exit $fail
