; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -o - %s -mtriple=arm64-apple-ios7.0 -aarch64-enable-atomic-cfg-tidy=0 | FileCheck %s

; We've got the usual issues with LLVM reordering blocks here. The
; tests are correct for the current order, but who knows when that
; will change. Beware!
@var32 = global i32 0
@var64 = global i64 0

define i32 @test_tbz() {
; CHECK-LABEL: test_tbz:
; CHECK:       ; %bb.0:
; CHECK-NEXT:  Lloh0:
; CHECK-NEXT:    adrp x8, _var32@PAGE
; CHECK-NEXT:  Lloh1:
; CHECK-NEXT:    ldr w8, [x8, _var32@PAGEOFF]
; CHECK-NEXT:    tbz w8, #15, LBB0_5
; CHECK-NEXT:  ; %bb.1: ; %test1
; CHECK-NEXT:    tbz w8, #12, LBB0_5
; CHECK-NEXT:  ; %bb.2: ; %test2
; CHECK-NEXT:  Lloh2:
; CHECK-NEXT:    adrp x8, _var64@PAGE
; CHECK-NEXT:  Lloh3:
; CHECK-NEXT:    ldr x8, [x8, _var64@PAGEOFF]
; CHECK-NEXT:    tbz w8, #15, LBB0_5
; CHECK-NEXT:  ; %bb.3: ; %test3
; CHECK-NEXT:    tbz w8, #12, LBB0_5
; CHECK-NEXT:  ; %bb.4: ; %end2
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
; CHECK-NEXT:  LBB0_5: ; %end1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:    .loh AdrpLdr Lloh0, Lloh1
; CHECK-NEXT:    .loh AdrpLdr Lloh2, Lloh3

  %val = load i32, i32* @var32
  %val64 = load i64, i64* @var64

  %tbit0 = and i32 %val, 32768
  %tst0 = icmp ne i32 %tbit0, 0
  br i1 %tst0, label %test1, label %end1

test1:
  %tbit1 = and i32 %val, 4096
  %tst1 = icmp ne i32 %tbit1, 0
  br i1 %tst1, label %test2, label %end1

test2:
  %tbit2 = and i64 %val64, 32768
  %tst2 = icmp ne i64 %tbit2, 0
  br i1 %tst2, label %test3, label %end1

test3:
  %tbit3 = and i64 %val64, 4096
  %tst3 = icmp ne i64 %tbit3, 0
  br i1 %tst3, label %end2, label %end1

end2:
  ret i32 1

end1:
  ret i32 0
}
