; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes
; RUN: opt < %s -passes=function-attrs -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @_Z4foo1Pi(ptr nocapture readnone %a) local_unnamed_addr #0 {
; CHECK: Function Attrs: uwtable
; CHECK-LABEL: @_Z4foo1Pi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @_Z3extv()
; CHECK-NEXT:    ret void
;
entry:
  tail call void @_Z3extv()
  ret void
}

declare void @_Z3extv() local_unnamed_addr

define void @_Z4foo2Pi(ptr nocapture %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo2Pi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    tail call void @free(ptr [[A:%.*]]) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    ret void
;
entry:
  tail call void @free(ptr %a) #2
  ret void
}

declare void @free(ptr nocapture) local_unnamed_addr #2

define i32 @_Z4foo3Pi(ptr nocapture readonly %a) local_unnamed_addr #3 {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: read) uwtable
; CHECK-LABEL: @_Z4foo3Pi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load i32, ptr %a, align 4
  ret i32 %0
}

define double @_Z4foo4Pd(ptr nocapture readonly %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo4Pd(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load double, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = tail call double @cos(double [[TMP0]]) #[[ATTR2]]
; CHECK-NEXT:    ret double [[CALL]]
;
entry:
  %0 = load double, ptr %a, align 8
  %call = tail call double @cos(double %0) #2
  ret double %call
}

declare double @cos(double) local_unnamed_addr #2

define noalias ptr @_Z4foo5Pm(ptr nocapture readonly %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo5Pm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = tail call noalias ptr @malloc(i64 [[TMP0]]) #[[ATTR2]]
; CHECK-NEXT:    ret ptr [[CALL]]
;
entry:
  %0 = load i64, ptr %a, align 8
  %call = tail call noalias ptr @malloc(i64 %0) #2
  ret ptr %call
}

declare noalias ptr @malloc(i64) local_unnamed_addr #2

define noalias ptr @_Z4foo6Pm(ptr nocapture %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo6Pm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8
; CHECK-NEXT:    [[CALL:%.*]] = tail call ptr @realloc(ptr [[A]], i64 [[TMP0]]) #[[ATTR2]]
; CHECK-NEXT:    ret ptr [[CALL]]
;
entry:
  %0 = load i64, ptr %a, align 8
  %call = tail call ptr @realloc(ptr %a, i64 %0) #2
  ret ptr %call
}

declare noalias ptr @realloc(ptr nocapture, i64) local_unnamed_addr #2

define void @_Z4foo7Pi(ptr %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo7Pi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ISNULL:%.*]] = icmp eq ptr [[A:%.*]], null
; CHECK-NEXT:    br i1 [[ISNULL]], label [[DELETE_END:%.*]], label [[DELETE_NOTNULL:%.*]]
; CHECK:       delete.notnull:
; CHECK-NEXT:    tail call void @_ZdlPv(ptr [[A]]) #[[ATTR6:[0-9]+]]
; CHECK-NEXT:    br label [[DELETE_END]]
; CHECK:       delete.end:
; CHECK-NEXT:    ret void
;
entry:
  %isnull = icmp eq ptr %a, null
  br i1 %isnull, label %delete.end, label %delete.notnull

delete.notnull:                                   ; preds = %entry
  tail call void @_ZdlPv(ptr %a) #5
  br label %delete.end

delete.end:                                       ; preds = %delete.notnull, %entry
  ret void
}

declare void @_ZdlPv(ptr) local_unnamed_addr #4

define void @_Z4foo8Pi(ptr %a) local_unnamed_addr #1 {
; CHECK: Function Attrs: nounwind uwtable
; CHECK-LABEL: @_Z4foo8Pi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ISNULL:%.*]] = icmp eq ptr [[A:%.*]], null
; CHECK-NEXT:    br i1 [[ISNULL]], label [[DELETE_END:%.*]], label [[DELETE_NOTNULL:%.*]]
; CHECK:       delete.notnull:
; CHECK-NEXT:    tail call void @_ZdaPv(ptr [[A]]) #[[ATTR6]]
; CHECK-NEXT:    br label [[DELETE_END]]
; CHECK:       delete.end:
; CHECK-NEXT:    ret void
;
entry:
  %isnull = icmp eq ptr %a, null
  br i1 %isnull, label %delete.end, label %delete.notnull

delete.notnull:                                   ; preds = %entry
  tail call void @_ZdaPv(ptr %a) #5
  br label %delete.end

delete.end:                                       ; preds = %delete.notnull, %entry
  ret void
}

declare void @may_free()

define void @nofree_callsite_attr(ptr %a) {
; CHECK: Function Attrs: nofree
; CHECK-LABEL: @nofree_callsite_attr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @may_free() #[[ATTR5:[0-9]+]]
; CHECK-NEXT:    ret void
;
entry:
  call void @may_free() nofree
  ret void
}

declare void @_ZdaPv(ptr) local_unnamed_addr #4

attributes #0 = { uwtable }
attributes #1 = { nounwind uwtable }
attributes #2 = { nounwind }
attributes #3 = { norecurse nounwind readonly uwtable }
attributes #4 = { nobuiltin nounwind }
attributes #5 = { builtin nounwind }
