/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Bounds
implements Serializable {
    protected double _dX1 = 0.0;
    protected double _dY1 = 0.0;
    protected double _dX2 = 0.0;
    protected double _dY2 = 0.0;

    public Bounds(double d, double d2) {
        this._dX1 = d;
        this._dX2 = d;
        this._dY1 = d2;
        this._dY2 = d2;
    }

    public Bounds(double d, double d2, double d3, double d4) {
        this._dX1 = Math.min(d, d3);
        this._dX2 = Math.max(d, d3);
        this._dY1 = Math.min(d2, d4);
        this._dY2 = Math.max(d2, d4);
    }

    public Bounds(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public Bounds(Point2D point2D, Point2D point2D2) {
        this(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public Bounds(Bounds bounds) {
        this(bounds.getLesserX(), bounds.getLesserY(), bounds.getGreaterX(), bounds.getGreaterY());
    }

    public Bounds(Rectangle2D rectangle2D) {
        this._dX1 = rectangle2D.getMinX();
        this._dX2 = rectangle2D.getMaxX();
        this._dY1 = rectangle2D.getMinY();
        this._dY2 = rectangle2D.getMaxY();
    }

    public Bounds(Point2D point2D, double d, double d2) {
        this._dX1 = point2D.getX() - d / 2.0;
        this._dX2 = point2D.getX() + d / 2.0;
        this._dY1 = point2D.getY() - d2 / 2.0;
        this._dY2 = point2D.getY() + d2 / 2.0;
    }

    public Bounds(Dimension dimension) {
        this(0.0, 0.0, dimension.width, dimension.height);
    }

    protected Bounds() {
    }

    public double getLesserX() {
        return this._dX1;
    }

    public double getGreaterX() {
        return this._dX2;
    }

    public double getLesserY() {
        return this._dY1;
    }

    public double getGreaterY() {
        return this._dY2;
    }

    public double getWest() {
        return this._dX1;
    }

    public double getEast() {
        return this._dX2;
    }

    public double getSouth() {
        return this._dY1;
    }

    public double getNorth() {
        return this._dY2;
    }

    public double getWidth() {
        return this._dX2 - this._dX1;
    }

    public double getHeight() {
        return this._dY2 - this._dY1;
    }

    public Rectangle2D asRectangle2D() {
        return new Rectangle2D.Double(this.getLesserX(), this.getLesserY(), this.getWidth(), this.getHeight());
    }

    public void setCenter(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException();
        }
        Point2D point2D2 = this.getCenter();
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        this.offset(d, d2);
    }

    public Point2D getCenter() {
        return new Point2D.Double((this._dX1 + this._dX2) / 2.0, (this._dY1 + this._dY2) / 2.0);
    }

    public void zoomBy(double d) {
        double d2 = this._dX2 - this._dX1;
        double d3 = this._dY2 - this._dY1;
        double d4 = d2 * d;
        double d5 = d3 * d;
        Point2D point2D = this.getCenter();
        this._dX1 = point2D.getX() - d4 / 2.0;
        this._dY1 = point2D.getY() - d5 / 2.0;
        this._dX2 = point2D.getX() + d4 / 2.0;
        this._dY2 = point2D.getY() + d5 / 2.0;
    }

    public void shiftBy(int n, int n2) {
        double d = this._dX2 - this._dX1;
        double d2 = this._dY2 - this._dY1;
        double d3 = d * (double)n / 100.0;
        double d4 = d2 * (double)n2 / 100.0;
        this.offset(d3, d4);
    }

    public void offset(double d, double d2) {
        this._dX1 += d;
        this._dX2 += d;
        this._dY1 += d2;
        this._dY2 += d2;
    }

    public void expandToRatio(double d) {
        double d2;
        double d3;
        double d4;
        double d5 = this.getWidth() / this.getHeight();
        if (d5 < d) {
            d4 = d * this.getHeight();
            d3 = (this._dX1 + this._dX2) / 2.0;
            d2 = d4 / 2.0;
            this._dX1 = d3 - d2;
            this._dX2 = d3 + d2;
        }
        if (d5 > d) {
            d4 = this.getWidth() / d;
            d3 = (this._dY1 + this._dY2) / 2.0;
            d2 = d4 / 2.0;
            this._dY1 = d3 - d2;
            this._dY2 = d3 + d2;
        }
    }

    public void includeXCoordinate(double d) {
        this._dX1 = this.min(this._dX1, this._dX2, d);
        this._dX2 = this.max(this._dX1, this._dX2, d);
    }

    public void includeYCoordinate(double d) {
        this._dY1 = this.min(this._dY1, this._dY2, d);
        this._dY2 = this.max(this._dY1, this._dY2, d);
    }

    public void includePoint(double d, double d2) {
        this.includeXCoordinate(d);
        this.includeYCoordinate(d2);
    }

    public void includePoint(Point2D point2D) {
        this.includePoint(point2D.getX(), point2D.getY());
    }

    public void includeLine(double d, double d2, double d3, double d4) {
        this.includePoint(d, d2);
        this.includePoint(d3, d4);
    }

    public void includeLine(Point2D point2D, Point2D point2D2) {
        this.includeLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void includeBounds(Bounds bounds) {
        this.includeXCoordinate(bounds.getLesserX());
        this.includeXCoordinate(bounds.getGreaterX());
        this.includeYCoordinate(bounds.getLesserY());
        this.includeYCoordinate(bounds.getGreaterY());
    }

    public void includeRectangle2D(Rectangle2D rectangle2D) {
        this.includeXCoordinate(rectangle2D.getMinX());
        this.includeXCoordinate(rectangle2D.getMaxX());
        this.includeYCoordinate(rectangle2D.getMinY());
        this.includeYCoordinate(rectangle2D.getMaxY());
    }

    public void intersect(Bounds bounds) {
        this._dX1 = Math.max(this._dX1, bounds.getLesserX());
        this._dY1 = Math.max(this._dY1, bounds.getLesserY());
        this._dX2 = Math.min(this._dX2, bounds.getGreaterX());
        this._dY2 = Math.min(this._dY2, bounds.getGreaterY());
        if (this._dX1 > this._dX2) {
            this._dX1 = this._dX2;
        }
        if (this._dY1 > this._dY2) {
            this._dY1 = this._dY2;
        }
    }

    public boolean intersectsPoint(double d, double d2) {
        return this._dX1 <= d && d <= this._dX2 && this._dY1 <= d2 && d2 <= this._dY2;
    }

    public boolean intersectsPoint(Point2D point2D) {
        return this.intersectsPoint(point2D.getX(), point2D.getY());
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        if (this.intersectsPoint(d, d2)) {
            return true;
        }
        if (this.intersectsPoint(d3, d4)) {
            return true;
        }
        if (d < this._dX1 && d3 < this._dX1) {
            return false;
        }
        if (d > this._dX2 && d3 > this._dX2) {
            return false;
        }
        if (d2 < this._dY1 && d4 < this._dY1) {
            return false;
        }
        if (d2 > this._dY2 && d4 > this._dY2) {
            return false;
        }
        if (this._dX1 <= d && d <= this._dX2 && this._dX1 <= d3 && d3 <= this._dX2) {
            return true;
        }
        if (this._dY1 <= d2 && d2 <= this._dY2 && this._dY1 <= d4 && d4 <= this._dY2) {
            return true;
        }
        double d5 = (d4 - d2) / (d3 - d);
        double d6 = d5 * (this._dX1 - d) + d2;
        double d7 = d5 * (this._dX2 - d) + d2;
        double d8 = (this._dY1 - d2) / d5 + d;
        double d9 = (this._dY2 - d2) / d5 + d;
        return this.intersectsPoint(this._dX1, d6) || this.intersectsPoint(this._dX2, d7) || this.intersectsPoint(d8, this._dY1) || this.intersectsPoint(d9, this._dY2);
    }

    public boolean intersectsLine(Point2D point2D, Point2D point2D2) {
        return this.intersectsLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public boolean intersectsBounds(Bounds bounds) {
        double d = bounds.getLesserX();
        double d2 = bounds.getGreaterX();
        double d3 = bounds.getLesserY();
        double d4 = bounds.getGreaterY();
        if (d < this._dX1) {
            if (d3 < this._dY1) {
                return d2 >= this._dX1 && d4 >= this._dY1;
            }
            return d2 >= this._dX1 && d3 <= this._dY2;
        }
        if (d3 < this._dY1) {
            return d <= this._dX2 && d4 >= this._dY1;
        }
        return d <= this._dX2 && d3 <= this._dY2;
    }

    public boolean completelyContainsLine(double d, double d2, double d3, double d4) {
        return this._dX1 > Math.min(d, d3) && this._dX2 < Math.max(d, d3) && this._dY1 > Math.min(d2, d4) && this._dY2 < Math.max(d2, d4);
    }

    public boolean isCompletelyInside(Bounds bounds) {
        return this._dX1 > bounds.getLesserX() && this._dX2 < bounds.getGreaterX() && this._dY1 > bounds.getLesserY() && this._dY2 < bounds.getGreaterY();
    }

    public Point2D[] cropLine(double d, double d2, double d3, double d4) {
        if (!this.intersectsLine(d, d2, d3, d4)) {
            return null;
        }
        Point2D[] point2DArray = new Point2D[2];
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        if (((Point2D)double_).getX() == ((Point2D)double_2).getX()) {
            if (((Point2D)double_).getY() > this._dY2) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), this._dY2);
            }
            if (((Point2D)double_2).getY() > this._dY2) {
                ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), this._dY2);
            }
            if (((Point2D)double_).getY() < this._dY1) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), this._dY1);
            }
            if (((Point2D)double_2).getY() < this._dY1) {
                ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), this._dY1);
            }
        } else if (((Point2D)double_).getY() == ((Point2D)double_2).getY()) {
            if (((Point2D)double_).getX() > this._dX2) {
                ((Point2D)double_).setLocation(this._dX2, ((Point2D)double_).getY());
            }
            if (((Point2D)double_2).getX() > this._dX2) {
                ((Point2D)double_2).setLocation(this._dX2, ((Point2D)double_2).getY());
            }
            if (((Point2D)double_).getX() < this._dX1) {
                ((Point2D)double_).setLocation(this._dX1, ((Point2D)double_).getY());
            }
            if (((Point2D)double_2).getX() < this._dX1) {
                ((Point2D)double_2).setLocation(this._dX1, ((Point2D)double_2).getY());
            }
        } else {
            double d5;
            double d6 = (((Point2D)double_).getY() - ((Point2D)double_2).getY()) / (((Point2D)double_).getX() - ((Point2D)double_2).getX());
            if (!this.intersectsPoint(double_)) {
                if (((Point2D)double_).getY() > this._dY2 && (d5 = (this._dY2 - ((Point2D)double_).getY()) / d6 + ((Point2D)double_).getX()) >= this._dX1 && d5 <= this._dX2) {
                    ((Point2D)double_).setLocation(d5, ((Point2D)double_).getY());
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), this._dY2);
                }
                if (((Point2D)double_).getY() < this._dY1 && (d5 = (this._dY1 - ((Point2D)double_).getY()) / d6 + ((Point2D)double_).getX()) >= this._dX1 && d5 <= this._dX2) {
                    ((Point2D)double_).setLocation(d5, ((Point2D)double_).getY());
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), this._dY1);
                }
                if (((Point2D)double_).getX() > this._dX2 && (d5 = d6 * (this._dX2 - ((Point2D)double_).getX()) + ((Point2D)double_).getY()) >= this._dY1 && d5 <= this._dY2) {
                    ((Point2D)double_).setLocation(this._dX2, ((Point2D)double_).getY());
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), d5);
                }
                if (((Point2D)double_).getX() < this._dX1 && (d5 = d6 * (this._dX1 - ((Point2D)double_).getX()) + ((Point2D)double_).getY()) >= this._dY1 && d5 <= this._dY2) {
                    ((Point2D)double_).setLocation(this._dX1, ((Point2D)double_).getY());
                    ((Point2D)double_).setLocation(((Point2D)double_).getX(), d5);
                }
            }
            if (!this.intersectsPoint(double_2)) {
                if (((Point2D)double_2).getY() > this._dY2 && (d5 = (this._dY2 - ((Point2D)double_).getY()) / d6 + ((Point2D)double_).getX()) >= this._dX1 && d5 <= this._dX2) {
                    ((Point2D)double_2).setLocation(d5, ((Point2D)double_2).getY());
                    ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), this._dY2);
                }
                if (((Point2D)double_2).getY() < this._dY1 && (d5 = (this._dY1 - ((Point2D)double_).getY()) / d6 + ((Point2D)double_).getX()) >= this._dX1 && d5 <= this._dX2) {
                    ((Point2D)double_2).setLocation(d5, ((Point2D)double_2).getY());
                    ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), this._dY1);
                }
                if (((Point2D)double_2).getX() > this._dX2 && (d5 = d6 * (this._dX2 - ((Point2D)double_).getX()) + ((Point2D)double_).getY()) >= this._dY1 && d5 <= this._dY2) {
                    ((Point2D)double_2).setLocation(this._dX2, ((Point2D)double_2).getY());
                    ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), d5);
                }
                if (((Point2D)double_2).getX() < this._dX1 && (d5 = d6 * (this._dX1 - ((Point2D)double_).getX()) + ((Point2D)double_).getY()) >= this._dY1 && d5 <= this._dY2) {
                    ((Point2D)double_2).setLocation(this._dX1, ((Point2D)double_2).getY());
                    ((Point2D)double_2).setLocation(((Point2D)double_2).getX(), d5);
                }
            }
        }
        point2DArray[0] = double_;
        point2DArray[1] = double_2;
        return point2DArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Bounds)) {
            return false;
        }
        Bounds bounds = (Bounds)object;
        return this._dX1 == bounds.getLesserX() && this._dX2 == bounds.getGreaterX() && this._dY1 == bounds.getLesserY() && this._dY2 == bounds.getGreaterY();
    }

    public int hashCode() {
        double d;
        for (d = Math.abs(this._dX1 + this._dX2 + this._dY1 + this._dY2); d != 0.0 && d < 1.0; d *= 4.0) {
        }
        return (int)d;
    }

    public String toString() {
        return Double.toString(this._dX1) + " " + Double.toString(this._dY1) + " " + Double.toString(this._dX2) + " " + Double.toString(this._dY2);
    }

    private double min(double d, double d2, double d3) {
        return Math.min(Math.min(d, d2), d3);
    }

    private double max(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }
}

