/* GRaw.c generated by valac 0.40.4, the Vala compiler
 * generated from GRaw.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GRAW_TYPE_COLORSPACE (graw_colorspace_get_type ())

#define GRAW_TYPE_FLIP (graw_flip_get_type ())

#define GRAW_TYPE_FUJI_ROTATE (graw_fuji_rotate_get_type ())

#define GRAW_TYPE_HIGHLIGHT_MODE (graw_highlight_mode_get_type ())

#define GRAW_TYPE_INTERPOLATION_QUALITY (graw_interpolation_quality_get_type ())

#define GRAW_TYPE_USE_CAMERA_MATRIX (graw_use_camera_matrix_get_type ())

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
typedef struct _GRawProcessedImagePrivate GRawProcessedImagePrivate;
#define _free0(var) ((var == NULL) ? NULL : (var = (free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GRawParamSpecProcessedImage GRawParamSpecProcessedImage;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;
typedef struct _GRawProcessorPrivate GRawProcessorPrivate;
#define _libraw_close0(var) ((var == NULL) ? NULL : (var = (libraw_close (var), NULL)))
typedef struct _GRawParamSpecProcessor GRawParamSpecProcessor;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GRAW_COLORSPACE_RAW = 0,
	GRAW_COLORSPACE_SRGB = 1,
	GRAW_COLORSPACE_ADOBE = 2,
	GRAW_COLORSPACE_WIDE = 3,
	GRAW_COLORSPACE_PROPHOTO = 4,
	GRAW_COLORSPACE_XYZ = 5
} GRawColorspace;

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()
typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

typedef enum  {
	GRAW_FUJI_ROTATE_USE = -1,
	GRAW_FUJI_ROTATE_DONT_USE = 0
} GRawFujiRotate;

typedef enum  {
	GRAW_HIGHLIGHT_MODE_CLIP = 0,
	GRAW_HIGHLIGHT_MODE_UNCLIP = 1,
	GRAW_HIGHLIGHT_MODE_BLEND = 2,
	GRAW_HIGHLIGHT_MODE_REBUILD = 3
} GRawHighlightMode;

typedef enum  {
	GRAW_INTERPOLATION_QUALITY_LINEAR = 0,
	GRAW_INTERPOLATION_QUALITY_VNG = 1,
	GRAW_INTERPOLATION_QUALITY_PPG = 2,
	GRAW_INTERPOLATION_QUALITY_AHD = 3
} GRawInterpolationQuality;

typedef enum  {
	GRAW_USE_CAMERA_MATRIX_IGNORE = 0,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE = 1,
	GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA = 3
} GRawUseCameraMatrix;

struct _GRawProcessedImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessedImagePrivate * priv;
};

struct _GRawProcessedImageClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessedImage *self);
};

struct _GRawProcessedImagePrivate {
	libraw_processed_image_t* image;
	GdkPixbuf* pixbuf;
};

struct _GRawParamSpecProcessedImage {
	GParamSpec parent_instance;
};

struct _GRawProcessor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GRawProcessorPrivate * priv;
};

struct _GRawProcessorClass {
	GTypeClass parent_class;
	void (*finalize) (GRawProcessor *self);
};

struct _GRawProcessorPrivate {
	libraw_data_t* proc;
};

struct _GRawParamSpecProcessor {
	GParamSpec parent_instance;
};


static gpointer graw_processed_image_parent_class = NULL;
static gpointer graw_processor_parent_class = NULL;

#define GRAW_HD_POWER 2.222
#define GRAW_HD_SLOPE 4.5
#define GRAW_SRGB_POWER 2.4
#define GRAW_SRGB_SLOPE 12.92
GType graw_colorspace_get_type (void) G_GNUC_CONST;
GQuark graw_exception_quark (void);
GType graw_flip_get_type (void) G_GNUC_CONST;
GType graw_fuji_rotate_get_type (void) G_GNUC_CONST;
GType graw_highlight_mode_get_type (void) G_GNUC_CONST;
GType graw_interpolation_quality_get_type (void) G_GNUC_CONST;
GType graw_use_camera_matrix_get_type (void) G_GNUC_CONST;
gpointer graw_processed_image_ref (gpointer instance);
void graw_processed_image_unref (gpointer instance);
GParamSpec* graw_param_spec_processed_image (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void graw_value_set_processed_image (GValue* value,
                                     gpointer v_object);
void graw_value_take_processed_image (GValue* value,
                                      gpointer v_object);
gpointer graw_value_get_processed_image (const GValue* value);
GType graw_processed_image_get_type (void) G_GNUC_CONST;
#define GRAW_PROCESSED_IMAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImagePrivate))
GRawProcessedImage* graw_processed_image_new (libraw_data_t* proc,
                                              GError** error);
GRawProcessedImage* graw_processed_image_construct (GType object_type,
                                                    libraw_data_t* proc,
                                                    GError** error);
void graw_throw_exception (const gchar* caller,
                           enum LibRaw_errors _result_,
                           GError** error);
GRawProcessedImage* graw_processed_image_new_from_thumb (libraw_data_t* proc,
                                                         GError** error);
GRawProcessedImage* graw_processed_image_construct_from_thumb (GType object_type,
                                                               libraw_data_t* proc,
                                                               GError** error);
GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
gushort graw_processed_image_get_width (GRawProcessedImage* self);
gushort graw_processed_image_get_height (GRawProcessedImage* self);
gushort graw_processed_image_get_colors (GRawProcessedImage* self);
gushort graw_processed_image_get_bits (GRawProcessedImage* self);
guint8* graw_processed_image_get_data (GRawProcessedImage* self);
guint graw_processed_image_get_data_size (GRawProcessedImage* self);
static void graw_processed_image_finalize (GRawProcessedImage * obj);
gpointer graw_processor_ref (gpointer instance);
void graw_processor_unref (gpointer instance);
GParamSpec* graw_param_spec_processor (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void graw_value_set_processor (GValue* value,
                               gpointer v_object);
void graw_value_take_processor (GValue* value,
                                gpointer v_object);
gpointer graw_value_get_processor (const GValue* value);
GType graw_processor_get_type (void) G_GNUC_CONST;
#define GRAW_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GRAW_TYPE_PROCESSOR, GRawProcessorPrivate))
GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
GRawProcessor* graw_processor_construct (GType object_type,
                                         enum LibRaw_constructor_flags options);
void graw_processor_adjust_sizes_info_only (GRawProcessor* self,
                                            GError** error);
libraw_imgother_t graw_processor_get_image_other (GRawProcessor* self);
libraw_iparams_t graw_processor_get_image_params (GRawProcessor* self);
libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
libraw_thumbnail_t graw_processor_get_thumbnail (GRawProcessor* self);
GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self,
                                                   GError** error);
GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self,
                                                     GError** error);
void graw_processor_open_buffer (GRawProcessor* self,
                                 guint8* buffer,
                                 int buffer_length1,
                                 GError** error);
void graw_processor_open_file (GRawProcessor* self,
                               const gchar* filename,
                               GError** error);
void graw_processor_process (GRawProcessor* self,
                             GError** error);
void graw_processor_ppm_tiff_writer (GRawProcessor* self,
                                     const gchar* filename,
                                     GError** error);
void graw_processor_thumb_writer (GRawProcessor* self,
                                  const gchar* filename,
                                  GError** error);
void graw_processor_recycle (GRawProcessor* self);
void graw_processor_unpack (GRawProcessor* self,
                            GError** error);
void graw_processor_unpack_thumb (GRawProcessor* self,
                                  GError** error);
void graw_processor_configure_for_rgb_display (GRawProcessor* self,
                                               gboolean half_size);
libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
static void graw_processor_finalize (GRawProcessor * obj);


GType
graw_colorspace_get_type (void)
{
	static volatile gsize graw_colorspace_type_id__volatile = 0;
	if (g_once_init_enter (&graw_colorspace_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_COLORSPACE_RAW, "GRAW_COLORSPACE_RAW", "raw"}, {GRAW_COLORSPACE_SRGB, "GRAW_COLORSPACE_SRGB", "srgb"}, {GRAW_COLORSPACE_ADOBE, "GRAW_COLORSPACE_ADOBE", "adobe"}, {GRAW_COLORSPACE_WIDE, "GRAW_COLORSPACE_WIDE", "wide"}, {GRAW_COLORSPACE_PROPHOTO, "GRAW_COLORSPACE_PROPHOTO", "prophoto"}, {GRAW_COLORSPACE_XYZ, "GRAW_COLORSPACE_XYZ", "xyz"}, {0, NULL, NULL}};
		GType graw_colorspace_type_id;
		graw_colorspace_type_id = g_enum_register_static ("GRawColorspace", values);
		g_once_init_leave (&graw_colorspace_type_id__volatile, graw_colorspace_type_id);
	}
	return graw_colorspace_type_id__volatile;
}


GQuark
graw_exception_quark (void)
{
	return g_quark_from_static_string ("graw_exception-quark");
}


GType
graw_flip_get_type (void)
{
	static volatile gsize graw_flip_type_id__volatile = 0;
	if (g_once_init_enter (&graw_flip_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_FLIP_FROM_SOURCE, "GRAW_FLIP_FROM_SOURCE", "from-source"}, {GRAW_FLIP_NONE, "GRAW_FLIP_NONE", "none"}, {GRAW_FLIP_UPSIDE_DOWN, "GRAW_FLIP_UPSIDE_DOWN", "upside-down"}, {GRAW_FLIP_COUNTERCLOCKWISE, "GRAW_FLIP_COUNTERCLOCKWISE", "counterclockwise"}, {GRAW_FLIP_CLOCKWISE, "GRAW_FLIP_CLOCKWISE", "clockwise"}, {0, NULL, NULL}};
		GType graw_flip_type_id;
		graw_flip_type_id = g_enum_register_static ("GRawFlip", values);
		g_once_init_leave (&graw_flip_type_id__volatile, graw_flip_type_id);
	}
	return graw_flip_type_id__volatile;
}


GType
graw_fuji_rotate_get_type (void)
{
	static volatile gsize graw_fuji_rotate_type_id__volatile = 0;
	if (g_once_init_enter (&graw_fuji_rotate_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_FUJI_ROTATE_USE, "GRAW_FUJI_ROTATE_USE", "use"}, {GRAW_FUJI_ROTATE_DONT_USE, "GRAW_FUJI_ROTATE_DONT_USE", "dont-use"}, {0, NULL, NULL}};
		GType graw_fuji_rotate_type_id;
		graw_fuji_rotate_type_id = g_enum_register_static ("GRawFujiRotate", values);
		g_once_init_leave (&graw_fuji_rotate_type_id__volatile, graw_fuji_rotate_type_id);
	}
	return graw_fuji_rotate_type_id__volatile;
}


GType
graw_highlight_mode_get_type (void)
{
	static volatile gsize graw_highlight_mode_type_id__volatile = 0;
	if (g_once_init_enter (&graw_highlight_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_HIGHLIGHT_MODE_CLIP, "GRAW_HIGHLIGHT_MODE_CLIP", "clip"}, {GRAW_HIGHLIGHT_MODE_UNCLIP, "GRAW_HIGHLIGHT_MODE_UNCLIP", "unclip"}, {GRAW_HIGHLIGHT_MODE_BLEND, "GRAW_HIGHLIGHT_MODE_BLEND", "blend"}, {GRAW_HIGHLIGHT_MODE_REBUILD, "GRAW_HIGHLIGHT_MODE_REBUILD", "rebuild"}, {0, NULL, NULL}};
		GType graw_highlight_mode_type_id;
		graw_highlight_mode_type_id = g_enum_register_static ("GRawHighlightMode", values);
		g_once_init_leave (&graw_highlight_mode_type_id__volatile, graw_highlight_mode_type_id);
	}
	return graw_highlight_mode_type_id__volatile;
}


GType
graw_interpolation_quality_get_type (void)
{
	static volatile gsize graw_interpolation_quality_type_id__volatile = 0;
	if (g_once_init_enter (&graw_interpolation_quality_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_INTERPOLATION_QUALITY_LINEAR, "GRAW_INTERPOLATION_QUALITY_LINEAR", "linear"}, {GRAW_INTERPOLATION_QUALITY_VNG, "GRAW_INTERPOLATION_QUALITY_VNG", "vng"}, {GRAW_INTERPOLATION_QUALITY_PPG, "GRAW_INTERPOLATION_QUALITY_PPG", "ppg"}, {GRAW_INTERPOLATION_QUALITY_AHD, "GRAW_INTERPOLATION_QUALITY_AHD", "ahd"}, {0, NULL, NULL}};
		GType graw_interpolation_quality_type_id;
		graw_interpolation_quality_type_id = g_enum_register_static ("GRawInterpolationQuality", values);
		g_once_init_leave (&graw_interpolation_quality_type_id__volatile, graw_interpolation_quality_type_id);
	}
	return graw_interpolation_quality_type_id__volatile;
}


GType
graw_use_camera_matrix_get_type (void)
{
	static volatile gsize graw_use_camera_matrix_type_id__volatile = 0;
	if (g_once_init_enter (&graw_use_camera_matrix_type_id__volatile)) {
		static const GEnumValue values[] = {{GRAW_USE_CAMERA_MATRIX_IGNORE, "GRAW_USE_CAMERA_MATRIX_IGNORE", "ignore"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE", "embedded-color-profile"}, {GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA, "GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_DATA", "embedded-color-data"}, {0, NULL, NULL}};
		GType graw_use_camera_matrix_type_id;
		graw_use_camera_matrix_type_id = g_enum_register_static ("GRawUseCameraMatrix", values);
		g_once_init_leave (&graw_use_camera_matrix_type_id__volatile, graw_use_camera_matrix_type_id);
	}
	return graw_use_camera_matrix_type_id__volatile;
}


GRawProcessedImage*
graw_processed_image_construct (GType object_type,
                                libraw_data_t* proc,
                                GError** error)
{
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_processed_image_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	libraw_processed_image_t* _tmp2_;
	libraw_processed_image_t* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	libraw_processed_image_t* _tmp5_;
	gushort _tmp6_;
	libraw_processed_image_t* _tmp7_;
	gushort _tmp8_;
	libraw_processed_image_t* _tmp9_;
	gushort _tmp10_;
	libraw_processed_image_t* _tmp11_;
	gushort _tmp12_;
	libraw_processed_image_t* _tmp13_;
	gushort _tmp14_;
	GdkPixbuf* _tmp15_;
	GError * _inner_error_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (proc != NULL, NULL);
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
#line 113 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_result_ = LIBRAW_SUCCESS;
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = libraw_dcraw_make_mem_image (proc, &_result_);
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 114 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->image = _tmp0_;
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _result_;
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ProcessedImage", _tmp1_, &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 412 "GRaw.c"
		} else {
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 420 "GRaw.c"
		}
	}
#line 116 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = self->priv->image;
#line 116 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_vala_assert (_tmp2_ != NULL, "image != null");
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp4_ = _tmp3_->data;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp4__length1 = _tmp3_->data_size;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp5_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp6_ = _tmp5_->bits;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp7_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp8_ = _tmp7_->width;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp9_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp10_ = _tmp9_->height;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp11_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp12_ = _tmp11_->width;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp13_ = self->priv->image;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp14_ = _tmp13_->colors;
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp15_ = gdk_pixbuf_new_from_data (_tmp4_, GDK_COLORSPACE_RGB, FALSE, (gint) _tmp6_, (gint) _tmp8_, (gint) _tmp10_, (gint) (_tmp12_ * _tmp14_), (GdkPixbufDestroyNotify) NULL, NULL);
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 120 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->pixbuf = _tmp15_;
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 461 "GRaw.c"
}


GRawProcessedImage*
graw_processed_image_new (libraw_data_t* proc,
                          GError** error)
{
#line 112 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processed_image_construct (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
#line 471 "GRaw.c"
}


GRawProcessedImage*
graw_processed_image_construct_from_thumb (GType object_type,
                                           libraw_data_t* proc,
                                           GError** error)
{
	GRawProcessedImage* self = NULL;
	enum LibRaw_errors _result_ = 0;
	libraw_processed_image_t* _tmp0_;
	enum LibRaw_errors _tmp1_;
	libraw_processed_image_t* _tmp2_;
	libraw_processed_image_t* _tmp16_;
	GdkPixbuf* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	libraw_processed_image_t* _tmp20_;
	GdkPixbuf* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	libraw_processed_image_t* _tmp24_;
	GdkPixbuf* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	libraw_processed_image_t* _tmp28_;
	GdkPixbuf* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (proc != NULL, NULL);
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessedImage*) g_type_create_instance (object_type);
#line 125 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_result_ = LIBRAW_SUCCESS;
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = libraw_dcraw_make_mem_thumb (proc, &_result_);
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 126 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->image = _tmp0_;
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _result_;
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ProcessedImage.from_thumb", _tmp1_, &_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 528 "GRaw.c"
		} else {
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 536 "GRaw.c"
		}
	}
#line 128 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = self->priv->image;
#line 128 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_vala_assert (_tmp2_ != NULL, "image != null");
#line 543 "GRaw.c"
	{
		GBytes* bytes = NULL;
		libraw_processed_image_t* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		GBytes* _tmp5_;
		GdkPixbuf* _tmp6_ = NULL;
		GBytes* _tmp7_;
		GMemoryInputStream* _tmp8_;
		GMemoryInputStream* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp3_ = self->priv->image;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp4_ = _tmp3_->data;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp4__length1 = _tmp3_->data_size;
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp5_ = g_bytes_new_static (_tmp4_, _tmp4__length1);
#line 134 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		bytes = _tmp5_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp7_ = bytes;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp7_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp9_ = _tmp8_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp10_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp11_ = _tmp10_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (_tmp9_);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp6_ = _tmp11_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_g_bytes_unref0 (bytes);
#line 585 "GRaw.c"
			goto __catch33_g_error;
		}
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp12_ = _tmp6_;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp6_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (self->priv->pixbuf);
#line 135 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		self->priv->pixbuf = _tmp12_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_object_unref0 (_tmp6_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_bytes_unref0 (bytes);
#line 600 "GRaw.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		err = _inner_error_;
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp13_ = err;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp14_ = _tmp13_->message;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_tmp15_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp14_);
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_inner_error_ = _tmp15_;
#line 138 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		_g_error_free0 (err);
#line 623 "GRaw.c"
		goto __finally33;
	}
	__finally33:
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_graw_processed_image_unref0 (self);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 637 "GRaw.c"
		} else {
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 645 "GRaw.c"
		}
	}
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp16_ = self->priv->image;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp17_ = self->priv->pixbuf;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp19_ = _tmp18_;
#line 142 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp16_->width = (gushort) _tmp19_;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp20_ = self->priv->image;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp21_ = self->priv->pixbuf;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp23_ = _tmp22_;
#line 143 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp20_->height = (gushort) _tmp23_;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp24_ = self->priv->image;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp25_ = self->priv->pixbuf;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp26_ = gdk_pixbuf_get_n_channels (_tmp25_);
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp27_ = _tmp26_;
#line 144 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp24_->colors = (gushort) _tmp27_;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp28_ = self->priv->image;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp29_ = self->priv->pixbuf;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp30_ = gdk_pixbuf_get_bits_per_sample (_tmp29_);
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp31_ = _tmp30_;
#line 145 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp28_->bits = (gushort) _tmp31_;
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 690 "GRaw.c"
}


GRawProcessedImage*
graw_processed_image_new_from_thumb (libraw_data_t* proc,
                                     GError** error)
{
#line 124 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processed_image_construct_from_thumb (GRAW_TYPE_PROCESSED_IMAGE, proc, error);
#line 700 "GRaw.c"
}


GdkPixbuf*
graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self)
{
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->pixbuf;
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = gdk_pixbuf_copy (_tmp0_);
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 720 "GRaw.c"
}


gushort
graw_processed_image_get_width (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->width;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 740 "GRaw.c"
}


gushort
graw_processed_image_get_height (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 83 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->height;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 760 "GRaw.c"
}


gushort
graw_processed_image_get_colors (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 89 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->colors;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 90 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 780 "GRaw.c"
}


gushort
graw_processed_image_get_bits (GRawProcessedImage* self)
{
	gushort result;
	libraw_processed_image_t* _tmp0_;
	gushort _tmp1_;
#line 95 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->bits;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 800 "GRaw.c"
}


guint8*
graw_processed_image_get_data (GRawProcessedImage* self)
{
	guint8* result;
	libraw_processed_image_t* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 101 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), NULL);
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->data;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1__length1 = _tmp0_->data_size;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 823 "GRaw.c"
}


guint
graw_processed_image_get_data_size (GRawProcessedImage* self)
{
	guint result;
	libraw_processed_image_t* _tmp0_;
	guint _tmp1_;
#line 107 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSED_IMAGE (self), 0U);
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->image;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_->data_size;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp1_;
#line 108 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 843 "GRaw.c"
}


static void
graw_value_processed_image_init (GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	value->data[0].v_pointer = NULL;
#line 852 "GRaw.c"
}


static void
graw_value_processed_image_free_value (GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (value->data[0].v_pointer);
#line 863 "GRaw.c"
	}
}


static void
graw_value_processed_image_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (src_value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = graw_processed_image_ref (src_value->data[0].v_pointer);
#line 876 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = NULL;
#line 880 "GRaw.c"
	}
}


static gpointer
graw_value_processed_image_peek_pointer (const GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 890 "GRaw.c"
}


static gchar*
graw_value_processed_image_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (collect_values[0].v_pointer) {
#line 902 "GRaw.c"
		GRawProcessedImage * object;
		object = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (object->parent_instance.g_class == NULL) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 909 "GRaw.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 913 "GRaw.c"
		}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = graw_processed_image_ref (object);
#line 917 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 921 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 925 "GRaw.c"
}


static gchar*
graw_value_processed_image_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	GRawProcessedImage ** object_p;
	object_p = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!object_p) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 941 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = NULL;
#line 947 "GRaw.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = value->data[0].v_pointer;
#line 951 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = graw_processed_image_ref (value->data[0].v_pointer);
#line 955 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 959 "GRaw.c"
}


GParamSpec*
graw_param_spec_processed_image (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	GRawParamSpecProcessedImage* spec;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSED_IMAGE), NULL);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return G_PARAM_SPEC (spec);
#line 979 "GRaw.c"
}


gpointer
graw_value_get_processed_image (const GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE), NULL);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 990 "GRaw.c"
}


void
graw_value_set_processed_image (GValue* value,
                                gpointer v_object)
{
	GRawProcessedImage * old;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_ref (value->data[0].v_pointer);
#line 1013 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1017 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (old);
#line 1023 "GRaw.c"
	}
}


void
graw_value_take_processed_image (GValue* value,
                                 gpointer v_object)
{
	GRawProcessedImage * old;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSED_IMAGE));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 1045 "GRaw.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1049 "GRaw.c"
	}
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processed_image_unref (old);
#line 1055 "GRaw.c"
	}
}


static void
graw_processed_image_class_init (GRawProcessedImageClass * klass)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_processed_image_parent_class = g_type_class_peek_parent (klass);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	((GRawProcessedImageClass *) klass)->finalize = graw_processed_image_finalize;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_type_class_add_private (klass, sizeof (GRawProcessedImagePrivate));
#line 1069 "GRaw.c"
}


static void
graw_processed_image_instance_init (GRawProcessedImage * self)
{
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv = GRAW_PROCESSED_IMAGE_GET_PRIVATE (self);
#line 74 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->pixbuf = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->ref_count = 1;
#line 1082 "GRaw.c"
}


static void
graw_processed_image_finalize (GRawProcessedImage * obj)
{
	GRawProcessedImage * self;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_signal_handlers_destroy (self);
#line 73 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_free0 (self->priv->image);
#line 74 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 1098 "GRaw.c"
}


GType
graw_processed_image_get_type (void)
{
	static volatile gsize graw_processed_image_type_id__volatile = 0;
	if (g_once_init_enter (&graw_processed_image_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { graw_value_processed_image_init, graw_value_processed_image_free_value, graw_value_processed_image_copy_value, graw_value_processed_image_peek_pointer, "p", graw_value_processed_image_collect_value, "p", graw_value_processed_image_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GRawProcessedImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processed_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessedImage), 0, (GInstanceInitFunc) graw_processed_image_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType graw_processed_image_type_id;
		graw_processed_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessedImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&graw_processed_image_type_id__volatile, graw_processed_image_type_id);
	}
	return graw_processed_image_type_id__volatile;
}


gpointer
graw_processed_image_ref (gpointer instance)
{
	GRawProcessedImage * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_atomic_int_inc (&self->ref_count);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return instance;
#line 1127 "GRaw.c"
}


void
graw_processed_image_unref (gpointer instance)
{
	GRawProcessedImage * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		GRAW_PROCESSED_IMAGE_GET_CLASS (self)->finalize (self);
#line 72 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1142 "GRaw.c"
	}
}


GRawProcessor*
graw_processor_construct (GType object_type,
                          enum LibRaw_constructor_flags options)
{
	GRawProcessor* self = NULL;
	libraw_data_t* _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = (GRawProcessor*) g_type_create_instance (object_type);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = libraw_init (options);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_libraw_close0 (self->priv->proc);
#line 164 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv->proc = _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return self;
#line 1163 "GRaw.c"
}


GRawProcessor*
graw_processor_new (enum LibRaw_constructor_flags options)
{
#line 163 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return graw_processor_construct (GRAW_TYPE_PROCESSOR, options);
#line 1172 "GRaw.c"
}


void
graw_processor_adjust_sizes_info_only (GRawProcessor* self,
                                       GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("adjust_sizes_info_only", libraw_adjust_sizes_info_only (_tmp0_), &_inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1196 "GRaw.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 168 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1204 "GRaw.c"
		}
	}
}


static libraw_imgother_t
libraw_get_image_other (libraw_data_t* self)
{
	libraw_imgother_t result = {0};
	libraw_imgother_t _tmp0_;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->other;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 188 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1221 "GRaw.c"
}


libraw_imgother_t
graw_processor_get_image_other (GRawProcessor* self)
{
	libraw_imgother_t result = {0};
	libraw_data_t* _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = libraw_get_image_other (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1236 "GRaw.c"
}


static libraw_iparams_t
libraw_get_image_params (libraw_data_t* self)
{
	libraw_iparams_t result = {0};
	libraw_iparams_t _tmp0_;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->idata;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 189 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1251 "GRaw.c"
}


libraw_iparams_t
graw_processor_get_image_params (GRawProcessor* self)
{
	libraw_iparams_t result = {0};
	libraw_data_t* _tmp0_;
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = libraw_get_image_params (_tmp0_);
#line 176 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1266 "GRaw.c"
}


static libraw_image_sizes_t
libraw_get_sizes (libraw_data_t* self)
{
	libraw_image_sizes_t result = {0};
	libraw_image_sizes_t _tmp0_;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->sizes;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 192 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1281 "GRaw.c"
}


libraw_image_sizes_t
graw_processor_get_sizes (GRawProcessor* self)
{
	libraw_image_sizes_t result = {0};
	libraw_data_t* _tmp0_;
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = libraw_get_sizes (_tmp0_);
#line 180 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1296 "GRaw.c"
}


static libraw_thumbnail_t
libraw_get_thumbnail (libraw_data_t* self)
{
	libraw_thumbnail_t result = {0};
	libraw_thumbnail_t _tmp0_;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = self->thumbnail;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	result = _tmp0_;
#line 193 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	return result;
#line 1311 "GRaw.c"
}


libraw_thumbnail_t
graw_processor_get_thumbnail (GRawProcessor* self)
{
	libraw_thumbnail_t result = {0};
	libraw_data_t* _tmp0_;
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = libraw_get_thumbnail (_tmp0_);
#line 184 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1326 "GRaw.c"
}


GRawProcessedImage*
graw_processor_make_mem_image (GRawProcessor* self,
                               GError** error)
{
	GRawProcessedImage* result = NULL;
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError * _inner_error_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = self->priv->proc;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processed_image_new (_tmp1_, &_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = _tmp2_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1356 "GRaw.c"
		} else {
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1364 "GRaw.c"
		}
	}
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp0_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp3_;
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_graw_processed_image_unref0 (_tmp0_);
#line 188 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1377 "GRaw.c"
}


GRawProcessedImage*
graw_processor_make_thumb_image (GRawProcessor* self,
                                 GError** error)
{
	GRawProcessedImage* result = NULL;
	GRawProcessedImage* _tmp0_ = NULL;
	libraw_data_t* _tmp1_;
	GRawProcessedImage* _tmp2_;
	GRawProcessedImage* _tmp3_;
	GError * _inner_error_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = self->priv->proc;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processed_image_new_from_thumb (_tmp1_, &_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1407 "GRaw.c"
		} else {
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return NULL;
#line 1415 "GRaw.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp0_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = _tmp3_;
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_graw_processed_image_unref0 (_tmp0_);
#line 192 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1428 "GRaw.c"
}


void
graw_processor_open_buffer (GRawProcessor* self,
                            guint8* buffer,
                            int buffer_length1,
                            GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 195 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("open_buffer", libraw_open_buffer (_tmp0_, buffer, buffer_length1), &_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1454 "GRaw.c"
		} else {
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1462 "GRaw.c"
		}
	}
}


void
graw_processor_open_file (GRawProcessor* self,
                          const gchar* filename,
                          GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 199 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("open_file", libraw_open_file (_tmp0_, filename), &_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1491 "GRaw.c"
		} else {
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1499 "GRaw.c"
		}
	}
}


void
graw_processor_process (GRawProcessor* self,
                        GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("process", libraw_dcraw_process (_tmp0_), &_inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1525 "GRaw.c"
		} else {
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1533 "GRaw.c"
		}
	}
}


void
graw_processor_ppm_tiff_writer (GRawProcessor* self,
                                const gchar* filename,
                                GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 207 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("ppm_tiff_writer", libraw_dcraw_ppm_tiff_writer (_tmp0_, filename), &_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1562 "GRaw.c"
		} else {
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 208 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1570 "GRaw.c"
		}
	}
}


void
graw_processor_thumb_writer (GRawProcessor* self,
                             const gchar* filename,
                             GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 211 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (filename != NULL);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("thumb_writer", libraw_dcraw_thumb_writer (_tmp0_, filename), &_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1599 "GRaw.c"
		} else {
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1607 "GRaw.c"
		}
	}
}


void
graw_processor_recycle (GRawProcessor* self)
{
	libraw_data_t* _tmp0_;
#line 215 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 216 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 216 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	libraw_recycle (_tmp0_);
#line 1623 "GRaw.c"
}


void
graw_processor_unpack (GRawProcessor* self,
                       GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("unpack", libraw_unpack (_tmp0_), &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1647 "GRaw.c"
		} else {
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1655 "GRaw.c"
		}
	}
}


void
graw_processor_unpack_thumb (GRawProcessor* self,
                             GError** error)
{
	libraw_data_t* _tmp0_;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_throw_exception ("unpack_thumb", libraw_unpack_thumb (_tmp0_), &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1681 "GRaw.c"
		} else {
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			g_clear_error (&_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 1689 "GRaw.c"
		}
	}
}


static void
lib_raw_output_params_set_chromatic_aberrations (libraw_output_params_t* params,
                                                 gdouble red_multiplier,
                                                 gdouble green_multiplier)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*params).aber[0] = red_multiplier;
#line 148 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = (*params).aber[0];
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*params).aber[2] = green_multiplier;
#line 149 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp1_ = (*params).aber[2];
#line 1710 "GRaw.c"
}


static void
lib_raw_output_params_set_gamma_curve (libraw_output_params_t* params,
                                       gdouble power,
                                       gdouble slope)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*params).gamm[0] = 1.0 / power;
#line 153 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp0_ = (*params).gamm[0];
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	(*params).gamm[1] = slope;
#line 154 "/home/jens/Source/shotwell/vapi/libraw.vapi"
	_tmp1_ = (*params).gamm[1];
#line 1729 "GRaw.c"
}


void
graw_processor_configure_for_rgb_display (GRawProcessor* self,
                                          gboolean half_size)
{
	libraw_output_params_t* _tmp0_;
	libraw_output_params_t* _tmp1_;
	libraw_output_params_t* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	libraw_output_params_t* _tmp5_;
	libraw_output_params_t* _tmp6_;
	libraw_output_params_t* _tmp7_;
	libraw_output_params_t* _tmp8_;
	libraw_output_params_t* _tmp9_;
	libraw_output_params_t* _tmp10_;
	libraw_output_params_t* _tmp11_;
	libraw_output_params_t* _tmp12_;
	libraw_output_params_t* _tmp13_;
	libraw_output_params_t* _tmp14_;
	libraw_output_params_t* _tmp15_;
	libraw_output_params_t* _tmp16_;
	libraw_output_params_t* _tmp17_;
	libraw_output_params_t* _tmp18_;
	libraw_output_params_t* _tmp19_;
	libraw_output_params_t* _tmp20_;
	libraw_output_params_t* _tmp21_;
	libraw_output_params_t* _tmp22_;
	libraw_output_params_t* _tmp23_;
	libraw_output_params_t* _tmp24_;
	libraw_output_params_t* _tmp25_;
	libraw_output_params_t* _tmp26_;
	libraw_output_params_t* _tmp27_;
	libraw_output_params_t* _tmp28_;
	libraw_output_params_t* _tmp29_;
#line 230 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (GRAW_IS_PROCESSOR (self));
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = graw_processor_get_output_params (self);
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp1_ = _tmp0_;
#line 235 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	lib_raw_output_params_set_chromatic_aberrations (_tmp1_, 1.0, 1.0);
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = graw_processor_get_output_params (self);
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = _tmp2_;
#line 236 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	lib_raw_output_params_set_gamma_curve (_tmp3_, GRAW_SRGB_POWER, GRAW_SRGB_SLOPE);
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp4_ = graw_processor_get_output_params (self);
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp5_ = _tmp4_;
#line 240 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp5_).bright = 1.0f;
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp6_ = graw_processor_get_output_params (self);
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp7_ = _tmp6_;
#line 242 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp7_).half_size = half_size;
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp8_ = graw_processor_get_output_params (self);
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp9_ = _tmp8_;
#line 244 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp9_).highlight = (gint) GRAW_HIGHLIGHT_MODE_CLIP;
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp10_ = graw_processor_get_output_params (self);
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp11_ = _tmp10_;
#line 245 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp11_).use_auto_wb = TRUE;
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp12_ = graw_processor_get_output_params (self);
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp13_ = _tmp12_;
#line 246 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp13_).use_camera_wb = TRUE;
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp14_ = graw_processor_get_output_params (self);
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp15_ = _tmp14_;
#line 247 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp15_).use_camera_matrix = (gint) GRAW_USE_CAMERA_MATRIX_EMBEDDED_COLOR_PROFILE;
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp16_ = graw_processor_get_output_params (self);
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp17_ = _tmp16_;
#line 248 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp17_).output_color = (gint) GRAW_COLORSPACE_SRGB;
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp18_ = graw_processor_get_output_params (self);
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp19_ = _tmp18_;
#line 253 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp19_).output_bps = 8;
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp20_ = graw_processor_get_output_params (self);
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp21_ = _tmp20_;
#line 255 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp21_).user_flip = (gint) GRAW_FLIP_FROM_SOURCE;
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp22_ = graw_processor_get_output_params (self);
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp23_ = _tmp22_;
#line 256 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp23_).user_qual = (gint) GRAW_INTERPOLATION_QUALITY_PPG;
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp24_ = graw_processor_get_output_params (self);
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp25_ = _tmp24_;
#line 260 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp25_).no_auto_bright = TRUE;
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp26_ = graw_processor_get_output_params (self);
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp27_ = _tmp26_;
#line 261 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp27_).auto_bright_thr = 0.01f;
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp28_ = graw_processor_get_output_params (self);
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp29_ = _tmp28_;
#line 262 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	(*_tmp29_).use_fuji_rotate = (gint) GRAW_FUJI_ROTATE_USE;
#line 1859 "GRaw.c"
}


libraw_output_params_t*
graw_processor_get_output_params (GRawProcessor* self)
{
	libraw_output_params_t* result;
	libraw_data_t* _tmp0_;
#line 156 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (GRAW_IS_PROCESSOR (self), NULL);
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp0_ = self->priv->proc;
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	result = &_tmp0_->params;
#line 157 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return result;
#line 1876 "GRaw.c"
}


static void
graw_value_processor_init (GValue* value)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	value->data[0].v_pointer = NULL;
#line 1885 "GRaw.c"
}


static void
graw_value_processor_free_value (GValue* value)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (value->data[0].v_pointer);
#line 1896 "GRaw.c"
	}
}


static void
graw_value_processor_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (src_value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = graw_processor_ref (src_value->data[0].v_pointer);
#line 1909 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1913 "GRaw.c"
	}
}


static gpointer
graw_value_processor_peek_pointer (const GValue* value)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 1923 "GRaw.c"
}


static gchar*
graw_value_processor_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (collect_values[0].v_pointer) {
#line 1935 "GRaw.c"
		GRawProcessor * object;
		object = collect_values[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (object->parent_instance.g_class == NULL) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1942 "GRaw.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1946 "GRaw.c"
		}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = graw_processor_ref (object);
#line 1950 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 1954 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 1958 "GRaw.c"
}


static gchar*
graw_value_processor_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	GRawProcessor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!object_p) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1974 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (!value->data[0].v_pointer) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = NULL;
#line 1980 "GRaw.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = value->data[0].v_pointer;
#line 1984 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		*object_p = graw_processor_ref (value->data[0].v_pointer);
#line 1988 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return NULL;
#line 1992 "GRaw.c"
}


GParamSpec*
graw_param_spec_processor (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	GRawParamSpecProcessor* spec;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GRAW_TYPE_PROCESSOR), NULL);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return G_PARAM_SPEC (spec);
#line 2012 "GRaw.c"
}


gpointer
graw_value_get_processor (const GValue* value)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR), NULL);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return value->data[0].v_pointer;
#line 2023 "GRaw.c"
}


void
graw_value_set_processor (GValue* value,
                          gpointer v_object)
{
	GRawProcessor * old;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_ref (value->data[0].v_pointer);
#line 2046 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 2050 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (old);
#line 2056 "GRaw.c"
	}
}


void
graw_value_take_processor (GValue* value,
                           gpointer v_object)
{
	GRawProcessor * old;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	old = value->data[0].v_pointer;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (v_object) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GRAW_TYPE_PROCESSOR));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = v_object;
#line 2078 "GRaw.c"
	} else {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		value->data[0].v_pointer = NULL;
#line 2082 "GRaw.c"
	}
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (old) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		graw_processor_unref (old);
#line 2088 "GRaw.c"
	}
}


static void
graw_processor_class_init (GRawProcessorClass * klass)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	graw_processor_parent_class = g_type_class_peek_parent (klass);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	((GRawProcessorClass *) klass)->finalize = graw_processor_finalize;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_type_class_add_private (klass, sizeof (GRawProcessorPrivate));
#line 2102 "GRaw.c"
}


static void
graw_processor_instance_init (GRawProcessor * self)
{
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->priv = GRAW_PROCESSOR_GET_PRIVATE (self);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self->ref_count = 1;
#line 2113 "GRaw.c"
}


static void
graw_processor_finalize (GRawProcessor * obj)
{
	GRawProcessor * self;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAW_TYPE_PROCESSOR, GRawProcessor);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_signal_handlers_destroy (self);
#line 161 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_libraw_close0 (self->priv->proc);
#line 2127 "GRaw.c"
}


GType
graw_processor_get_type (void)
{
	static volatile gsize graw_processor_type_id__volatile = 0;
	if (g_once_init_enter (&graw_processor_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { graw_value_processor_init, graw_value_processor_free_value, graw_value_processor_copy_value, graw_value_processor_peek_pointer, "p", graw_value_processor_collect_value, "p", graw_value_processor_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GRawProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graw_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GRawProcessor), 0, (GInstanceInitFunc) graw_processor_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType graw_processor_type_id;
		graw_processor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GRawProcessor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&graw_processor_type_id__volatile, graw_processor_type_id);
	}
	return graw_processor_type_id__volatile;
}


gpointer
graw_processor_ref (gpointer instance)
{
	GRawProcessor * self;
	self = instance;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_atomic_int_inc (&self->ref_count);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	return instance;
#line 2156 "GRaw.c"
}


void
graw_processor_unref (gpointer instance)
{
	GRawProcessor * self;
	self = instance;
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		GRAW_PROCESSOR_GET_CLASS (self)->finalize (self);
#line 154 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2171 "GRaw.c"
	}
}


void
graw_throw_exception (const gchar* caller,
                      enum LibRaw_errors _result_,
                      GError** error)
{
	gchar* msg = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	g_return_if_fail (caller != NULL);
#line 267 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	if (_result_ == LIBRAW_SUCCESS) {
#line 268 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		return;
#line 2191 "GRaw.c"
	} else {
#line 269 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		if (_result_ > 0) {
#line 2195 "GRaw.c"
			const gchar* _tmp0_;
			GError* _tmp1_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp0_ = g_strerror ((gint) _result_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp1_ = g_error_new (GRAW_EXCEPTION, GRAW_EXCEPTION_SYSTEM_ERROR, "%s: System error %d: %s", caller, (gint) _result_, _tmp0_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp1_;
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2210 "GRaw.c"
			} else {
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 270 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2218 "GRaw.c"
			}
		}
	}
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp2_ = libraw_strerror (_result_);
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_tmp3_ = g_strdup_printf ("%s: %s", caller, _tmp2_);
#line 272 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	msg = _tmp3_;
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	switch (_result_) {
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSPECIFIED_ERROR:
#line 2232 "GRaw.c"
		{
			const gchar* _tmp4_;
			GError* _tmp5_;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp4_ = msg;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp5_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSPECIFIED, _tmp4_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp5_;
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2250 "GRaw.c"
			} else {
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2260 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_FILE_UNSUPPORTED:
#line 2265 "GRaw.c"
		{
			const gchar* _tmp6_;
			GError* _tmp7_;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp6_ = msg;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp7_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE, _tmp6_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp7_;
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2283 "GRaw.c"
			} else {
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2293 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_REQUEST_FOR_NONEXISTENT_IMAGE:
#line 2298 "GRaw.c"
		{
			const gchar* _tmp8_;
			GError* _tmp9_;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp8_ = msg;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp9_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NONEXISTANT_IMAGE, _tmp8_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp9_;
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2316 "GRaw.c"
			} else {
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2326 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_OUT_OF_ORDER_CALL:
#line 2331 "GRaw.c"
		{
			const gchar* _tmp10_;
			GError* _tmp11_;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp10_ = msg;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp11_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_ORDER_CALL, _tmp10_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp11_;
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2349 "GRaw.c"
			} else {
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 285 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2359 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_NO_THUMBNAIL:
#line 2364 "GRaw.c"
		{
			const gchar* _tmp12_;
			GError* _tmp13_;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp12_ = msg;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp13_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_NO_THUMBNAIL, _tmp12_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp13_;
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2382 "GRaw.c"
			} else {
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 288 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2392 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSUPPORTED_THUMBNAIL:
#line 2397 "GRaw.c"
		{
			const gchar* _tmp14_;
			GError* _tmp15_;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp14_ = msg;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp15_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL, _tmp14_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp15_;
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2415 "GRaw.c"
			} else {
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2425 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_UNSUFFICIENT_MEMORY:
#line 2430 "GRaw.c"
		{
			const gchar* _tmp16_;
			GError* _tmp17_;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp16_ = msg;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp17_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_OUT_OF_MEMORY, _tmp16_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp17_;
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2448 "GRaw.c"
			} else {
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 294 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2458 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_DATA_ERROR:
#line 2463 "GRaw.c"
		{
			const gchar* _tmp18_;
			GError* _tmp19_;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp18_ = msg;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp19_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_DATA_ERROR, _tmp18_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp19_;
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2481 "GRaw.c"
			} else {
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2491 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_IO_ERROR:
#line 2496 "GRaw.c"
		{
			const gchar* _tmp20_;
			GError* _tmp21_;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp20_ = msg;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp21_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_IO_ERROR, _tmp20_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp21_;
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2514 "GRaw.c"
			} else {
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 300 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2524 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_CANCELLED_BY_CALLBACK:
#line 2529 "GRaw.c"
		{
			const gchar* _tmp22_;
			GError* _tmp23_;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp22_ = msg;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp23_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_CANCELLED_BY_CALLBACK, _tmp22_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp23_;
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2547 "GRaw.c"
			} else {
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2557 "GRaw.c"
			}
		}
#line 274 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
		case LIBRAW_BAD_CROP:
#line 2562 "GRaw.c"
		{
			const gchar* _tmp24_;
			GError* _tmp25_;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp24_ = msg;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_tmp25_ = g_error_new_literal (GRAW_EXCEPTION, GRAW_EXCEPTION_BAD_CROP, _tmp24_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_inner_error_ = _tmp25_;
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_propagate_error (error, _inner_error_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2580 "GRaw.c"
			} else {
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				_g_free0 (msg);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				g_clear_error (&_inner_error_);
#line 306 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
				return;
#line 2590 "GRaw.c"
			}
		}
		default:
		{
#line 309 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			_g_free0 (msg);
#line 309 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
			return;
#line 2599 "GRaw.c"
		}
	}
#line 266 "/home/jens/Source/shotwell/src/photos/GRaw.vala"
	_g_free0 (msg);
#line 2604 "GRaw.c"
}



