/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ServiceErrorException;
import amazon.fws.clicommando.exceptions.ServiceExecutionException;
import amazon.fws.clicommando.messages.CoralMessageParser;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.ServiceResponseHandler;
import amazon.fws.clicommando.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;

public class HttpServiceResponseHandler
implements ServiceResponseHandler {
    private HttpURLConnection connection;
    private CliCommandoException exception = null;
    private String url;
    private String body;
    private String header;
    private String debugInfo;
    private int respCode;
    private String method;
    private String serverReference = null;
    private String serverErrorMessage = null;

    public HttpServiceResponseHandler(String url, String method, int responseCode, String header, String body, Command command) {
        this.respCode = responseCode;
        this.header = header;
        this.body = body;
        this.url = url;
        this.method = method;
        this.processResponse(command);
    }

    public HttpServiceResponseHandler(String url, HttpURLConnection connection, Command command) {
        this.connection = connection;
        try {
            this.respCode = connection.getResponseCode();
            this.method = connection.getRequestMethod();
        }
        catch (IOException ioe) {
            this.setDebugInfo(url, command);
            this.debugInfo = this.debugInfo + "\nConnection exception: " + ioe.getLocalizedMessage();
            this.debugInfo = this.debugInfo + "\nRequest: " + url;
            throw new ServiceErrorException(this.getDebugInfo(), "N/A", ioe.getLocalizedMessage());
        }
        this.setHeader();
        this.setBody();
        this.url = url;
        this.processResponse(command);
    }

    private void processResponse(Command command) {
        this.parseServerErrorMessage(this.getBody());
        this.setDebugInfo(this.url, command);
        this.setException();
    }

    public String getBody() {
        return this.body;
    }

    public String getResponseHeader() {
        return this.header;
    }

    public boolean isError() {
        return this.respCode >= 300;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public CliCommandoException getException() {
        return this.exception;
    }

    public String sanitizeUrl(String url, Command command) {
        return HttpServiceResponseHandler.sanitizeURL(url, command);
    }

    public static String sanitizeURL(String url, Command command) {
        String sanitizedUrl = url;
        if (StringUtils.notEmpty(url)) {
            sanitizedUrl = sanitizedUrl.replaceFirst("Signature=.+%3D", "Signature=###");
            sanitizedUrl = sanitizedUrl.replaceFirst("AWSAccessKeyId=.+?&", "AWSAccessKeyId=###&");
            if (command != null) {
                Collection<ParamConfig> params = command.getCurrentCommandConfig().getAllParameters();
                for (ParamConfig pc : params) {
                    if (!pc.isSecureInput()) continue;
                    sanitizedUrl = sanitizedUrl.replaceFirst(pc.getName() + "=.+?&", pc.getName() + "=###&");
                }
            }
        }
        return sanitizedUrl;
    }

    private void setHeader() {
        StringBuilder headers = new StringBuilder();
        for (String header : this.connection.getHeaderFields().keySet()) {
            List<String> values = this.connection.getHeaderFields().get(header);
            for (String value : values) {
                if (header == null) {
                    headers.append(value + "\n");
                    continue;
                }
                headers.append(header + ": " + value + "\n");
            }
        }
        this.header = headers.toString();
    }

    private void setBody() {
        StringBuilder response;
        block3: {
            BufferedReader reader = null;
            response = new StringBuilder();
            try {
                String line;
                reader = this.respCode >= 400 ? new BufferedReader(new InputStreamReader(this.connection.getErrorStream())) : new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    response.append(line + '\n');
                }
                reader.close();
            }
            catch (IOException ioe) {
                if (!StringUtils.isEmpty(response.toString())) break block3;
                response.append("***" + ioe.getLocalizedMessage() + "***");
            }
        }
        this.body = response.toString();
    }

    private void setDebugInfo(String url, Command command) {
        StringBuilder errMsgBuilder = new StringBuilder();
        errMsgBuilder.append("Problem with service call:\nCalled:\n" + this.sanitizeUrl(url, command));
        errMsgBuilder.append("\nHeaders:\n" + this.getResponseHeader());
        errMsgBuilder.append("\nReturn:\n" + this.getBody() + "\n");
        errMsgBuilder.append("\nCode: " + this.respCode + "\n");
        this.debugInfo = errMsgBuilder.toString();
    }

    public void setException() {
        if (this.respCode >= 300) {
            switch (this.respCode) {
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 307: {
                    if (this.method.equalsIgnoreCase("GET") || this.method.equalsIgnoreCase("HEAD")) {
                        this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.CANNOT_REDIRECT, new String[0]);
                        break;
                    }
                    this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.CANNOT_REDIRECT_USE_GET, new String[0]);
                    break;
                }
                case 400: {
                    if (this.getBody().toLowerCase().contains("throttl")) {
                        this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.THROTTLED_REQUEST, this.serverErrorMessage, this.serverReference);
                        break;
                    }
                    this.exception = new BadInputException(this.getDebugInfo(), ErrorMessages.ErrorCode.BAD_REQUEST, this.serverErrorMessage, this.serverReference);
                    break;
                }
                case 401: {
                    this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.UNAUTHORIZED_REQUEST, this.serverErrorMessage, this.serverReference);
                    break;
                }
                case 403: {
                    this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.FORBIDDEN_REQUEST, this.serverErrorMessage, this.serverReference);
                    break;
                }
                case 404: {
                    this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.SERVICE_NOT_FOUND, this.serverErrorMessage, this.serverReference);
                    break;
                }
                case 409: {
                    this.exception = new ServiceExecutionException(this.getDebugInfo(), ErrorMessages.ErrorCode.CONFLICT_IN_RESOURCE, this.serverErrorMessage, this.serverReference);
                    break;
                }
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: {
                    this.exception = new ServiceErrorException(this.getDebugInfo(), this.serverErrorMessage, this.serverReference);
                    break;
                }
                default: {
                    this.exception = new ServiceErrorException(this.getDebugInfo(), this.serverErrorMessage, this.serverReference);
                }
            }
        }
    }

    private void parseServerErrorMessage(String serverMessage) {
        String[] coral = CoralMessageParser.parse(serverMessage);
        if (coral != null) {
            this.serverErrorMessage = StringUtils.isEmpty(coral[1]) ? coral[0] : coral[1];
            this.serverReference = coral[2];
        }
    }

    public String getHeader() {
        return this.header;
    }

    public String getResponse() {
        return this.body;
    }

    public String getUrl() {
        return this.url;
    }
}

