/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDIDebugger;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class CDebugAdapter
implements ICDIDebugger {
    final ICDebugger fDebugger;

    public CDebugAdapter(ICDebugger debugger) {
        this.fDebugger = debugger;
    }

    @Override
    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        IFile[] exeFile;
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (exe == null) {
            this.abort(InternalDebugCoreMessages.CDebugAdapter_Program_file_not_specified, null, 105);
        }
        if ((exeFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(exe.getPath())).length == 0) {
            this.abort(InternalDebugCoreMessages.CDebugAdapter_0, null, -1);
        }
        int pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
        String coreFile = config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null);
        try {
            ICDISession session = pid == -1 && coreFile == null ? this.fDebugger.createLaunchSession(config, exeFile[0]) : (pid != -1 ? this.fDebugger.createAttachSession(config, exeFile[0], pid) : this.fDebugger.createCoreSession(config, exeFile[0], (IPath)new Path(coreFile)));
            Process debugger = session.getSessionProcess();
            if (debugger != null) {
                IProcess debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)this.renderDebuggerProcessLabel());
                launch.addProcess(debuggerProcess);
            }
            return session;
        }
        catch (CDIException e) {
            this.abort(e.getLocalizedMessage(), e, -1);
            throw new IllegalStateException();
        }
    }

    protected String renderDebuggerProcessLabel() {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String message = InternalDebugCoreMessages.CDebugAdapter_1;
        return MessageFormat.format((String)format, (Object[])new Object[]{message, timestamp});
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), code, message, exception);
        status.add((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = CDebugAdapter.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName != null) {
            programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
        }
        return programName;
    }

    public static IPath getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        String path = CDebugAdapter.getProgramName(configuration);
        if (path == null) {
            return null;
        }
        return new Path(path);
    }
}

