/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Hierarchy;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskIndex;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class Dimension
implements IDimension {
    protected String name = null;
    protected IDocumentManager documentManager = null;
    private IDocumentObject documentObj = null;
    private Hierarchy hierarchy = null;
    private int length = 0;
    private boolean isTime;
    private static Logger logger = Logger.getLogger(Dimension.class.getName());

    protected Dimension() {
    }

    public Dimension(String name, IDocumentManager documentManager, Hierarchy hierarchy, boolean isTime) throws DataException, IOException {
        Object[] params = new Object[]{name, documentManager, hierarchy, isTime};
        logger.entering(Dimension.class.getName(), "dimension", params);
        this.name = name;
        this.documentManager = documentManager;
        this.isTime = isTime;
        this.documentObj = documentManager.createDocumentObject(NamingUtil.getDimensionDocName(name));
        this.documentObj.writeBoolean(isTime);
        this.documentObj.writeString(hierarchy.getName());
        ILevel[] levels = hierarchy.getLevels();
        int i = 0;
        while (i < levels.length) {
            this.documentObj.writeString(levels[i].getLeveType());
            ++i;
        }
        this.hierarchy = hierarchy;
        this.length = hierarchy.size();
        this.documentObj.close();
        this.documentObj = null;
        logger.exiting(Dimension.class.getName(), "dimension");
    }

    Dimension(String name, IDocumentManager documentManager) throws IOException, DataException {
        Object[] params = new Object[]{name, documentManager};
        logger.entering(Dimension.class.getName(), "dimension", params);
        this.name = name;
        this.documentManager = documentManager;
        this.loadFromDisk();
        logger.exiting(Dimension.class.getName(), "dimension");
    }

    protected void loadFromDisk() throws IOException, DataException {
        this.documentObj = this.documentManager.openDocumentObject(NamingUtil.getDimensionDocName(this.name));
        if (this.documentObj == null) {
            throw new DataException("data.olap.DimensionNotExist", this.name);
        }
        this.isTime = this.documentObj.readBoolean();
        String hierarchyName = this.documentObj.readString();
        this.hierarchy = this.loadHierarchy(hierarchyName);
        this.hierarchy.loadFromDisk();
        this.length = this.hierarchy.size();
        Level[] levels = (Level[])this.hierarchy.getLevels();
        try {
            int i = 0;
            while (i < levels.length) {
                levels[i].setLevelType(this.documentObj.readString());
                ++i;
            }
        }
        catch (EOFException eOFException) {}
        this.documentObj.close();
        this.documentObj = null;
    }

    protected Hierarchy loadHierarchy(String hierarchyName) {
        return new Hierarchy(this.documentManager, this.name, hierarchyName);
    }

    @Override
    public IDiskArray getAllRows(StopSign stopSign) throws IOException {
        try {
            return this.hierarchy.readAllRows(stopSign);
        }
        catch (DataException e) {
            IOException ex = new IOException(e.getLocalizedMessage());
            ex.initCause((Throwable)((Object)e));
            throw ex;
        }
    }

    public DimensionRow getRowByPosition(int position) throws IOException {
        return this.hierarchy.readRowByPosition(position);
    }

    public IDiskArray getDimensionRowByPositions(IDiskArray positionArray, StopSign stopSign) throws IOException {
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionRow.getCreator(), positionArray.size());
        int i = 0;
        while (i < positionArray.size()) {
            if (stopSign.isStopped()) break;
            int pos = (Integer)positionArray.get(i);
            resultArray.add(this.hierarchy.readRowByPosition(pos));
            ++i;
        }
        return resultArray;
    }

    public DimensionRow getDimensionRowByOffset(int offset) throws IOException {
        return this.hierarchy.readRowByOffset(offset);
    }

    public IDiskArray find(Level level, Object[] keyValue) throws IOException, DataException {
        DiskIndex index = level.getDiskIndex();
        if (index == null) {
            return null;
        }
        return index.find(keyValue);
    }

    public IDiskArray findPosition(Level level, Object[] keyValue) throws IOException, DataException {
        IDiskArray indexKeyArray = this.find(level, keyValue);
        int len = 0;
        int i = 0;
        while (i < indexKeyArray.size()) {
            IndexKey key = (IndexKey)indexKeyArray.get(i);
            len += key.getDimensionPos().length;
            ++i;
        }
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(len);
        int i2 = 0;
        while (i2 < indexKeyArray.size()) {
            IndexKey key = (IndexKey)indexKeyArray.get(i2);
            int[] pos = key.getDimensionPos();
            int j = 0;
            while (j < pos.length) {
                result.add(pos[j]);
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public IndexKey findFirst(Level level, Object[] keyValue) throws IOException, DataException {
        DiskIndex index = level.getDiskIndex();
        if (index == null) {
            return null;
        }
        return index.findFirst(keyValue);
    }

    public IDiskArray find(Level[] levels, ISelection[][] filters) throws IOException, DataException {
        return DimensionFilterHelper.find(levels, filters);
    }

    public Level getDetailLevel() {
        return (Level)this.hierarchy.getLevels()[this.hierarchy.getLevels().length - 1];
    }

    @Override
    public IDiskArray findAll() throws IOException {
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(this.length);
        int lastPos = this.length() - 1;
        int i = 0;
        while (i <= lastPos) {
            result.add(i);
            ++i;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTime() {
        return this.isTime;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.hierarchy.close();
    }
}

