/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.CLICommand;
import org.eclipse.cdt.debug.mi.core.command.MIInterpreterExecConsole;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;

public class CLIProcessor {
    MISession session;

    public CLIProcessor(MISession s) {
        this.session = s;
    }

    void processStateChanges(CLICommand cmd) {
        String operation = cmd.getOperation().trim();
        this.processStateChanges(cmd.getToken(), operation);
    }

    void processStateChanges(MIInterpreterExecConsole exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processStateChanges(exec.getToken(), operations[0]);
        }
    }

    void processStateChanges(int token, String op) {
        String operation = op;
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        int type = CLIProcessor.getSteppingOperationKind(operation);
        if (type != -1) {
            this.session.getMIInferior().setRunning();
            MIRunningEvent event = new MIRunningEvent(this.session, token, type);
            this.session.fireEvent(event);
        }
    }

    void processSettingChanges(CLICommand cmd) {
        String operation = cmd.getOperation().trim();
        this.processSettingChanges(cmd.getToken(), operation);
    }

    void processSettingChanges(MIInterpreterExecConsole exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processSettingChanges(exec.getToken(), operations[0]);
        }
    }

    void processSettingChanges(int token, String command) {
        String operation = command;
        int indx = operation.indexOf(32);
        operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim();
        if (this.isSettingBreakpoint(operation) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            int hint = 0;
            if (this.isSettingBreakpoint(operation)) {
                hint = this.getBreakpointHint(command);
            }
            this.session.fireEvent(new MIBreakpointChangedEvent(this.session, 0, hint));
        } else if (this.isSettingSignal(operation)) {
            this.session.fireEvent(new MISignalChangedEvent(this.session, ""));
        } else if (this.isDetach(operation)) {
            this.session.getMIInferior().setDisconnected();
            MIDetachedEvent event = new MIDetachedEvent(this.session, token);
            this.session.fireEvent(event);
        }
    }

    static int getSteppingOperationKind(String operation) {
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.startsWith("ret") && "return".indexOf(operation) != -1) {
            type = 7;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    public static boolean isSteppingOperation(String operation) {
        int type = CLIProcessor.getSteppingOperationKind(operation);
        return type != -1;
    }

    boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1 || operation.startsWith("catch")) {
            isbreak = true;
        }
        return isbreak;
    }

    boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    int getBreakpointHint(String command) {
        StringTokenizer st = new StringTokenizer(command);
        String op = st.nextToken();
        if (op.startsWith("rb") && "rbreak".indexOf(op) != -1) {
            return 2;
        }
        if (op.equals("catch")) {
            return 4;
        }
        if (!st.hasMoreTokens()) {
            return 1;
        }
        String token = st.nextToken();
        if ("if".equals(token) || "ignore".equals(token) || token.charAt(0) == '+' || token.charAt(0) == '-') {
            return 1;
        }
        if (token.charAt(0) == '*') {
            return 3;
        }
        int index = token.lastIndexOf(58);
        String lineNumber = token;
        if (index != -1 && index + 1 < token.length()) {
            lineNumber = token.substring(index + 1, token.length());
        }
        try {
            Integer.parseInt(lineNumber);
        }
        catch (NumberFormatException numberFormatException) {
            return 2;
        }
        return 1;
    }

    boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }
}

