/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.CallbackIdUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import java.util.HashSet;
import java.util.Set;

public class TimelineIntervalAPI
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityAPI activity;
    protected Set<Integer> correlationIds = new HashSet<Integer>();

    public TimelineIntervalAPI(TimelineIntervalKind kind, CuptiActivityAPI activity) {
        super(kind, activity.start, activity.end, activity.getID());
        if (activity != null) {
            this.correlationIds.add(activity.correlationId);
        }
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        if (this.kind == TimelineIntervalKind.RUNTIME) {
            return CallbackIdUtils.getRuntimeName(this.getCallbackId(), false);
        }
        return CallbackIdUtils.getDriverName(this.getCallbackId(), false);
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return this.correlationIds;
    }

    @Override
    public int getPrimaryCorrelationId() {
        return this.activity.correlationId;
    }

    public int getCallbackId() {
        return this.activity.cbid;
    }

    public void setCorrelationId(int correlationId) {
        this.activity.correlationId = correlationId;
    }

    public int getProcessId() {
        return this.activity.processId;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

