/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.ui.ConnectionControl;
import com.nvidia.viper.ui.ImportMultipleFilesControl;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportMultipleFilesScopeControl
extends Composite {
    private final ImportMultipleFilesControl multipleFilesControl;
    private org.eclipse.swt.widgets.List multipleScopesList;
    private Text scopeText;
    private Button addButton;
    Map<String, List<Integer>> fileScopeMap;

    public ImportMultipleFilesScopeControl(Composite parent, ConnectionControl connection) {
        super(parent, 0);
        this.multipleFilesControl = new ImportMultipleFilesControl(this, connection);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.multipleFilesControl.getMultipleFilesListControl().setLayoutData((Object)new GridData(4, 4, true, false));
        Label multipleScopesLabel = new Label((Composite)this, 0);
        multipleScopesLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        multipleScopesLabel.setText("Kernel scopes:");
        this.createMultipleScopesControl();
        this.fileScopeMap = new TreeMap<String, List<Integer>>();
        this.multipleFilesControl.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("ImportMultipleFilesControl:listselectionchanged")) {
                    ImportMultipleFilesScopeControl.this.handleSelectionChanged();
                } else if (event.getPropertyName().equals("ImportMultipleFilesControl:listitemsremoved")) {
                    ImportMultipleFilesScopeControl.this.handleFileListRemoval();
                }
            }
        });
    }

    private void handleFileListRemoval() {
        String[] selectedFiles;
        String[] stringArray = selectedFiles = this.multipleFilesControl.getMultipleFilesListControl().getSelection();
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedFile = stringArray[n2];
            List<Integer> selectedScopes = this.fileScopeMap.remove(selectedFile);
            if (selectedScopes != null) {
                for (int scope : selectedScopes) {
                    this.multipleScopesList.remove(scope);
                }
            }
            ++n2;
        }
        this.reArrangeScopesList();
    }

    private void handleScopesRemoval(int scopeId) {
        for (List<Integer> scopes : this.fileScopeMap.values()) {
            for (int scope : scopes) {
                if (scope != scopeId) continue;
                scopes.remove(scope);
                return;
            }
        }
    }

    private void reArrangeScopesList() {
        ArrayList<Integer> outOfIndexEntries = new ArrayList<Integer>();
        for (List<Integer> scopeList : this.fileScopeMap.values()) {
            outOfIndexEntries.addAll(scopeList);
        }
        Collections.sort(outOfIndexEntries);
        HashMap<Integer, Integer> oldNewScopeEntriesMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < outOfIndexEntries.size()) {
            if (i != (Integer)outOfIndexEntries.get(i)) {
                oldNewScopeEntriesMap.put((Integer)outOfIndexEntries.get(i), i);
                ++i;
            }
            ++i;
        }
        for (List<Integer> scopesList : this.fileScopeMap.values()) {
            int scopeIndex = 0;
            while (scopeIndex < scopesList.size()) {
                int scope = scopesList.get(scopeIndex);
                if (oldNewScopeEntriesMap.containsKey(scope)) {
                    scopesList.set(scopeIndex, (Integer)oldNewScopeEntriesMap.get(scope));
                }
                ++scopeIndex;
            }
        }
        outOfIndexEntries.clear();
        oldNewScopeEntriesMap.clear();
    }

    private void handleSelectionChanged() {
        String[] selectedFiles;
        if (this.fileScopeMap.isEmpty()) {
            return;
        }
        this.multipleScopesList.deselectAll();
        String[] stringArray = selectedFiles = this.multipleFilesControl.getMultipleFilesListControl().getSelection();
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedFile = stringArray[n2];
            List<Integer> scopes = this.fileScopeMap.get(selectedFile);
            if (scopes != null) {
                int[] scopeArray = new int[scopes.size()];
                int scopeIndex = 0;
                while (scopeIndex < scopes.size()) {
                    scopeArray[scopeIndex] = scopes.get(scopeIndex);
                    ++scopeIndex;
                }
                this.multipleScopesList.setSelection(scopeArray);
            }
            ++n2;
        }
    }

    private String getFileFromScope(int scopeId) {
        for (String file : this.fileScopeMap.keySet()) {
            for (Integer scope : this.fileScopeMap.get(file)) {
                if (scope != scopeId) continue;
                return file;
            }
        }
        return null;
    }

    private void createMultipleScopesControl() {
        Composite multipleScopesControl = new Composite((Composite)this, 0);
        multipleScopesControl.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout multipleScopesLayout = new GridLayout(3, false);
        multipleScopesLayout.marginWidth = 0;
        multipleScopesLayout.marginHeight = 0;
        multipleScopesControl.setLayout((Layout)multipleScopesLayout);
        this.scopeText = new Text(multipleScopesControl, 2052);
        this.scopeText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.scopeText.setMessage("Add the nvprof scope used for analysis in the format <context id/name>:<stream id/name>:<kernel name>:<invocation>");
        this.scopeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ImportMultipleFilesScopeControl.this.scopeText.getText();
                int numSplitChars = text.length() - text.replace(":", "").length();
                if (numSplitChars != 3) {
                    ImportMultipleFilesScopeControl.this.addButton.setEnabled(false);
                    return;
                }
                String[] subStrings = text.split(":");
                if (subStrings.length > 4) {
                    ImportMultipleFilesScopeControl.this.addButton.setEnabled(false);
                    return;
                }
                if (subStrings.length == 4 && !subStrings[3].trim().matches("[0-9]+")) {
                    ImportMultipleFilesScopeControl.this.addButton.setEnabled(false);
                    return;
                }
                ImportMultipleFilesScopeControl.this.addButton.setEnabled(true);
            }
        });
        this.addButton = new Button(multipleScopesControl, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] selectedFiles = ImportMultipleFilesScopeControl.this.multipleFilesControl.getMultipleFilesListControl().getSelection();
                if (selectedFiles.length != 1) {
                    final String message = selectedFiles.length == 0 ? "Please select an event/metric data file to add scope" : "Please select only one event/metric data file to add scope";
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Cannot add the scope", message);
                        }
                    });
                } else {
                    ImportMultipleFilesScopeControl.this.multipleScopesList.add(ImportMultipleFilesScopeControl.this.scopeText.getText());
                    ImportMultipleFilesScopeControl.this.scopeText.setText("");
                    List<Integer> scopesList = ImportMultipleFilesScopeControl.this.fileScopeMap.get(selectedFiles[0]);
                    if (scopesList == null) {
                        scopesList = new ArrayList<Integer>();
                        ImportMultipleFilesScopeControl.this.fileScopeMap.put(selectedFiles[0], scopesList);
                    }
                    scopesList.add(ImportMultipleFilesScopeControl.this.multipleScopesList.getItemCount() - 1);
                }
            }
        });
        this.multipleScopesList = new org.eclipse.swt.widgets.List(multipleScopesControl, 2562);
        this.multipleScopesList.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.multipleScopesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices = ImportMultipleFilesScopeControl.this.multipleScopesList.getSelectionIndices();
                org.eclipse.swt.widgets.List fileList = ImportMultipleFilesScopeControl.this.multipleFilesControl.getMultipleFilesListControl();
                fileList.deselectAll();
                ArrayList<String> stringList = new ArrayList<String>();
                int[] nArray = selectionIndices;
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectionIndex = nArray[n2];
                    String file = ImportMultipleFilesScopeControl.this.getFileFromScope(selectionIndex);
                    if (file != null) {
                        stringList.add(file);
                    }
                    ++n2;
                }
                fileList.setSelection(stringList.toArray(new String[0]));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = new Button(multipleScopesControl, 8);
        removeButton.setText("Remove");
        removeButton.setLayoutData((Object)new GridData(0, 128, false, false, 1, 1));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices = ImportMultipleFilesScopeControl.this.multipleScopesList.getSelectionIndices();
                ImportMultipleFilesScopeControl.this.multipleScopesList.remove(selectionIndices);
                int[] nArray = selectionIndices;
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectionIndex = nArray[n2];
                    ImportMultipleFilesScopeControl.this.handleScopesRemoval(selectionIndex);
                    ++n2;
                }
                ImportMultipleFilesScopeControl.this.reArrangeScopesList();
            }
        });
    }

    Object parseSubString(String str, boolean numberExpected, boolean stringExpected) {
        if (str == null || str.isEmpty() || str.trim().length() == 0) {
            return null;
        }
        if (numberExpected && str.matches("[0-9]+")) {
            return Integer.parseInt(str);
        }
        if (stringExpected) {
            return str;
        }
        return null;
    }

    private SessionFilter parseScope(String item) {
        String[] subStrings = item.split(":");
        Object context = null;
        Object stream = null;
        Object kernel = null;
        Object invocation = null;
        try {
            context = this.parseSubString(subStrings[0], true, true);
            stream = this.parseSubString(subStrings[1], true, true);
            kernel = this.parseSubString(subStrings[2], false, true);
            invocation = this.parseSubString(subStrings[3], true, false);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (context != null || stream != null || kernel != null || invocation != null) {
            return new SessionFilter(context, stream, kernel, invocation);
        }
        return null;
    }

    public String[] getFiles() throws ViperException, CoreException {
        return this.multipleFilesControl.getFiles();
    }

    public List<SessionFilter> getScopes(String filename) {
        List<Integer> scopeIndices = this.fileScopeMap.get(filename);
        if (scopeIndices != null) {
            ArrayList<SessionFilter> sessionFilters = new ArrayList<SessionFilter>();
            for (int scopeIndex : scopeIndices) {
                String scopeItem = this.multipleScopesList.getItem(scopeIndex);
                SessionFilter sessionFilter = this.parseScope(scopeItem);
                sessionFilters.add(sessionFilter);
            }
            return sessionFilters;
        }
        return null;
    }
}

