/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.memory;

import com.nvidia.cuda.ide.debug.memory.CudaGdbMemoryBlockRetrieval;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.MemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;

public class CudaGdbMemoryBlockRetrievalManager
extends MemoryBlockRetrievalManager {
    private final String fModelId;
    private final DsfSession fSession;
    private final ILaunchConfiguration fLaunchConfig;
    private DsfMemoryBlockRetrieval fMemRetrieval = null;

    public CudaGdbMemoryBlockRetrievalManager(String modelId, ILaunchConfiguration config, DsfSession session) {
        super(modelId, config, session);
        this.fModelId = modelId;
        this.fSession = session;
        this.fLaunchConfig = config;
    }

    protected IMemoryBlockRetrieval createMemoryBlockRetrieval(String model, ILaunchConfiguration config, DsfSession session) {
        CudaGdbMemoryBlockRetrieval memRetrieval = null;
        try {
            memRetrieval = new CudaGdbMemoryBlockRetrieval(model, config, session);
        }
        catch (DebugException e) {
            GdbPlugin.getDefault().getLog().log(e.getStatus());
        }
        return memRetrieval;
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval(IDMContext dmc) {
        IMemory.IMemoryDMContext memDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
        if (memDmc instanceof DeviceThread) {
            if (this.fMemRetrieval == null) {
                try {
                    this.fMemRetrieval = new CudaGdbMemoryBlockRetrieval(this.fModelId, this.fLaunchConfig, this.fSession);
                }
                catch (DebugException e) {
                    GdbPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
            return this.fMemRetrieval;
        }
        return super.getMemoryBlockRetrieval(dmc);
    }
}

