/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.mi;

import com.nvidia.cuda.ide.debug.core.Activator;
import java.util.ArrayList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public abstract class AbstractMITableInfo<T>
extends MIInfo {
    private T[] entries;
    private boolean parsed;
    private final String tableName;

    public AbstractMITableInfo(MIOutput record, String tableName) {
        super(record);
        this.tableName = tableName;
    }

    public final synchronized T[] getEntries() {
        if (!this.parsed) {
            this.parse(this.getMIOutput());
        }
        return this.entries;
    }

    private void parse(MIOutput record) {
        MIResultRecord rr;
        this.entries = this.createArray(0);
        this.parsed = true;
        if (this.isDone() && (rr = record.getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue val = results[i].getMIValue();
                if (this.tableName.equals(var) && val instanceof MITuple) {
                    MIResult[] miResults = ((MITuple)val).getMIResults();
                    this.processTableContents(miResults);
                }
                ++i;
            }
        }
    }

    private void processTableContents(MIResult[] miResults) {
        MIResult[] mIResultArray = miResults;
        int n = miResults.length;
        int n2 = 0;
        while (n2 < n) {
            MIValue value;
            MIResult miResult = mIResultArray[n2];
            if ("body".equals(miResult.getVariable()) && (value = miResult.getMIValue()) instanceof MIList) {
                try {
                    MIResult[] kernelResults = ((MIList)value).getMIResults();
                    ArrayList<T> vals = new ArrayList<T>(kernelResults.length);
                    MIResult[] mIResultArray2 = kernelResults;
                    int n3 = kernelResults.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MIResult kernelResult = mIResultArray2[n4];
                        T object = this.parseEntry(kernelResult);
                        if (object != null) {
                            vals.add(object);
                        }
                        ++n4;
                    }
                    this.entries = vals.toArray(this.createArray(vals.size()));
                }
                catch (RuntimeException e) {
                    Activator.log(null, e);
                    throw e;
                }
            }
            ++n2;
        }
    }

    private T parseEntry(MIResult result) {
        T entry = this.createEntry(result.getVariable());
        if (entry != null) {
            MIResult[] attrs;
            MIResult[] mIResultArray = attrs = ((MITuple)result.getMIValue()).getMIResults();
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                MIResult attr = mIResultArray[n2];
                String var = attr.getVariable();
                String val = attr.getMIValue() instanceof MIConst ? ((MIConst)attr.getMIValue()).getCString() : null;
                try {
                    this.setEntryProperty(entry, var, val);
                }
                catch (NumberFormatException e) {
                    Activator.log(e);
                }
                ++n2;
            }
        }
        return entry;
    }

    protected abstract void setEntryProperty(T var1, String var2, String var3);

    protected abstract T createEntry(String var1);

    protected abstract T[] createArray(int var1);
}

