/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.cuda.ide.debug.service.CudaCommandFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.DebugNewProcessSequence_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class CudaDebugNewProcessSequence_7_2
extends DebugNewProcessSequence_7_2 {
    private final Map<String, Object> fAttributes;
    private String fSessionId;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private IGDBControl fGdbControl;

    public CudaDebugNewProcessSequence_7_2(DsfExecutor executor, boolean isInitial, IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        super(executor, isInitial, dmc, file, attributes, rm);
        this.fAttributes = attributes;
        this.fSessionId = dmc.getSessionId();
    }

    private String getAbsoluteFileNameFromAttr(String attributeName) {
        IStringVariableManager svm = VariablesPlugin.getDefault().getStringVariableManager();
        String value = (String)CDebugUtils.getAttribute(this.fAttributes, (String)attributeName, (Object)"");
        if ("".equalsIgnoreCase(value)) {
            return value;
        }
        try {
            value = svm.performStringSubstitution(value);
        }
        catch (CoreException coreException) {}
        String absolutePath = new Path(value).toFile().getAbsolutePath();
        return absolutePath;
    }

    @ReflectionSequence.Execute
    public void stepSpecifyCudaCoreFile(RequestMonitor rm) {
        if (this.fBackend.getSessionType() != SessionType.CORE) {
            rm.done();
            return;
        }
        String cudaCoreFile = this.getAbsoluteFileNameFromAttr("com.nvidia.cuda.ide.debug.cudaCoreFilePath");
        String coreFile = this.getAbsoluteFileNameFromAttr("org.eclipse.cdt.launch.COREFILE_PATH");
        ICommandControlService.ICommandControlDMContext context = this.fGdbControl.getContext();
        CudaCommandFactory factory = (CudaCommandFactory)this.fCommandFactory;
        ICommand<MIInfo> cmd = cudaCoreFile.length() == 0 ? factory.createMITargetSelectCore((IDMContext)context, coreFile) : (coreFile.length() == 0 ? factory.createMITargetSelectCudaCore((IDMContext)context, cudaCoreFile) : factory.createMITargetSelectCore((IDMContext)context, coreFile, cudaCoreFile));
        this.fGdbControl.queueCommand(cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    @ReflectionSequence.Execute
    public void stepInitializeSequence_7_2(RequestMonitor rm) {
        super.stepInitializeSequence_7_2(rm);
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSessionId);
        this.fGdbControl = (IGDBControl)tracker.getService(IGDBControl.class);
        this.fBackend = (IGDBBackend)tracker.getService(IGDBBackend.class);
        tracker.dispose();
        this.fCommandFactory = this.fGdbControl != null ? this.fGdbControl.getCommandFactory() : null;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.add(orderList.indexOf("stepSpecifyCoreFile") + 1, "stepSpecifyCudaCoreFile");
            orderList.remove("stepSpecifyCoreFile");
            return orderList.toArray(new String[orderList.size()]);
        }
        return null;
    }
}

