/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.common.device.ICudaDevice;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.ui.RemodeSolibBlock;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.devices.CudaDevice;
import com.nvidia.cuda.ide.sdk.CudaSDKCore;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GDBSolibBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.IMILaunchConfigurationComponent;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.SolibSearchPathBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class CudaDebuggerPage
extends AbstractCDebuggerPage
implements Observer {
    private Combo fApiFailureCombo;
    protected Button[] fDevices;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    private boolean fIsInitializing = false;
    private Button fKernelEvents;
    private Button fMemcheck;
    private IMILaunchConfigurationComponent fSolibBlock;
    protected TabFolder fTabFolder;
    protected Button fUpdateThreadlistOnSuspend;
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CudaDebuggerPage.this.updateLaunchConfigurationDialog();
        }
    };
    private final Mode mode;
    private Button fValueExtrapolation;

    public CudaDebuggerPage(Mode mode) {
        this.mode = mode;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private Button addCheckbox(Composite parent, String label) {
        Button button = ControlFactory.createCheckBox((Composite)parent, (String)label);
        button.addSelectionListener(this.listener);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        button.setLayoutData((Object)gd);
        return button;
    }

    public void applyLocalLaunchAttributes(ILaunchConfigurationWorkingCopy configuration) {
        if (this.mode != Mode.Core) {
            configuration.setAttribute("breakOnError", this.fApiFailureCombo.getText());
            configuration.setAttribute("lc.kernelevents", this.fKernelEvents.getSelection());
            configuration.setAttribute("lc.extrapolate", this.fValueExtrapolation.getSelection());
        }
        if (this.fMemcheck != null) {
            configuration.setAttribute("lc.enable.memcheck", this.fMemcheck.getSelection());
        }
        if (this.fDevices != null) {
            StringBuffer devs = new StringBuffer();
            boolean needsComma = false;
            boolean hasUnselectedDevices = false;
            Button[] buttonArray = this.fDevices;
            int n = this.fDevices.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                if (button.getSelection()) {
                    if (needsComma) {
                        devs.append(",");
                    }
                    needsComma = true;
                    devs.append(((ICudaDevice)button.getData()).getOrdinal());
                } else {
                    hasUnselectedDevices = true;
                }
                ++n2;
            }
            configuration.setAttribute("lc.devices", hasUnselectedDevices ? devs.toString() : null);
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    private void createCudaControls(Composite parent) {
        if (this.mode == Mode.Local) {
            String warning = null;
            if (System.getenv("CUDA_VISIBLE_DEVICES") == null) {
                ICudaDevice[] devices = CudaDevice.getDevices(null);
                if (devices == null || devices.length == 0) {
                    warning = "No CUDA-compatible devices detected";
                } else if (devices.length > 1) {
                    Label label = new Label(parent, 0);
                    label.setText("Enabled CUDA devices:");
                    Composite devicesPane = new Composite(parent, 0);
                    GridLayout layout = new GridLayout(2, true);
                    layout.marginHeight = 0;
                    layout.marginWidth = 0;
                    devicesPane.setLayout((Layout)layout);
                    devicesPane.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
                    this.fDevices = new Button[devices.length];
                    int n = 0;
                    ICudaDevice[] iCudaDeviceArray = devices;
                    int n2 = devices.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        ICudaDevice cudaDevice = iCudaDeviceArray[n3];
                        Button button = new Button(devicesPane, 32);
                        button.setText(cudaDevice.getName());
                        button.setData((Object)cudaDevice);
                        button.addSelectionListener(this.listener);
                        this.fDevices[n++] = button;
                        ++n3;
                    }
                    warning = "Devices used by OS user interface will be excluded by cuda-gdb";
                }
            } else {
                warning = "CUDA_VISIBLE_DEVICES is set for Nsight Eclipse Edition process";
            }
            if (warning != null) {
                CLabel label = new CLabel(parent, 0);
                label.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
                label.setText(warning);
                label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            }
        }
        if (this.mode != Mode.Attach && this.mode != Mode.Core) {
            this.fMemcheck = this.createCheckButton(parent, "Enable CUDA memcheck");
            this.fMemcheck.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
            this.fMemcheck.addSelectionListener(this.listener);
        }
        if (this.mode != Mode.Core) {
            this.fKernelEvents = this.createCheckButton(parent, "Print to console when CUDA kernel is launched or terminated");
            this.fKernelEvents.addSelectionListener(this.listener);
            this.fKernelEvents.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
            this.fValueExtrapolation = this.createCheckButton(parent, "Extrapolate \"optimized out\" CUDA register values");
            this.fValueExtrapolation.addSelectionListener(this.listener);
            this.fValueExtrapolation.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        }
    }

    public void createMainTab(TabFolder tabFolder) {
        GridData gd;
        Label label;
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString((String)"GDBDebuggerPage.main_tab_name"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        this.createCudaControls(subComp);
        if (this.mode != Mode.Core) {
            this.fUpdateThreadlistOnSuspend = this.addCheckbox(subComp, LaunchUIMessages.getString((String)"GDBDebuggerPage.update_thread_list_on_suspend"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpdateThreadlistOnSuspend, "org.eclipse.cdt.dsf.gdb.ui.update_threadlist_button_context");
            this.createVerticalSpacer(subComp, -1);
        }
        if (this.mode != Mode.Core) {
            label = ControlFactory.createLabel((Composite)subComp, (String)"Set CUDA API call failures:");
            gd = new GridData();
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            String[] items = new String[]{"ignore", "hide", "stop", "ignore_all", "stop_all"};
            this.fApiFailureCombo = ControlFactory.createSelectCombo((Composite)subComp, (String[])items, (String)"ignore");
            this.fApiFailureCombo.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.fApiFailureCombo.addSelectionListener(this.listener);
            this.createVerticalSpacer(subComp, -1);
        }
        label = ControlFactory.createLabel((Composite)subComp, (String)"CUDA GDB executable:");
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!CudaDebuggerPage.this.isInitializing()) {
                    CudaDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, LaunchUIMessages.getString((String)"GDBDebuggerPage.gdb_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CudaDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString((String)"GDBDebuggerPage.gdb_browse_dlg_title"));
                String gdbCommand = CudaDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CudaDebuggerPage.this.fGDBCommandText.setText(res);
            }

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                CudaDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)"CUDA GDB init file:");
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!CudaDebuggerPage.this.isInitializing()) {
                    CudaDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, LaunchUIMessages.getString((String)"GDBDebuggerPage.gdb_cmdfile_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CudaDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString((String)"GDBDebuggerPage.gdb_cmdfile_dlg_title"));
                String gdbCommand = CudaDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CudaDebuggerPage.this.fGDBInitText.setText(res);
            }

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                CudaDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString((String)"GDBDebuggerPage.cmdfile_warning"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
    }

    public IMILaunchConfigurationComponent createSolibBlock(Composite parent) {
        RemodeSolibBlock block = this.mode == Mode.Remote ? new RemodeSolibBlock((IMILaunchConfigurationComponent)new SolibSearchPathBlock(), true, true) : new GDBSolibBlock((IMILaunchConfigurationComponent)new SolibSearchPathBlock(), true, true);
        block.createControl(parent);
        return block;
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString((String)"GDBDebuggerPage.shared_libraries"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        if (this.fSolibBlock instanceof Observable) {
            ((Observable)this.fSolibBlock).addObserver(this);
        }
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)this.fSolibBlock).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    private boolean getBooleanAttr(ILaunchConfiguration config, String attributeName, boolean defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public String getName() {
        return LaunchUIMessages.getString((String)"GDBDebuggerPage.tab_name");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    private String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        IPreferenceStore cudaPreferenceStore = Activator.getDefault().getPreferenceStore();
        String gdbCommand = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.DEBUG_NAME", DebugUtil.getCudaGdbExecutablePath(configuration));
        String gdbInit = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.GDB_INIT", cudaPreferenceStore.getString("cudagdb.initfile"));
        boolean updateThreadsOnSuspend = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean memcheck = this.getBooleanAttr(configuration, "lc.enable.memcheck", cudaPreferenceStore.getBoolean("memcheck.default"));
        String apiFailure = this.getStringAttr(configuration, "breakOnError", cudaPreferenceStore.getString("break.on.api.default"));
        boolean kernelEvents = this.getBooleanAttr(configuration, "lc.kernelevents", false);
        boolean extrapolate = this.getBooleanAttr(configuration, "lc.extrapolate", true);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        if (this.mode != Mode.Core) {
            this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
            ControlFactory.selectCombo((Combo)this.fApiFailureCombo, (String)apiFailure);
            this.fKernelEvents.setSelection(kernelEvents);
            this.fValueExtrapolation.setSelection(extrapolate);
        }
        if (this.fMemcheck != null) {
            this.fMemcheck.setSelection(memcheck);
        }
        if (this.fDevices != null) {
            ICudaDevice[] devices;
            String devicesString = this.getStringAttr(configuration, "lc.devices", null);
            if (devicesString == null || devicesString.trim().length() == 0) {
                devices = CudaSDKCore.getDefault().getSDKPreferences().getEnabledDevices();
                if (devices.length == 0) {
                    devices = CudaDevice.getDevices((boolean)true, null);
                }
            } else {
                devices = CudaDevice.getDevices((String)devicesString);
            }
            Button[] buttonArray = this.fDevices;
            int n = this.fDevices.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                boolean selected = false;
                ICudaDevice[] iCudaDeviceArray = devices;
                int n3 = devices.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICudaDevice cudaDevice = iCudaDeviceArray[n4];
                    if (cudaDevice.equals(button.getData())) {
                        selected = true;
                        break;
                    }
                    ++n4;
                }
                button.setSelection(selected);
                ++n2;
            }
        }
        this.setInitializing(false);
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            if (this.fDevices != null) {
                boolean deviceSelected = false;
                Button[] buttonArray = this.fDevices;
                int n = this.fDevices.length;
                int n2 = 0;
                while (n2 < n) {
                    Button button = buttonArray[n2];
                    if (button.getSelection()) {
                        deviceSelected = true;
                        break;
                    }
                    ++n2;
                }
                if (!deviceSelected) {
                    this.setMessage(null);
                    this.setErrorMessage("At least one CUDA device must be selected");
                    return false;
                }
            }
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(LaunchUIMessages.getString((String)"GDBDebuggerPage.gdb_executable_not_specified"));
            this.setMessage(null);
        }
        return valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.fGDBCommandText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", this.fGDBInitText.getText().trim());
        if (this.mode != Mode.Core) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        }
        this.applyLocalLaunchAttributes(configuration);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPreferenceStore cudaPreferenceStore = Activator.getDefault().getPreferenceStore();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", DebugUtil.getCudaGdbExecutablePath((ILaunchConfiguration)configuration));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", cudaPreferenceStore.getString("cudagdb.initfile"));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        configuration.setAttribute("lc.enable.memcheck", cudaPreferenceStore.getBoolean("memcheck.default"));
        configuration.setAttribute("breakOnError", cudaPreferenceStore.getString("break.on.api.default"));
        configuration.setAttribute("lc.devices", null);
        configuration.setAttribute("lc.extrapolate", true);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public static enum Mode {
        Attach,
        Connect,
        Local,
        Remote,
        Core;

    }
}

