/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.commands;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.DebugCommandHandler;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IEvaluationService;

public class ReverseToggleCommandHandler
extends DebugCommandHandler
implements IDebugContextListener,
IElementUpdater {
    private static final String REVERSE_TOGGLE_COMMAND_ID = "org.eclipse.cdt.debug.ui.command.reverseToggle";
    private Object fActiveContext = null;
    private IReverseToggleHandler fTargetAdapter = null;
    private IDebugContextService fContextService = null;

    protected Class<?> getCommandType() {
        return IReverseToggleHandler.class;
    }

    public ReverseToggleCommandHandler() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.fContextService = DebugUITools.getDebugContextManager().getContextService(window);
            if (this.fContextService != null) {
                this.fContextService.addPostDebugContextListener((IDebugContextListener)this);
                this.refresh(this.fContextService.getActiveContext());
            }
        }
    }

    public void dispose() {
        if (this.fContextService != null) {
            this.fContextService.removePostDebugContextListener((IDebugContextListener)this);
        }
        this.fTargetAdapter = null;
        this.fActiveContext = null;
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.refresh(event.getContext());
    }

    private void refresh(ISelection selection) {
        ICommandService commandService;
        IStructuredSelection ss;
        this.fTargetAdapter = null;
        this.fActiveContext = null;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            this.fActiveContext = ss.getFirstElement();
            if (this.fActiveContext instanceof IAdaptable) {
                this.fTargetAdapter = this.getAdapter((IAdaptable)this.fActiveContext);
            }
        }
        if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
            commandService.refreshElements(REVERSE_TOGGLE_COMMAND_ID, null);
        }
    }

    private IReverseToggleHandler getAdapter(IAdaptable adaptable) {
        IAdapterManager adapterManager;
        IReverseToggleHandler adapter = (IReverseToggleHandler)adaptable.getAdapter(IReverseToggleHandler.class);
        if (adapter == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)adaptable, this.getCommandType().getName())) {
            adapter = (IReverseToggleHandler)adapterManager.loadAdapter((Object)adaptable, IReverseToggleHandler.class.getName());
        }
        return adapter;
    }

    protected void postExecute(IRequest request, Object[] targets) {
        super.postExecute(request, targets);
        new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ICommandService commandService;
                IEvaluationService exprService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                if (exprService != null) {
                    exprService.requestEvaluation("org.eclipse.cdt.debug.ui.isReverseDebuggingEnabled");
                }
                if ((commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)) != null) {
                    commandService.refreshElements(ReverseToggleCommandHandler.REVERSE_TOGGLE_COMMAND_ID, null);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void updateElement(UIElement element, Map parameters) {
        if (this.fTargetAdapter != null && this.fTargetAdapter.toggleNeedsUpdating()) {
            boolean toggled = this.fTargetAdapter.isReverseToggled(this.fActiveContext);
            element.setChecked(toggled);
        }
    }
}

