/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMLOADAVERAGES_H_
#define OPENDRIM_OPERATINGSYSTEMLOADAVERAGES_H_

#include <Instance.h>

const static char* OpenDRIM_OperatingSystemLoadAverages_classnames[] = {"OpenDRIM_OperatingSystemLoadAverages"};
static string OpenDRIM_OperatingSystemLoadAverages_NAMESPACE = _NAMESPACE;

class OpenDRIM_OperatingSystemLoadAverages {

public:
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<float> LoadAverages;
	bool LoadAverages_isNULL;
	
	OpenDRIM_OperatingSystemLoadAverages() {
		InstanceID_isNULL = true;
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		Name_isNULL = true;
		LoadAverages_isNULL = true;
	}
	
	~OpenDRIM_OperatingSystemLoadAverages() {}
	
	string getKeys() const {
		return CF_toLowCase(".Name=\"" + CF_quoteString(Name) + "\"");
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getLoadAverages(vector<float>& value) const {
		if (LoadAverages_isNULL==true)
			return NOT_FOUND;
		value = LoadAverages;
		return OK;
	}
	
	int setLoadAverages(const vector<float>& newValue) {
		LoadAverages = newValue;
		LoadAverages_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_OPERATINGSYSTEMLOADAVERAGES_H_*/
