!{\src2tex{textfont=tt}}
!!****f* ABINIT/prcrskerker1
!! NAME
!! prcrscgres
!!
!! FUNCTION
!! preconditionning by a real-space conjugate gradient on residual
!! using a model dielectric function in real space
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  nfft=number of fft grid points
!!  nspden=number of spin-density components
!!  ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  dielar(7)=input parameters for dielectric matrix:
!!                diecut,dielng,diemac,diemix,diegap,dielam.
!!  gprimd(3,3)=dimensional primitive translations in fourier space (bohr**-1)
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  vresid(nfft,nspden)=residual potential
!!  base(nfft) = real space function used as a basis to guess a fine dielectric funtion
!!  see the calling routine to know the content
!!
!! OUTPUT
!!  vrespc(nfft,nspden)=preconditioned residual of the potential
!!
!! SIDE EFFECTS
!!
!! WARNINGS
!! This is experimental code : input, ouptput, results and any other feature may vary greatly.
!!
!! NOTES
!!
!! PARENTS
!!      prcref
!!
!! CHILDREN
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prcrskerker1(mpi_enreg,nfft,nspden,ngfft,dielar,gprimd,rprimd,vresid,vrespc,natom,xred,base)

  use defs_basis
  use defs_datatypes
  use frskerker1

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_13recipspace
 use interfaces_lib01cg
#endif
!End of the abilint section

  implicit none

!Arguments ------------------------------------
  !scalars
  integer,intent(in) :: natom,nfft,nspden
  type(MPI_type),intent(inout) :: mpi_enreg
  !arrays
  integer,intent(in) :: ngfft(18)
  real(dp),intent(in) :: base(nfft),dielar(7),gprimd(3,3),rprimd(3,3),vresid(nfft,nspden)
  real(dp),intent(in) :: xred(3,natom)
  real(dp),intent(out) :: vrespc(nfft,nspden)

!Local variables-------------------------------
  !logical,save ::ok=.FALSE.
  !scalars
  integer :: c1,c2,cplex,i1,i2,i3,iatom,iatom27,ifft,ispden,n1,n2,n3,natom27
  real(dp) :: base_max,base_min,base_delta,base_shift,maxg2,ming2
  real(dp) :: core,dielng,diemac,diemix,dr,l1,l2,l3,l4,p0=1_dp,p1=0_dp
  real(dp) :: p2=26.7288_dp,p3=-236.423_dp,p4=711.185_dp,p5=-1071.08_dp
  real(dp) :: p6=881.438_dp,p7=-390.626_dp,p8=67.7794_dp,r,rdummy1,rdummy2,rmin
  real(dp) :: x,xp,xp2,xr,y,yr,zr
  !arrays
  real(dp),parameter :: identity(4)=(/one,one,zero,zero/)
  real(dp) :: base_cp(nfft),bla(nfft/351),buffer(nfft,nspden),buffer2(nfft,nspden)
  real(dp) :: deltaW(nfft,nspden),dvstar(nfft,nspden),gvrespc(2,nfft,nspden),g2cart(nfft),ldvstar(nfft,nspden)
  real(dp) :: lvres(nfft,nspden),mat(nfft,nspden),qphon(3),rdiel(nfft)
  real(dp) :: rdiemac(nfft),xcart(3,natom),xcart27(3,natom*27)

! *************************************************************************

!DEBUG
! write(6,*)' prckerker1 : enter '
!ENDDEBUG

  dielng=dielar(2)
  diemac=dielar(3)
  diemix=dielar(4)
  !******************************************************************
  ! compute the diemac(r)                                          **
  !******************************************************************
  !this task will be devoted to a general function later
  n1=ngfft(1)
  n2=ngfft(2)
  n3=ngfft(3)
  !base_cp=base
  base_min=base(1)
  base_max=base(1)
  do ifft=1,nfft
     base_min = min(base_min,base(ifft))
     base_max = max(base_max,base(ifft))
  end do
  base_delta = base_max - base_min
  rdiemac(:) = ((base(:)-base_min) / (base_delta) ) *(diemac-one) + one
  !******************************************************************
  ! compute deltaW                                                 **
  !******************************************************************
  vrespc=vresid !starting point
  call laplacian(gprimd,mpi_enreg,nfft,nspden,ngfft,rdfuncr=vrespc,laplacerdfuncr=deltaW,g2cart_out=g2cart) ! put the laplacian of the residuals into deltaW
  !call laplacian(vrespc,buffer,ngfft,gprimd) ! put the laplacian of the residuals into deltaW
  ! do ifft=1,nfft
  !    if (buffer(ifft,1)/=deltaW(ifft,1)) then
  !       write(0,*) buffer-deltaW
  !       stop
  !    end if
  ! end do
  do ispden=1,nspden
     deltaW(:,ispden)= diemix*(((one/rdiemac(:))*vresid(:,ispden))-(((dielng)**2)*deltaW(:,ispden)))
  end do
  !call random_number(deltaW)
  !call random_number(vrespc)
  !******************************************************************
  ! Finding the preconditionned residuals which minimizes          **
  ! half*(vrespc*(1-dielng2/4pi2 nabla2) vrespc) - vrespc * deltaW **
  !***********************************************************************
  vrespc=diemix*vrespc
  !buffer=vrespc


  !==============================================================================
  !==============================================================================
  !! Original loop
  !==============================================================================
  !==============================================================================

  call frskerker1__init(mpi_enreg,nfft,ngfft,nspden,dielng,deltaW,gprimd,mat,g2cart)

  !call cgpr(pf_rscgres,dpf_rscgres,newvres,real(1e-40,dp),700,vrespc,rdummy1,rdummy2)
  !rdummy1 = pf_rscgres(nfft,nspden,vrespc)
  !write(0,*) 'qualite solution',rdummy1
  call cgpr(nfft,nspden,frskerker1__pf,frskerker1__dpf,frskerker1__newvres,&
       & real(1e-5,dp),700,vrespc,rdummy1,rdummy2)
  call frskerker1__end()

  !==============================================================================
  !==============================================================================
  !! Original loop end
  !==============================================================================
  !==============================================================================


  !cplex=1
  !qphon(:)=zero
  !call moddiel(cplex,dielar,nfft,ngfft,nspden,qphon,rprimd,vresid,buffer)
  !c1=0
  !do ifft=1,nfft,1
  !   if((abs(buffer(ifft,1)-vrespc(ifft,1))/(abs(buffer(ifft,1)+vrespc(ifft,1))*half)) > 5e-3) then
  !      !write(0,*) ifft,buffer(ifft,1),vrespc(ifft,1),vresid(ifft,1)
  !      c1=c1+1
  !   end if
  !end do
  !call laplacian(vrespc,buffer,ngfft,gprimd)
  !buffer=vrespc(:,:)-buffer(:,:)*dielng**2
  !c2=0
  !do ifft=1,nfft,1
  !   if((abs(buffer(ifft,1)-deltaW(ifft,1))/(abs(buffer(ifft,1)+deltaW(ifft,1))*half)) > 5e-3) then
  !      c2=c2+1
  !   end if
  !end do
!!$  !stop
  !write(0,*) 'erreurs de type 1 et 2',c1,c2
  !write(0,*) 'prctrscgres:',rdummy1,rdummy2
  !call laplacian(gprimd,mpi_enreg,nfft,nspden,ngfft,&
  !     & g2cart_out=g2cart)

  !vrespc=vresid
  !do ispden=1,nspden
  !   call fourdp(1, gvrespc(:,:,ispden), vrespc(:,ispden),-1,mpi_enreg,nfft,ngfft,0)
  !end do
  !filtering
  !do ispden=1,nspden
  !   do ifft=1,nfft        
  !      !    gvrespc(:,ifft,ispden)=(one-exp(-g2cart(ifft)*15.0_dp))*gvrespc(:,ifft,ispden)
  !      !      gvrespc(:,ifft,ispden)=(exp(-g2cart(ifft)*10.0_dp))*gvrespc(:,ifft,ispden)
  !      !      gvrespc(:,ifft,ispden)=(one-one/(exp(-0.002_dp/g2cart(ifft)**2)+one))*gvrespc(:,ifft,ispden)
  !      gvrespc(:,ifft,ispden)=(two-2_dp/(exp(-0.008_dp/(g2cart(ifft)+0.0012_dp))+one))*gvrespc(:,ifft,ispden)
  !      gvrespc(:,ifft,ispden)=min(one,(sqrt(g2cart(ifft)/0.006_dp))**(one))*gvrespc(:,ifft,ispden)
  !   end do
  !end do
  !change resulting potential to real space
  !do ispden=1,nspden
  !   call fourdp(1,gvrespc(:,:,ispden),vrespc(:,ispden),1,mpi_enreg,nfft,ngfft,0)
  !end do
  !vrespc=vrespc*diemix
  !maxg2=g2cart(1)
  !ming2=g2cart(5)
  !do ifft=1,nfft   
  !   maxg2=max(g2cart(ifft),maxg2)
  !   if(g2cart(ifft) .gt. zero) ming2=min(g2cart(ifft),ming2)
  !end do
  !write(0,*) 'maxg2=',maxg2,'ming2=',ming2
  !stop

!DEBUG
! write(6,*)' prckerker1 : exit '
!ENDDEBUG

end subroutine prcrskerker1
!!***
