!{\src2tex{textfont=tt}}
!!****f* ABINIT/bessp
!! NAME
!! bessp
!!
!! FUNCTION
!! Compute first derivative of spherical Bessel function j_prime_l(x)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  ll=l-order of the Bessel function
!!  xx=where to compute j_prime_l
!!
!! PARENTS
!!      opt_proj
!!
!! SOURCE

 function bessp(xx,ll)

 use defs_basis

 implicit none


!Arguments ---------------------------------------------
 integer :: ll
 real(dp) :: bessp,xx

! *********************************************************************

 if (ll==0) then
  if(xx<1.d-3)then
   bessp=(-10.d0+xx*xx)*xx/30.0d0
  else
   bessp=-(sin(xx)-xx*cos(xx))/xx**2
  endif
 endif
 if (ll==1) then
  if(xx<1.d-3)then
   bessp=(10.d0-3.d0*xx*xx)/30.d0
  else
   bessp=((xx*xx-2.d0)*sin(xx)+2.d0*xx*cos(xx))/xx**3
   endif
 endif
 if (ll==2) then
  if(xx<1.d-3)then
   bessp=(1.d0-xx*xx/7.d0)*2.d0*xx/15.0d0
  else
   bessp=((4.d0*xx*xx-9.d0)*sin(xx)+(9.d0-xx*xx)*xx*cos(xx))/xx**4
  endif
 endif
 if (ll==3) then
  if(xx<1.d-3)then
   bessp=(1.d0/35-xx*xx/378.d0+xx**4/11880.d0)*xx*xx
  else
   bessp=((-60.d0+27.d0*xx*xx-xx**4)*sin(xx)+(60.d0*xx-7.d0*xx**3)*cos(xx))/xx**5
  endif
 endif

 end function bessp

!!***
