{
(* Lexic *)
(* $Id: lexic.mll,v 1.5 2004/08/02 17:13:39 berke Exp $ *)

open Syntax

exception Parse_error of int * int * string

let lexical_error l s = raise (Parse_error(Lexing.lexeme_start l, Lexing.lexeme_end l,s))
}
let blancs = [' ' '\n' '\t' '\r']+
let upperalpha = ['A'-'Z']
let alpha = ['a'-'z''A'-'Z']
let alphanum = alpha | ['0'-'9']
let decimaldigit = ['0'-'9']
let sign = '+'|'-'
let space = [' ''\t''\r''\n']
rule token = parse
(* Operators *)
(* Various non-alphabetic symbols *)
| "(" { LPAREN }
| ")" { RPAREN }
| "[" { LBRACK }
| "]" { RBRACK }
| "," { COMMA }
| "+" { PLUS }
| "*" { STAR }
| "~" { TILDE }
| ":" { COLON }
| "<>" { NEQ } 
| "!=" { NEQ }
| "=" { EQ }
| "<=" { LEQ }
| ">=" { GEQ }
| "<" { LT }
| ">" { GT }
| "," { COMMA }
| "=~" { MATCHES }
| "!~" { DOESNT_MATCH }
| ":=" { ASSIGN }
| "&" { AND }
| "|" { OR }
| "!" { NOT }
| "^R" { REVERSE }
| "and" { AND }
| "or" { OR }
| "not" { NOT }
| "all" { TRUE }
| "none" { FALSE }
| "true" { TRUE }
| "false" { FALSE }
| "id" { IDENTITY }
| "\"" { STRING(readstr lexbuf) }
| "/" { REGEXP(readregexp lexbuf) }
| "$"(alphanum|'_'|'-')+
  { IDENT(let w = Lexing.lexeme lexbuf in String.sub w 1 (String.length w - 1)) }
| (alphanum|'_'|'-'|'*'|'?')+ { STRING(Lexing.lexeme lexbuf) }
(* Comments, space, strings and end of file *)
| "(*" { eat_comment lexbuf; token lexbuf }
| space+ { token lexbuf }
| eof { EOF }
| _ { lexical_error lexbuf
	(Printf.sprintf "Unexpected %S" (Lexing.lexeme lexbuf)) }
and eat_comment = parse
  "(*" { eat_comment lexbuf; eat_comment lexbuf }
| "*)" { }
| [^'(' '*']+ { eat_comment lexbuf }
| _ { eat_comment lexbuf }
and readstr = parse
  "\"" { "" }
| "\\\"" { "\""^(readstr lexbuf) }
| [^'"' '\\']+ { let s = Lexing.lexeme lexbuf in s^(readstr lexbuf) }
and readregexp = parse
  "/" { ("",readregexpoptions lexbuf) }
| "\\/" { let (s,o) = readregexp lexbuf in ("/"^s,o) }
| ([^'/' '\\']+ | '\\'[^'/'][^'/' '\\']*) { let s = Lexing.lexeme lexbuf in let (s',o) = readregexp lexbuf in (s^s',o) }
and readregexpoptions = parse
 (['w' 'i']*) {
    let w = Lexing.lexeme lexbuf in
    let rec loop r i =
      if i = String.length w then
        r
      else
        loop
          ((match w.[i] with
             'w' -> Ast.Word_boundary
           | 'i' -> Ast.Case_insensitive
           | _ -> assert false)::r)
          (i + 1)
    in
    loop [] 0 }
and readident = parse
  alpha (alphanum|'_')* { Lexing.lexeme lexbuf }
{
(* Epilogue. *)
}
