/*
 * Copyright (c) 2021, 2023-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include <cstddef>
#include <cstdint>

#if defined(ARM_COMPUTE_ENABLE_SVE)

namespace arm_conv {
namespace depthwise {

void sve_fp32_packed_to_nhwc_generic_with_multiplier_output2x8_mla_depthfirst_impl(
  const float *const *const inptrs,
  float *const *const outptrs,
  const float *weights,
  const float *bias,
  const unsigned int kernel_points,
  const unsigned int n_output_channels,
  const float activation_min,
  const float activation_max
)
{
  const float minmax_vals[2] = { activation_min, activation_max };

  __asm__ __volatile__(
    "ptrue p1.b\n"
    "mov x9, #0x0\n"
    "ld1rw { z10.s }, p1/Z, [%x[minmax_vals]]\n"
    "ld1rw { z9.s }, p1/Z, [%x[minmax_vals], #4]\n"
    "whilelt p0.s, x9, %x[n_output_channels]\n"
    "1:"  // Output channel loop
    "mov z31.b, #0x0\n"
    "cbz %x[bias], 2f\n"
    "ld1w { z31.s }, p0/Z, [%x[bias], x9, LSL #2]\n"
    "2:"  // Output channel loop: Load bias: Done
    "mov x23, %x[inptrs]\n"
    "lsr x22, %x[kernel_points], #0x1\n"
    "mov z16.d, z31.d\n"
    "mov z17.d, z31.d\n"
    "mov z18.d, z31.d\n"
    "mov z19.d, z31.d\n"
    "ld1w { z13.s }, p1/Z, [%x[weights]]\n"
    "addvl %x[weights], %x[weights], #1\n"
    "mov z20.d, z31.d\n"
    "mov z21.d, z31.d\n"
    "ldp x21, x20, [x23], #0x10\n"
    "mov z22.d, z31.d\n"
    "mov z23.d, z31.d\n"
    "mov z24.d, z31.d\n"
    "mov z25.d, z31.d\n"
    "mov z26.d, z31.d\n"
    "mov z27.d, z31.d\n"
    "ld1rqw { z7.s }, p1/Z, [x21]\n"
    "ld1rqw { z6.s }, p1/Z, [x21, #16]\n"
    "mov z28.d, z31.d\n"
    "mov z29.d, z31.d\n"
    "ld1rqw { z1.s }, p1/Z, [x20]\n"
    "ld1rqw { z2.s }, p1/Z, [x20, #16]\n"
    "mov z30.d, z31.d\n"
    "mov z31.d, z31.d\n"
    "cbz x22, 6f\n"
    "ldp x21, x20, [x23], #0x10\n"
    "subs x22, x22, #0x1\n"
    "ld1w { z8.s }, p1/Z, [%x[weights]]\n"
    "addvl %x[weights], %x[weights], #1\n"
    "ld1rqw { z5.s }, p1/Z, [x21]\n"
    "ld1rqw { z3.s }, p1/Z, [x21, #16]\n"
    "ld1rqw { z0.s }, p1/Z, [x20]\n"
    "ld1rqw { z4.s }, p1/Z, [x20, #16]\n"
    "beq 4f\n"
    "3:"  // Output channel loop: Kernel loop
    "ldp x21, x20, [x23], #0x10\n"
    "fmla z16.s, z13.s, z7.s[0]\n"
    "fmla z17.s, z13.s, z7.s[1]\n"
    "subs x22, x22, #0x1\n"
    "fmla z18.s, z13.s, z7.s[2]\n"
    "fmla z19.s, z13.s, z7.s[3]\n"
    "fmla z20.s, z13.s, z6.s[0]\n"
    "fmla z21.s, z13.s, z6.s[1]\n"
    "fmla z22.s, z13.s, z6.s[2]\n"
    "fmla z23.s, z13.s, z6.s[3]\n"
    "ld1rqw { z7.s }, p1/Z, [x21]\n"
    "ld1rqw { z6.s }, p1/Z, [x21, #16]\n"
    "fmla z24.s, z13.s, z1.s[0]\n"
    "fmla z25.s, z13.s, z1.s[1]\n"
    "fmla z26.s, z13.s, z1.s[2]\n"
    "fmla z27.s, z13.s, z1.s[3]\n"
    "ld1rqw { z1.s }, p1/Z, [x20]\n"
    "fmla z28.s, z13.s, z2.s[0]\n"
    "fmla z29.s, z13.s, z2.s[1]\n"
    "fmla z30.s, z13.s, z2.s[2]\n"
    "fmla z31.s, z13.s, z2.s[3]\n"
    "ld1rqw { z2.s }, p1/Z, [x20, #16]\n"
    "ldp x21, x20, [x23], #0x10\n"
    "ld1w { z13.s }, p1/Z, [%x[weights]]\n"
    "fmla z16.s, z8.s, z5.s[0]\n"
    "fmla z17.s, z8.s, z5.s[1]\n"
    "fmla z18.s, z8.s, z5.s[2]\n"
    "fmla z19.s, z8.s, z5.s[3]\n"
    "fmla z20.s, z8.s, z3.s[0]\n"
    "fmla z21.s, z8.s, z3.s[1]\n"
    "ld1rqw { z5.s }, p1/Z, [x21]\n"
    "fmla z22.s, z8.s, z3.s[2]\n"
    "fmla z23.s, z8.s, z3.s[3]\n"
    "ld1rqw { z3.s }, p1/Z, [x21, #16]\n"
    "fmla z24.s, z8.s, z0.s[0]\n"
    "fmla z25.s, z8.s, z0.s[1]\n"
    "fmla z26.s, z8.s, z0.s[2]\n"
    "fmla z27.s, z8.s, z0.s[3]\n"
    "ld1rqw { z0.s }, p1/Z, [x20]\n"
    "fmla z28.s, z8.s, z4.s[0]\n"
    "fmla z29.s, z8.s, z4.s[1]\n"
    "fmla z30.s, z8.s, z4.s[2]\n"
    "fmla z31.s, z8.s, z4.s[3]\n"
    "ld1rqw { z4.s }, p1/Z, [x20, #16]\n"
    "ld1w { z8.s }, p1/Z, [%x[weights], #1, MUL VL]\n"
    "addvl %x[weights], %x[weights], #2\n"
    "bgt 3b\n"
    "4:"  // Output channel loop: Kernel loop tail
    "tbnz %x[kernel_points], #0, 5f\n"
    "fmla z16.s, z13.s, z7.s[0]\n"
    "fmla z17.s, z13.s, z7.s[1]\n"
    "ldr x27, [%x[outptrs], #0x0]\n"
    "ldr x26, [%x[outptrs], #0x8]\n"
    "fmla z18.s, z13.s, z7.s[2]\n"
    "fmla z19.s, z13.s, z7.s[3]\n"
    "ldr x25, [%x[outptrs], #0x10]\n"
    "ldr x24, [%x[outptrs], #0x18]\n"
    "fmla z20.s, z13.s, z6.s[0]\n"
    "fmla z21.s, z13.s, z6.s[1]\n"
    "ldr x23, [%x[outptrs], #0x20]\n"
    "ldr x22, [%x[outptrs], #0x28]\n"
    "fmla z22.s, z13.s, z6.s[2]\n"
    "fmla z23.s, z13.s, z6.s[3]\n"
    "ldr x21, [%x[outptrs], #0x30]\n"
    "ldr x20, [%x[outptrs], #0x38]\n"
    "fmla z24.s, z13.s, z1.s[0]\n"
    "fmla z25.s, z13.s, z1.s[1]\n"
    "fmla z26.s, z13.s, z1.s[2]\n"
    "fmla z27.s, z13.s, z1.s[3]\n"
    "fmla z28.s, z13.s, z2.s[0]\n"
    "fmla z29.s, z13.s, z2.s[1]\n"
    "fmla z30.s, z13.s, z2.s[2]\n"
    "fmla z31.s, z13.s, z2.s[3]\n"
    "fmla z16.s, z8.s, z5.s[0]\n"
    "fmla z17.s, z8.s, z5.s[1]\n"
    "fmla z18.s, z8.s, z5.s[2]\n"
    "fmla z19.s, z8.s, z5.s[3]\n"
    "fmla z20.s, z8.s, z3.s[0]\n"
    "fmla z21.s, z8.s, z3.s[1]\n"
    "fmla z22.s, z8.s, z3.s[2]\n"
    "fmla z23.s, z8.s, z3.s[3]\n"
    "fmla z24.s, z8.s, z0.s[0]\n"
    "fmla z25.s, z8.s, z0.s[1]\n"
    "fmin z16.s, p1/M, z16.s, z9.s\n"
    "fmin z17.s, p1/M, z17.s, z9.s\n"
    "fmla z26.s, z8.s, z0.s[2]\n"
    "fmla z27.s, z8.s, z0.s[3]\n"
    "fmin z18.s, p1/M, z18.s, z9.s\n"
    "fmin z19.s, p1/M, z19.s, z9.s\n"
    "fmla z28.s, z8.s, z4.s[0]\n"
    "fmla z29.s, z8.s, z4.s[1]\n"
    "fmin z20.s, p1/M, z20.s, z9.s\n"
    "fmin z21.s, p1/M, z21.s, z9.s\n"
    "fmla z30.s, z8.s, z4.s[2]\n"
    "fmla z31.s, z8.s, z4.s[3]\n"
    "fmin z22.s, p1/M, z22.s, z9.s\n"
    "fmin z23.s, p1/M, z23.s, z9.s\n"
    "fmax z16.s, p1/M, z16.s, z10.s\n"
    "fmax z17.s, p1/M, z17.s, z10.s\n"
    "fmax z18.s, p1/M, z18.s, z10.s\n"
    "fmax z19.s, p1/M, z19.s, z10.s\n"
    "fmax z20.s, p1/M, z20.s, z10.s\n"
    "fmax z21.s, p1/M, z21.s, z10.s\n"
    "fmax z22.s, p1/M, z22.s, z10.s\n"
    "fmax z23.s, p1/M, z23.s, z10.s\n"
    "st1w { z16.s }, p0, [x27, x9, LSL #2]\n"
    "ldr x27, [%x[outptrs], #0x40]\n"
    "fmin z24.s, p1/M, z24.s, z9.s\n"
    "fmin z25.s, p1/M, z25.s, z9.s\n"
    "st1w { z17.s }, p0, [x26, x9, LSL #2]\n"
    "ldr x26, [%x[outptrs], #0x48]\n"
    "fmin z26.s, p1/M, z26.s, z9.s\n"
    "fmin z27.s, p1/M, z27.s, z9.s\n"
    "st1w { z18.s }, p0, [x25, x9, LSL #2]\n"
    "ldr x25, [%x[outptrs], #0x50]\n"
    "fmin z28.s, p1/M, z28.s, z9.s\n"
    "fmin z29.s, p1/M, z29.s, z9.s\n"
    "st1w { z19.s }, p0, [x24, x9, LSL #2]\n"
    "ldr x24, [%x[outptrs], #0x58]\n"
    "fmin z30.s, p1/M, z30.s, z9.s\n"
    "fmin z31.s, p1/M, z31.s, z9.s\n"
    "st1w { z20.s }, p0, [x23, x9, LSL #2]\n"
    "ldr x23, [%x[outptrs], #0x60]\n"
    "st1w { z21.s }, p0, [x22, x9, LSL #2]\n"
    "ldr x22, [%x[outptrs], #0x68]\n"
    "fmax z24.s, p1/M, z24.s, z10.s\n"
    "fmax z25.s, p1/M, z25.s, z10.s\n"
    "st1w { z22.s }, p0, [x21, x9, LSL #2]\n"
    "ldr x21, [%x[outptrs], #0x70]\n"
    "fmax z26.s, p1/M, z26.s, z10.s\n"
    "fmax z27.s, p1/M, z27.s, z10.s\n"
    "st1w { z23.s }, p0, [x20, x9, LSL #2]\n"
    "ldr x20, [%x[outptrs], #0x78]\n"
    "fmax z28.s, p1/M, z28.s, z10.s\n"
    "fmax z29.s, p1/M, z29.s, z10.s\n"
    "fmax z30.s, p1/M, z30.s, z10.s\n"
    "fmax z31.s, p1/M, z31.s, z10.s\n"
    "st1w { z24.s }, p0, [x27, x9, LSL #2]\n"
    "st1w { z25.s }, p0, [x26, x9, LSL #2]\n"
    "st1w { z26.s }, p0, [x25, x9, LSL #2]\n"
    "st1w { z27.s }, p0, [x24, x9, LSL #2]\n"
    "st1w { z28.s }, p0, [x23, x9, LSL #2]\n"
    "st1w { z29.s }, p0, [x22, x9, LSL #2]\n"
    "st1w { z30.s }, p0, [x21, x9, LSL #2]\n"
    "st1w { z31.s }, p0, [x20, x9, LSL #2]\n"
    "b 7f\n"
    "5:"  // Output channel loop: Odd tail
    "fmla z16.s, z13.s, z7.s[0]\n"
    "fmla z17.s, z13.s, z7.s[1]\n"
    "ldp x20, x28, [x23], #0x10\n"
    "ldr x27, [%x[outptrs], #0x0]\n"
    "fmla z18.s, z13.s, z7.s[2]\n"
    "fmla z19.s, z13.s, z7.s[3]\n"
    "ldr x26, [%x[outptrs], #0x8]\n"
    "ldr x25, [%x[outptrs], #0x10]\n"
    "fmla z20.s, z13.s, z6.s[0]\n"
    "fmla z21.s, z13.s, z6.s[1]\n"
    "ldr x24, [%x[outptrs], #0x18]\n"
    "ldr x23, [%x[outptrs], #0x20]\n"
    "fmla z22.s, z13.s, z6.s[2]\n"
    "fmla z23.s, z13.s, z6.s[3]\n"
    "ld1rqw { z6.s }, p1/Z, [x20]\n"
    "ld1rqw { z7.s }, p1/Z, [x20, #16]\n"
    "fmla z24.s, z13.s, z1.s[0]\n"
    "fmla z25.s, z13.s, z1.s[1]\n"
    "ldr x22, [%x[outptrs], #0x28]\n"
    "ldr x21, [%x[outptrs], #0x30]\n"
    "fmla z26.s, z13.s, z1.s[2]\n"
    "fmla z27.s, z13.s, z1.s[3]\n"
    "ld1rqw { z1.s }, p1/Z, [x28]\n"
    "ldr x20, [%x[outptrs], #0x38]\n"
    "fmla z28.s, z13.s, z2.s[0]\n"
    "fmla z29.s, z13.s, z2.s[1]\n"
    "fmla z30.s, z13.s, z2.s[2]\n"
    "fmla z31.s, z13.s, z2.s[3]\n"
    "ld1w { z13.s }, p1/Z, [%x[weights]]\n"
    "ld1rqw { z2.s }, p1/Z, [x28, #16]\n"
    "fmla z16.s, z8.s, z5.s[0]\n"
    "fmla z17.s, z8.s, z5.s[1]\n"
    "addvl %x[weights], %x[weights], #1\n"
    "fmla z18.s, z8.s, z5.s[2]\n"
    "fmla z19.s, z8.s, z5.s[3]\n"
    "fmla z20.s, z8.s, z3.s[0]\n"
    "fmla z21.s, z8.s, z3.s[1]\n"
    "fmla z22.s, z8.s, z3.s[2]\n"
    "fmla z23.s, z8.s, z3.s[3]\n"
    "fmla z24.s, z8.s, z0.s[0]\n"
    "fmla z25.s, z8.s, z0.s[1]\n"
    "fmla z26.s, z8.s, z0.s[2]\n"
    "fmla z27.s, z8.s, z0.s[3]\n"
    "fmla z28.s, z8.s, z4.s[0]\n"
    "fmla z29.s, z8.s, z4.s[1]\n"
    "fmla z30.s, z8.s, z4.s[2]\n"
    "fmla z31.s, z8.s, z4.s[3]\n"
    "fmla z16.s, z13.s, z6.s[0]\n"
    "fmla z17.s, z13.s, z6.s[1]\n"
    "fmla z18.s, z13.s, z6.s[2]\n"
    "fmla z19.s, z13.s, z6.s[3]\n"
    "fmla z20.s, z13.s, z7.s[0]\n"
    "fmla z21.s, z13.s, z7.s[1]\n"
    "fmla z22.s, z13.s, z7.s[2]\n"
    "fmla z23.s, z13.s, z7.s[3]\n"
    "fmla z24.s, z13.s, z1.s[0]\n"
    "fmla z25.s, z13.s, z1.s[1]\n"
    "fmin z16.s, p1/M, z16.s, z9.s\n"
    "fmin z17.s, p1/M, z17.s, z9.s\n"
    "fmla z26.s, z13.s, z1.s[2]\n"
    "fmla z27.s, z13.s, z1.s[3]\n"
    "fmin z18.s, p1/M, z18.s, z9.s\n"
    "fmin z19.s, p1/M, z19.s, z9.s\n"
    "fmla z28.s, z13.s, z2.s[0]\n"
    "fmla z29.s, z13.s, z2.s[1]\n"
    "fmin z20.s, p1/M, z20.s, z9.s\n"
    "fmin z21.s, p1/M, z21.s, z9.s\n"
    "fmla z30.s, z13.s, z2.s[2]\n"
    "fmla z31.s, z13.s, z2.s[3]\n"
    "fmin z22.s, p1/M, z22.s, z9.s\n"
    "fmin z23.s, p1/M, z23.s, z9.s\n"
    "fmax z16.s, p1/M, z16.s, z10.s\n"
    "fmax z17.s, p1/M, z17.s, z10.s\n"
    "fmax z18.s, p1/M, z18.s, z10.s\n"
    "fmax z19.s, p1/M, z19.s, z10.s\n"
    "fmax z20.s, p1/M, z20.s, z10.s\n"
    "fmax z21.s, p1/M, z21.s, z10.s\n"
    "fmax z22.s, p1/M, z22.s, z10.s\n"
    "fmax z23.s, p1/M, z23.s, z10.s\n"
    "st1w { z16.s }, p0, [x27, x9, LSL #2]\n"
    "ldr x27, [%x[outptrs], #0x40]\n"
    "fmin z24.s, p1/M, z24.s, z9.s\n"
    "fmin z25.s, p1/M, z25.s, z9.s\n"
    "st1w { z17.s }, p0, [x26, x9, LSL #2]\n"
    "ldr x26, [%x[outptrs], #0x48]\n"
    "fmin z26.s, p1/M, z26.s, z9.s\n"
    "fmin z27.s, p1/M, z27.s, z9.s\n"
    "st1w { z18.s }, p0, [x25, x9, LSL #2]\n"
    "ldr x25, [%x[outptrs], #0x50]\n"
    "fmin z28.s, p1/M, z28.s, z9.s\n"
    "fmin z29.s, p1/M, z29.s, z9.s\n"
    "st1w { z19.s }, p0, [x24, x9, LSL #2]\n"
    "ldr x24, [%x[outptrs], #0x58]\n"
    "fmin z30.s, p1/M, z30.s, z9.s\n"
    "fmin z31.s, p1/M, z31.s, z9.s\n"
    "st1w { z20.s }, p0, [x23, x9, LSL #2]\n"
    "ldr x23, [%x[outptrs], #0x60]\n"
    "st1w { z21.s }, p0, [x22, x9, LSL #2]\n"
    "ldr x22, [%x[outptrs], #0x68]\n"
    "fmax z24.s, p1/M, z24.s, z10.s\n"
    "fmax z25.s, p1/M, z25.s, z10.s\n"
    "st1w { z22.s }, p0, [x21, x9, LSL #2]\n"
    "ldr x21, [%x[outptrs], #0x70]\n"
    "fmax z26.s, p1/M, z26.s, z10.s\n"
    "fmax z27.s, p1/M, z27.s, z10.s\n"
    "st1w { z23.s }, p0, [x20, x9, LSL #2]\n"
    "ldr x20, [%x[outptrs], #0x78]\n"
    "fmax z28.s, p1/M, z28.s, z10.s\n"
    "fmax z29.s, p1/M, z29.s, z10.s\n"
    "fmax z30.s, p1/M, z30.s, z10.s\n"
    "fmax z31.s, p1/M, z31.s, z10.s\n"
    "st1w { z24.s }, p0, [x27, x9, LSL #2]\n"
    "st1w { z25.s }, p0, [x26, x9, LSL #2]\n"
    "st1w { z26.s }, p0, [x25, x9, LSL #2]\n"
    "st1w { z27.s }, p0, [x24, x9, LSL #2]\n"
    "st1w { z28.s }, p0, [x23, x9, LSL #2]\n"
    "st1w { z29.s }, p0, [x22, x9, LSL #2]\n"
    "st1w { z30.s }, p0, [x21, x9, LSL #2]\n"
    "st1w { z31.s }, p0, [x20, x9, LSL #2]\n"
    "b 7f\n"
    "6:"  // Output channel loop: Single kernel point
    "fmla z16.s, z13.s, z7.s[0]\n"
    "fmla z17.s, z13.s, z7.s[1]\n"
    "ldr x27, [%x[outptrs], #0x0]\n"
    "ldr x26, [%x[outptrs], #0x8]\n"
    "fmla z18.s, z13.s, z7.s[2]\n"
    "fmla z19.s, z13.s, z7.s[3]\n"
    "ldr x25, [%x[outptrs], #0x10]\n"
    "ldr x24, [%x[outptrs], #0x18]\n"
    "fmla z20.s, z13.s, z6.s[0]\n"
    "fmla z21.s, z13.s, z6.s[1]\n"
    "ldr x23, [%x[outptrs], #0x20]\n"
    "ldr x22, [%x[outptrs], #0x28]\n"
    "fmla z22.s, z13.s, z6.s[2]\n"
    "fmla z23.s, z13.s, z6.s[3]\n"
    "ldr x21, [%x[outptrs], #0x30]\n"
    "ldr x20, [%x[outptrs], #0x38]\n"
    "fmla z24.s, z13.s, z1.s[0]\n"
    "fmla z25.s, z13.s, z1.s[1]\n"
    "fmin z16.s, p1/M, z16.s, z9.s\n"
    "fmin z17.s, p1/M, z17.s, z9.s\n"
    "fmla z26.s, z13.s, z1.s[2]\n"
    "fmla z27.s, z13.s, z1.s[3]\n"
    "fmin z18.s, p1/M, z18.s, z9.s\n"
    "fmin z19.s, p1/M, z19.s, z9.s\n"
    "fmla z28.s, z13.s, z2.s[0]\n"
    "fmla z29.s, z13.s, z2.s[1]\n"
    "fmin z20.s, p1/M, z20.s, z9.s\n"
    "fmin z21.s, p1/M, z21.s, z9.s\n"
    "fmla z30.s, z13.s, z2.s[2]\n"
    "fmla z31.s, z13.s, z2.s[3]\n"
    "fmin z22.s, p1/M, z22.s, z9.s\n"
    "fmin z23.s, p1/M, z23.s, z9.s\n"
    "fmax z16.s, p1/M, z16.s, z10.s\n"
    "fmax z17.s, p1/M, z17.s, z10.s\n"
    "fmax z18.s, p1/M, z18.s, z10.s\n"
    "fmax z19.s, p1/M, z19.s, z10.s\n"
    "fmax z20.s, p1/M, z20.s, z10.s\n"
    "fmax z21.s, p1/M, z21.s, z10.s\n"
    "fmax z22.s, p1/M, z22.s, z10.s\n"
    "fmax z23.s, p1/M, z23.s, z10.s\n"
    "st1w { z16.s }, p0, [x27, x9, LSL #2]\n"
    "ldr x27, [%x[outptrs], #0x40]\n"
    "fmin z24.s, p1/M, z24.s, z9.s\n"
    "fmin z25.s, p1/M, z25.s, z9.s\n"
    "st1w { z17.s }, p0, [x26, x9, LSL #2]\n"
    "ldr x26, [%x[outptrs], #0x48]\n"
    "fmin z26.s, p1/M, z26.s, z9.s\n"
    "fmin z27.s, p1/M, z27.s, z9.s\n"
    "st1w { z18.s }, p0, [x25, x9, LSL #2]\n"
    "ldr x25, [%x[outptrs], #0x50]\n"
    "fmin z28.s, p1/M, z28.s, z9.s\n"
    "fmin z29.s, p1/M, z29.s, z9.s\n"
    "st1w { z19.s }, p0, [x24, x9, LSL #2]\n"
    "ldr x24, [%x[outptrs], #0x58]\n"
    "fmin z30.s, p1/M, z30.s, z9.s\n"
    "fmin z31.s, p1/M, z31.s, z9.s\n"
    "st1w { z20.s }, p0, [x23, x9, LSL #2]\n"
    "ldr x23, [%x[outptrs], #0x60]\n"
    "st1w { z21.s }, p0, [x22, x9, LSL #2]\n"
    "ldr x22, [%x[outptrs], #0x68]\n"
    "fmax z24.s, p1/M, z24.s, z10.s\n"
    "fmax z25.s, p1/M, z25.s, z10.s\n"
    "st1w { z22.s }, p0, [x21, x9, LSL #2]\n"
    "ldr x21, [%x[outptrs], #0x70]\n"
    "fmax z26.s, p1/M, z26.s, z10.s\n"
    "fmax z27.s, p1/M, z27.s, z10.s\n"
    "st1w { z23.s }, p0, [x20, x9, LSL #2]\n"
    "ldr x20, [%x[outptrs], #0x78]\n"
    "fmax z28.s, p1/M, z28.s, z10.s\n"
    "fmax z29.s, p1/M, z29.s, z10.s\n"
    "fmax z30.s, p1/M, z30.s, z10.s\n"
    "fmax z31.s, p1/M, z31.s, z10.s\n"
    "st1w { z24.s }, p0, [x27, x9, LSL #2]\n"
    "st1w { z25.s }, p0, [x26, x9, LSL #2]\n"
    "st1w { z26.s }, p0, [x25, x9, LSL #2]\n"
    "st1w { z27.s }, p0, [x24, x9, LSL #2]\n"
    "st1w { z28.s }, p0, [x23, x9, LSL #2]\n"
    "st1w { z29.s }, p0, [x22, x9, LSL #2]\n"
    "st1w { z30.s }, p0, [x21, x9, LSL #2]\n"
    "st1w { z31.s }, p0, [x20, x9, LSL #2]\n"
    "7:"  // Output channel loop: Done
    "incw x9\n"
    "whilelt p0.s, x9, %x[n_output_channels]\n"
    "b.any 1b\n"
    : [weights] "+&r" (weights)
    : [bias] "r" (bias), [inptrs] "r" (inptrs), [kernel_points] "r" ((uint64_t) kernel_points), [minmax_vals] "r" (minmax_vals), [n_output_channels] "r" ((uint64_t) n_output_channels), [outptrs] "r" (outptrs)
    : "cc", "memory", "p0", "p1", "x9", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z13", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SVE)
