/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller;

import jarinstaller.ErrorHandler;
import jarinstaller.JarInstallerGUI;
import jarinstaller.XMLParser;
import jarinstaller.gui.DebugInfo;
import jarinstaller.gui.FileUtil;
import jarinstaller.gui.Resource;
import jarinstaller.gui.SilentInstall;
import jarinstaller.oshandler.IOsHandler;
import jarinstaller.oshandler.OsFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class MainLogic {
    private boolean debugOn = false;
    public static final String MAIN_LOGIC_MESSAGES = "main_logic_messages";
    public static final int PARAM_SIZE = 100;
    public static final int NOT_INSTALLED = 0;
    public static final int INSTALLED = 1;
    public static final int INSTALLED_BUT = -1;
    char NL = (char)10;
    IOsHandler osHandler = OsFactory.getOsHandler();
    FileUtil fu = new FileUtil();
    private boolean is_applet;
    private URI source;
    private Hashtable params;
    private Resource resource;
    ErrorHandler err;
    boolean silent;
    boolean scMenu = false;
    boolean scDesktop = true;
    private Vector messages = new Vector();
    private static final String CHAR_SET_UTF_8 = "UTF-8";
    private static final String CHAR_SET_ISO_8859_2 = "ISO-8859-2";
    private static final String CHAR_SET_ISO_8859_1 = "ISO-8859-1";
    private static final String PROP_SEP = "=";
    private static final String COMMENT = "#";

    public MainLogic(URI source, String par_file, boolean is_applet, String[] args) {
        this.source = source;
        this.is_applet = is_applet;
        this.err = new ErrorHandler(this.debugOn);
        this.params = new Hashtable(100);
        this.params.put(MAIN_LOGIC_MESSAGES, this.messages);
        this.silent = this.isSetArg(args, "-s");
        this.setDinParams(this.params);
        this.resource = (Resource)this.params.get("parameter.option.resources");
        this.loadParams(par_file);
        this.appInit(this.silent);
    }

    public void exec() {
        if (this.silent) {
            this.doSilent(this.scMenu, this.scDesktop);
            this.doClose();
        } else {
            this.doGui();
        }
    }

    private boolean isSetArg(String[] args, String flag) {
        if (args == null || args.length == 0) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals(flag)) continue;
            return true;
        }
        return false;
    }

    private void doSilent(boolean scMenu, boolean scDesktop) {
        SilentInstall si = new SilentInstall(this.params, scMenu, scDesktop);
        si.exec();
        si.close();
    }

    private void doGui() {
        JarInstallerGUI guiIns = new JarInstallerGUI(this.source, this.is_applet, this.params);
        guiIns.exec();
    }

    public void doClose() {
        System.exit(0);
    }

    private void setDinParams(Hashtable params) {
        params.put("DUMMY", Boolean.TRUE);
        params.put("OS_NAME", System.getProperty("os.name").toUpperCase());
        params.put("OS_ARCH", System.getProperty("os.arch"));
        params.put("OS_VERSION", System.getProperty("os.version"));
        params.put("JAVA_HOME", System.getProperty("java.home"));
        params.put("JAVA_VERSION", System.getProperty("java.version"));
        params.put("USER_NAME", System.getProperty("user.name"));
        params.put("USER_HOME", this.osHandler.getUserHomeDir());
        params.put("WINDOWS_TMP", this.osHandler.getEnvironmentVariable("TMP"));
        params.put("parameter.dir.jarinstaller", "jarinstaller");
        params.put("parameter.option.resources", new Resource(this.source, (String)params.get("parameter.dir.jarinstaller")));
        params.put("parameter.option.sourcefile", this.source);
        params.put("parameter.option.isapplet", this.is_applet);
        params.put("and", "&");
        params.put("OS_PREFIX", this.osHandler.getOsPrefix());
        if (this.osHandler.canCreateDesktopIcon()) {
            params.put("CANCREATEDESKTOPSHORTCUT", Boolean.TRUE);
        }
        if (this.osHandler.canCreateMenuItem()) {
            params.put("CANCREATEMENUSHORTCUT", Boolean.TRUE);
        }
    }

    private void loadParams(String par_file) {
        XMLParser parser = new XMLParser(this.err);
        URL fileURL = this.resource.getResource(par_file);
        Hashtable readParams = (Hashtable)parser.parse(fileURL.toString());
        if (readParams != null) {
            this.params.putAll(readParams);
        }
    }

    public void appInit(boolean silent) {
        this.initDataStore();
        this.setRootApplicationDir();
        this.setUserPropertyFile();
        this.getPathFile(silent);
        this.getUserProperties();
        this.getEnvVariables();
        if (this.isInstalled() != 0) {
            this.params.put("ISINSTALLED", Boolean.TRUE);
            this.params.putAll(this.collectData());
            this.params.put("ROOTSAME", "true");
        }
    }

    private void initDataStore() {
        this.params.put("parameter.option.install.filelist", new Vector());
        this.params.put("parameter.option.install.dirlist", new Vector());
    }

    private void setRootApplicationDir() {
        String dirname = this.osHandler.getApplicationDir();
        String key = (String)this.params.get("parameter.dir.rootapplication");
        this.params.put(key, dirname);
    }

    private void setUserPropertyFile() {
        String key = "parameter.file.user.property";
        try {
            this.params.put(key, this.fu.replaceTokens((String)this.params.get(key), this.params));
        }
        catch (Exception e) {
            this.params.put(key, "");
        }
    }

    private void getPathFile(boolean silent) {
        boolean pathFileExist;
        boolean notMain;
        String rootdir = "";
        String userPropertyDir = new File((String)this.params.get("parameter.file.user.property")).getParent();
        String mainprogram = (String)this.params.get("MAINPROGRAM");
        boolean bl = notMain = mainprogram == null || mainprogram.length() == 0;
        if (!notMain && !silent) {
            this.createUserDir(userPropertyDir);
        }
        Object[] resa = this.isSystemInitDirUsable();
        boolean usable = (Boolean)resa[0];
        boolean bl2 = pathFileExist = ((String)resa[1]).length() > 0;
        if (pathFileExist) {
            this.setPathParams(silent, this.osHandler.getInitDir());
            return;
        }
        if (this.getOnlyPathFile(userPropertyDir).length() > 0) {
            this.setPathParams(silent, userPropertyDir);
            return;
        }
        if (usable) {
            this.setPathParams(silent, this.osHandler.getInitDir());
            return;
        }
        rootdir = userPropertyDir;
        File dir = new File(rootdir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String rootfile = (String)this.params.get("PATHFILENAME");
        this.setPathParams(silent, userPropertyDir);
    }

    private void getUserProperties() {
        String file = (String)this.params.get("parameter.file.user.property");
        String datadir = "";
        try {
            File rfile = new File(file);
            if (rfile.exists()) {
                Properties pr = new Properties();
                datadir = this.getExistingMultilangDir(rfile, "prop.usr.root");
            }
            this.params.put("DESTINATIONDATADIR", datadir);
        }
        catch (Exception e) {
            this.params.put("DESTINATIONDATADIR", "");
        }
    }

    private void getEnvVariables() {
        Vector env = (Vector)this.params.get("userenvvariables");
        if (env == null) {
            return;
        }
        String var = null;
        for (int i = 0; i < env.size(); ++i) {
            Hashtable title = (Hashtable)env.elementAt(i);
            String key = (String)title.get("key");
            var = this.osHandler.getEnvironmentVariable(key);
            if (var == null) {
                var = "";
            }
            this.params.put(key, var);
        }
    }

    private int isInstalled() {
        String installPath;
        Hashtable inspage = (Hashtable)this.params.get("installedpage");
        try {
            String pv = (String)inspage.get("installpath");
            if (pv == null || pv.length() == 0) {
                return 0;
            }
            installPath = this.fu.replaceTokens(pv, this.params);
        }
        catch (Exception e) {
            return 0;
        }
        if (installPath == null || installPath.length() == 0) {
            return 0;
        }
        Vector neededFiles = (Vector)inspage.get("neededfiles");
        for (int i = 0; i < neededFiles.size(); ++i) {
            String fname;
            try {
                fname = this.fu.replaceTokens((String)neededFiles.elementAt(i), this.params);
            }
            catch (Exception e) {
                return -1;
            }
            if (this.fu.isExist(installPath, fname)) continue;
            return -1;
        }
        return 1;
    }

    private Hashtable collectData() {
        Hashtable out = new Hashtable();
        try {
            Hashtable inspage = (Hashtable)this.params.get("installedpage");
            String installPath = this.fu.replaceTokens((String)inspage.get("installpath"), this.params);
            out.put(inspage.get("destkey"), installPath);
        }
        catch (Exception e) {
            return out;
        }
        return out;
    }

    private void createUserDir(String path) {
        try {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPathParams(boolean silent, String rootdir) {
        this.params.put("PATHFILEDIR", rootdir);
        this.getOriginalPathFile(silent, rootdir);
    }

    private Object[] isSystemInitDirUsable() {
        Object[] result = new Object[]{Boolean.FALSE, ""};
        try {
            String rootdir = this.osHandler.getInitDir();
            String rootfile = (String)this.params.get("PATHFILENAME");
            String pv = "";
            File rfile = new File(rootdir + File.separator + rootfile);
            if (rfile.exists()) {
                Properties pr = new Properties();
                pv = this.getOnlyPathFile(rootdir);
                if (pv.length() != 0) {
                    result[0] = Boolean.TRUE;
                    result[1] = pv;
                    return result;
                }
                result[0] = rfile.canWrite() ? Boolean.TRUE : Boolean.FALSE;
                return result;
            }
            try {
                if (!rfile.createNewFile()) {
                    result[0] = Boolean.FALSE;
                    return result;
                }
                System.out.println("File access ok = " + rfile.getAbsolutePath());
                rfile.delete();
                result[0] = Boolean.TRUE;
                result[1] = "";
                return result;
            }
            catch (IOException e) {
                rfile.delete();
                result[0] = Boolean.FALSE;
                return result;
            }
        }
        catch (Exception e) {
            result[0] = Boolean.FALSE;
            return result;
        }
    }

    private void getOriginalPathFile(boolean silent, String rootdir) {
        String pathvar = (String)this.params.get("install.path.var");
        try {
            String pv = this.getOnlyPathFile(rootdir);
            if (silent) {
                this.params.put(pathvar, pv);
            } else {
                this.params.put(pathvar, this.chkFile(pv));
            }
        }
        catch (Exception e) {
            this.params.put(pathvar, "");
        }
    }

    private String getOnlyPathFile(String rootdir) {
        String pv = "";
        try {
            String rootfile = (String)this.params.get("PATHFILENAME");
            File rfile = new File(rootdir + File.separator + rootfile);
            if (rfile.exists()) {
                pv = this.getExistingMultilangDir(rfile, (String)this.params.get("install.path.varname"));
            }
            return pv;
        }
        catch (Exception e) {
            return pv;
        }
    }

    private String getExistingMultilangDir(File rfile, String key) {
        String pv = "";
        try {
            Properties pr1 = new Properties();
            try {
                pr1.load(new FileInputStream(rfile.getPath()));
            }
            catch (Exception e) {
                // empty catch block
            }
            Properties pr2 = new Properties();
            this.loadPropertyFile(rfile, pr2, CHAR_SET_UTF_8);
            Properties pr3 = new Properties();
            this.loadPropertyFile(rfile, pr3, CHAR_SET_ISO_8859_2);
            Properties pr4 = new Properties();
            this.loadPropertyFile(rfile, pr4, CHAR_SET_ISO_8859_1);
            pv = this.getValidFilePath(pr3, pr1, pr2, pr4, key);
            return pv;
        }
        catch (Exception e) {
            return pv;
        }
    }

    private String getValidFilePath(Properties pr1, Properties pr2, Properties pr3, Properties pr4, String key) {
        String pv1 = (String)pr1.get(key);
        if (this.existsDir(pv1)) {
            return pv1;
        }
        String pv2 = (String)pr2.get(key);
        if (this.existsDir(pv2)) {
            return pv2;
        }
        String pv3 = (String)pr3.get(key);
        if (this.existsDir(pv3)) {
            return pv3;
        }
        String pv4 = (String)pr4.get(key);
        if (this.existsDir(pv4)) {
            return pv4;
        }
        return pv1;
    }

    private boolean existsDir(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        File file = new File(fileName);
        return file.exists() && file.isDirectory();
    }

    private String chkFile(String filename) {
        try {
            File pvfile = new File(filename);
            if (!pvfile.exists()) {
                return "";
            }
            return filename;
        }
        catch (Exception e) {
            if (this.debugOn) {
                DebugInfo.showMessage("chk path = " + filename);
            }
            return "";
        }
    }

    private boolean loadPropertyFile(File inputFile, Properties pl, String charset) {
        BufferedReader br = null;
        String utf8_bom = String.valueOf(new char[]{'\uefbb', '\ubf00'});
        String utf16be_bom = String.valueOf('\ufeff');
        String utf16le_bom = String.valueOf('\ufffe');
        String utf32be_bom = String.valueOf(new char[]{'\u0000', '\ufeff'});
        String utf32le_bom = String.valueOf(new char[]{'\ufffe', '\u0000'});
        try {
            boolean first_line = true;
            boolean ret = true;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile.getPath()), charset));
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return ret;
                }
                if (first_line) {
                    if (line.startsWith(utf16be_bom)) {
                        line = line.substring(utf16be_bom.length());
                    } else if (line.startsWith(utf16le_bom)) {
                        line = line.substring(utf16le_bom.length());
                    } else if (line.startsWith(utf32be_bom)) {
                        line = line.substring(utf32be_bom.length());
                    } else if (line.startsWith(utf32le_bom)) {
                        line = line.substring(utf32le_bom.length());
                    } else if (line.startsWith(utf8_bom)) {
                        line = line.substring(utf8_bom.length());
                    }
                    first_line = false;
                }
                if ((line = line.trim()).length() <= 0 || line.startsWith(COMMENT)) continue;
                String[] prop = line.split(PROP_SEP, 2);
                String[] property = new String[]{"", ""};
                System.arraycopy(prop, 0, property, 0, prop.length);
                property[0] = this.getValidObject(property[0]).toString().trim();
                property[1] = this.getValidObject(property[1]).toString().trim();
                pl.put(property[0], property[1]);
            }
        }
        catch (Exception e) {
            try {
                br.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            boolean ret = false;
            return ret;
        }
    }

    private Object getValidObject(Object o) {
        if (o == null) {
            return "";
        }
        return o;
    }
}

