ITK Release 4.13
================

The Insight Segmentation and Registration Toolkit (ITK), is an open-source, cross-platform library for multidimensional image analysis. On behalf of the Insight Toolkit community, we are proud to announce that **ITK 4.13.0** has been released!

Links to the `Sourceforge.net` tarballs can be found on the download page:

Outline
----------

1. Introduction
2. New Features
3. ITK Changelog
4. ITK Sphinx Examples Changelog
5. ITK Software Guide Changelog

Introduction
---------------

Developed by an international community, ITK collects best-of-breed algorithms for registering, segmenting, analyzing, and quantifying n-dimensional imaging data. The high-quality library facilitates reproducible research, provides a software resource for teaching image analysis, and offers a platform for commercial product development.

Here are a few selected highlights for this release:

 - ITK is on PyPI: install ITK's Python wrapping with: `pip install itk`
 - IsotropicWavelets remote module: isotropic and steerable wavelets in the frequency domain
 - Improvement of the Image IO, including full 64 bit pixel support
 - ITK Python interface improvements: use ITK in a procedural way
 - Improved image and transform IO factory registration
 - ITK's thread pool refactored for improved performance
 - Improved ITK test driver to compare images spacing, origin, size and direction


This release brings multiple exciting new developments for ITK's Python wrapping.

**Binary Python Packages**
Binary Python wheels are available for Linux, macOS, and Windows, for Python 2.7 and the recent Python 3.X. The wheels have been published on PyPI, the Python package index. These binary wheels are built to be compatible with Python distributions from [Python.org](https://www.python.org/), system package managers like apt and Homebrew, and Anaconda. (official announcement [here](https://blog.kitware.com/itk-is-on-pypi-pip-install-itk-is-here)). This means that it has never been easier to install and start using ITK: one simple `pip install itk` command, and a few seconds later it is possible to start interactively processing images.

**External Module Python Packages**
Furthermore, Python packages for externally developed ITK modules can now be automatically generated and uploaded to PyPI. The module Python package is created by free GitHub continuous integration services. Like the main ITK packages, these packages embed documentation from Doxygen comments into Python docstrings. See https://blog.kitware.com/python-packages-for-itk-modules for details on how to get started. A number of novel ITK module Python packages have already been created this way, including

  - itk-bonemorphometry
  - itk-polartransform
  - itk-texturefeatures
  - itk-anisotropicdiffusionlbr
  - itk-ultrasound
  - itk-morphologicalcontourinterpolation
  - itk-cuberille
  - itk-ringartifact

**IsotropicWavelets Remote Module**
A Python package is available for a powerful new remote module, IsotropicWavelets. This module implements a multiresolution (MRA) analysis framework using isotropic and steerable wavelets in the frequency domain. This framework provides the backbone for state of the art filters for denoising, feature detection or phase analysis in N-dimensions. Since it is wrapped in Python, it is as easy to use as ITK: Install the module with `pip install itk-isotropicwavelets`. Write a Python script or start an interactive Python environment, and call `import itk`. All the functionality of IsotropicWavelets will be available.

**Procedural Filter Interface for Rapid Prototyping**
ITK v4.13.0 also incorporates an API improvement throughout the entire toolkit to facilitate rapid prototyping: ITK Python filters are now callables, so ITK can be used in a procedural way. It is possible to run filters without the need to declare a filter object first, and without the need to explicitly call ‘Update()’ on a pipeline.

`itk.imwrite(itk.MedianImageFilter(itk.imread(‘my_image.png’), Radius=4), ‘my_output.png’)`

This one-liner will read an image, filter it with the MedianImageFilter with a radius of 4 voxels, and save the result in a different file.

**Image IO Improvement, including Full 64 bit Pixel Support**
Several improvements have been made in the Image IO in this major release: 64 bit images are now consistently supported by all Image IOs. Additionally, MINC image IO is now enabled by default, Bruker IO improved and enabled by default, and DICOM support via DCMTK was greatly improved (and supported on MS Windows). See below “Improved Factory Registration” for the last improvement of Image IO in this release.

**GoogleTest for Writing Tests**
An ITK module can be tested with GoogleTest library, using the CMake funtion `CreateGoogleTestDriver()`,  in addition to the classic ITKTestDriver. This function will add the GTest dependency to your test.  GoogleTest makes it easy to write a lot of different tests to verify that your code works. Examples of tests using this framework can be found in ITK in `Modules/Filtering/ImageGrid/test/itkSliceImageFilterTest.cxx`, `/Modules/Filtering/ImageIntensity/test/itkArithmeticOpsFunctorsTest.cxx`, and several other files.

**Improved Factory Registration**
Each module (including remote modules) can list the factories and formats they support. This information is used to automatically register all formats supported by modules loaded during configuration. When loading ITK with the CMake command `find_package()` and loading a limited number of ITK components, it is now possible to load all modules corresponding to a factory, e.g. ImageIO, TransformIO. To load all components of a factory, add the component `ITK<factory>` in the list of requested components. Here is an example that finds ITK with the ITKCommon module and all the available image and transform IO modules:

  `find_package(ITK COMPONENTS ITKCommon ITKImageIO ITKTransformIO REQUIRED)`

**ITK's Thread Pool Refactored for Improved Performance**
ITK's thread pool has been refactored for improved performance. To test the thread pool, set the environment variable:

  `ITK_USE_THREADPOOL=1;`

Or, call the static method

  `itk::MultiThreader::SetGlobalDefaultUseThreadPool(true);`

at the start of your application. The thread pool is still experimental, and its implementation and interface will be improved and modified in the near future.

**Improved ITK test driver to compare images spacing, origin, size and direction**
In part to support improved testing and support for DICOM image metadata, the ITK test driver now checks image spacing, origin, and direction when making baseline image comparisons. If your project uses the ITK test driver, new image baselines with correct metadata information may be required. Alternatively, pass the `--ignoreInputInformation` flag to the test driver.

<br>

**Congratulations** to the **26** contributors to this release. We would especially like to recognize the **new contributors**: Laura Pascal, Beatriz Paniagua, Rene-Paul Debroize, Edwin Bennink, David Kügler, Adrien Bailly, and Steve Pieper.


The next feature release, scheduled for June 2018, will be ITK 5.0. This release will introduce thread pools by default with an optional Intel Threading Building Blocks (TBB) backend, require C++11 compiler support, and require a newer version of CMake.


New Features
------------------
* Wrapping Improvements
  - Binary Python packages are now available for Linux, macOS, and Windows. Install with:
```
          pip install --upgrade pip
          pip install itk
```

  - ITK modules developed on GitHub can generate their own Python package with freely available continuous integration services.
     - [https://blog.kitware.com/python-packages-for-itk-modules](https://blog.kitware.com/python-packages-for-itk-modules)
     - Example module Python packages now pip installable from PyPI: `itk-bonemorphometry`, `itk-polartransform`, `itk-texturefeatures`, `itk-anisotropicdiffusionlbr`, `itk-ultrasound`, `itk-morphologicalcontourinterpolation`, `itk-cuberille`, `itk-isotropicwavelets`, `itk-ringartifact`
  - Add wrapping for several classes: `MultiResolutionIterationEvent`, `RegionOfInterestFilter` for `VectorImage`'s, `FloatingPointExceptions`, `CorrelationMetricv4`, `DemonsMetricv4`, `JointHistogramMIMetricv4`, `ITKIOMesh`.
  - Enable `__call__()` function in Python for `itkTemplate` objects to make ITK more Pythonic. A developer can run instantiate, run a filter, and get the output, in one single command.
  - Python docstrings are generated from the C++ doxygen documentation and directly integrated in the Python modules.
  - The `unsigned short` pixel type is now supported in ITK Python packages.
  - Bruker IO wrapping

* New Remote Modules
  - SimpleITKFilters
    - The filters in this module may be wrappers of composites ITK filters, adapters of existing ITK filters or alternative implementations designed for SimpleITK's requirements.
    - [http://github.com/SimpleITK/ITKSimpleITKFilters](http://github.com/SimpleITK/ITKSimpleITKFilters)
  - TextureFeatures
    - Filters to estimate texture feature maps from N-dimensional grayscale images.
    - [http://hdl.handle.net/10380/3574](http://hdl.handle.net/10380/3574)
  - IsotropicWavelets
    - An ITK-based implementation of steerable isotropic wavelet transforms for multiscale phase analysis.
    - [http://hdl.handle.net/10380/3558](http://hdl.handle.net/10380/3558)

* Core Improvements
  - GoogleTest available for testing in ITK
  - Support VCPKG, Microsoft's vcpkg C++ package management system for Visual Studio
  - Refactor ITK's ThreadPool implementation for performance
  - Addition of type long long and unsigned long long for images
  - Add options to `itkTestDriver` and `itkTestingComparisonImageFilter` to compare image size, origin, spacing, and direction
  - Add `itk_module_examples()` macro to simplify the creation of independent examples in remote modules
  - Improve factory registration mechanism (see highlighted features)
  - ITK Python modules now share the list of factories that are registered
  - Automatic enabling of the `-fPIC` flag for external modules
  - Detect the presence of `feenableexcept` to compile on Alpine Linux
  - Update GDCM import script for changes in upstream content
  - CMake minimum required version is now 2.8.12

* Filtering Improvements
  - Improve `Not` functor and filter to follow other logic functors
  - Separate functors from filters in header by operator groups
  - Move rank filters out of review
  - Explicitly warn and deprecate negative pixel spacing
  - Add `SliceImageFilter`
  - Move advance Demons registration filters out of review
  - Add `ShapeLabelObject::GetRegion` method
  - Many improvements in `HoughTransform2DCirclesImageFilter`

* IO Improvements
  - Enable MINC IO by default
  - PNG IO was crashing instead of returning false when it couldn’t read image
  - Several DCMTK improvements: build DMCTK on Windows, replace ICONV with ICU in DCMTK dependencies, support color images (RGB/RGBA)
  - Use double floating point API for MetaImage: the text representation is now closer to the
DICOM Image Orientation (Patient) or Image Position (Patient) attribute and will allow easier conversion from one representation to the other.
  - Fixed `<nifti1_io.h>` leak into user code
  - Updated the Bruker2DSeq reader to ParaVision 6.0
  - ITKIOBruker is now its own module, migrated out of ITKReview

* Documentation Improvements
  - Improvement of documentation Markdown files throughout the repository
  - Update old file headers/copyright notices.
  - Improve source code coding style
  - Enable offline Doxygen support
  - Expose `RayCastInterpolateImageFunction` members in Doxygen
  - Updated documentation for `LabelStatisticsImageFilter::GetBoundingBox`.
  - Document behaviors of `ChangeLabelLabelMapFilter`
  - New content in the [ITK Software Guide](https://itk.org/ItkSoftwareGuide.pdf) on
    - Cross compilation
    - An entire new Coding Style Guide section
    - Python usage
    - Build configuration

* Remote Module Updates
  -  AnisotropicDiffusionLBR (08.31.2017)
  - Update MorphologicalContourInterpolation (09.22.2017)

* Third Party Library Updates
  - Update pygccxml version (v1.9.0)
  - Update libPNG to track upstream libpng16 branch
  - Update version of DCMTK to 3.6.1_20170529
  - Update CastXML to support GCC 7 (11.06.2017)
  - Update MetaIO (12.04.2017)
  - Adding libLBFGS third party library
  - Update MINC (09.14.2017)
  - Update VNL (10.05.2017)

* *Lots* of important bug fixes

* And much more! See details in the log below.


Changes from v4.12.0 to v4.13.0
------------------------------------------------

Adrien Bailly (1) @adrien.bailly :
      ENH: add wrapping for MultiResolutionIterationEvent and other missing event

Beatriz Paniagua (2) @bpaniagua :
      ENH: Updating pygccxml version
      ENH: Updating libPNG to track upstream libpng16 branch

Brad King (2) @brad.king :
      ENH: Port GDCM update script to update-third-party.bash
      ENH: Update GDCM import script for changes in upstream content

Bradley Lowekamp (93) @blowekamp :
      DOC: fix spelling transfrom->transform
      ENH: Improve Not functor and filter to follow other logic functors
      ENH: Separate functors from filters in header by operator groups
      DOC: Fix spelling mistakes from SimpleITK JSON, from spellintian
      ENH: making available GoogleTest for testing in ITK
      COMP: Address missing ITK_TEMPLATE_EXPORT definition
      COMP: Use single line for string argument, by-pass multi-line issues
      COMP: Revert to CMake 2 compatible line comment
      ENH: Move rank filters out of review
      BUG: Use const for pipeline inputs and state functions
      ENH: Explicitly warn and deprecate negative pixel spacing.
      BUG: Modify google test to define _VARIADIC_MAX=10
      COMP: Fix using system GoogleTest with a compiled system library
      ENH: Add SliceImageFilter
      COMP: Use itk::Math::abs over vnl_math_abs
      ENH: Add GetProbe method to collectors base.
      BUG: Add missing exports for GTest::* targets
      BUG: Fix computation of central moments for shape label map
      ENH: Adding operator functors from SimpleITK
      ENH: Choose efficient central moment computation for run
      BUG: Add missing OrientedBoundingBox option
      DOC: recommend using separate instances
      BUG: Manually set seed for ParticleSwarmOptimzerTest
      BUG: Fix computation of oriented bounding box
      BUG: shape label object elongation incorrectly zero
      ENH: Add GTest utilities for ITK
      ENH: adding explicit testing of computed label shape attributes
      BUG: Propagate make program to KWStyle ExternalProject
      BUG: Error only when unknown module is enabled.
      DOC: Document behaviors of ChangeLabelLabelMapFilter
      BUG: Document and assert improper usage of transform methods.
      COMP: Enable hidden visibility property with GoogleTest static libraries
      DOC: Doxygen namespace tag must be full namespace
      BUG: Fix computation for Jacobian local vector
      BUG: Cast to PrintType for MaskLabel variable printing
      ENH: Update FixedPointInverseDisplacementField remote module
      BUG: Error only when unknown module is enabled.
      BUG: Fix computation of central moments for shape label map
      BUG: shape label object elongation incorrectly zero
      BUG: Fix computation of oriented bounding box
      BUG: Add missing OrientedBoundingBox option
      ENH: Update FixedPointInverseDisplacementField remote module
      ENH: Only remove hidden visibility for C file with CMake<3
      BUG: Print missing Seeds parameter and values used for Upper/Lower
      ENH: Remove unneeded m_Upper and m_Lower ivars
      ENH: Prefer raw pointers for pipelined owned objects
      ENH: Update to use CircleCI 2.0
      ENH: Enable MINC IO by default
      ENH: Move advance Demons registration filters out of review
      BUG: Fix CircleCI command to upload test results
      ENH: Test SliceBySlice with non-zero index
      BUG: Use same origin for internal image as input image
      BUG: Remove duplicate code from local commit
      COMP: Remove MINC library level exports
      ENH: Add ProcessObject::AddOptionalInputName and more named inputs
      ENH: Make more use of AddOptionalInputName
      BUG: Use input macros for const correct pipeline inputs
      ENH: Remove input name when renamed and add tests
      BUG: Correct OBB names in GetAttributeFromName
      ENH: Add ShapeLabelObject::GetRegion method
      ENH: Hide MINC data in MINCIImageIO interface
      BUG: Remove newly added warning in ProcessObject AddRequiredInput
      BUG: Apply constant function specifier
      BUG: Fix marking of required inputs for GPU PDE registration
      BUG: Add missing getter method for PDE InitialDisplacementField
      ENH: Use Input macros for set/get GPU PDE inputs
      ENH: Move private GE format headers to src
      ENH: CircleCI use ccache and cache external data
      ENH: Extract reusable code into a copy image information functor
      ENH: Change Cast parent class to InPlaceImageFilter
      BUG: Add search paths for GoogleTest as source code on system
      BUG: Update BinaryImageToLabelMapFilter::m_NumberOfLabels
      COMP: Remove shadowing typedef
      ENH: Updating remote module TextureFeatures to 3.0.0
      COMP: Use integer suffix for long long types
      BUG: Disable checking of OBB origin
      PERF: Use initialized global variable for default number of threads
      ENH: Add remote mote SimpleITKFilters
      ENH: Add type for MultiThreader used by the ProcessObject
      BUG: Don't use void pointer
      BUG: Fix LBFGS2 iteration count and iterface
      BUG: Use AutoPtr for initialization based resource acquisition
      BUG: Fix factory registration during static initialization
      BUG: Fix const correctness of GetDisplacementField, use named input
      STYLE: Use LineSearch conventions
      BUG: Relax timeout to 60 seconds for itkSimpleFastMutexLockTest
      COMP: Mark itkTimeVaryingBSplineVelocityFieldImageRegistrationTest long
      COMP: Address linking error using operator<<
      COMP: Must define target before adding compile definitions
      COMP: Issue a CMake warning if ITKV3_COMPATIBILITY
      COMP: Enable CMP0063, support setting visibility properties
      COMP: Enable CMP0063, support setting visibility properties
      COMP: Enable CMP0063, support setting visibility properties

David Kügler (1) @david.kuegler :
      BUG: better support for OBJ mesh format

Dženan Zukić (21) @dzenanz :
      ENH: adding an example and improving tests
      ENH: support VCPKG
      ENH: rewriting ThreadPool and enabling it by default
      ENH: docs and compiler fix for ThreadPool, improvements of itkBarrierTest
      ENH: turning off thread pool by default for now
      STYLE: minor fix in debug mode and clearer code intent by using macros
      STYLE: warn users of the DeformableSimplexMesh3DFilter's limitations
      ENH: Addition of type long long and unsigned long long for images
      STYLE: VTK Mesh IO code simplification
      COMP: fixing warnings
      BUG: a call to SetGlobalDefaultNumberOfThreads was not respected
      BUG: LONGLONG was not handled by DCMTKImageIO
      BUG: PNG IO: return false instead of crashing in CanReadFile
      COMP: fix a warning
      BUG: ThreadPool hangs on Windows when ITK is compiled as DLLs
      BUG: tests writing to the same file randomly fail during parallel invocation
      COMP: fixing 2 compile errors on some compilers
      ENH: adding JSON format report to resource probe
      BUG: NIFTI crashing when requested region is set
      BUG: colliding file names caused spurious test failures
      BUG: fix two rename mistakes introduced in previous patch

Edwin Bennink (1) @ebennink :
      BUG: Fixed cylinder bbox, fixed and enhanced IsInside func

Floris Berendsen (2):
      COMP: add symbol name mangling for niftilib in ITK
      COMP: add symbol name mangling for niftilib in ITK

Francois Budin (54) @fbudin :
      ENH: Bump ITK version to 4.13.0.
      BUG: Update external data content links
      ENH: Add cleanup option to content synchronization script
      BUG: Used ITK_HAVE_FEENABLEEXCEPT instead of ITK_HAS_FEENABLEEXCEPT
      BUG: Used ITK_HAVE_FEENABLEEXCEPT instead of ITK_HAS_FEENABLEEXCEPT
      Revert "Merge branch 'feenableexcept-musl-for-release' into release"
      Merge branch 'upstream-metaio' into update_metaIO
      ENH: Bump CMakeLists.txt version to 4.12.1.
      COMP: Remove -fvisibility-inlines-hidden warning with CMake 2.8.12
      BUG: Remove VNL view from array functions and rename wrong variable
      BUG: itkSimilarity2DTransform was not reporting singular matrices
      ENH: Add test to verify ITK-3553 fixes
      BUG: itkTestingComparisonImageFilter should derive from itkImageToImageFilter
      BUG: Update tests to use ImageToImage compare image filter
      ENH: Add options to itkTestDriver and itkTestingComparisonImageFilter
      ENH: Adds MINC image IO wrapping
      ENH: Replace ICONV with ICU to compile DCMTK
      DOC: Document that workaround MSVC 2017 optimization bug has been corrected
      BUG: sha512 file must exist before complaining that it hasn't been updated
      BUG: Missing files for DCMTK ImageOrientation test
      BUG: itkgdcmopenjp2 was not exported in the build tree in GDCM
      BUG: Duplicate SetInput()/GetInput() in itkTestingComparisonImageFilter
      BUG: ICU_ARGS CMake variable should be declared CACHE
      BUG: Typo in CMake variable name
      BUG: Build DMCTK on Windows
      BUG: Support color images (RGB/RGBA) with DCMTK
      ENH: Add test for colored images loaded with DCMTK
      BUG: ICU is always compiled statically
      ENH: Update DCMTK build instructions for Windows
      ENH: Adds itk_module_examples() macro
      COMP: Bump CMake required version to 2.8.12
      ENH: Simplify itk-module-init.cmake for DCMTK
      BUG: Inconsistent image information between result and baseline
      BUG: Python docstrings were not generated anymore
      ENH: Add __call__() function in Python itkTemplate objects
      BUG: DMCTK configuration with ICU on Windows was only correct for VS2017
      BUG: Remove man page generation that is not necessary anymore
      ENH: Improving factory registration
      ENH: Adding factory components
      ENH: Update remote modules using FACTORY_NAMES
      BUG: Add previously removed function __getattr__() in `itkTemplate.py`
      BUG: Synchronize factories across modules in Python
      ENH: Allow RAW itk-module as shared library
      BUG: ITK_WRAP_DOC should not be saved in ITKConfig.cmake
      BUG: Remove unicode characters that stop python docstring generation
      BUG: `doxy2swig.py` failed with Python3
      BUG: Allow compilation of VNL with MSVC<1600
      BUG: \default is not a doxygen keyword
      BUG: Better control of GDCM symbols with CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS
      ENH: github comparison instead of shortlog in `UpdateThirdPartyFromUpstream.sh`
      BUG: DCMTK CMakeLists.txt detects MSVC versions in [1910,1919] as MSVC2017
      BUG: itkObjectFactoryBase was making ITK initialization crash
      BUG: itkSpatialObject.cxx was not respecting ITK_FUTURE_LEGACY_REMOVE
      BUG: Create IO Meta modules at module loading time

GCC-XML Upstream (1):
      ENH: pygccxml v1.9.0 (reduced)

GDCM Upstream (4):
      GDCM 2017-09-15 (87e3c363)
      GDCM 2017-10-13 (46919364)
      GDCM 2017-11-09 (af81d444)
      GDCM 2017-11-23 (4c51c343)

Google double-conversion Maintainers (1):
      ENH: Google double-conversion (reduced)

GoogleTest Upstream (2):
      googletest 2016-07-14 (a3ac2d7f)
      GoogleTest 2017-12-11 (0fe96607)

Hans Johnson (7) @hjmjohnson :
      BUG: vnl_fft_1d lacks sufficient numerical stability
      COMP: Clang compiler regression
      ENH: Synchronized with cmake version of file
      BUG: Respect ITK_FUTURE_LEGACY_REMOVE
      COMP: Missing ITK_OVERRIDE for BinaryPruningIMageFilter
      BUG: Fix non-windows cmake configuration regression
      COMP: Fix VariationalRegistration for future const GetMacro support

Jean-Baptiste VIMORT (2) @jbvimort :
      ENH: Automatic enabling of the -fPIC flag for external modules
      ENH: Supression of GDCM's linking to CoreFoundation

Jean-Christophe Fillion-Robin (6) @jcfr :
      ENH: Support installing each module python wrapping independently
      COMP: Update KWsys to set MACOSX_RPATH property based on CMAKE_MACOSX_RPATH
      COMP: Update MINC to set MACOSX_RPATH property based on CMAKE_MACOSX_RPATH
      COMP: ITKModuleExternal: Reset targets file
      BUG: Fix hook clone
      COMP: UseITK: Fix configure error due to different subproject requirements

Jon Haitz Legarreta Gorroño (37) @jhlegarreta :
      ENH: Improve coverage for v3 compatibility image arithm filters.
      DOC: Fix typo in 'exception'.
      STYLE: Improve the itk::FastMarchingImageFilterBase class style.
      STYLE: Improve itkApproximageSignedDistanceMapImageFilterTest style.
      ENH: Check for input/output objects with an assertion.
      BUG: Fix const casting compiler errors.
      DOC: Update old file headers/copyright notices.
      STYLE: Improve the itkSmoothingRecursiveGaussiaImageFilter style.
      ENH: Improve coverage for itkSmoothingRecursiveGaussianImageFilter.
      BUG: Fix links to NOTICE and LICENSE files in `README.md`.
      STYLE: Conform (partially) to ITK coding style.
      DOC: Add missing links to Markdown file cross-refs.
      ENH: Add a Pull Request template.
      DOC: Remove extension to Markdown cross-ref link text.
      STYLE: Change SubtractConstantFromImageFilterTest name.
      BUG: Add missing input image iterator declaration.
      BUG: Fix Superclass names in V3Compatibility tests.
      DOC: Fix wrong comments in V3Compatibility tests.
      DOC: Correct the preferred class names in ITKv4.
      COMP: Fix valgrind-detected uninitialized members.
      ENH: Improve coverage for itkWarpHarmonicEnergyCalculator.
      ENH: Bump lastest version of remote repository.
      ENH: Display error message in Iterator classes' wrapping.
      DOC: Add links to NOTICE and LICENSE files in README.
      DOC: Rework the contributing files.
      DOC: Document how to upload binary data in a Markdown file.
      DOC: Transition ThirdParty top-level README files to Markdown.
      DOC: Add third party project updating documentation markdown file.
      DOC: Document the release process in a Markdown file.
      DOC: Transition Utilities/Maintenance/README Markdown.
      DOC: Remove Documentation/Style.pdf file.
      DOC: Redirect the "Submit a patch" link to `CONTRIBUTING.md`.
      DOC: Mention the ITK full name in `README.md`.
      DOC: Fix broken links and oversights in `CONTRIBUTING.md`.
      DOC: Add a `GitHelp.md` resource to Documentation.
      DOC: Make the ITK long name be consistent in .md files.
      DOC: Create ISSUE_TEMPLATE.md

KWSys Upstream (1):
      KWSys 2017-10-17 (fc4d55ba)

Laura Pascal (2):
      ENH: Update version of DCMTK to 3.6.1_20170529
      ENH: Update the DoubleConversion library upstream update script.

Mathieu Malaterre (4) @mathieu.malaterre :
      ENH: Explicit set the precision when printing double
      ENH: Use double floating point API for MetaImage
      ENH: Define a global default double precision for MetaImage
      ENH: Enforce data truncation for legacy tests

Matthew McCormick (52) @matt.mccormick :
      ENH: Add install rules for External Module Python package
      COMP: Do not wrap std::_Deque_alloc
      ENH: Wrap RegionOfInterestFilter for VectorImage's
      COMP: Disable CoreFoundation calls
      ENH: Execute the merge when updating third party subtrees
      ENH: Allow custom repo and branch for MetaIO subtree updates
      COMP: Specify AR to PCRE build on macOS
      BUG: Mark GoogleTest CMake options as advanced
      COMP: Address LBFGS2Optimizerv4 doxygen warnings
      BUG: ITKIOGE has a public dependency on ITKIOIPL
      COMP: Bump KWStyle to latest master
      ENH: Add TextureFeatures remote module
      COMP: Detect the presence of mallinfo
      COMP: IsNull() capitalization in LevelSetEquationAdvectionTerm
      ENH: Wrap FloatingPointExceptions
      COMP: Use GDCM_HAVE_BYTESWAP_H
      COMP: Fail early when byteswap functions are not available
      COMP: Detect the presence of feenableexcept
      BUG: Use itkGetConstObjectMacro for LogBiasFieldControlPointLattice
      COMP: Detect the presence of feenableexcept
      COMP: Use GDCM_HAVE_BYTESWAP_H
      COMP: Fix AnisotropicDiffusionLBR example build
      BUG: Correct GPUMeanImageFilter Superclass
      BUG: Remove debug code from GPUMeanImageFilter
      BUG: Do not use static_cast, SmartPointer in GPUImage::GetGPUDataManager
      BUG: Remove debug code in itkGPUImage.hxx
      COMP: Do not call vector.data() in ITKIOBruker
      ENH: Bump CMakeLists.txt version to 4.12.1
      DOC: Format the README in markdown syntax
      DOC: Enable offline Doxygen support
      BUG: ITKIOMINC DEPENDS on ITKMINC
      BUG: Update Bruker IO wrapping after migration from ITKReview
      COMP: Update MorphologicalContourInterpolation to 2017-09-22
      DOC: Do not pre-cache Doxygen php files
      DOC: Expose RayCastInterpolateImageFunction members in Doxygen
      BUG: RayCastInterpolateImageFunciton physical space issues
      COMP: Overloaded - operator ambiguous in RayCastInterpolateImageFunction
      BUG: Add missing template export for GradientAnisotropicDiffusionImageFilter
      ENH: Wrap {Correlation,Demons,JointHistogramMI} Metricv4
      ENH: Add Python wrapping for ITKIOMesh
      BUG: Hide HDF5 CMake options from main configuration
      BUG: Add DCMTK external project dependency after ExternalProject_Add
      COMP: Bump CastXML to 2017-11-06 master
      BUG: Fix hooks clone when ITK is a submodule
      BUG: Remove duplicate entries of ITK_WRAP_PYTHON_LIBRARY_IMPORTS
      DOC: Remove broken HoughTransform2DCircles wiki examples link
      DOC: NeighborhoodIterator documentation formatting improvements
      COMP: Do not use export macro in vnl_amoeba default_verbose
      COMP: HoughTransform2DCirclesImageFilter lines too long for Software Guide
      BUG: Reset LIST_OF_IMAGEIO_FORMATS in UseITK.cmake
      COMP: Do not wrap itk::ObjectFactoryBasePrivate
      DOC: Update Python package release process

MetaIO Maintainers (5):
      MetaIO 2017-07-20 (92caf34d)
      MetaIO 2017-08-17 (3e1cb552)
      MetaIO 2017-10-04 (55395e3d)
      MetaIO 2017-08-31 (5f935e1b)
      MetaIO 2017-12-04 (02a2e22e)

Niels Dekker (23) @Niels_Dekker :
      COMP: Fixed <nifti1_io.h> leak into user code
      STYLE: Replaced NiftiImageHolder by AutoPointer
      COMP: Fixed "gifti_io.h" leak into user code
      COMP: Fixed "Ge5xHdr.h" leak into user code
      PERF: Break out of loop as soon as requested number of circles is found
      STYLE: Removed useless (or obsolete) local bool, 'found'.
      PERF: Avoid redundant search in GetCircles(n)
      PERF: GetCircles now calls Graft, instead of copying pixels from GetOutput(0)
      DOC: Added comment that the grafted output image should not be modified.
      STYLE: Removed HoughTransform GetCircles parameter (n) which appears obsolete
      ENH: Added deprecated GetCircles(unsigned int) overload to HoughTransform
      COMP: Replaced deprecated GetCircles(n) call in HoughTransform example
      BUG: HoughTransform CirclesList should be empty when NumberOfCircles is zero
      ENH: Tested HoughTransform CirclesList is empty when NumberOfCircles is zero
      BUG: HoughTransform GetCircles() should avoid circles with accumulator <= 0
      STYLE: Removed HoughTransform GetLines parameter (n), which appears obsolete
      ENH: Improved HoughTransform2DCirclesImageFilter accuracy, using Math::Round
      BUG: HoughTransform GetLines() returned too many lines
      PERF: Improved speed of HoughTransform2DCirclesImageFilter::GenerateData()
      STYLE: HoughTransform calling convenience overload of SetVariance
      DOC: Mentioned that HoughTransform2DCirclesImageFilter also finds discs
      ENH: Allow different types accumulator and radius image Hough Circles filter
      BUG: Access violation itkGaussianDerivativeOperatorTest argv[0]

Pablo Hernandez-Cerdan (4) @phcerdan :
      ENH: Add External Module IsotropicWavelets.
      ENH: Update ExternalModule IsotropicWavelets to v0.4
      ENH: Update IsotropicWavelets
      COMP: Fix macro ITK_NOEXCEPT, deprecate ITK_NOEXCEPT_OR_THROW

Rene-Paul Debroize (1):
      ENH: Add remote module TBBImageToImageFilter

Samuel Gerber (2):
      ENH: Adding libLBFGS third party library
      BUG: stdint.h missing on Visual Studio 9

Sean McBride (17) @seanm :
      COMP: Added missing ITK_OVERRIDE
      COMP: fixed compilation error with int vs nullptr_t
      PERF: Fixed some comments; prefer preincrement
      COMP: Set GDCM_USE_COREFOUNDATION_LIBRARY off
      COMP: add itk prefix to gdcmopenjp2 library name
      COMP: Fixed some -Winconsistent-missing-override warnings
      COMP: Added ITK_OVERRIDE to hundreds of destructor declarations.
      COMP: Made ITK_OVERRIDE work only in MSVC >= 2012 (instead of 2010)
      COMP: Fixed Wshadow warnings by removing shadows
      COMP: Added a bunch more missing ITK_OVERRIDE
      COMP: suppress all compilers warnings from third party google test
      COMP: Added yet more ITK_OVERRIDEs, mostly on destructors
      COMP: Added yet more ITK_OVERRIDEs
      COMP: Fixed various -Wconst-qual warnings
      COMP: Fixed some Wcast-qual warnings
      COMP: Removed superfluous declarations in subclass, fixing override warnings
      COMP: Silence -Wunused-template warnings by making affected methods inline

Simon Rit (1) @simon.rit :
      COMP: remove dynamic exception specifications

Steve Pieper (1) @pieper  :
      BUG: ITK-3553 fixes ImageOrientation issue in DCMTK reader

Tobias Wood (3) @spinicist :
      ENH: Updated the Bruker2DSeq reader to ParaVision 6.0
      BUG: Bruker2dseq was not registered correctly due to module name change.
      BUG: Fixed origin & orientation issues.

VXL Maintainers (2):
      VNL 2017-10-05 (dd7794d9)
      VNL 2017-12-08 (a1573ca8)

Vladimir S. FONOV (2):
      MINC 2017-09-14 (e11c6df9)
      MINC 2017-10-18 (f2d06a67)

Ziv Yaniv (2) @zivy :
      DOC: Updated documentation for LabelStatisticsImageFilter::GetBoundingBox.
      BUG: itkVTKImageIO::CanWriteFile accepted files with wrong extension.

ITK Sphinx Examples Changelog
-----------------------------------------------

Bradley Lowekamp (1) @blowekamp :
      Add python syntax highlighting

Dženan Zukić (1) @dzenanz :
      COMP: allow examples to build when ITK_LEGACY_REMOVE is enabled

Francois Budin (1) @fbudin :
      ENH: Bump ITK version to 4.13.0

Jon Haitz Legarreta Gorroño (6) @jhlegarreta :
      ENH: Add WatershedImageFilter example.
      ENH: Improve layout and doc for adaptive histogram equalization example.
      ENH: Update the ToDo list of examples to import from Wiki.
      ENH: Add an example for itk::AdaptiveHistogramEqualizationImageFilter.
      BUG: Fix the example images not being rendered.
      DOC: Improve the README.rst code syntax.

Matt McCormick (2) @matt.mccormick :
      DOC: Update documentation to install PyPI package
      STYLE: Make Python code in src/ flake8 compliant


ITK Software Guide Changelog
-----------------------------------------------

Francois Budin (1) @fbudin :
      ENH: Add patch number to ITK version in Software guide

Jon Haitz Legarreta Gorroño (21) @jhlegarreta :
      ENH: Make class and brief dcostring keywords' start columns consistent.
      DOC: Update the ITK logo to the new ITK logo.
      DOC: Fix `ParseCxxExamples.py` script location in `README.md`.
      DOC: Fix use of \center vs. \centering in figures.
      DOC: Update to the official name of Apple OS systems.
      DOC: Remove redundant greater-than sign in path.
      DOC: Keep ITK CMake minimum required version consistency.
      DOC: Update the Advanced Module Configuration CMake options.
      DOC: Update Figures 2.2 and 2.3 in Advanced Module Configuration.
      DOC: Update supported compilers' list.
      DOC: Transition SoftwareGuide/Cover and Latex READMEs to Markdown
      DOC: Fix ITK long name case mismatch.
      DOC: Fix Coding Style Guide formatting issues.
      DOC: Add Documentation Style section.
      DOC: Add a CMake Style item to the Overview section.
      DOC: Mention the ITK full name in common abstract.
      DOC: Add a cross compilation section to Configuring and Building ch.
      DOC: Add content to empty example in Variable Initialization
      DOC: Use tilde to connect names and references.
      DOC: Enhance the `README.md` syntax.
      DOC: Add a test layout subsection.

Matt McCormick (17) @matt.mccormick :
      DOC: Correct Coding Style Guide doxygen links
      ENH: Enable specification of ITK_GIT_TAG in the superbuild
      COMP: Use the xcolor package instead of color
      ENH: Split Running and Parsing examples into an ExternalProject
      ENH: Improve EPS conversion operation output
      ENH: Add support for Ninja job pools
      COMP: Address undefined colorlet command
      COMP: Undefined toprule command
      COMP: Undefined control sequence cellcolor
      COMP: Undefined table configuration
      BUG: Do not add_subdirectory(Examples) for ITKSoftwareGuide build
      BUG: Do not depend on Examples generated .tex sources
      BUG: Update ITK version to 2017-12-15 master
      COMP: Remove ITKV3_COMPATIBILITY
      ENH: Add CircleCI configuration
      ENH: Propagate CMAKE_{C,CXX}_COMPILER_LAUNCHER in superbuild
      ENH: Bump ITK version to 4.13.0
