package junit.test.svg;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGSVGElement;

import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/** 
 * This class contains tests for the SVGSVGElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/12/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGSVGElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGSVGElement(null);
			fail();
		}
		catch(Exception e){/**/}
		
		try { new SVGSVGElement(node, null); }
		catch(MalformedSVGDocument e){ fail(); }
	}
	
	
	
	@Test
	public void testGetDefs()
	{
		try
		{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder builder = factory.newDocumentBuilder();
	        Document document = builder.newDocument();
			Element elt, n;
	        SVGSVGElement e = new SVGSVGElement(node, null);
			
			assertNull(e.getMeta());

			n = document.createElement(SVGElements.SVG_SVG);
			n.setAttribute("xmlns", SVGDocument.SVG_NAMESPACE);
			elt = document.createElement(SVGElements.SVG_DEFS);
			n.appendChild(elt);
			e = new SVGSVGElement(n, null);
			assertNotNull(e.getDefs());
		}
		catch(Exception e) { fail(); }
	}
	
	
	
	@Test
	public void testGetMeta()
	{
		try
		{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	        DocumentBuilder builder = factory.newDocumentBuilder();
	        Document document = builder.newDocument();
			Element elt, n;
	        SVGSVGElement e = new SVGSVGElement(node, null);
			
			assertNull(e.getMeta());

			n = document.createElement(SVGElements.SVG_SVG);
			n.setAttribute("xmlns", SVGDocument.SVG_NAMESPACE);
			elt = document.createElement(SVGElements.SVG_METADATA);
			n.appendChild(elt);
			e = new SVGSVGElement(n, null);
			assertNotNull(e.getMeta());
		}
		catch(Exception e) { fail(); }
	}
	
	
	
	
	@Test
	public void testGetHeight()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "200");
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertEquals(e.getHeight(), 200.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertTrue(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			e = new SVGSVGElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			e = new SVGSVGElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			e = new SVGSVGElement(node, null);
			assertTrue(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetY()
	{
		try
		{
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertEquals(e.getY(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_Y, "-10");
			e = new SVGSVGElement(node, null);
			assertEquals(e.getY(), -10.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetX()
	{
		try
		{
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertEquals(e.getX(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_X, "10");
			e = new SVGSVGElement(node, null);
			assertEquals(e.getX(), 10.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetWidth()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "100");
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertEquals(e.getWidth(), 100.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testVersion()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_VERSION, "1.1");
			SVGSVGElement e = new SVGSVGElement(node, null);
			assertEquals(e.getVersion(), "1.1");
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_SVG;
	}
}
