/* ----- multiscalar/ed25519, derived from supercop/crypto_multiscalar/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *multiscalar_ed25519_checksums[] = {
  "4835e913d35c3c10ad459c2154c0b2041f0621b3f4f837b86f41d7c37917864b",
  "b0c5400d6d1550c8f56869e0fdf87a524c523f7fd2c59701a9982f1c90f6d6bc",
} ;

static void (*crypto_multiscalar)(unsigned char *,const unsigned char *,const unsigned char *,long long);
#define crypto_multiscalar_SCALARBYTES lib25519_multiscalar_ed25519_SCALARBYTES
#define crypto_multiscalar_POINTBYTES lib25519_multiscalar_ed25519_POINTBYTES
#define crypto_multiscalar_OUTPUTBYTES lib25519_multiscalar_ed25519_OUTPUTBYTES

static void *storage_multiscalar_ed25519_Q;
static unsigned char *test_multiscalar_ed25519_Q;
static void *storage_multiscalar_ed25519_n;
static unsigned char *test_multiscalar_ed25519_n;
static void *storage_multiscalar_ed25519_P;
static unsigned char *test_multiscalar_ed25519_P;
static void *storage_multiscalar_ed25519_Q2;
static unsigned char *test_multiscalar_ed25519_Q2;
static void *storage_multiscalar_ed25519_n2;
static unsigned char *test_multiscalar_ed25519_n2;
static void *storage_multiscalar_ed25519_P2;
static unsigned char *test_multiscalar_ed25519_P2;

#define precomputed_multiscalar_ed25519_NUM 33

static const unsigned char precomputed_multiscalar_ed25519_Q_0[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1};
static const unsigned char precomputed_multiscalar_ed25519_n_0[] = {};
static const unsigned char precomputed_multiscalar_ed25519_P_0[] = {};
static const unsigned char precomputed_multiscalar_ed25519_Q_1[] = {0,221,146,167,238,108,128,58,43,205,91,236,52,180,248,105,205,102,50,71,57,122,214,247,165,191,35,244,214,48,118,63,0};
static const unsigned char precomputed_multiscalar_ed25519_n_1[] = {45,199,56,69,211,78,171,23,42,169,146,203,108,29,24,200,219,255,69,208,231,32,97,37,124,183,164,96,225,65,55,225};
static const unsigned char precomputed_multiscalar_ed25519_P_1[] = {226,154,248,55,65,29,162,20,153,123,104,247,83,183,90,22,105,218,223,210,53,221,116,100,113,100,175,152,146,168,165,204};
static const unsigned char precomputed_multiscalar_ed25519_Q_2[] = {152,24,12,28,46,34,220,82,92,144,58,222,121,105,210,45,16,250,190,204,47,128,167,246,34,145,84,65,147,131,102,101,0};
static const unsigned char precomputed_multiscalar_ed25519_n_2[] = {184,57,116,236,48,253,92,95,173,65,68,238,177,171,113,146,56,139,130,170,134,42,240,106,24,239,230,7,142,5,57,126,82,46,242,145,224,140,69,88,216,53,93,18,234,81,75,179,193,97,239,240,225,79,246,251,183,89,96,128,116,200,85,7};
static const unsigned char precomputed_multiscalar_ed25519_P_2[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,140,133,170,25,245,162,100,236,147,230,98,182,33,117,2,255,184,62,127,138,176,126,111,193,240,144,126,184,25,69,16};
static const unsigned char precomputed_multiscalar_ed25519_Q_3[] = {115,64,96,226,45,33,21,170,19,82,39,160,182,76,83,225,181,98,254,75,89,107,184,89,201,139,212,131,66,188,31,160,0};
static const unsigned char precomputed_multiscalar_ed25519_n_3[] = {55,1,193,3,13,91,26,21,136,156,47,121,6,33,217,128,188,113,34,83,0,93,164,118,27,52,113,96,60,153,225,50,45,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,239,86,169,35,114,49,134,113,152,97,186,203,172,42,64,244,176,195,172,162,235,246,44,73,154,29,23,66,83,177,57,184};
static const unsigned char precomputed_multiscalar_ed25519_P_3[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,213,121,136,37,29,239,61,248,252,184,228,217,97,119,73,27,172,179,111,163,97,43,0,164,23,11,132,174,73,30,248};
static const unsigned char precomputed_multiscalar_ed25519_Q_4[] = {116,78,89,85,206,218,33,70,214,238,34,149,125,184,15,135,225,154,205,125,158,84,66,103,172,150,167,15,56,229,60,22,0};
static const unsigned char precomputed_multiscalar_ed25519_n_4[] = {6,247,93,229,163,228,228,203,123,185,96,85,155,229,176,155,188,114,32,27,80,191,215,170,111,44,119,103,60,22,121,45,201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,104,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,188,27,148,243,125,215,37,254,217,102,216,105,94,215,43,184,104,220,227,210,187,180,159,13,165,232,87,162,164,210,245,37};
static const unsigned char precomputed_multiscalar_ed25519_P_4[] = {146,127,168,228,59,1,102,67,152,120,46,85,31,190,103,114,209,102,88,32,8,162,132,93,252,51,20,216,81,157,49,50,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_multiscalar_ed25519_Q_5[] = {255,233,35,250,80,236,38,75,29,141,2,251,59,70,72,217,51,15,206,51,73,65,73,68,222,60,237,145,227,154,61,126,0};
static const unsigned char precomputed_multiscalar_ed25519_n_5[] = {242,101,226,111,216,114,57,215,156,29,242,81,237,252,228,123,211,113,143,250,114,53,216,68,49,14,141,103,105,133,176,221,234,213,187,91,189,57,14,170,117,242,184,203,183,237,58,95,3,135,67,115,156,248,108,111,109,85,181,121,253,109,182,118,108,110,42,195,22,198,198,204,156,53,150,244,220,251,224,248,230,6,207,252,212,87,245,200,253,130,77,149,2,101,9,122,156,14,95,242,105,244,67,216,210,134,131,118,20,177,248,96,207,135,219,229,204,20,187,24,129,53,120,155,23,17,7,226,201,199,165,159,232,144,169,46,135,142,16,6,185,0,4,43,96,2,229,28,202,19,151,18,239,248,15,142,174,86,190,1};
static const unsigned char precomputed_multiscalar_ed25519_P_5[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,204,187,189,75,219,98,216,134,196,3,31,169,119,156,166,202,106,118,246,98,179,59,76,177,56,227,141,155,95,82,253,180,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,93,39,20,28,255,2,18,134,153,73,56,114,182,179,21,215,192,237,211,83,160,87,110,94,174,244,165,199,25,87,45,220,55,164,222,204,53,182,202,184,194,170,93,165,112,125,189,121,11,250,94,121,114,226,237,28,23,134,123,116,93,114,219,238};
static const unsigned char precomputed_multiscalar_ed25519_Q_6[] = {223,93,58,71,69,115,119,242,71,73,44,116,42,51,147,207,147,195,64,217,75,228,165,8,173,201,65,171,199,112,150,91,0};
static const unsigned char precomputed_multiscalar_ed25519_n_6[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,254,94,124,15,134,171,28,14,233,237,70,142,41,240,73,155,78,34,174,97,150,110,170,179,80,231,1,138,149,166,120,218,1,127,125,50,111,99,166,37,18,79,57,213,176,92,89,77,254,89,138,115,206,182,63,145,220,79,178,224,83,104,224,88,108,110,42,195,22,198,198,204,156,53,150,244,220,251,224,248,230,6,207,252,212,87,245,200,253,130,77,149,2,101,9,122,29,187,73,86,4,244,29,215,169,208,167,48,76,217,70,204,48,39,69,154,176,225,60,132,173,202,28,18,50,93,223,93,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_multiscalar_ed25519_P_6[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,111,245,181,212,37,25,251,205,83,50,17,180,149,11,77,65,97,143,250,195,132,124,190,178,43,53,157,190,228,26,241,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_7[] = {78,216,197,28,74,3,14,24,24,61,239,14,172,238,197,66,118,128,118,109,139,229,210,155,4,117,45,90,63,229,114,235,0};
static const unsigned char precomputed_multiscalar_ed25519_n_7[] = {226,118,65,216,35,222,52,122,196,98,154,147,42,230,40,43,43,192,183,175,143,206,145,120,234,210,133,55,127,5,214,135,173,138,72,176,189,178,234,70,243,195,84,138,73,140,205,230,178,206,197,111,35,233,22,241,65,139,79,122,155,48,232,52,36,142,172,198,113,232,198,57,159,255,205,168,76,255,151,212,8,10,164,78,126,218,60,68,79,156,99,225,244,176,135,12,254,139,105,215,41,175,58,206,86,40,86,18,195,128,159,7,85,118,5,221,235,138,140,140,169,234,2,207,39,102,167,246,120,213,253,117,39,230,226,162,190,241,183,244,68,93,134,119,150,202,36,204,58,228,7,225,57,29,32,1,42,146,200,31,155,114,108,38,206,64,142,101,80,248,197,192,15,132,165,250,210,182,252,51,233,36,197,21,245,250,160,122,71,201,203,4,132,236,55,74,67,26,55,33,76,165,40,50,70,63,85,250,182,0,50,50,249,99,244,129,173,1,194,150,161,142,77,61};
static const unsigned char precomputed_multiscalar_ed25519_P_7[] = {151,215,33,57,1,142,84,32,8,181,139,216,90,196,218,22,16,239,123,120,106,195,198,128,35,234,112,179,215,32,201,108,185,72,227,86,77,107,90,137,155,213,91,240,49,176,223,161,175,249,185,196,231,44,206,190,126,57,178,142,130,105,85,177,213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,25,224,232,58,139,150,34,80,161,146,28,133,118,62,238,202,91,241,202,29,153,76,203,196,54,203,128,123,32,153,69,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,50,230,107,248,250,98,212,59,9,187,225,48,111,215,29,69,22,209,88,32,187,161,151,173,130,151,73,122,243,191,51,104,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_8[] = {141,222,34,55,0,234,224,133,233,36,114,147,163,85,73,16,146,250,175,225,63,123,149,196,150,197,48,72,88,212,109,31,0};
static const unsigned char precomputed_multiscalar_ed25519_n_8[] = {9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,117,211,243,222,126,235,55,68,221,144,7,24,81,192,174,17,97,27,144,179,42,155,237,213,200,78,192,182,107,45,191,144,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,146,172,113,163,224,192,222,217,90,217,159,126,142,150,214,9,139,160,125,254,125,171,251,146,27,225,11,207,120,72,109,36,185,163,20,246,115,7,146,203,134,228,226,251,67,197,205,28,154,189,85,17,164,205,216,63,36,242,74,173,199,171,205,190,130,84,19,4,60,48,141,12,178,221,31,98,30,57,15,194,200,65,207,143,117,37,104,21,32,76,60,20,255,59,56,50,141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,59,196,197,236,5,56,83,216,139,88,63,161,137,11,219,239,84,147,125,29,34,136,23,202,96,67,166,60,148,232,217,48};
static const unsigned char precomputed_multiscalar_ed25519_P_8[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,23,239,142,4,223,170,238,168,148,249,186,110,0,70,196,154,221,88,117,130,170,128,174,233,9,68,26,0,135,6,99,37,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_multiscalar_ed25519_Q_9[] = {129,211,91,89,49,200,142,71,17,189,9,119,98,134,36,131,54,138,39,217,19,16,220,12,166,79,216,41,185,148,121,159,0};
static const unsigned char precomputed_multiscalar_ed25519_n_9[] = {227,168,132,242,204,168,64,244,206,210,135,8,2,245,107,211,227,83,85,18,129,135,206,189,109,170,78,12,71,24,36,147,102,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,139,204,83,21,85,124,217,22,118,157,244,105,82,213,160,92,59,73,138,110,51,110,249,234,26,0,184,221,4,235,186,250,30,71,24,173,234,206,231,119,225,88,182,101,109,151,80,8,120,109,194,50,205,100,167,105,79,151,146,127,227,123,139,216,125,66,104,247,132,180,192,187,46,42,175,135,205,121,176,242,150,222,236,201,195,231,104,95,12,243,205,228,140,141,233,98,51,97,41,58,109,66,139,167,192,98,208,36,199,110,247,242,207,113,174,166,80,41,147,56,138,165,237,122,164,33,212,218,1,152,115,21,182,190,201,7,186,75,12,149,94,69,4,166,193,194,133,57,21,86,48,115,33,8,50,3,206,117,134,12,86,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,152,172,133,44,228,61,251,141,86,193,114,141,35,124,51,104,46,20,20,253,198,133,87,173,208,104,228,229,166,218,54,39};
static const unsigned char precomputed_multiscalar_ed25519_P_9[] = {174,28,140,42,152,174,210,68,224,196,209,1,21,59,146,36,126,97,41,120,187,23,20,225,26,186,166,86,138,193,110,249,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,254,90,203,49,121,32,157,148,187,182,88,227,232,11,71,94,101,211,56,18,214,243,160,127,93,214,99,129,92,20,94,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,171,218,180,64,195,195,243,209,228,218,235,234,245,213,163,182,244,89,150,126,242,11,121,206,36,15,18,25,150,238,10,200,207,223,112,10,195,39,193,44,65,127,159,133,196,165,36,61,185,244,13,180,20,103,193,157,27,133,38,146,149,180,8,95,168,146,227,123,75,28,230,171,177,124,253,157,142,143,44,193,36,20,11,20,18,77,36,162,83,38,75,197,63,126,124,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,49,155,201,60,63,9,62,17,68,106,7,102,227,178,155,46,238,187,77,116,77,107,193,43,239,44,159,161,0,160,226};
static const unsigned char precomputed_multiscalar_ed25519_Q_10[] = {47,203,254,111,39,190,42,81,34,155,198,73,249,4,202,157,18,92,4,82,69,193,22,196,95,216,198,53,34,130,208,21,0};
static const unsigned char precomputed_multiscalar_ed25519_n_10[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,80,128,30,198,126,200,221,228,211,221,195,215,82,194,117,161,151,211,77,66,218,99,13,63,43,139,102,164,17,239,173,237,138,154,87,166,95,18,179,193,229,16,215,75,250,161,38,216,174,103,76,90,158,229,22,214,211,129,207,68,160,22,67,50,205,162,157,59,121,183,149,136,193,252,115,135,244,1,33,32,22,222,81,240,231,189,231,221,203,69,3,117,251,178,230,95,126,235,109,5,82,168,242,173,40,121,225,175,194,48,228,175,14,159,147,244,227,237,168,113,105,255,154,96,28,228,159,46,247,36,245,188,149,214,233,46,66,148,183,221,252,26,70,60,97,49,178,51,13,65,208,246,37,253,173,33,44,143,131,214,177,227,119,233,51,189,234,210,248,137,159,139,18,154,227,208,113,161,138,63,11,221,248,156,70,66,76,92,239,73,18,153,254,163,37,191,218,215,85,80,61,209,118,90,69,91,96,159,185,107,109,55,57,138,109,136,71,139,56,227,7,74,145,44,185,163,20,246,115,7,146,203,134,228,226,251,67,197,205,28,154,189,85,17,164,205,216,63,36,242,74,173,199,171,205,190,185,153,149,121,107,29,30,66,35,187,245,46,250,107,240,211,163,91,144,139,91,17,47,9,112,235,100,109,139,87,250,11};
static const unsigned char precomputed_multiscalar_ed25519_P_10[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,9,93,83,176,16,154,47,189,102,237,11,171,73,119,18,131,25,71,86,228,238,215,184,60,98,137,253,149,93,100,56,90,198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133,220,234,249,86,193,249,109,206,225,64,121,251,206,118,14,227,126,168,189,9,100,182,200,205,243,240,226,117,201,227,129,151,23,239,142,4,223,170,238,168,148,249,186,110,0,70,196,154,221,88,117,130,170,128,174,233,9,68,26,0,135,6,99,37,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_11[] = {150,166,195,114,205,143,130,118,168,104,3,236,99,100,143,11,92,1,100,217,147,174,252,78,223,247,51,77,155,174,84,3,0};
static const unsigned char precomputed_multiscalar_ed25519_n_11[] = {251,20,205,22,18,45,140,190,126,44,253,66,128,176,50,192,252,122,70,154,122,29,29,152,110,246,227,159,201,85,115,14,119,195,199,150,170,84,251,69,88,217,222,51,157,13,129,207,109,234,184,225,60,60,95,139,126,247,197,61,146,40,52,105,59,165,116,243,222,39,14,75,117,201,56,88,131,138,27,107,64,141,149,24,249,40,251,77,99,192,254,11,8,229,57,60,120,213,253,117,39,230,226,162,190,241,183,244,68,93,134,119,150,202,36,204,58,228,7,225,57,29,32,1,42,146,200,31,77,177,121,96,84,139,63,5,178,202,255,136,155,60,40,70,183,159,10,113,105,129,192,202,211,240,251,234,65,219,143,208,63,79,175,196,37,214,102,173,214,113,33,207,152,40,4,65,10,123,231,78,8,193,98,195,94,96,68,69,88,209,203,187,128,85,84,86,103,134,233,206,253,178,190,109,191,86,32,11,28,234,128,161,38,5,225,211,234,186,109,63,31,101,58,166,41,150,56,66,194,243,61,124,200,153,191,220,78,137,202,95,69,20,56,197,232,106,1,140,164,99,31,175,193,179,67,106,12,248,65,87,216,192,126,15,134,3,245,186,233,189,174,87,82,112,219,112,105,22,86,211,39,62,236,206,71,116,192,33,39,148,81,143,77,21,31,71,106,177,66,54,99,199,54,159,148,22,123,232,252,113,22,66,78,162,33,208,110,177,15,127,90,32,244,240,158,67,160,98,105,210,19,203,108,150,40,115,251,91,176,140,2,115,48,210,40,92,190,198,170,0,181,65};
static const unsigned char precomputed_multiscalar_ed25519_P_11[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,61,227,168,201,62,206,243,180,231,40,168,128,245,169,10,122,70,7,110,192,34,177,39,127,252,46,229,95,148,190,160,227,63,155,167,85,203,168,61,38,87,57,129,95,5,241,123,38,75,244,14,99,66,153,82,210,64,114,204,141,65,147,46,110,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,212,237,35,214,88,113,132,40,60,80,209,34,174,121,149,22,109,7,213,15,191,58,126,163,195,253,200,181,162,142,134,130,157,237,31,140,183,79,213,32,138,227,217,70,57,52,254,52,51,35,118,28,188,195,184,231,205,225,101,11,48,142,14,49,188,153,92,67,233,4,141,138,239,46,141,249,223,43,69,205,236,181,182,117,192,143,83,49,96,124,52,210,131,113,171};
static const unsigned char precomputed_multiscalar_ed25519_Q_12[] = {239,164,97,110,141,24,38,122,198,70,17,191,20,104,172,237,10,111,170,23,86,207,34,197,59,29,96,192,96,241,77,200,0};
static const unsigned char precomputed_multiscalar_ed25519_n_12[] = {76,212,80,94,225,201,248,233,153,87,96,240,254,43,50,121,50,14,130,15,14,31,6,194,241,121,102,168,65,109,126,13,169,19,224,200,12,166,213,124,101,219,218,164,209,123,9,163,60,112,1,120,198,194,126,82,172,127,57,199,143,118,136,179,156,244,93,163,213,85,5,121,52,112,72,183,207,164,8,16,33,191,131,232,140,209,243,145,231,250,164,98,115,98,111,248,157,120,14,48,197,12,12,89,118,149,172,42,112,221,5,195,10,204,7,166,82,83,127,243,96,170,157,124,5,233,46,188,214,5,98,80,116,99,36,237,240,200,234,42,69,239,75,60,9,188,82,41,232,174,71,164,157,239,205,231,168,177,46,236,55,1,193,3,13,91,26,21,136,156,47,121,6,33,217,128,188,113,34,83,0,93,164,118,27,52,113,96,60,153,225,50,109,68,140,29,77,90,225,64,27,216,81,249,248,13,224,229,39,75,5,234,160,160,16,184,163,31,56,176,158,133,35,241,65,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,54,37,1,28,218,33,220,136,5,71,101,8,183,190,29,24,146,185,136,18,76,106,240,106,237,41,92,113,111,78,128,196,236,76,132,70,157,241,221,48,29,4,189,142,0,120,148,234,177,176,70,187,1,45,14,123,206,251,38,253,65,125,233,43,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,46,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_multiscalar_ed25519_P_12[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,225,20,213,63,248,74,41,247,121,23,195,173,133,130,142,114,209,255,11,202,152,245,223,165,55,48,230,88,240,215,176,51,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,118,204,154,125,150,237,4,38,221,137,153,88,247,95,101,36,50,152,10,202,112,0,212,55,235,57,120,124,255,174,79,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_13[] = {164,195,238,54,116,11,46,105,78,215,220,131,214,149,243,30,36,234,232,205,74,223,81,28,158,101,134,144,82,123,206,217,0};
static const unsigned char precomputed_multiscalar_ed25519_n_13[] = {11,163,41,219,220,35,220,141,60,43,154,69,230,58,81,101,123,46,175,146,142,1,145,190,47,142,200,0,160,188,217,205,147,177,110,179,202,135,113,172,11,116,75,202,185,14,2,31,161,149,102,134,21,127,26,241,197,209,93,134,97,141,62,165,20,4,85,110,217,255,78,64,28,1,248,94,117,233,197,217,48,159,148,170,163,27,107,159,111,63,237,243,182,45,245,215,123,167,149,249,233,72,27,58,236,97,42,246,211,151,217,159,232,57,160,132,63,15,131,168,134,44,119,147,160,215,200,126,227,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,13,128,230,91,224,15,7,155,225,117,215,207,243,11,132,90,243,25,15,7,129,7,30,242,209,75,182,182,187,198,60,136,205,14,167,42,6,55,63,137,185,9,184,181,93,230,138,82,234,158,184,80,146,60,32,44,244,172,136,11,204,187,31,60,135,66,191,128,173,42,43,144,248,213,11,235,216,58,148,188,84,67,4,150,50,8,196,205,87,212,195,30,232,224,226,13,211,240,242,49,177,41,103,153,170,191,54,141,149,169,47,145,155,73,27,224,119,128,208,68,151,24,231,130,251,200,94,210,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,107,144,140,4,79,32,150,9,93,55,209,235,41,105,232,161,117,216,93,212,94,95,196,118,1,80,13,114,201,134,147,152,175,202,134,245,133,76,126,254,102,29,148,126,246,108,62,236,248,18,234,58,30,95,81,61,103,55,26,88,237,152,141,0,151,94,130,82,221,252,209,198,199,26,20,205,60,74,1,29,137,237,106,244,192,65,231,216,208,227,226,208,76,171,69,41};
static const unsigned char precomputed_multiscalar_ed25519_P_13[] = {88,91,13,15,231,217,29,183,59,136,253,27,138,32,32,170,229,100,100,254,169,42,12,212,243,37,48,115,82,205,61,75,165,137,42,231,114,136,190,77,148,227,58,245,249,0,12,66,6,4,247,197,195,58,161,195,216,204,134,76,112,196,27,187,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,40,174,138,96,128,212,165,42,12,102,51,192,109,1,249,234,83,232,50,190,131,247,141,204,223,121,65,17,214,67,123,76,135,71,172,255,125,138,213,173,246,27,96,8,12,137,4,166,32,13,237,226,29,192,130,209,210,140,113,195,102,213,13,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,101,147,107,76,5,205,24,21,7,49,148,92,235,56,126,81,125,226,124,147,66,156,48,69,171,95,180,15,162,232,130,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_multiscalar_ed25519_Q_14[] = {110,214,206,67,144,35,233,33,198,36,191,234,10,217,12,206,112,254,72,1,224,105,73,162,139,208,64,240,121,115,7,27,0};
static const unsigned char precomputed_multiscalar_ed25519_n_14[] = {76,212,80,94,225,201,248,233,153,87,96,240,254,43,50,121,50,14,130,15,14,31,6,194,241,121,102,168,65,109,126,13,132,236,55,74,67,26,55,33,76,165,40,50,70,63,85,250,182,0,50,50,249,99,244,129,173,1,194,150,161,142,77,61,186,158,39,249,65,182,131,130,227,79,239,189,243,18,90,94,246,202,159,107,15,23,95,159,151,158,75,54,153,8,26,120,30,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,188,27,148,243,125,215,37,254,217,102,216,105,94,215,43,184,104,220,227,210,187,180,159,13,165,232,87,162,164,210,245,37,239,86,169,35,114,49,134,113,152,97,186,203,172,42,64,244,176,195,172,162,235,246,44,73,154,29,23,66,83,177,57,184,98,17,150,246,34,228,209,128,249,112,145,63,157,32,92,21,125,244,16,102,144,168,28,36,132,218,148,175,105,14,7,209,188,227,89,245,238,23,122,180,4,0,106,100,175,127,130,68,233,247,166,14,64,133,219,61,220,26,171,28,141,160,128,216,2,202,242,89,69,77,94,149,108,206,245,125,252,141,71,221,36,148,183,243,225,91,159,78,43,246,233,124,220,243,126,44,239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,49,121,200,61,32,128,3,1,231,55,100,111,20,146,186,130,171,21,98,10,234,91,240,14,91,72,27,138,96,249,99,135,232,154,183,51,217,219,58,76,81,44,84,184,100,234,125,197,209,157,113,103,179,46,142,117,87,133,46,243,121,128,164,236,219,41,99,74,172,218,39,238,10,24,149,113,75,78,136,116,184,10,181,154,132,209,86,243,140,193,86,167,66,21,253,162,197,47,44,162,36,121,52,245,31,188,115,173,97,254,45,90,197,131,6,93,198,91,227,236,36,115,18,212,218,14,56,47};
static const unsigned char precomputed_multiscalar_ed25519_P_14[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,22,77,155,232,128,188,248,249,38,126,187,21,102,7,7,10,176,45,15,196,241,202,209,207,17,70,255,71,236,98,85,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,28,213,121,136,37,29,239,61,248,252,184,228,217,97,119,73,27,172,179,111,163,97,43,0,164,23,11,132,174,73,30,248,137,69,47,227,172,31,73,113,4,82,219,115,183,110,186,127,96,238,163,134,121,185,4,30,97,66,207,14,43,130,149,74,194,190,153,152,223,48,13,243,14,97,250,244,89,125,206,246,133,15,200,164,18,200,170,81,183,230,58,48,168,7,29,207,170,170,137,25,119,2,252,172,188,88,14,220,190,147,72,84,113,69,196,4,12,97,49,221,213,128,1,142,167,83,35,154,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,93,244,50,113,66,179,57,211,253,225,190,117,120,86,219,184,146,36,29,96,63,244,87,98,222,90,63,41,165,34,157,4,214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_multiscalar_ed25519_Q_15[] = {91,9,208,30,72,196,164,135,16,174,63,49,136,53,120,236,210,0,207,82,183,137,82,152,55,134,152,94,233,109,84,171,0};
static const unsigned char precomputed_multiscalar_ed25519_n_15[] = {236,76,132,70,157,241,221,48,29,4,189,142,0,120,148,234,177,176,70,187,1,45,14,123,206,251,38,253,65,125,233,43,80,128,30,198,126,200,221,228,211,221,195,215,82,194,117,161,151,211,77,66,218,99,13,63,43,139,102,164,17,239,173,237,111,223,140,100,214,4,245,14,102,116,123,56,52,216,244,219,237,108,8,165,8,57,121,142,6,238,192,103,225,33,152,74,87,137,192,137,47,8,218,146,161,115,255,22,232,182,128,8,158,66,205,51,65,33,249,127,152,5,51,233,162,66,252,13,140,238,43,191,40,55,119,168,23,85,8,91,158,104,231,89,173,186,13,155,182,219,140,92,140,153,239,227,81,217,249,29,54,37,1,28,218,33,220,136,5,71,101,8,183,190,29,24,146,185,136,18,76,106,240,106,237,41,92,113,111,78,128,196,253,228,163,144,33,202,33,134,168,192,30,115,139,170,87,132,153,87,208,58,32,76,246,132,176,241,228,133,177,108,135,246,111,127,148,18,120,81,211,48,65,176,93,59,196,219,56,94,186,29,99,247,188,81,10,99,111,1,186,204,131,44,207,94,156,177,193,86,189,233,183,47,86,129,206,228,167,252,193,253,109,210,139,109,165,213,45,32,201,68,150,226,245,73,63,250,155,124,228,30,71,207,134,213,227,86,119,98,102,219,55,176,31,189,75,116,62,241,61,216,203,76,171,131,123,124,5,32,76,212,80,94,225,201,248,233,153,87,96,240,254,43,50,121,50,14,130,15,14,31,6,194,241,121,102,168,65,109,126,13,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,239,86,169,35,114,49,134,113,152,97,186,203,172,42,64,244,176,195,172,162,235,246,44,73,154,29,23,66,83,177,57,184,9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,243,239,25,40,41,92,158,226,132,39,145,80,192,174,198,81,21,110,16,211,193,225,172,60,49,124,230,64,82,197,144,60};
static const unsigned char precomputed_multiscalar_ed25519_P_15[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,88,78,16,89,228,21,2,195,49,38,218,72,89,190,124,38,55,42,224,111,94,168,121,115,151,161,13,0,12,48,189,216,94,179,170,170,101,101,185,230,57,175,75,118,170,119,121,133,199,153,227,99,82,227,181,74,85,36,10,23,127,20,23,133,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,239,138,32,241,198,98,195,188,217,154,113,246,151,24,76,221,15,3,57,249,201,237,2,68,153,212,135,237,141,187,73,82,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,229,78,250,80,108,44,25,109,221,14,11,80,220,168,145,40,252,194,137,59,106,40,73,102,194,33,190,45,228,131,82,36,82,49,0,206,138,128,103,94,215,199,79,148,176,211,83,15,138,246,195,43,213,194,68,128,138,177,213,19,36,12,108,95,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,213,121,136,37,29,239,61,248,252,184,228,217,97,119,73,27,172,179,111,163,97,43,0,164,23,11,132,174,73,30,248,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_multiscalar_ed25519_Q_16[] = {207,78,97,214,30,150,194,0,193,231,110,63,52,207,4,23,155,38,250,253,133,159,147,220,162,166,189,120,3,89,146,243,0};
static const unsigned char precomputed_multiscalar_ed25519_n_16[] = {36,142,172,198,113,232,198,57,159,255,205,168,76,255,151,212,8,10,164,78,126,218,60,68,79,156,99,225,244,176,135,12,55,1,193,3,13,91,26,21,136,156,47,121,6,33,217,128,188,113,34,83,0,93,164,118,27,52,113,96,60,153,225,50,247,26,236,56,187,64,39,152,123,57,124,168,219,207,81,9,149,219,181,200,248,111,193,66,142,204,34,159,128,193,119,228,254,125,108,134,61,27,127,24,91,9,64,229,144,11,18,179,176,161,240,141,239,158,108,254,201,21,140,72,119,41,87,87,159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,112,139,153,45,75,224,158,161,181,181,5,92,44,171,176,197,76,127,207,89,66,180,90,55,36,96,235,4,152,81,2,1,106,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,77,192,58,202,151,9,254,160,51,99,208,86,137,140,192,124,166,206,182,93,160,52,195,104,25,26,166,9,58,36,77,172,187,215,104,14,4,79,117,106,4,118,141,241,155,238,74,177,96,78,217,206,210,118,219,66,160,101,173,88,155,114,227,75,179,167,62,82,90,25,101,231,216,243,159,25,93,189,208,123,65,64,158,154,102,204,98,128,122,168,126,233,185,93,133,174,5,28,199,215,233,253,56,142,212,48,98,164,35,204,235,7,133,144,166,108,103,137,209,210,189,232,79,134,224,173,254,229,151,58,31,140,28,227,39,169,233,128,88,249,229,5,67,55,104,224,37,146,226,236,3,240,68,145,227,65,254,18,8,56,48,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,50,146,218,145,122,219,44,63,245,184,133,39,182,218,108,232,155,251,15,242,70,97,69,186,193,5,246,65,144,51,229,189,7,219,106,96,221,127,6,108,167,11,167,172,240,145,168,98,128,46,209,97,94,44,120,171,214,75,26,60,22,77,41,159};
static const unsigned char precomputed_multiscalar_ed25519_P_16[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,70,10,7,184,178,1,134,156,115,196,217,170,112,42,225,219,0,185,221,28,118,63,115,17,42,9,162,173,218,253,224,52,233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,156,150,196,154,170,66,127,146,158,29,148,28,82,245,142,92,14,102,24,218,203,35,213,87,156,137,6,223,75,78,90,40,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,140,83,126,160,70,139,66,149,114,23,122,128,112,229,249,134,124,12,92,224,116,174,207,45,106,243,101,57,190,19,130,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_17[] = {225,180,153,37,217,163,199,211,221,130,251,224,134,16,58,150,70,212,215,98,27,152,92,81,181,236,125,13,8,206,111,2,0};
static const unsigned char precomputed_multiscalar_ed25519_n_17[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,27,62,172,125,172,250,68,146,122,98,190,183,145,2,3,236,115,32,101,154,61,251,226,190,123,205,67,127,25,2,197,93,184,65,16,62,158,68,249,176,89,116,100,209,208,222,193,12,47,113,80,220,163,171,224,171,45,60,185,253,122,212,209,11,151,58,31,140,28,227,39,169,233,128,88,249,229,5,67,55,104,224,37,146,226,236,3,240,68,145,227,65,254,18,8,56,12,248,65,87,216,192,126,15,134,3,245,186,233,189,174,87,82,112,219,112,105,22,86,211,39,62,236,206,71,116,192,33,185,163,20,246,115,7,146,203,134,228,226,251,67,197,205,28,154,189,85,17,164,205,216,63,36,242,74,173,199,171,205,190,238,228,182,211,120,71,36,3,196,106,218,181,227,112,177,3,189,213,139,152,185,220,247,87,102,57,13,254,21,113,102,195,200,74,134,44,70,180,212,197,15,219,86,183,66,2,127,37,97,222,196,130,123,229,13,117,229,242,226,0,223,109,193,253,82,237,203,160,191,17,32,47,203,136,114,193,75,238,19,188,31,27,59,246,205,34,102,249,44,86,221,68,72,222,177,22,200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,97,109,241,97,180,128,47,156,127,244,75,216,171,211,89,165,98,15,249,114,194,149,89,105,98,67,221,11,117,134,135,202,151,58,31,140,28,227,39,169,233,128,88,249,229,5,67,55,104,224,37,146,226,236,3,240,68,145,227,65,254,18,8,56,246,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,205,101,75,193,22,49,100,93,82,83,37,104,44,252,203,71,170,147,110,14,180,138,252,79,18,64,139,6,52,7,2,96,244,7,97,12,194,169,95,155,0,83,20,157,182,54,106,197,62,173,202,106,121,148,244,81,183,219,195,232,177,3,93,18,128,85,84,86,103,134,233,206,253,178,190,109,191,86,32,11,28,234,128,161,38,5,225,211,234,186,109,63,31,101,58,166,200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_multiscalar_ed25519_P_17[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,38,21,168,96,237,124,15,122,1,32,125,141,252,199,121,228,140,227,114,181,68,240,255,160,237,54,99,221,214,161,29,228,49,3,153,153,223,12,177,38,109,85,59,167,205,142,196,60,63,65,198,167,177,167,237,141,82,73,20,64,14,239,182,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,212,237,35,214,88,113,132,40,60,80,209,34,174,121,149,22,109,7,213,15,191,58,126,163,195,253,200,181,162,142,134,23,239,142,4,223,170,238,168,148,249,186,110,0,70,196,154,221,88,117,130,170,128,174,233,9,68,26,0,135,6,99,37,106,173,112,132,1,214,19,225,234,89,136,126,39,212,82,123,205,17,97,142,59,0,213,67,134,134,175,133,239,46,166,185,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,86,61,227,197,26,54,182,162,51,43,30,84,182,153,93,233,203,30,210,148,156,117,165,93,82,18,183,114,163,74,43,66,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,251,204,204,128,8,220,238,105,44,58,49,106,45,138,167,67,179,217,38,155,220,221,190,179,149,53,35,101,22,224,99,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_18[] = {218,117,165,40,25,13,243,221,163,113,141,49,170,91,173,52,37,184,187,77,187,160,7,144,245,242,241,178,140,8,139,40,0};
static const unsigned char precomputed_multiscalar_ed25519_n_18[] = {7,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,49,235,49,228,149,49,45,58,234,129,190,117,229,64,89,111,206,106,243,93,23,14,80,136,146,221,147,12,142,226,21,160,84,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,146,39,38,136,109,169,232,40,159,186,165,206,88,99,164,171,37,127,57,162,149,236,37,133,203,3,248,212,50,143,250,134,47,106,200,15,198,133,8,217,190,239,6,61,91,119,241,117,79,120,240,60,169,69,166,199,157,107,149,87,20,155,177,69,119,89,23,71,255,198,159,153,120,22,198,59,69,90,185,219,79,14,189,116,133,30,111,117,87,183,151,138,39,82,196,240,96,72,70,149,34,69,67,58,66,141,141,220,178,11,46,141,73,240,206,203,26,225,144,86,38,120,236,111,192,32,14,201,55,1,193,3,13,91,26,21,136,156,47,121,6,33,217,128,188,113,34,83,0,93,164,118,27,52,113,96,60,153,225,50,179,167,62,82,90,25,101,231,216,243,159,25,93,189,208,123,65,64,158,154,102,204,98,128,122,168,126,233,185,93,133,174,15,41,244,135,131,199,74,8,155,37,97,63,213,87,216,77,151,57,59,186,104,181,175,233,0,114,167,138,248,126,78,214,2,202,242,89,69,77,94,149,108,206,245,125,252,141,71,221,36,148,183,243,225,91,159,78,43,246,233,124,220,243,126,44,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,180,79,135,53,79,206,207,162,132,240,83,160,152,235,135,100,159,27,195,13,251,232,252,173,149,169,174,38,158,7,175,110,156,177,193,86,189,233,183,47,86,129,206,228,167,252,193,253,109,210,139,109,165,213,45,32,201,68,150,226,245,73,63,250,99,9,33,217,58,164,194,235,154,63,42,68,249,210,176,145,30,212,0,124,129,201,109,250,150,237,82,78,60,119,31,83};
static const unsigned char precomputed_multiscalar_ed25519_P_18[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,193,29,237,131,173,137,220,29,27,182,114,43,215,171,97,147,242,17,208,244,113,180,140,21,236,65,222,114,169,174,56,121,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,137,25,119,2,252,172,188,88,14,220,190,147,72,84,113,69,196,4,12,97,49,221,213,128,1,142,167,83,35,154,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,229,78,250,80,108,44,25,109,221,14,11,80,220,168,145,40,252,194,137,59,106,40,73,102,194,33,190,45,228,131,82,36,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_19[] = {97,171,179,67,130,68,49,48,243,87,104,64,5,5,197,80,245,231,39,108,151,19,132,178,72,140,113,159,213,137,27,11,0};
static const unsigned char precomputed_multiscalar_ed25519_n_19[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,245,164,198,179,20,205,255,16,168,200,7,66,45,102,5,254,227,126,14,215,45,118,227,190,127,110,91,103,81,246,209,23,85,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,117,211,243,222,126,235,55,68,221,144,7,24,81,192,174,17,97,27,144,179,42,155,237,213,200,78,192,182,107,45,191,144,169,19,224,200,12,166,213,124,101,219,218,164,209,123,9,163,60,112,1,120,198,194,126,82,172,127,57,199,143,118,136,179,185,153,149,121,107,29,30,66,35,187,245,46,250,107,240,211,163,91,144,139,91,17,47,9,112,235,100,109,139,87,250,11,119,89,23,71,255,198,159,153,120,22,198,59,69,90,185,219,79,14,189,116,133,30,111,117,87,183,151,138,39,82,196,240,62,93,152,217,175,76,132,62,139,93,206,57,127,185,107,148,189,115,88,172,27,130,91,0,181,211,106,17,216,113,78,94,63,79,175,196,37,214,102,173,214,113,33,207,152,40,4,65,10,123,231,78,8,193,98,195,94,96,68,69,88,209,203,187,30,200,13,227,220,228,210,132,209,2,10,163,246,249,200,105,106,72,133,219,121,8,140,11,107,169,174,232,36,89,23,197,55,73,139,224,77,38,146,110,127,108,168,213,186,0,239,139,109,148,151,212,218,24,105,245,225,87,254,62,218,152,111,221,158,146,219,1,15,177,78,157,207,83,12,96,179,212,142,109,141,198,170,199,171,40,167,214,75,120,25,106,20,6,37,247,234,192,208,121,104,92,125,224,68,243,119,51,57,63,76,165,185,81,37,216,60,248,33,1,140,154,88,100,28,124,247,164,229,245,171,170,76,86,32,65,144,222,188,225,128,10,50,113,183,11,176,193,253,168,168,15,198,60,158,140,137,21,52,57,201,199,165,159,232,144,169,46,135,142,16,6,185,0,4,43,96,2,229,28,202,19,151,18,239,248,15,142,174,86,190,1,159,180,190,89,47,96,77,248,160,6,18,6,129,217,173,89,244,156,36,89,35,173,65,57,13,127,106,138,37,119,126,239,162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,137,44,34,150,53,209,172,114,128,210,105,25,33,44,160,42,232,98,122,8,104,205,148,159,144,231,163,119,145,16,94,94,8,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_multiscalar_ed25519_P_19[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,63,155,167,85,203,168,61,38,87,57,129,95,5,241,123,38,75,244,14,99,66,153,82,210,64,114,204,141,65,147,46,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,128,193,139,175,147,22,46,21,185,195,61,179,142,166,169,88,209,55,108,222,138,135,41,240,5,151,220,245,107,224,39,195,136,214,163,222,147,54,35,49,23,162,36,244,199,70,202,102,112,198,111,4,92,150,163,27,99,152,152,215,184,204,159,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,200,155,227,231,185,147,228,65,34,34,103,226,253,28,41,243,159,146,38,10,205,153,173,149,216,121,160,178,44,135,91,78,55,164,222,204,53,182,202,184,194,170,93,165,112,125,189,121,11,250,94,121,114,226,237,28,23,134,123,116,93,114,219,238,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_20[] = {69,144,172,240,37,83,82,7,212,66,89,224,157,26,237,205,118,138,244,109,211,101,142,8,17,63,107,125,168,53,59,35,0};
static const unsigned char precomputed_multiscalar_ed25519_n_20[] = {7,219,106,96,221,127,6,108,167,11,167,172,240,145,168,98,128,46,209,97,94,44,120,171,214,75,26,60,22,77,41,159,39,148,81,143,77,21,31,71,106,177,66,54,99,199,54,159,148,22,123,232,252,113,22,66,78,162,33,208,110,177,15,127,160,40,208,113,143,252,5,81,143,228,238,42,179,129,145,83,10,142,125,123,118,151,248,82,231,32,248,160,2,82,47,172,229,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,254,181,131,237,70,62,29,162,235,218,190,54,139,92,166,169,90,55,83,246,46,178,110,254,4,177,242,70,22,37,211,25,41,150,56,66,194,243,61,124,200,153,191,220,78,137,202,95,69,20,56,197,232,106,1,140,164,99,31,175,193,179,67,106,58,52,155,20,12,137,212,119,238,72,159,77,164,203,142,43,79,247,174,84,152,239,154,182,62,7,240,200,191,100,69,129,149,56,25,8,162,129,98,177,36,16,107,125,232,73,250,201,39,205,83,161,20,156,154,84,46,166,75,24,30,158,53,19,76,212,80,94,225,201,248,233,153,87,96,240,254,43,50,121,50,14,130,15,14,31,6,194,241,121,102,168,65,109,126,13,31,251,88,9,125,5,186,63,70,239,188,239,8,46,113,2,58,206,234,68,156,253,167,122,90,166,66,135,146,27,194,39,49,255,117,2,235,53,171,67,89,100,242,97,23,246,19,152,39,249,139,69,19,148,155,255,43,106,62,210,157,12,115,226,20,13,129,220,61,45,58,0,227,76,116,207,207,191,160,124,114,48,153,120,161,239,90,166,23,77,144,93,183,99,211,165,169,19,224,200,12,166,213,124,101,219,218,164,209,123,9,163,60,112,1,120,198,194,126,82,172,127,57,199,143,118,136,179,234,163,4,57,175,201,29,197,187,122,191,199,201,82,146,18,237,126,252,221,174,153,125,201,206,48,39,172,48,119,58,159,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,38,161,138,11,66,221,39,170,165,171,0,234,120,122,103,85,163,195,242,225,253,159,232,228,204,184,145,182,216,68,19,115,89,99,12,30,211,37,83,122,205,218,158,25,11,182,232,99,233,119,132,239,126,46,63,77,18,195,58,96,184,234,29,186,1,127,125,50,111,99,166,37,18,79,57,213,176,92,89,77,254,89,138,115,206,182,63,145,220,79,178,224,83,104,224,88,27,62,172,125,172,250,68,146,122,98,190,183,145,2,3,236,115,32,101,154,61,251,226,190,123,205,67,127,25,2,197,93};
static const unsigned char precomputed_multiscalar_ed25519_P_20[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,130,157,237,31,140,183,79,213,32,138,227,217,70,57,52,254,52,51,35,118,28,188,195,184,231,205,225,101,11,48,142,14,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,177,128,224,43,46,53,185,115,184,125,236,183,255,81,135,112,198,223,220,35,108,31,97,246,106,215,228,255,86,194,114,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,129,206,226,192,60,48,242,171,47,234,128,86,234,76,239,107,16,141,166,19,152,161,130,248,97,70,233,202,119,214,138,140,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,181,113,188,59,126,252,77,135,76,69,203,26,144,40,59,91,15,248,90,67,131,42,210,9,63,145,15,28,0,160,167,146,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,118,220,78,70,115,17,136,245,69,232,175,237,244,130,244,242,138,44,131,210,210,186,233,213,16,200,171,254,250,59,238,183,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,154,38,21,168,96,237,124,15,122,1,32,125,141,252,199,121,228,140,227,114,181,68,240,255,160,237,54,99,221,214,161,29};
static const unsigned char precomputed_multiscalar_ed25519_Q_21[] = {111,185,18,195,162,95,33,79,138,119,132,209,2,184,2,45,214,123,89,6,234,139,71,95,56,21,240,20,230,15,43,55,0};
static const unsigned char precomputed_multiscalar_ed25519_n_21[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,234,213,187,91,189,57,14,170,117,242,184,203,183,237,58,95,3,135,67,115,156,248,108,111,109,85,181,121,253,109,182,118,137,44,34,150,53,209,172,114,128,210,105,25,33,44,160,42,232,98,122,8,104,205,148,159,144,231,163,119,145,16,94,94,140,238,43,191,40,55,119,168,23,85,8,91,158,104,231,89,173,186,13,155,182,219,140,92,140,153,239,227,81,217,249,29,77,51,97,11,192,82,159,21,25,34,129,104,148,53,43,65,190,137,80,52,175,251,102,55,127,221,188,111,207,214,67,146,7,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,185,153,149,121,107,29,30,66,35,187,245,46,250,107,240,211,163,91,144,139,91,17,47,9,112,235,100,109,139,87,250,11,67,31,129,82,121,247,157,110,254,84,178,61,127,10,230,159,18,71,54,124,54,178,89,134,129,148,10,184,6,172,2,193,58,59,46,160,240,108,76,13,63,82,94,247,96,152,71,249,124,3,230,109,221,198,141,52,85,83,131,55,245,248,241,49,102,209,130,99,13,53,194,126,55,119,41,190,147,159,73,22,56,37,193,23,5,224,92,170,202,213,118,14,39,146,196,218,137,214,101,156,113,207,49,144,199,199,149,141,144,59,217,120,168,236,193,174,237,134,190,34,35,136,108,147,28,75,26,94,227,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,229,11,201,113,37,50,57,212,170,57,152,243,177,45,138,199,243,14,179,170,176,242,163,202,28,191,57,106,99,12,69,241,41,150,56,66,194,243,61,124,200,153,191,220,78,137,202,95,69,20,56,197,232,106,1,140,164,99,31,175,193,179,67,106,64,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,26,196,180,41,59,5,102,202,100,167,244,50,201,209,210,12,74,47,40,208,66,1,220,205,242,5,24,154,38,179,107,32,7,219,106,96,221,127,6,108,167,11,167,172,240,145,168,98,128,46,209,97,94,44,120,171,214,75,26,60,22,77,41,159,123,167,149,249,233,72,27,58,236,97,42,246,211,151,217,159,232,57,160,132,63,15,131,168,134,44,119,147,160,215,200,126,21,164,234,152,19,74,198,117,163,165,173,24,65,51,120,11,81,228,43,160,9,210,76,118,113,245,218,122,251,47,7,66,132,236,55,74,67,26,55,33,76,165,40,50,70,63,85,250,182,0,50,50,249,99,244,129,173,1,194,150,161,142,77,61,158,227,146,34,189,35,36,216,159,121,161,153,241,245,86,138,94,122,54,50,244,184,200,149,36,3,206,84,84,252,197,105};
static const unsigned char precomputed_multiscalar_ed25519_P_21[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,187,189,75,219,98,216,134,196,3,31,169,119,156,166,202,106,118,246,98,179,59,76,177,56,227,141,155,95,82,253,180,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,84,88,182,166,140,253,57,101,101,99,147,104,232,163,67,55,87,223,26,173,147,45,206,154,245,204,81,126,111,54,30,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,170,33,247,194,222,182,96,54,155,168,65,102,106,96,101,111,53,246,43,208,38,57,223,94,137,54,64,20,250,115,161,224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_multiscalar_ed25519_Q_22[] = {78,37,112,208,165,12,242,116,69,23,199,144,40,71,126,51,120,5,78,182,19,242,33,198,92,32,218,70,151,216,233,83,0};
static const unsigned char precomputed_multiscalar_ed25519_n_22[] = {45,24,235,39,145,68,76,34,210,153,17,175,60,223,29,209,227,53,0,215,38,173,217,168,237,22,39,14,149,20,49,28,10,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,46,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,244,7,97,12,194,169,95,155,0,83,20,157,182,54,106,197,62,173,202,106,121,148,244,81,183,219,195,232,177,3,93,18,43,67,95,186,120,252,154,199,135,177,120,78,31,156,16,253,251,167,243,246,205,68,193,123,50,6,156,93,34,54,82,191,222,30,198,191,192,151,136,32,202,226,155,182,80,45,87,178,84,211,101,101,89,185,252,116,184,211,200,193,164,166,196,58,199,184,112,2,99,186,74,228,10,187,31,158,189,74,1,244,48,54,32,8,211,91,218,194,51,174,129,169,132,4,47,215,78,223,50,97,208,128,213,107,63,87,92,27,148,98,1,29,213,166,44,60,150,147,117,111,157,210,79,209,21,6,196,215,57,113,181,213,93,108,227,83,44,88,14,146,88,216,155,98,252,140,149,87,201,59,97,113,149,170,124,76,232,232,166,0,28,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,87,137,192,137,47,8,218,146,161,115,255,22,232,182,128,8,158,66,205,51,65,33,249,127,152,5,51,233,162,66,252,13,0,171,133,191,38,121,233,140,173,30,82,188,142,224,215,204,76,92,105,230,195,41,183,70,139,161,238,147,34,19,8,214,11,21,253,114,236,217,129,197,108,17,42,106,212,54,192,25,134,107,85,119,98,200,177,22,224,125,191,22,31,75,179,17,128,242,26,15,3,196,126,165,45,45,194,84,1,118,33,5,27,238,246,15,225,234,101,221,56,100,41,101,144,100,244,226,19,2,182,247,235,189,49,79,213,185,173,28,104,72,181,230,137,64,173,159,7,115,175,207,59,119,242,128,201,243,189,167,26,196,180,41,59,5,102,202,100,167,244,50,201,209,210,12,74,47,40,208,66,1,220,205,242,5,24,154,38,179,107,32,247,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,143,192,152,41,235,203,237,250,157,241,173,128,102,139,115,130,2,17,78,146,88,129,196,157,185,112,233,152,15,251,242,16,135,66,191,128,173,42,43,144,248,213,11,235,216,58,148,188,84,67,4,150,50,8,196,205,87,212,195,30,232,224,226,13,184,57,116,236,48,253,92,95,173,65,68,238,177,171,113,146,56,139,130,170,134,42,240,106,24,239,230,7,142,5,57,126,230,46,136,158,177,207,59,170,144,45,48,237,58,74,131,72,77,61,247,181,180,98,13,61,47,48,86,41,205,138,246,21,40,114,127,191,207,235,81,167,52,145,60,220,56,169,190,195,132,119,184,219,34,185,56,98,198,55,201,168,85,104,176,218};
static const unsigned char precomputed_multiscalar_ed25519_P_22[] = {199,236,124,83,1,216,161,208,134,85,174,61,9,55,128,115,55,76,63,115,233,153,174,119,183,114,140,220,197,121,190,45,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215,235,255,253,10,123,77,157,77,31,33,36,232,30,234,91,201,252,121,20,168,229,215,26,202,15,140,72,58,23,119,165,13,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,210,135,38,35,240,152,245,169,27,78,187,137,195,161,191,122,98,218,220,68,72,237,3,4,52,210,182,142,94,130,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94,179,170,170,101,101,185,230,57,175,75,118,170,119,121,133,199,153,227,99,82,227,181,74,85,36,10,23,127,20,23,133,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,243,182,201,175,117,79,239,92,175,22,13,115,148,32,160,228,203,210,99,163,185,112,86,97,124,186,221,34,191,186,149,130,223,47,165,110,45,118,185,14,59,180,66,247,76,122,23,101,184,157,224,237,21,95,141,238,138,254,23,218,234,247,47,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,65,170,33,247,194,222,182,96,54,155,168,65,102,106,96,101,111,53,246,43,208,38,57,223,94,137,54,64,20,250,115,161,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,208,233,39,246,78,56,173,140,70,234,172,241,52,164,230,52,144,141,104,108,223,53,143,85,218,42,115,215,59,123,21,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_multiscalar_ed25519_Q_23[] = {16,65,82,170,31,221,124,71,246,148,136,128,78,3,96,115,156,209,119,40,15,77,91,29,50,118,151,62,128,162,153,152,0};
static const unsigned char precomputed_multiscalar_ed25519_n_23[] = {11,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,97,97,219,89,207,57,35,55,179,12,203,37,182,142,188,179,221,15,39,209,226,177,31,189,96,243,84,199,107,16,103,236,169,98,83,155,201,37,111,23,19,80,56,45,56,199,88,233,62,39,93,57,25,151,103,101,8,171,249,1,240,38,165,23,140,238,43,191,40,55,119,168,23,85,8,91,158,104,231,89,173,186,13,155,182,219,140,92,140,153,239,227,81,217,249,29,41,150,56,66,194,243,61,124,200,153,191,220,78,137,202,95,69,20,56,197,232,106,1,140,164,99,31,175,193,179,67,106,179,167,62,82,90,25,101,231,216,243,159,25,93,189,208,123,65,64,158,154,102,204,98,128,122,168,126,233,185,93,133,174,251,11,224,127,228,62,26,176,158,187,235,72,151,229,69,9,55,186,252,174,0,168,110,10,145,196,242,44,36,248,241,96,40,114,127,191,207,235,81,167,52,145,60,220,56,169,190,195,132,119,184,219,34,185,56,98,198,55,201,168,85,104,176,218,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,175,41,121,235,84,189,113,146,190,179,59,118,241,30,66,233,125,137,156,189,254,51,2,161,168,245,213,237,54,81,74,233,244,218,14,171,203,186,123,244,7,232,173,171,8,249,53,86,170,136,188,7,238,116,75,28,127,15,251,215,229,26,45,130,10,205,206,105,222,49,93,160,207,151,67,92,212,233,17,187,39,54,112,7,187,203,82,178,89,99,137,92,142,164,33,167,120,213,253,117,39,230,226,162,190,241,183,244,68,93,134,119,150,202,36,204,58,228,7,225,57,29,32,1,42,146,200,31,49,223,252,87,12,1,188,16,66,240,34,58,154,248,135,171,225,199,103,17,27,205,165,11,213,225,178,209,187,216,191,73,184,65,16,62,158,68,249,176,89,116,100,209,208,222,193,12,47,113,80,220,163,171,224,171,45,60,185,253,122,212,209,11,121,42,204,232,25,147,135,118,132,176,227,78,94,54,152,30,220,250,239,23,99,217,29,18,22,246,189,203,246,133,138,128,144,90,131,66,109,174,3,106,179,163,122,123,177,144,123,81,76,246,187,252,100,100,226,16,27,59,161,143,128,222,200,119,226,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,195,14,73,121,247,33,224,153,139,172,197,16,140,167,247,60,11,179,134,76,34,116,201,16,160,139,132,165,239,69,67,145,0,171,133,191,38,121,233,140,173,30,82,188,142,224,215,204,76,92,105,230,195,41,183,70,139,161,238,147,34,19,8,214,211,184,248,64,48,52,129,149,61,58,29,171,221,99,114,205,160,151,162,17,157,49,253,62,220,124,137,166,28,119,230,172};
static const unsigned char precomputed_multiscalar_ed25519_P_23[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,72,53,73,163,241,142,138,8,63,185,190,179,109,147,119,94,200,70,153,9,1,255,99,213,114,215,105,47,26,199,37,222,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,249,155,78,94,79,202,180,69,80,125,111,243,27,67,8,2,78,59,82,148,182,205,100,78,209,239,221,19,5,5,19,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,228,49,3,153,153,223,12,177,38,109,85,59,167,205,142,196,60,63,65,198,167,177,167,237,141,82,73,20,64,14,239,182,242,103,154,104,206,84,253,102,133,46,58,180,171,36,179,77,151,219,223,20,131,175,37,180,7,208,164,92,18,131,134,64,199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,46,24,217,230,194,229,140,126,236,25,82,163,216,36,125,79,180,116,146,175,237,120,254,203,11,190,78,72,78,38,143,33};
static const unsigned char precomputed_multiscalar_ed25519_Q_24[] = {57,30,152,139,109,163,52,159,60,8,227,190,241,216,147,144,157,64,84,192,228,205,21,31,238,130,99,220,65,116,130,108,0};
static const unsigned char precomputed_multiscalar_ed25519_n_24[] = {244,7,97,12,194,169,95,155,0,83,20,157,182,54,106,197,62,173,202,106,121,148,244,81,183,219,195,232,177,3,93,18,212,11,110,82,168,250,225,78,229,42,82,192,162,255,52,78,77,100,31,103,55,132,198,79,204,40,238,174,34,45,62,24,169,19,224,200,12,166,213,124,101,219,218,164,209,123,9,163,60,112,1,120,198,194,126,82,172,127,57,199,143,118,136,179,15,41,244,135,131,199,74,8,155,37,97,63,213,87,216,77,151,57,59,186,104,181,175,233,0,114,167,138,248,126,78,214,10,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,138,154,87,166,95,18,179,193,229,16,215,75,250,161,38,216,174,103,76,90,158,229,22,214,211,129,207,68,160,22,67,50,175,202,134,245,133,76,126,254,102,29,148,126,246,108,62,236,248,18,234,58,30,95,81,61,103,55,26,88,237,152,141,0,89,99,12,30,211,37,83,122,205,218,158,25,11,182,232,99,233,119,132,239,126,46,63,77,18,195,58,96,184,234,29,186,126,62,203,223,56,203,10,117,237,121,172,99,1,8,57,156,185,115,139,158,105,125,215,159,36,78,178,21,97,59,191,7,53,182,35,254,100,27,231,222,202,203,171,12,87,22,68,26,237,116,143,215,112,46,233,235,139,137,167,47,100,188,197,26,72,169,27,160,126,53,155,140,243,53,64,116,249,52,36,204,83,230,15,222,125,176,82,154,182,232,23,102,14,21,214,159,121,42,204,232,25,147,135,118,132,176,227,78,94,54,152,30,220,250,239,23,99,217,29,18,22,246,189,203,246,133,138,128,82,46,242,145,224,140,69,88,216,53,93,18,234,81,75,179,193,97,239,240,225,79,246,251,183,89,96,128,116,200,85,7,237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,197,69,20,172,231,88,91,153,45,227,251,12,112,16,200,104,126,31,241,36,244,211,235,52,99,154,60,131,75,43,1,174,199,184,112,2,99,186,74,228,10,187,31,158,189,74,1,244,48,54,32,8,211,91,218,194,51,174,129,169,132,4,47,215,182,126,21,84,85,165,10,125,119,224,48,75,77,199,133,97,105,42,103,201,168,125,139,134,217,53,16,149,132,111,207,78,237,78,194,29,34,218,51,178,186,202,62,106,73,125,44,46,178,118,156,173,221,230,7,31,45,226,172,141,227,17,151,207,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,159,180,190,89,47,96,77,248,160,6,18,6,129,217,173,89,244,156,36,89,35,173,65,57,13,127,106,138,37,119,126,239,40,114,127,191,207,235,81,167,52,145,60,220,56,169,190,195,132,119,184,219,34,185,56,98,198,55,201,168,85,104,176,218,123,167,149,249,233,72,27,58,236,97,42,246,211,151,217,159,232,57,160,132,63,15,131,168,134,44,119,147,160,215,200,126,156,14,95,242,105,244,67,216,210,134,131,118,20,177,248,96,207,135,219,229,204,20,187,24,129,53,120,155,23,17,7,226,157,120,14,48,197,12,12,89,118,149,172,42,112,221,5,195,10,204,7,166,82,83,127,243,96,170,157,124,5,233,46,188};
static const unsigned char precomputed_multiscalar_ed25519_P_24[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,149,214,73,206,1,102,91,120,237,154,121,160,40,33,78,236,68,177,160,92,56,17,175,127,203,250,239,120,176,106,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,101,147,107,76,5,205,24,21,7,49,148,92,235,56,126,81,125,226,124,147,66,156,48,69,171,95,180,15,162,232,130,118,220,78,70,115,17,136,245,69,232,175,237,244,130,244,242,138,44,131,210,210,186,233,213,16,200,171,254,250,59,238,183,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,199,57,32,48,85,10,180,225,243,96,77,241,107,154,180,99,87,82,111,148,177,163,202,90,47,20,18,234,128,210,77,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,242,103,154,104,206,84,253,102,133,46,58,180,171,36,179,77,151,219,223,20,131,175,37,180,7,208,164,92,18,131,134,64,85,140,133,170,25,245,162,100,236,147,230,98,182,33,117,2,255,184,62,127,138,176,126,111,193,240,144,126,184,25,69,16,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,58,219,187,31,80,221,92,26,59,144,161,155,43,240,36,197,134,66,207,235,11,30,127,244,192,96,230,236,81,238,67,235,255,253,10,123,77,157,77,31,33,36,232,30,234,91,201,252,121,20,168,229,215,26,202,15,140,72,58,23,119,165,13,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,39,20,28,255,2,18,134,153,73,56,114,182,179,21,215,192,237,211,83,160,87,110,94,174,244,165,199,25,87,45,220,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_multiscalar_ed25519_Q_25[] = {103,189,75,245,106,65,28,57,113,237,28,36,131,205,215,118,80,147,147,191,169,233,248,127,208,19,184,104,37,52,180,143,0};
static const unsigned char precomputed_multiscalar_ed25519_n_25[] = {241,121,168,29,30,93,209,103,30,221,227,39,81,245,182,140,78,130,214,20,42,77,155,136,40,42,169,224,108,208,40,3,238,224,79,227,139,136,243,74,109,20,254,150,91,61,202,188,131,140,228,207,44,131,140,3,180,182,81,75,139,181,27,119,11,17,93,105,93,243,84,193,228,161,120,237,204,188,75,160,41,202,142,200,234,82,1,219,1,200,200,244,28,107,130,38,212,141,74,134,231,55,23,40,147,237,96,182,127,227,147,130,120,67,132,117,99,45,80,187,227,133,14,224,243,97,188,90,156,100,146,71,177,60,60,115,184,242,103,117,112,83,181,81,81,53,74,166,54,216,109,194,34,193,145,98,225,116,189,247,83,91,188,20,67,62,181,174,4,205,88,132,105,106,20,88,217,210,42,19,204,69,188,216,234,149,176,107,241,6,8,65,243,239,25,40,41,92,158,226,132,39,145,80,192,174,198,81,21,110,16,211,193,225,172,60,49,124,230,64,82,197,144,60,46,239,25,232,202,99,97,112,175,217,126,192,32,91,171,255,242,100,84,213,46,135,47,189,117,242,232,112,18,174,160,219,31,251,88,9,125,5,186,63,70,239,188,239,8,46,113,2,58,206,234,68,156,253,167,122,90,166,66,135,146,27,194,39,9,136,91,164,94,90,133,110,134,122,217,14,69,227,101,169,177,175,98,234,1,95,106,0,1,69,186,76,15,89,34,218,205,101,75,193,22,49,100,93,82,83,37,104,44,252,203,71,170,147,110,14,180,138,252,79,18,64,139,6,52,7,2,96,39,227,136,41,192,245,246,197,80,168,72,228,169,53,169,57,106,104,95,215,230,70,150,18,75,74,238,248,226,9,204,50,180,95,201,163,160,65,161,138,246,87,174,195,206,106,205,59,47,79,76,114,42,250,231,68,63,113,203,65,98,211,114,201,2,202,242,89,69,77,94,149,108,206,245,125,252,141,71,221,36,148,183,243,225,91,159,78,43,246,233,124,220,243,126,44,43,67,95,186,120,252,154,199,135,177,120,78,31,156,16,253,251,167,243,246,205,68,193,123,50,6,156,93,34,54,82,191,139,204,83,21,85,124,217,22,118,157,244,105,82,213,160,92,59,73,138,110,51,110,249,234,26,0,184,221,4,235,186,250,99,9,33,217,58,164,194,235,154,63,42,68,249,210,176,145,30,212,0,124,129,201,109,250,150,237,82,78,60,119,31,83,30,200,13,227,220,228,210,132,209,2,10,163,246,249,200,105,106,72,133,219,121,8,140,11,107,169,174,232,36,89,23,197,29,187,73,86,4,244,29,215,169,208,167,48,76,217,70,204,48,39,69,154,176,225,60,132,173,202,28,18,50,93,223,93,11,17,93,105,93,243,84,193,228,161,120,237,204,188,75,160,41,202,142,200,234,82,1,219,1,200,200,244,28,107,130,38,109,68,140,29,77,90,225,64,27,216,81,249,248,13,224,229,39,75,5,234,160,160,16,184,163,31,56,176,158,133,35,241,11,17,93,105,93,243,84,193,228,161,120,237,204,188,75,160,41,202,142,200,234,82,1,219,1,200,200,244,28,107,130,38,55,1,193,3,13,91,26,21,136,156,47,121,6,33,217,128,188,113,34,83,0,93,164,118,27,52,113,96,60,153,225,50,196,18,81,134,86,86,215,133,173,140,69,93,70,253,104,199,213,17,36,163,109,250,208,227,137,247,214,44,172,146,45,235,143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_multiscalar_ed25519_P_25[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,158,251,253,167,211,145,101,54,88,215,183,60,69,159,70,234,116,19,85,158,161,253,158,20,200,120,230,35,160,121,31,169,167,102,135,40,146,118,179,11,74,69,203,137,202,49,35,213,12,132,64,26,216,253,19,1,45,128,121,52,14,36,189,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,155,229,133,71,36,57,20,172,83,15,238,190,36,187,206,191,180,140,181,169,20,139,229,117,161,204,231,238,212,139,255,226,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,161,183,99,122,140,45,200,137,177,154,153,194,118,91,99,182,63,210,3,226,119,227,143,49,15,6,176,185,59,62,253,205,194,251,204,204,128,8,220,238,105,44,58,49,106,45,138,167,67,179,217,38,155,220,221,190,179,149,53,35,101,22,224,99,234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,170,170,137,25,119,2,252,172,188,88,14,220,190,147,72,84,113,69,196,4,12,97,49,221,213,128,1,142,167,83,35,154,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,74,254,90,203,49,121,32,157,148,187,182,88,227,232,11,71,94,101,211,56,18,214,243,160,127,93,214,99,129,92,20,94,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,239,158,251,253,167,211,145,101,54,88,215,183,60,69,159,70,234,116,19,85,158,161,253,158,20,200,120,230,35,160,121,31,74,118,204,154,125,150,237,4,38,221,137,153,88,247,95,101,36,50,152,10,202,112,0,212,55,235,57,120,124,255,174,79,239,158,251,253,167,211,145,101,54,88,215,183,60,69,159,70,234,116,19,85,158,161,253,158,20,200,120,230,35,160,121,31,249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_26[] = {202,212,118,180,113,115,231,149,174,102,84,139,217,36,0,59,102,54,209,139,67,224,212,253,75,168,38,37,49,106,213,140,0};
static const unsigned char precomputed_multiscalar_ed25519_n_26[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,117,186,86,193,169,238,230,48,135,189,28,180,80,189,28,3,221,174,69,23,214,241,60,101,129,77,200,107,26,219,174,98,126,62,203,223,56,203,10,117,237,121,172,99,1,8,57,156,185,115,139,158,105,125,215,159,36,78,178,21,97,59,191,7,2,165,2,4,36,118,38,122,160,247,208,82,211,147,22,41,24,100,56,218,88,54,172,78,184,194,188,186,97,19,157,124,238,192,154,11,113,88,235,17,224,151,129,200,232,239,204,172,154,187,64,255,89,210,136,36,141,196,209,18,28,109,138,68,48,214,123,114,250,71,71,102,172,244,228,105,69,92,43,211,24,97,236,118,77,237,123,191,61,11,59,221,105,87,232,199,247,36,245,188,149,214,233,46,66,148,183,221,252,26,70,60,97,49,178,51,13,65,208,246,37,253,173,33,44,143,131,214,167,217,66,88,150,31,231,11,139,69,52,250,75,64,13,150,225,57,138,104,248,166,198,208,102,51,3,67,83,61,68,95,53,182,35,254,100,27,231,222,202,203,171,12,87,22,68,26,237,116,143,215,112,46,233,235,139,137,167,47,100,188,197,26,154,103,37,176,166,34,182,45,102,97,29,212,197,54,171,114,210,243,183,197,137,60,31,144,76,220,255,210,154,103,218,101,156,100,146,71,177,60,60,115,184,242,103,117,112,83,181,81,81,53,74,166,54,216,109,194,34,193,145,98,225,116,189,247,156,177,193,86,189,233,183,47,86,129,206,228,167,252,193,253,109,210,139,109,165,213,45,32,201,68,150,226,245,73,63,250,9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,169,19,224,200,12,166,213,124,101,219,218,164,209,123,9,163,60,112,1,120,198,194,126,82,172,127,57,199,143,118,136,179,201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,247,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,238,224,79,227,139,136,243,74,109,20,254,150,91,61,202,188,131,140,228,207,44,131,140,3,180,182,81,75,139,181,27,119,94,0,221,220,61,163,31,237,60,151,245,87,134,97,62,140,111,139,239,58,198,17,254,115,8,65,149,123,136,130,189,216,55,73,139,224,77,38,146,110,127,108,168,213,186,0,239,139,109,148,151,212,218,24,105,245,225,87,254,62,218,152,111,221,8,165,135,109,38,188,238,155,87,22,138,12,18,235,153,222,128,51,67,75,33,68,235,172,167,57,227,54,207,196,244,85,254,139,105,215,41,175,58,206,86,40,86,18,195,128,159,7,85,118,5,221,235,138,140,140,169,234,2,207,39,102,167,246,111,127,148,18,120,81,211,48,65,176,93,59,196,219,56,94,186,29,99,247,188,81,10,99,111,1,186,204,131,44,207,94,90,32,244,240,158,67,160,98,105,210,19,203,108,150,40,115,251,91,176,140,2,115,48,210,40,92,190,198,170,0,181,65,178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,251,11,224,127,228,62,26,176,158,187,235,72,151,229,69,9,55,186,252,174,0,168,110,10,145,196,242,44,36,248,241,96};
static const unsigned char precomputed_multiscalar_ed25519_P_26[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,162,196,37,196,91,13,47,220,33,15,36,212,167,213,92,170,129,205,222,33,201,106,72,29,142,14,158,13,184,216,87,183,211,5,162,97,81,55,96,84,244,139,98,174,72,254,137,69,113,108,90,6,143,98,172,74,225,183,170,43,137,145,123,140,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,174,0,249,186,188,197,181,66,237,199,28,211,186,24,235,249,48,255,166,97,85,255,220,142,57,129,170,204,73,137,166,46,199,57,32,48,85,10,180,225,243,96,77,241,107,154,180,99,87,82,111,148,177,163,202,90,47,20,18,234,128,210,77,75,245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,229,78,250,80,108,44,25,109,221,14,11,80,220,168,145,40,252,194,137,59,106,40,73,102,194,33,190,45,228,131,82,36,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,128,193,139,175,147,22,46,21,185,195,61,179,142,166,169,88,209,55,108,222,138,135,41,240,5,151,220,245,107,224,39,7,243,82,203,238,244,174,88,213,177,183,2,211,41,150,174,114,236,64,237,90,64,45,5,215,139,206,15,203,63,31,113,205,25,224,232,58,139,150,34,80,161,146,28,133,118,62,238,202,91,241,202,29,153,76,203,196,54,203,128,123,32,153,69,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,49,188,153,92,67,233,4,141,138,239,46,141,249,223,43,69,205,236,181,182,117,192,143,83,49,96,124,52,210,131,113,171,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,249,155,78,94,79,202,180,69,80,125,111,243,27,67,8,2,78,59,82,148,182,205,100,78,209,239,221,19,5,5,19};
static const unsigned char precomputed_multiscalar_ed25519_Q_27[] = {10,123,2,0,133,44,103,86,31,213,185,148,108,8,131,170,18,30,111,64,177,3,40,23,25,203,110,49,40,189,201,219,0};
static const unsigned char precomputed_multiscalar_ed25519_n_27[] = {1,127,125,50,111,99,166,37,18,79,57,213,176,92,89,77,254,89,138,115,206,182,63,145,220,79,178,224,83,104,224,88,120,213,253,117,39,230,226,162,190,241,183,244,68,93,134,119,150,202,36,204,58,228,7,225,57,29,32,1,42,146,200,31,123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,23,7,65,51,149,36,30,87,104,231,184,31,93,209,80,96,33,104,161,19,194,203,111,40,83,189,48,173,63,210,232,208,182,126,21,84,85,165,10,125,119,224,48,75,77,199,133,97,105,42,103,201,168,125,139,134,217,53,16,149,132,111,207,78,217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,112,139,153,45,75,224,158,161,181,181,5,92,44,171,176,197,76,127,207,89,66,180,90,55,36,96,235,4,152,81,2,1,63,79,175,196,37,214,102,173,214,113,33,207,152,40,4,65,10,123,231,78,8,193,98,195,94,96,68,69,88,209,203,187,89,97,177,47,34,143,4,65,144,101,3,3,61,141,133,237,190,157,112,205,21,200,138,233,58,125,225,97,113,17,231,39,58,59,46,160,240,108,76,13,63,82,94,247,96,152,71,249,124,3,230,109,221,198,141,52,85,83,131,55,245,248,241,49,26,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,151,94,130,82,221,252,209,198,199,26,20,205,60,74,1,29,137,237,106,244,192,65,231,216,208,227,226,208,76,171,69,41,234,192,208,121,104,92,125,224,68,243,119,51,57,63,76,165,185,81,37,216,60,248,33,1,140,154,88,100,28,124,247,164,111,127,148,18,120,81,211,48,65,176,93,59,196,219,56,94,186,29,99,247,188,81,10,99,111,1,186,204,131,44,207,94,211,184,248,64,48,52,129,149,61,58,29,171,221,99,114,205,160,151,162,17,157,49,253,62,220,124,137,166,28,119,230,172,254,139,105,215,41,175,58,206,86,40,86,18,195,128,159,7,85,118,5,221,235,138,140,140,169,234,2,207,39,102,167,246,226,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,86,178,153,116,152,255,97,90,8,75,214,79,167,187,42,52,106,28,63,172,112,183,215,42,251,48,142,162,217,15,16,158,137,214,101,156,113,207,49,144,199,199,149,141,144,59,217,120,168,236,193,174,237,134,190,34,35,136,108,147,28,75,26,94,224,151,49,114,42,152,20,223,159,117,106,209,62,155,111,26,193,170,37,250,161,107,103,249,162,53,51,138,226,196,35,173,11,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,45,135,117,117,221,96,158,137,90,251,75,196,245,249,25,149,169,14,81,248,67,224,143,74,205,1,86,169,116,49,237,224,52,189,122,254,96,58,23,33,128,83,84,145,201,155,36,127,32,43,151,10,66,48,203,128,142,237,202,135,240,65,104,20,254,181,131,237,70,62,29,162,235,218,190,54,139,92,166,169,90,55,83,246,46,178,110,254,4,177,242,70,22,37,211,25};
static const unsigned char precomputed_multiscalar_ed25519_P_27[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,213,129,207,252,72,220,150,232,180,214,236,3,150,58,24,251,45,35,15,140,66,230,54,228,41,47,99,49,248,93,34,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,155,167,85,203,168,61,38,87,57,129,95,5,241,123,38,75,244,14,99,66,153,82,210,64,114,204,141,65,147,46,110,103,206,13,23,104,245,26,94,42,159,70,228,204,117,44,117,34,245,196,235,133,249,75,29,11,76,251,236,169,246,60,175,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,46,24,217,230,194,229,140,126,236,25,82,163,216,36,125,79,180,116,146,175,237,120,254,203,11,190,78,72,78,38,143,33,205,25,224,232,58,139,150,34,80,161,146,28,133,118,62,238,202,91,241,202,29,153,76,203,196,54,203,128,123,32,153,69,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,178,109,38,70,41,237,18,240,215,92,142,111,252,179,121,206,3,231,169,159,174,127,240,124,96,176,166,100,44,114,241,31,177,128,224,43,46,53,185,115,184,125,236,183,255,81,135,112,198,223,220,35,108,31,97,246,106,215,228,255,86,194,114};
static const unsigned char precomputed_multiscalar_ed25519_Q_28[] = {191,76,100,94,194,1,174,166,224,233,88,140,12,215,135,50,125,245,35,219,46,223,80,188,59,11,180,172,189,101,50,150,0};
static const unsigned char precomputed_multiscalar_ed25519_n_28[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,141,243,215,13,0,128,116,14,77,95,244,173,192,205,65,85,75,38,176,202,84,178,37,16,142,17,108,173,160,49,185,145,243,239,25,40,41,92,158,226,132,39,145,80,192,174,198,81,21,110,16,211,193,225,172,60,49,124,230,64,82,197,144,60,121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,234,163,4,57,175,201,29,197,187,122,191,199,201,82,146,18,237,126,252,221,174,153,125,201,206,48,39,172,48,119,58,159,229,11,201,113,37,50,57,212,170,57,152,243,177,45,138,199,243,14,179,170,176,242,163,202,28,191,57,106,99,12,69,241,57,113,181,213,93,108,227,83,44,88,14,146,88,216,155,98,252,140,149,87,201,59,97,113,149,170,124,76,232,232,166,0,119,195,199,150,170,84,251,69,88,217,222,51,157,13,129,207,109,234,184,225,60,60,95,139,126,247,197,61,146,40,52,105,52,189,122,254,96,58,23,33,128,83,84,145,201,155,36,127,32,43,151,10,66,48,203,128,142,237,202,135,240,65,104,20,53,109,14,179,175,177,125,128,58,92,220,161,101,96,90,172,82,42,62,213,1,113,251,177,125,236,51,205,180,255,39,211,188,227,89,245,238,23,122,180,4,0,106,100,175,127,130,68,233,247,166,14,64,133,219,61,220,26,171,28,141,160,128,216,239,86,169,35,114,49,134,113,152,97,186,203,172,42,64,244,176,195,172,162,235,246,44,73,154,29,23,66,83,177,57,184,216,40,0,197,245,121,227,219,209,32,115,33,82,197,19,232,163,88,233,69,59,103,246,233,243,21,54,174,232,32,254,26,111,12,171,228,139,54,88,129,206,139,93,188,112,112,36,171,8,156,92,189,85,242,14,16,73,158,208,138,118,25,146,151,111,127,148,18,120,81,211,48,65,176,93,59,196,219,56,94,186,29,99,247,188,81,10,99,111,1,186,204,131,44,207,94,175,202,134,245,133,76,126,254,102,29,148,126,246,108,62,236,248,18,234,58,30,95,81,61,103,55,26,88,237,152,141,0,189,174,78,254,105,243,88,109,188,177,120,89,96,182,51,208,238,57,231,111,183,169,211,92,118,114,221,63,93,231,61,253,216,2,108,219,184,157,228,61,249,31,158,36,194,153,126,54,217,184,34,235,160,121,143,0,51,140,242,179,255,38,97,41,40,114,127,191,207,235,81,167,52,145,60,220,56,169,190,195,132,119,184,219,34,185,56,98,198,55,201,168,85,104,176,218,5,28,199,215,233,253,56,142,212,48,98,164,35,204,235,7,133,144,166,108,103,137,209,210,189,232,79,134,224,173,254,229,219,41,99,74,172,218,39,238,10,24,149,113,75,78,136,116,184,10,181,154,132,209,86,243,140,193,86,167,66,21,253,162,199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,11,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,162,227,74,141,7,117,86,143,120,139,84,224,42,16,162,18,5,164,63,51,130,23,34,172,174,178,163,177,196,254,117,32,99,41,234,134,146,181,231,105,255,10,10,110,150,131,135,82,169,135,210,200,106,172,40,155,5,94,54,164,103,104,187,101,77,192,58,202,151,9,254,160,51,99,208,86,137,140,192,124,166,206,182,93,160,52,195,104,25,26,166,9,58,36,77,172,50,146,218,145,122,219,44,63,245,184,133,39,182,218,108,232,155,251,15,242,70,97,69,186,193,5,246,65,144,51,229,189,45,135,117,117,221,96,158,137,90,251,75,196,245,249,25,149,169,14,81,248,67,224,143,74,205,1,86,169,116,49,237,224};
static const unsigned char precomputed_multiscalar_ed25519_P_28[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,192,106,93,141,102,16,107,154,169,49,52,230,176,187,125,47,224,76,108,73,211,100,91,127,22,109,245,93,157,138,84,243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,154,210,135,38,35,240,152,245,169,27,78,187,137,195,161,191,122,98,218,220,68,72,237,3,4,52,210,182,142,94,130,34,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,98,178,109,38,70,41,237,18,240,215,92,142,111,252,179,121,206,3,231,169,159,174,127,240,124,96,176,166,100,44,114,241,231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,194,190,153,152,223,48,13,243,14,97,250,244,89,125,206,246,133,15,200,164,18,200,170,81,183,230,58,48,168,7,29,207,28,213,121,136,37,29,239,61,248,252,184,228,217,97,119,73,27,172,179,111,163,97,43,0,164,23,11,132,174,73,30,248,211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,164,107,69,128,187,178,86,109,37,82,219,199,41,91,63,236,254,109,46,249,149,155,63,168,175,69,1,128,65,249,168,38,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,74,101,147,107,76,5,205,24,21,7,49,148,92,235,56,126,81,125,226,124,147,66,156,48,69,171,95,180,15,162,232,130,232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,156,150,196,154,170,66,127,146,158,29,148,28,82,245,142,92,14,102,24,218,203,35,213,87,156,137,6,223,75,78,90,40,93,244,50,113,66,179,57,211,253,225,190,117,120,86,219,184,146,36,29,96,63,244,87,98,222,90,63,41,165,34,157,4,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31,191,24,181,18,144,15,134,120,14,199,70,8,215,199,191,173,170,229,27,153,196,174,115,179,179,253,240,20,209,156,214,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,140,83,126,160,70,139,66,149,114,23,122,128,112,229,249,134,124,12,92,224,116,174,207,45,106,243,101,57,190,19,130,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_29[] = {27,44,69,66,35,64,136,139,246,252,163,117,105,69,34,221,102,2,220,2,122,44,80,105,143,221,133,150,247,218,166,145,0};
static const unsigned char precomputed_multiscalar_ed25519_n_29[] = {235,100,117,49,183,175,151,65,153,179,224,213,239,163,249,95,29,20,88,32,23,137,140,224,21,48,178,109,130,135,90,199,7,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,254,94,124,15,134,171,28,14,233,237,70,142,41,240,73,155,78,34,174,97,150,110,170,179,80,231,1,138,149,166,120,218,140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,179,167,62,82,90,25,101,231,216,243,159,25,93,189,208,123,65,64,158,154,102,204,98,128,122,168,126,233,185,93,133,174,247,36,245,188,149,214,233,46,66,148,183,221,252,26,70,60,97,49,178,51,13,65,208,246,37,253,173,33,44,143,131,214,26,196,180,41,59,5,102,202,100,167,244,50,201,209,210,12,74,47,40,208,66,1,220,205,242,5,24,154,38,179,107,32,161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,228,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,128,50,68,138,52,208,119,66,185,178,15,167,162,149,132,123,4,203,194,201,208,97,182,120,149,93,88,24,15,182,208,112,235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,2,165,2,4,36,118,38,122,160,247,208,82,211,147,22,41,24,100,56,218,88,54,172,78,184,194,188,186,97,19,157,124,130,84,19,4,60,48,141,12,178,221,31,98,30,57,15,194,200,65,207,143,117,37,104,21,32,76,60,20,255,59,56,50,204,17,148,195,115,180,129,190,26,116,87,192,250,236,96,47,240,44,93,198,10,219,84,56,125,77,91,191,20,125,253,224,122,119,95,191,96,167,203,192,254,209,49,64,25,39,197,49,36,111,123,188,14,202,29,113,97,44,134,8,104,53,32,197,24,165,247,179,92,212,253,70,39,143,176,70,158,16,37,121,47,30,128,134,213,251,163,138,171,80,74,23,66,197,171,154,0,171,133,191,38,121,233,140,173,30,82,188,142,224,215,204,76,92,105,230,195,41,183,70,139,161,238,147,34,19,8,214,167,217,66,88,150,31,231,11,139,69,52,250,75,64,13,150,225,57,138,104,248,166,198,208,102,51,3,67,83,61,68,95,239,86,169,35,114,49,134,113,152,97,186,203,172,42,64,244,176,195,172,162,235,246,44,73,154,29,23,66,83,177,57,184,30,71,24,173,234,206,231,119,225,88,182,101,109,151,80,8,120,109,194,50,205,100,167,105,79,151,146,127,227,123,139,216,171,169,159,61,122,235,44,148,46,222,28,220,150,18,121,145,129,40,129,69,175,105,198,232,38,163,92,13,10,146,209,253,89,99,12,30,211,37,83,122,205,218,158,25,11,182,232,99,233,119,132,239,126,46,63,77,18,195,58,96,184,234,29,186,86,178,153,116,152,255,97,90,8,75,214,79,167,187,42,52,106,28,63,172,112,183,215,42,251,48,142,162,217,15,16,158,43,67,95,186,120,252,154,199,135,177,120,78,31,156,16,253,251,167,243,246,205,68,193,123,50,6,156,93,34,54,82,191,238,224,79,227,139,136,243,74,109,20,254,150,91,61,202,188,131,140,228,207,44,131,140,3,180,182,81,75,139,181,27,119,200,74,134,44,70,180,212,197,15,219,86,183,66,2,127,37,97,222,196,130,123,229,13,117,229,242,226,0,223,109,193,253,112,231,170,71,246,0,119,203,34,27,101,36,9,52,108,224,221,111,65,55,55,231,58,1,139,56,60,219,208,78,1,192,205,14,167,42,6,55,63,137,185,9,184,181,93,230,138,82,234,158,184,80,146,60,32,44,244,172,136,11,204,187,31,60,235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_multiscalar_ed25519_P_29[] = {181,199,217,71,209,106,104,20,158,157,53,221,5,248,177,73,218,34,88,43,141,212,228,2,122,91,160,144,109,95,127,149,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,111,245,181,212,37,25,251,205,83,50,17,180,149,11,77,65,97,143,250,195,132,124,190,178,43,53,157,190,228,26,241,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,170,33,247,194,222,182,96,54,155,168,65,102,106,96,101,111,53,246,43,208,38,57,223,94,137,54,64,20,250,115,161,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,11,53,167,255,212,166,185,151,249,211,204,77,66,158,198,8,80,216,136,25,180,91,214,194,45,142,49,139,92,122,243,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,162,196,37,196,91,13,47,220,33,15,36,212,167,213,92,170,129,205,222,33,201,106,72,29,142,14,158,13,184,216,87,183,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,174,0,249,186,188,197,181,66,237,199,28,211,186,24,235,249,48,255,166,97,85,255,220,142,57,129,170,204,73,137,166,46,28,213,121,136,37,29,239,61,248,252,184,228,217,97,119,73,27,172,179,111,163,97,43,0,164,23,11,132,174,73,30,248,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,128,52,193,107,80,158,196,253,229,50,230,227,166,97,128,203,115,228,227,31,3,194,225,77,12,212,62,196,253,65,123,118,220,78,70,115,17,136,245,69,232,175,237,244,130,244,242,138,44,131,210,210,186,233,213,16,200,171,254,250,59,238,183,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,76,135,71,172,255,125,138,213,173,246,27,96,8,12,137,4,166,32,13,237,226,29,192,130,209,210,140,113,195,102,213,13,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_30[] = {198,146,230,126,43,165,110,174,12,173,179,193,228,31,7,146,94,40,81,229,153,223,150,240,107,121,210,44,15,85,176,199,0};
static const unsigned char precomputed_multiscalar_ed25519_n_30[] = {244,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,10,205,206,105,222,49,93,160,207,151,67,92,212,233,17,187,39,54,112,7,187,203,82,178,89,99,137,92,142,164,33,167,10,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,121,185,194,132,218,157,140,30,147,141,84,51,247,197,127,174,119,198,160,189,153,136,196,52,2,160,16,6,253,68,195,102,98,17,150,246,34,228,209,128,249,112,145,63,157,32,92,21,125,244,16,102,144,168,28,36,132,218,148,175,105,14,7,209,137,214,101,156,113,207,49,144,199,199,149,141,144,59,217,120,168,236,193,174,237,134,190,34,35,136,108,147,28,75,26,94,156,100,146,71,177,60,60,115,184,242,103,117,112,83,181,81,81,53,74,166,54,216,109,194,34,193,145,98,225,116,189,247,151,58,31,140,28,227,39,169,233,128,88,249,229,5,67,55,104,224,37,146,226,236,3,240,68,145,227,65,254,18,8,56,111,223,140,100,214,4,245,14,102,116,123,56,52,216,244,219,237,108,8,165,8,57,121,142,6,238,192,103,225,33,152,74,197,69,20,172,231,88,91,153,45,227,251,12,112,16,200,104,126,31,241,36,244,211,235,52,99,154,60,131,75,43,1,174,215,235,248,33,134,228,145,138,236,92,153,186,134,138,170,119,89,189,243,226,5,238,175,125,36,51,219,119,123,44,113,242,119,89,23,71,255,198,159,153,120,22,198,59,69,90,185,219,79,14,189,116,133,30,111,117,87,183,151,138,39,82,196,240,49,220,38,253,219,15,107,196,63,79,16,157,110,13,167,21,134,34,75,197,25,74,255,124,111,225,212,150,144,108,191,157,155,114,108,38,206,64,142,101,80,248,197,192,15,132,165,250,210,182,252,51,233,36,197,21,245,250,160,122,71,201,203,4,76,212,80,94,225,201,248,233,153,87,96,240,254,43,50,121,50,14,130,15,14,31,6,194,241,121,102,168,65,109,126,13,173,138,72,176,189,178,234,70,243,195,84,138,73,140,205,230,178,206,197,111,35,233,22,241,65,139,79,122,155,48,232,52,245,164,198,179,20,205,255,16,168,200,7,66,45,102,5,254,227,126,14,215,45,118,227,190,127,110,91,103,81,246,209,23,160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,114,18,27,37,41,239,106,144,146,243,67,192,252,109,238,197,236,88,173,131,230,226,149,253,55,6,215,27,80,230,127,79,4,149,142,179,78,76,200,17,174,229,69,215,251,224,160,9,132,88,65,60,71,173,67,101,194,4,250,134,243,65,100,33,151,94,130,82,221,252,209,198,199,26,20,205,60,74,1,29,137,237,106,244,192,65,231,216,208,227,226,208,76,171,69,41,77,194,206,53,183,42,187,157,136,36,232,196,237,237,140,27,140,236,181,39,237,157,171,239,4,243,105,148,48,222,239,178,13,128,230,91,224,15,7,155,225,117,215,207,243,11,132,90,243,25,15,7,129,7,30,242,209,75,182,182,187,198,60,136,238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,242,101,226,111,216,114,57,215,156,29,242,81,237,252,228,123,211,113,143,250,114,53,216,68,49,14,141,103,105,133,176,221,8,217,3,216,180,141,96,70,206,129,220,78,85,130,228,99,255,162,209,150,110,245,172,123,111,228,102,204,35,62,148,10,67,31,129,82,121,247,157,110,254,84,178,61,127,10,230,159,18,71,54,124,54,178,89,134,129,148,10,184,6,172,2,193,40,253,123,12,120,179,14,43,21,169,30,19,79,137,251,223,205,181,110,123,49,68,251,37,215,182,148,244,6,115,152,10,238,192,154,11,113,88,235,17,224,151,129,200,232,239,204,172,154,187,64,255,89,210,136,36,141,196,209,18,28,109,138,68};
static const unsigned char precomputed_multiscalar_ed25519_P_30[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,171,217,24,230,242,173,91,25,91,69,3,222,72,93,219,24,196,138,141,211,243,229,71,130,181,131,8,188,132,79,119,137,69,47,227,172,31,73,113,4,82,219,115,183,110,186,127,96,238,163,134,121,185,4,30,97,66,207,14,43,130,149,74,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,88,78,16,89,228,21,2,195,49,38,218,72,89,190,124,38,55,42,224,111,94,168,121,115,151,161,13,0,12,48,189,216,93,58,219,187,31,80,221,92,26,59,144,161,155,43,240,36,197,134,66,207,235,11,30,127,244,192,96,230,236,81,238,67,135,33,199,48,130,174,69,44,56,235,155,106,46,18,193,74,197,43,229,251,250,118,124,219,95,88,55,76,87,193,106,31,95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,50,230,107,248,250,98,212,59,9,187,225,48,111,215,29,69,22,209,88,32,187,161,151,173,130,151,73,122,243,191,51,104,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,185,72,227,86,77,107,90,137,155,213,91,240,49,176,223,161,175,249,185,196,231,44,206,190,126,57,178,142,130,105,85,177,224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,132,70,67,164,86,9,197,16,252,146,73,2,232,33,255,223,193,67,40,179,195,170,229,89,7,43,87,49,23,83,99,191,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,122,40,174,138,96,128,212,165,42,12,102,51,192,109,1,249,234,83,232,50,190,131,247,141,204,223,121,65,17,214,67,123,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,123,169,150,160,75,79,37,43,229,26,205,112,232,185,234,42,203,123,151,64,10,237,129,34,188,95,160,241,232,66,165,91,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,211,5,162,97,81,55,96,84,244,139,98,174,72,254,137,69,113,108,90,6,143,98,172,74,225,183,170,43,137,145,123,140};
static const unsigned char precomputed_multiscalar_ed25519_Q_31[] = {106,104,65,68,14,17,184,196,56,219,236,51,187,204,219,63,169,128,62,184,216,46,202,76,200,215,106,38,243,79,93,69,0};
static const unsigned char precomputed_multiscalar_ed25519_n_31[] = {237,78,194,29,34,218,51,178,186,202,62,106,73,125,44,46,178,118,156,173,221,230,7,31,45,226,172,141,227,17,151,207,127,213,152,182,223,228,4,193,136,176,165,31,22,2,248,77,37,243,59,144,21,95,84,41,81,35,194,117,231,238,169,111,47,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,152,172,133,44,228,61,251,141,86,193,114,141,35,124,51,104,46,20,20,253,198,133,87,173,208,104,228,229,166,218,54,39,236,76,132,70,157,241,221,48,29,4,189,142,0,120,148,234,177,176,70,187,1,45,14,123,206,251,38,253,65,125,233,43,184,57,116,236,48,253,92,95,173,65,68,238,177,171,113,146,56,139,130,170,134,42,240,106,24,239,230,7,142,5,57,126,45,24,235,39,145,68,76,34,210,153,17,175,60,223,29,209,227,53,0,215,38,173,217,168,237,22,39,14,149,20,49,28,117,211,243,222,126,235,55,68,221,144,7,24,81,192,174,17,97,27,144,179,42,155,237,213,200,78,192,182,107,45,191,144,15,41,244,135,131,199,74,8,155,37,97,63,213,87,216,77,151,57,59,186,104,181,175,233,0,114,167,138,248,126,78,214,86,178,153,116,152,255,97,90,8,75,214,79,167,187,42,52,106,28,63,172,112,183,215,42,251,48,142,162,217,15,16,158,103,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,203,202,2,169,16,196,96,94,85,166,198,237,66,181,68,243,20,236,9,223,194,192,243,160,28,38,36,155,97,36,115,126,49,220,38,253,219,15,107,196,63,79,16,157,110,13,167,21,134,34,75,197,25,74,255,124,111,225,212,150,144,108,191,157,90,59,202,166,207,9,31,154,21,232,125,154,16,62,70,194,3,71,93,173,97,213,117,254,213,210,254,58,162,214,163,243,107,144,140,4,79,32,150,9,93,55,209,235,41,105,232,161,117,216,93,212,94,95,196,118,1,80,13,114,201,134,147,152,112,231,170,71,246,0,119,203,34,27,101,36,9,52,108,224,221,111,65,55,55,231,58,1,139,56,60,219,208,78,1,192,27,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,90,59,202,166,207,9,31,154,21,232,125,154,16,62,70,194,3,71,93,173,97,213,117,254,213,210,254,58,162,214,163,243,20,13,129,220,61,45,58,0,227,76,116,207,207,191,160,124,114,48,153,120,161,239,90,166,23,77,144,93,183,99,211,165,147,177,110,179,202,135,113,172,11,116,75,202,185,14,2,31,161,149,102,134,21,127,26,241,197,209,93,134,97,141,62,165,137,214,101,156,113,207,49,144,199,199,149,141,144,59,217,120,168,236,193,174,237,134,190,34,35,136,108,147,28,75,26,94,144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,230,46,136,158,177,207,59,170,144,45,48,237,58,74,131,72,77,61,247,181,180,98,13,61,47,48,86,41,205,138,246,21,219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,97,97,219,89,207,57,35,55,179,12,203,37,182,142,188,179,221,15,39,209,226,177,31,189,96,243,84,199,107,16,103,236,47,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,207,141,179,208,56,2,148,44,90,217,30,253,24,197,34,101,191,192,83,209,243,104,240,119,98,14,82,216,220,3,117,88,121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,29,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_multiscalar_ed25519_P_31[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,56,154,210,2,9,92,211,74,142,58,57,233,89,206,85,220,165,151,239,81,72,116,0,94,145,190,132,81,245,0,153,121,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,49,155,201,60,63,9,62,17,68,106,7,102,227,178,155,46,238,187,77,116,77,107,193,43,239,44,159,161,0,160,226,251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,199,236,124,83,1,216,161,208,134,85,174,61,9,55,128,115,55,76,63,115,233,153,174,119,183,114,140,220,197,121,190,45,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,119,179,69,51,228,63,171,99,99,245,120,201,142,186,9,129,202,143,180,225,148,142,84,249,43,23,209,4,113,247,253,227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,172,229,155,51,94,147,124,86,135,201,209,56,213,3,233,21,25,43,105,206,252,68,0,169,25,77,17,166,188,42,30,102,197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,172,229,155,51,94,147,124,86,135,201,209,56,213,3,233,21,25,43,105,206,252,68,0,169,25,77,17,166,188,42,30,102,181,113,188,59,126,252,77,135,76,69,203,26,144,40,59,91,15,248,90,67,131,42,210,9,63,145,15,28,0,160,167,146,165,137,42,231,114,136,190,77,148,227,58,245,249,0,12,66,6,4,247,197,195,58,161,195,216,204,134,76,112,196,27,187,237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,208,233,39,246,78,56,173,140,70,234,172,241,52,164,230,52,144,141,104,108,223,53,143,85,218,42,115,215,59,123,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,207,247,146,52,189,140,43,51,226,193,61,145,89,74,87,244,97,25,10,40,89,81,139,190,107,54,8,176,254,211,49,188,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_multiscalar_ed25519_Q_32[] = {121,118,175,182,163,174,150,66,50,189,193,116,215,44,56,174,204,85,40,229,252,28,158,38,162,37,29,216,89,121,160,251,0};
static const unsigned char precomputed_multiscalar_ed25519_n_32[] = {254,125,108,134,61,27,127,24,91,9,64,229,144,11,18,179,176,161,240,141,239,158,108,254,201,21,140,72,119,41,87,87,129,21,233,114,180,129,225,231,121,155,188,115,181,243,7,153,232,178,188,165,208,48,183,77,240,181,40,3,222,94,195,103,190,246,223,154,191,27,55,10,117,88,160,66,56,250,94,137,117,57,210,251,250,19,130,255,235,10,17,62,151,173,142,212,212,11,110,82,168,250,225,78,229,42,82,192,162,255,52,78,77,100,31,103,55,132,198,79,204,40,238,174,34,45,62,24,251,20,205,22,18,45,140,190,126,44,253,66,128,176,50,192,252,122,70,154,122,29,29,152,110,246,227,159,201,85,115,14,229,11,201,113,37,50,57,212,170,57,152,243,177,45,138,199,243,14,179,170,176,242,163,202,28,191,57,106,99,12,69,241,239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,141,203,237,140,118,33,77,156,167,147,173,30,87,190,11,245,81,177,228,70,126,48,133,10,224,149,166,121,203,198,216,71,46,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,246,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,67,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,4,149,142,179,78,76,200,17,174,229,69,215,251,224,160,9,132,88,65,60,71,173,67,101,194,4,250,134,243,65,100,33,28,178,130,91,222,84,112,121,65,213,250,160,82,72,125,6,147,73,14,137,38,173,83,81,104,84,214,126,225,251,5,90,186,158,39,249,65,182,131,130,227,79,239,189,243,18,90,94,246,202,159,107,15,23,95,159,151,158,75,54,153,8,26,120,86,178,153,116,152,255,97,90,8,75,214,79,167,187,42,52,106,28,63,172,112,183,215,42,251,48,142,162,217,15,16,158,179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,20,4,85,110,217,255,78,64,28,1,248,94,117,233,197,217,48,159,148,170,163,27,107,159,111,63,237,243,182,45,245,215,27,107,1,33,187,58,164,159,254,69,198,233,218,50,250,157,146,125,121,182,44,201,245,85,157,36,196,201,0,159,94,76,10,205,206,105,222,49,93,160,207,151,67,92,212,233,17,187,39,54,112,7,187,203,82,178,89,99,137,92,142,164,33,167,201,199,165,159,232,144,169,46,135,142,16,6,185,0,4,43,96,2,229,28,202,19,151,18,239,248,15,142,174,86,190,1,212,11,110,82,168,250,225,78,229,42,82,192,162,255,52,78,77,100,31,103,55,132,198,79,204,40,238,174,34,45,62,24,233,194,255,225,16,217,248,104,229,167,225,40,211,244,225,20,228,180,1,57,81,67,178,63,93,139,141,17,169,42,223,31,200,74,134,44,70,180,212,197,15,219,86,183,66,2,127,37,97,222,196,130,123,229,13,117,229,242,226,0,223,109,193,253,186,101,199,140,232,62,249,204,165,177,39,7,80,107,205,234,112,141,238,48,130,220,135,30,149,254,144,156,103,113,179,241,94,0,221,220,61,163,31,237,60,151,245,87,134,97,62,140,111,139,239,58,198,17,254,115,8,65,149,123,136,130,189,216,195,14,73,121,247,33,224,153,139,172,197,16,140,167,247,60,11,179,134,76,34,116,201,16,160,139,132,165,239,69,67,145,226,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,30,71,24,173,234,206,231,119,225,88,182,101,109,151,80,8,120,109,194,50,205,100,167,105,79,151,146,127,227,123,139,216,23,7,65,51,149,36,30,87,104,231,184,31,93,209,80,96,33,104,161,19,194,203,111,40,83,189,48,173,63,210,232,208,45,199,56,69,211,78,171,23,42,169,146,203,108,29,24,200,219,255,69,208,231,32,97,37,124,183,164,96,225,65,55,225,65,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_multiscalar_ed25519_P_32[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,77,101,137,127,195,208,36,90,25,0,200,48,152,83,97,17,147,219,185,133,251,124,161,172,249,250,73,50,121,88,250,10,36,211,115,33,235,10,62,13,210,121,190,127,27,216,112,250,182,10,206,151,96,71,140,19,44,139,225,92,94,243,72,226,65,149,214,73,206,1,102,91,120,237,154,121,160,40,33,78,236,68,177,160,92,56,17,175,127,203,250,239,120,176,106,197,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,70,67,164,86,9,197,16,252,146,73,2,232,33,255,223,193,67,40,179,195,170,229,89,7,43,87,49,23,83,99,191,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,22,77,155,232,128,188,248,249,38,126,187,21,102,7,7,10,176,45,15,196,241,202,209,207,17,70,255,71,236,98,85,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,195,3,187,245,22,231,13,150,172,75,222,151,26,133,243,108,13,10,201,159,73,58,48,93,4,96,21,64,103,99,205,195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,55,164,222,204,53,182,202,184,194,170,93,165,112,125,189,121,11,250,94,121,114,226,237,28,23,134,123,116,93,114,219,238,65,149,214,73,206,1,102,91,120,237,154,121,160,40,33,78,236,68,177,160,92,56,17,175,127,203,250,239,120,176,106,197,199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122,205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,213,129,207,252,72,220,150,232,180,214,236,3,150,58,24,251,45,35,15,140,66,230,54,228,41,47,99,49,248,93,34,226,154,248,55,65,29,162,20,153,123,104,247,83,183,90,22,105,218,223,210,53,221,116,100,113,100,175,152,146,168,165,204,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static const struct {
  const unsigned char *Q;
  long long Qsize;
  const unsigned char *n;
  long long nsize;
  const unsigned char *P;
  long long Psize;
  long long batch;
} precomputed_multiscalar_ed25519[precomputed_multiscalar_ed25519_NUM] = {
  {
    precomputed_multiscalar_ed25519_Q_0,33,
    precomputed_multiscalar_ed25519_n_0,0,
    precomputed_multiscalar_ed25519_P_0,0,
    0,
  },
  {
    precomputed_multiscalar_ed25519_Q_1,33,
    precomputed_multiscalar_ed25519_n_1,32,
    precomputed_multiscalar_ed25519_P_1,32,
    1,
  },
  {
    precomputed_multiscalar_ed25519_Q_2,33,
    precomputed_multiscalar_ed25519_n_2,64,
    precomputed_multiscalar_ed25519_P_2,64,
    2,
  },
  {
    precomputed_multiscalar_ed25519_Q_3,33,
    precomputed_multiscalar_ed25519_n_3,96,
    precomputed_multiscalar_ed25519_P_3,96,
    3,
  },
  {
    precomputed_multiscalar_ed25519_Q_4,33,
    precomputed_multiscalar_ed25519_n_4,128,
    precomputed_multiscalar_ed25519_P_4,128,
    4,
  },
  {
    precomputed_multiscalar_ed25519_Q_5,33,
    precomputed_multiscalar_ed25519_n_5,160,
    precomputed_multiscalar_ed25519_P_5,160,
    5,
  },
  {
    precomputed_multiscalar_ed25519_Q_6,33,
    precomputed_multiscalar_ed25519_n_6,192,
    precomputed_multiscalar_ed25519_P_6,192,
    6,
  },
  {
    precomputed_multiscalar_ed25519_Q_7,33,
    precomputed_multiscalar_ed25519_n_7,224,
    precomputed_multiscalar_ed25519_P_7,224,
    7,
  },
  {
    precomputed_multiscalar_ed25519_Q_8,33,
    precomputed_multiscalar_ed25519_n_8,256,
    precomputed_multiscalar_ed25519_P_8,256,
    8,
  },
  {
    precomputed_multiscalar_ed25519_Q_9,33,
    precomputed_multiscalar_ed25519_n_9,288,
    precomputed_multiscalar_ed25519_P_9,288,
    9,
  },
  {
    precomputed_multiscalar_ed25519_Q_10,33,
    precomputed_multiscalar_ed25519_n_10,320,
    precomputed_multiscalar_ed25519_P_10,320,
    10,
  },
  {
    precomputed_multiscalar_ed25519_Q_11,33,
    precomputed_multiscalar_ed25519_n_11,352,
    precomputed_multiscalar_ed25519_P_11,352,
    11,
  },
  {
    precomputed_multiscalar_ed25519_Q_12,33,
    precomputed_multiscalar_ed25519_n_12,384,
    precomputed_multiscalar_ed25519_P_12,384,
    12,
  },
  {
    precomputed_multiscalar_ed25519_Q_13,33,
    precomputed_multiscalar_ed25519_n_13,416,
    precomputed_multiscalar_ed25519_P_13,416,
    13,
  },
  {
    precomputed_multiscalar_ed25519_Q_14,33,
    precomputed_multiscalar_ed25519_n_14,448,
    precomputed_multiscalar_ed25519_P_14,448,
    14,
  },
  {
    precomputed_multiscalar_ed25519_Q_15,33,
    precomputed_multiscalar_ed25519_n_15,480,
    precomputed_multiscalar_ed25519_P_15,480,
    15,
  },
  {
    precomputed_multiscalar_ed25519_Q_16,33,
    precomputed_multiscalar_ed25519_n_16,512,
    precomputed_multiscalar_ed25519_P_16,512,
    16,
  },
  {
    precomputed_multiscalar_ed25519_Q_17,33,
    precomputed_multiscalar_ed25519_n_17,544,
    precomputed_multiscalar_ed25519_P_17,544,
    17,
  },
  {
    precomputed_multiscalar_ed25519_Q_18,33,
    precomputed_multiscalar_ed25519_n_18,576,
    precomputed_multiscalar_ed25519_P_18,576,
    18,
  },
  {
    precomputed_multiscalar_ed25519_Q_19,33,
    precomputed_multiscalar_ed25519_n_19,608,
    precomputed_multiscalar_ed25519_P_19,608,
    19,
  },
  {
    precomputed_multiscalar_ed25519_Q_20,33,
    precomputed_multiscalar_ed25519_n_20,640,
    precomputed_multiscalar_ed25519_P_20,640,
    20,
  },
  {
    precomputed_multiscalar_ed25519_Q_21,33,
    precomputed_multiscalar_ed25519_n_21,672,
    precomputed_multiscalar_ed25519_P_21,672,
    21,
  },
  {
    precomputed_multiscalar_ed25519_Q_22,33,
    precomputed_multiscalar_ed25519_n_22,704,
    precomputed_multiscalar_ed25519_P_22,704,
    22,
  },
  {
    precomputed_multiscalar_ed25519_Q_23,33,
    precomputed_multiscalar_ed25519_n_23,736,
    precomputed_multiscalar_ed25519_P_23,736,
    23,
  },
  {
    precomputed_multiscalar_ed25519_Q_24,33,
    precomputed_multiscalar_ed25519_n_24,768,
    precomputed_multiscalar_ed25519_P_24,768,
    24,
  },
  {
    precomputed_multiscalar_ed25519_Q_25,33,
    precomputed_multiscalar_ed25519_n_25,800,
    precomputed_multiscalar_ed25519_P_25,800,
    25,
  },
  {
    precomputed_multiscalar_ed25519_Q_26,33,
    precomputed_multiscalar_ed25519_n_26,832,
    precomputed_multiscalar_ed25519_P_26,832,
    26,
  },
  {
    precomputed_multiscalar_ed25519_Q_27,33,
    precomputed_multiscalar_ed25519_n_27,864,
    precomputed_multiscalar_ed25519_P_27,864,
    27,
  },
  {
    precomputed_multiscalar_ed25519_Q_28,33,
    precomputed_multiscalar_ed25519_n_28,896,
    precomputed_multiscalar_ed25519_P_28,896,
    28,
  },
  {
    precomputed_multiscalar_ed25519_Q_29,33,
    precomputed_multiscalar_ed25519_n_29,928,
    precomputed_multiscalar_ed25519_P_29,928,
    29,
  },
  {
    precomputed_multiscalar_ed25519_Q_30,33,
    precomputed_multiscalar_ed25519_n_30,960,
    precomputed_multiscalar_ed25519_P_30,960,
    30,
  },
  {
    precomputed_multiscalar_ed25519_Q_31,33,
    precomputed_multiscalar_ed25519_n_31,992,
    precomputed_multiscalar_ed25519_P_31,992,
    31,
  },
  {
    precomputed_multiscalar_ed25519_Q_32,33,
    precomputed_multiscalar_ed25519_n_32,1024,
    precomputed_multiscalar_ed25519_P_32,1024,
    32,
  },
} ;

static void test_multiscalar_ed25519_impl(long long impl)
{
  unsigned char *Q = test_multiscalar_ed25519_Q;
  unsigned char *n = test_multiscalar_ed25519_n;
  unsigned char *P = test_multiscalar_ed25519_P;
  unsigned char *Q2 = test_multiscalar_ed25519_Q2;
  unsigned char *n2 = test_multiscalar_ed25519_n2;
  unsigned char *P2 = test_multiscalar_ed25519_P2;
  long long Qlen = crypto_multiscalar_OUTPUTBYTES;
  long long nlen;
  long long Plen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_multiscalar_ed25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_multiscalar = lib25519_dispatch_multiscalar_ed25519(impl);
    printf("multiscalar_ed25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_multiscalar_ed25519_implementation(impl),lib25519_dispatch_multiscalar_ed25519_compiler(impl));
  } else {
    crypto_multiscalar = lib25519_multiscalar_ed25519;
    printf("multiscalar_ed25519 selected implementation %s compiler %s\n",lib25519_multiscalar_ed25519_implementation(),lib25519_multiscalar_ed25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 1024 : 128;
    long long maxtest = checksumbig ? 128 : 16;
    long long mlen;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      mlen = myrandom() % (maxtest + 1);

      nlen = mlen * crypto_multiscalar_SCALARBYTES;
      Plen = mlen * crypto_multiscalar_POINTBYTES;
      output_prepare(Q2,Q,Qlen);
      input_prepare(n2,n,nlen);
      input_prepare(P2,P,Plen);
      public(n,nlen);
      public(P,Plen);
      crypto_multiscalar(Q,n,P,mlen);
      public(n,nlen);
      public(P,Plen);
      public(Q,Qlen);
      checksum(Q,Qlen);
      output_compare(Q2,Q,Qlen,"crypto_multiscalar");
      input_compare(n2,n,nlen,"crypto_multiscalar");
      input_compare(P2,P,Plen,"crypto_multiscalar");

      double_canary(Q2,Q,Qlen);
      double_canary(n2,n,nlen);
      double_canary(P2,P,Plen);
      public(n2,nlen);
      public(P2,Plen);
      crypto_multiscalar(Q2,n2,P2,mlen);
      public(n2,nlen);
      public(P2,Plen);
      public(Q2,Qlen);
      if (memcmp(Q2,Q,Qlen) != 0) fail("failure: crypto_multiscalar is nondeterministic\n");

      double_canary(Q2,Q,Qlen);
      double_canary(n2,n,nlen);
      double_canary(P2,P,Plen);
      public(n2,nlen);
      public(P,Plen);
      crypto_multiscalar(n2,n2,P,mlen);
      public(n2,Qlen);
      public(P,Plen);
      if (memcmp(n2,Q,Qlen) != 0) fail("failure: crypto_multiscalar does not handle n=Q overlap\n");
      memcpy(n2,n,nlen);
      public(n,nlen);
      public(P2,Plen);
      crypto_multiscalar(P2,n,P2,mlen);
      public(P2,Qlen);
      public(n,nlen);
      if (memcmp(P2,Q,Qlen) != 0) fail("failure: crypto_multiscalar does not handle P=Q overlap\n");
      memcpy(P2,P,Plen);
    }
    checksum_expected(multiscalar_ed25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_multiscalar_ed25519_NUM;++precomp) {
    long long mlen = precomputed_multiscalar_ed25519[precomp].batch;
    output_prepare(Q2,Q,precomputed_multiscalar_ed25519[precomp].Qsize);
    input_prepare(n2,n,precomputed_multiscalar_ed25519[precomp].nsize);
    memcpy(n,precomputed_multiscalar_ed25519[precomp].n,precomputed_multiscalar_ed25519[precomp].nsize);
    memcpy(n2,precomputed_multiscalar_ed25519[precomp].n,precomputed_multiscalar_ed25519[precomp].nsize);
    input_prepare(P2,P,precomputed_multiscalar_ed25519[precomp].Psize);
    memcpy(P,precomputed_multiscalar_ed25519[precomp].P,precomputed_multiscalar_ed25519[precomp].Psize);
    memcpy(P2,precomputed_multiscalar_ed25519[precomp].P,precomputed_multiscalar_ed25519[precomp].Psize);
    crypto_multiscalar(Q,n,P,mlen);
    if (memcmp(Q,precomputed_multiscalar_ed25519[precomp].Q,precomputed_multiscalar_ed25519[precomp].Qsize)) {
      fail("failure: crypto_multiscalar fails precomputed test vectors\n");
      printf("expected Q: ");
      for (long long pos = 0;pos < precomputed_multiscalar_ed25519[precomp].Qsize;++pos) printf("%02x",precomputed_multiscalar_ed25519[precomp].Q[pos]);
      printf("\n");
      printf("received Q: ");
      for (long long pos = 0;pos < precomputed_multiscalar_ed25519[precomp].Qsize;++pos) printf("%02x",Q[pos]);
      printf("\n");
    }
    output_compare(Q2,Q,precomputed_multiscalar_ed25519[precomp].Qsize,"crypto_multiscalar");
    input_compare(n2,n,precomputed_multiscalar_ed25519[precomp].nsize,"crypto_multiscalar");
    input_compare(P2,P,precomputed_multiscalar_ed25519[precomp].Psize,"crypto_multiscalar");
  }
}

void test_multiscalar_ed25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"multiscalar")) return;
  if (targetp && strcmp(targetp,"ed25519")) return;
  storage_multiscalar_ed25519_Q = callocplus(crypto_multiscalar_OUTPUTBYTES);
  test_multiscalar_ed25519_Q = aligned(storage_multiscalar_ed25519_Q,crypto_multiscalar_OUTPUTBYTES);
  if (crypto_multiscalar_OUTPUTBYTES > maxalloc) maxalloc = crypto_multiscalar_OUTPUTBYTES;
  storage_multiscalar_ed25519_n = callocplus(128*crypto_multiscalar_SCALARBYTES+crypto_multiscalar_OUTPUTBYTES);
  test_multiscalar_ed25519_n = aligned(storage_multiscalar_ed25519_n,128*crypto_multiscalar_SCALARBYTES+crypto_multiscalar_OUTPUTBYTES);
  if (128*crypto_multiscalar_SCALARBYTES+crypto_multiscalar_OUTPUTBYTES > maxalloc) maxalloc = 128*crypto_multiscalar_SCALARBYTES+crypto_multiscalar_OUTPUTBYTES;
  storage_multiscalar_ed25519_P = callocplus(128*crypto_multiscalar_POINTBYTES+crypto_multiscalar_OUTPUTBYTES);
  test_multiscalar_ed25519_P = aligned(storage_multiscalar_ed25519_P,128*crypto_multiscalar_POINTBYTES+crypto_multiscalar_OUTPUTBYTES);
  if (128*crypto_multiscalar_POINTBYTES+crypto_multiscalar_OUTPUTBYTES > maxalloc) maxalloc = 128*crypto_multiscalar_POINTBYTES+crypto_multiscalar_OUTPUTBYTES;
  storage_multiscalar_ed25519_Q2 = callocplus(maxalloc);
  test_multiscalar_ed25519_Q2 = aligned(storage_multiscalar_ed25519_Q2,crypto_multiscalar_OUTPUTBYTES);
  storage_multiscalar_ed25519_n2 = callocplus(maxalloc);
  test_multiscalar_ed25519_n2 = aligned(storage_multiscalar_ed25519_n2,128*crypto_multiscalar_SCALARBYTES+crypto_multiscalar_OUTPUTBYTES);
  storage_multiscalar_ed25519_P2 = callocplus(maxalloc);
  test_multiscalar_ed25519_P2 = aligned(storage_multiscalar_ed25519_P2,128*crypto_multiscalar_POINTBYTES+crypto_multiscalar_OUTPUTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("multiscalar_ed25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_multiscalar_ed25519();++impl)
      forked(test_multiscalar_ed25519_impl,impl);
    ++test_multiscalar_ed25519_Q;
    ++test_multiscalar_ed25519_n;
    ++test_multiscalar_ed25519_P;
    ++test_multiscalar_ed25519_Q2;
    ++test_multiscalar_ed25519_n2;
    ++test_multiscalar_ed25519_P2;
  }
  free(storage_multiscalar_ed25519_P2);
  free(storage_multiscalar_ed25519_n2);
  free(storage_multiscalar_ed25519_Q2);
  free(storage_multiscalar_ed25519_P);
  free(storage_multiscalar_ed25519_n);
  free(storage_multiscalar_ed25519_Q);
}
#undef crypto_multiscalar_SCALARBYTES
#undef crypto_multiscalar_POINTBYTES
#undef crypto_multiscalar_OUTPUTBYTES

