package org.jboss.cache.invocation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.InterceptorChain;

/**
 * The JBoss Cache hand-wired interceptor stack.  A "minimal" AOP framework which uses delegation through an
 * interceptor chain rather than any bytecode manipulation.
 * <p/>
 * This class provides some generic behaviour such as the construction of an {@link org.jboss.cache.InvocationContext}
 * which is passed up the interceptor chain.
 * <p/>
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @see org.jboss.cache.interceptors.base.CommandInterceptor
 * @see org.jboss.cache.InvocationContext
 * @since 2.1.0
 */
public abstract class AbstractInvocationDelegate
{
   protected Log log = LogFactory.getLog(getClass());

   protected Configuration configuration;
   protected InvocationContextContainer invocationContextContainer;
   protected ComponentRegistry componentRegistry;
   protected InterceptorChain invoker;

   protected boolean originLocal = true;

   /**
    * Used by the interceptor chain factory to inject dependencies.
    */
   @Inject
   public void initialize(Configuration configuration, InvocationContextContainer invocationContextContainer,
                          ComponentRegistry componentRegistry, InterceptorChain interceptorChain)
   {
      this.configuration = configuration;
      this.invocationContextContainer = invocationContextContainer;
      this.invoker = interceptorChain;
      this.componentRegistry = componentRegistry;
   }


   protected void assertIsConstructed()
   {
      if (invocationContextContainer == null) throw new IllegalStateException("The cache has been destroyed!");
   }

}
