# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 251-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53326);
 script_cve_id("CVE-2002-1335", "CVE-2002-1348");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 251-1 (w3m, w3m-ssl)";
 script_name(name);

 desc = "The remote host is missing an update to w3m, w3m-ssl
announced via advisory DSA 251-1.

Hironori Sakamoto, one of the w3m developers, found two security
vulnerabilities in w3m and associated programs.  The w3m browser does
not properly escape HTML tags in frame contents and img alt
attributes.  A malicious HTML frame or img alt attribute may deceive a
user to send his local cookies which are used for configuration.  The
information is not leaked automatically, though.

For the stable distribution (woody) these problems have been fixed in
version 0.3-2.4.

The old stable distribution (potato) is not affected by these
problems.

For the unstable distribution (sid) these problems have been fixed in
version 0.3.2.2-1 and later.

We recommend that you upgrade your w3m and w3m-ssl packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20251-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 251-1 (w3m, w3m-ssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"w3m", ver:"0.3-2.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"w3m-img", ver:"0.3-2.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"w3m-ssl", ver:"0.3-2.4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
