###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Nagios-statd Daemon Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "
 
 Overview:
  Nagios-statd Daemon is running at this port. 

  Nagios-statd (nagios-statd  Daemon)  is the daemon program for
  nagios-stat.  These programs together comprise a  systems monitoring
  tool for various platforms.  It is designed to be integrated with the
  Nagios monitoring tool, although this is not a requirement.

  Nagios-statd is the daemon that listens for connections  from
  clients.  It  forks  off  a  new daemon for each incoming connection.
  The forked daemon executes a series of typical UNIX  commands  and
  returns  those commands standard output to the client.
  
 Solution:
  Limit incoming traffic to this port.

 Risk factor : None";

if (description)
{
 script_id(100187);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"None");

 script_name("Nagios-statd Daemon Detection");  

 script_description(desc);
 script_summary("Checks for the presence of Nagios-statd Daemon");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes");
 script_require_ports("Services/unknown", 1040);
 exit(0);
}


include("global_settings.inc");
include("misc_func.inc");


port = 1040;

if (known_service(port:port))exit(0);
if(!get_tcp_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);
  
req = string("version\r\n");
send(socket:soc, data:req);
while (data = recv_line(socket:soc, length:100)) {
   ret += data;
}    
  

if("nagios-statd" >< ret) {

 vers = string("unknown");

 version = eregmatch(pattern:"^nagios-statd ([0-9.]+)$", string: ret);
 
 if(!isnull(version[1])) {
  vers = version[1];
 } 

 set_kb_item(name:"nagios_statd/"+port+"/Version", value:vers);
 register_service(port:port, ipproto:"tcp", proto:"nagios_statd");

 tests = make_list("uptime","disk");
 
 foreach do (tests) {

   soc = open_sock_tcp(port); 
   req = string(do, "\r\n"); 
   send(socket:soc, data:req);

   result += string(do,":\n");

   while (data = recv_line(socket:soc, length:100)) {

    result += data;

   }

   result += string("\n");
   close(soc);
 }

 if(strlen(result)) {

   info = string("None\n\nHere are a few Information from the nagios-statd daemon received by OpenVAS:\n\n");
   info += result;

   desc = ereg_replace(
    	string:desc,
    	pattern:"None$",
    	replace:info
    ); 

 }  

  if(report_verbosity > 0) { 
     security_note(port:port,data:desc);
   }  

  exit(0);

}

exit(0);
