% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{git_branch}
\alias{git_branch}
\alias{git_branch_list}
\alias{git_branch_checkout}
\alias{git_branch_create}
\alias{git_branch_delete}
\alias{git_branch_move}
\alias{git_branch_fast_forward}
\alias{git_branch_set_upstream}
\alias{git_branch_exists}
\title{Git Branch}
\usage{
git_branch(repo = ".")

git_branch_list(local = NULL, repo = ".")

git_branch_checkout(branch, force = FALSE, orphan = FALSE, repo = ".")

git_branch_create(
  branch,
  ref = "HEAD",
  checkout = TRUE,
  force = FALSE,
  repo = "."
)

git_branch_delete(branch, repo = ".")

git_branch_move(branch, new_branch, force = FALSE, repo = ".")

git_branch_fast_forward(ref, repo = ".")

git_branch_set_upstream(upstream, branch = git_branch(repo), repo = ".")

git_branch_exists(branch, local = TRUE, repo = ".")
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{local}{set TRUE to only check for local branches, FALSE to check for remote
branches. Use NULL to return all branches.}

\item{branch}{name of branch to check out}

\item{force}{overwrite existing branch}

\item{orphan}{if branch does not exist, checkout unborn branch}

\item{ref}{string with a branch/tag/commit}

\item{checkout}{move HEAD to the newly created branch}

\item{new_branch}{target name of the branch once the move is performed; this name is validated for consistency.}

\item{upstream}{remote branch from \link{git_branch_list}, for example \code{"origin/master"}}
}
\description{
Create, list, and checkout branches.
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_reset}()},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
