% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_compare_means.R
\name{stat_compare_means}
\alias{stat_compare_means}
\title{Add Mean Comparison P-values to a ggplot}
\usage{
stat_compare_means(
  mapping = NULL,
  data = NULL,
  method = NULL,
  paired = FALSE,
  method.args = list(),
  ref.group = NULL,
  comparisons = NULL,
  hide.ns = FALSE,
  label.sep = ", ",
  label = NULL,
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  vjust = 0,
  tip.length = 0.03,
  bracket.size = 0.3,
  step.increase = 0,
  symnum.args = list(),
  geom = "text",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{method}{a character string indicating which method to be used for
comparing means.}

\item{paired}{a logical indicating whether you want a paired test. Used only
in \code{\link[stats]{t.test}} and in \link[stats]{wilcox.test}.}

\item{method.args}{a list of additional arguments used for the test method.
For example one might use \code{method.args = list(alternative = "greater")}
for wilcoxon test.}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 \code{ref.group} can be also \code{".all."}. In this case, each of the
 grouping variable levels is compared to all (i.e. basemean).}

\item{comparisons}{A list of length-2 vectors. The entries in the vector are
either the names of 2 values on the x-axis or the 2 integers that correspond
to the index of the groups of interest, to be compared.}

\item{hide.ns}{logical value. If TRUE, hide ns symbol when displaying
significance levels.}

\item{label.sep}{a character string to separate the terms. Default is ", ", to
separate the correlation coefficient and the p.value.}

\item{label}{character string specifying label type. Allowed values include
"p.signif" (shows the significance levels), "p.format" (shows the formatted
p value).}

\item{label.x.npc, label.y.npc}{can be \code{numeric} or \code{character}
vector of the same length as the number of groups and/or panels. If too
short they will be recycled. \itemize{ \item If \code{numeric}, value should
be between 0 and 1. Coordinates to be used for positioning the label,
expressed in "normalized parent coordinates". \item If \code{character},
allowed values include: i) one of c('right', 'left', 'center', 'centre',
'middle') for x-axis; ii) and one of c( 'bottom', 'top', 'center', 'centre',
'middle') for y-axis.}}

\item{label.x, label.y}{\code{numeric} Coordinates (in data units) to be used
for absolute positioning of the label. If too short they will be recycled.}

\item{vjust}{move the text up or down relative to the bracket.}

\item{tip.length}{numeric vector with the fraction of total height that the
 bar goes down to indicate the precise column. Default is 0.03. Can be of
 same length as the number of comparisons to adjust specifically the tip
 lenth of each comparison. For example tip.length = c(0.01, 0.03).

 If too short they will be recycled.}

\item{bracket.size}{Width of the lines of the bracket.}

\item{step.increase}{numeric vector with the increase in fraction of total
height for every additional comparison to minimize overlap.}

\item{symnum.args}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args <- list(cutpoints = c(0, 0.0001, 0.001,
 0.01, 0.05, Inf), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001 \item \code{****}:  p <= 0.0001 }}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If FALSE (the default), removes missing values with a warning. If
TRUE silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{other arguments to pass to \code{\link[ggplot2]{geom_text}} or
\code{\link[ggplot2:geom_text]{geom_label}}.}
}
\description{
Add mean comparison p-values to a ggplot, such as box blots, dot
 plots and stripcharts.
}
\examples{
# Load data
data("ToothGrowth")
head(ToothGrowth)

# Two independent groups
#:::::::::::::::::::::::::::::::::::::::::::::::::
p <- ggboxplot(ToothGrowth, x = "supp", y = "len",
  color = "supp", palette = "npg", add = "jitter")

#  Add p-value
p + stat_compare_means()
# Change method
p + stat_compare_means(method = "t.test")

 # Paired samples
 #:::::::::::::::::::::::::::::::::::::::::::::::::
 ggpaired(ToothGrowth, x = "supp", y = "len",
   color = "supp", line.color = "gray", line.size = 0.4,
   palette = "npg")+
 stat_compare_means(paired = TRUE)

# More than two groups
#:::::::::::::::::::::::::::::::::::::::::::::::::
# Pairwise comparisons: Specify the comparisons you want
my_comparisons <- list( c("0.5", "1"), c("1", "2"), c("0.5", "2") )
ggboxplot(ToothGrowth, x = "dose", y = "len",
          color = "dose", palette = "npg")+
# Add pairwise comparisons p-value
stat_compare_means(comparisons = my_comparisons, label.y = c(29, 35, 40))+
stat_compare_means(label.y = 45)     # Add global Anova p-value

# Multiple pairwise test against a reference group
ggboxplot(ToothGrowth, x = "dose", y = "len",
    color = "dose", palette = "npg")+
stat_compare_means(method = "anova", label.y = 40)+ # Add global p-value
stat_compare_means(aes(label = after_stat(p.signif)),
                  method = "t.test", ref.group = "0.5")

# Multiple grouping variables
#:::::::::::::::::::::::::::::::::::::::::::::::::
# Box plot facetted by "dose"
p <- ggboxplot(ToothGrowth, x = "supp", y = "len",
              color = "supp", palette = "npg",
              add = "jitter",
              facet.by = "dose", short.panel.labs = FALSE)
# Use only p.format as label. Remove method name.
p + stat_compare_means(
 aes(label = paste0("p = ", after_stat(p.format)))
)

}
\seealso{
\code{\link{compare_means}}
}
