% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as_draws_matrix.projection}
\alias{as_draws_matrix.projection}
\alias{as_draws.projection}
\title{Extract projected parameter draws and coerce to \code{draws_matrix} (see package
\pkg{posterior})}
\usage{
\method{as_draws_matrix}{projection}(x, ...)

\method{as_draws}{projection}(x, ...)
}
\arguments{
\item{x}{An object of class \code{projection} (returned by \code{\link[=project]{project()}}, possibly
as elements of a \code{list}).}

\item{...}{Arguments passed to \code{\link[=as.matrix.projection]{as.matrix.projection()}}, except for
\code{allow_nonconst_wdraws_prj}.}
}
\value{
An \eqn{S_{\mathrm{prj}} \times Q}{S_prj x Q} \code{draws_matrix} (see
\code{\link[posterior:draws_matrix]{posterior::draws_matrix()}}) of projected draws, with
\eqn{S_{\mathrm{prj}}}{S_prj} denoting the number of projected draws and
\eqn{Q} the number of parameters. If the projected draws have nonconstant
weights, \code{\link[posterior:weight_draws]{posterior::weight_draws()}} is applied internally.
}
\description{
These are the \code{\link[posterior:draws]{posterior::as_draws()}} and \code{\link[posterior:draws_matrix]{posterior::as_draws_matrix()}}
methods for \code{projection} objects (returned by \code{\link[=project]{project()}}, possibly as
elements of a \code{list}). They extract the projected parameter draws and return
them as a \code{draws_matrix}. In case of different (i.e., nonconstant) weights
for the projected draws, a \code{draws_matrix} allows for a safer handling of
these weights (safer in contrast to the matrix returned by
\code{\link[=as.matrix.projection]{as.matrix.projection()}}), in particular by providing the natural input for
\code{\link[posterior:resample_draws]{posterior::resample_draws()}} (see section "Examples" below).
}
\details{
In case of the augmented-data projection for a multilevel submodel
of a \code{\link[brms:brmsfamily]{brms::categorical()}} reference model, the multilevel parameters (and
therefore also their names) slightly differ from those in the \pkg{brms}
reference model fit (see section "Augmented-data projection" in
\code{\link[=extend_family]{extend_family()}}'s documentation).
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE) && requireNamespace("posterior", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The `stanreg` fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Projection onto an arbitrary combination of predictor terms (with a small
# value for `nclusters`, but only for illustrative purposes; this is not
# recommended in general):
prj <- project(fit, predictor_terms = c("X1", "X3", "X5"), nclusters = 5,
               seed = 9182)

# Applying the posterior::as_draws_matrix() generic to the output of
# project() dispatches to the projpred::as_draws_matrix.projection()
# method:
prj_draws <- posterior::as_draws_matrix(prj)

# Resample the projected draws according to their weights:
set.seed(3456)
prj_draws_resampled <- posterior::resample_draws(prj_draws, ndraws = 1000)

# The values from the following two objects should be the same (in general,
# this only holds approximately):
print(proportions(table(rownames(prj_draws_resampled))))
print(weights(prj_draws))

# Treat the resampled draws like ordinary draws, e.g., summarize them:
print(posterior::summarize_draws(
  prj_draws_resampled,
  "median", "mad", function(x) quantile(x, probs = c(0.025, 0.975))
))
# Or visualize them using the `bayesplot` package:
if (requireNamespace("bayesplot", quietly = TRUE)) {
  print(bayesplot::mcmc_intervals(prj_draws_resampled))
}
\dontshow{\}) # examplesIf}
}
