% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_graphics.R
\name{X11}
\alias{X11}
\alias{x11}
\alias{windows}
\alias{win.graph}
\alias{quartz}
\title{Overrides for platform specific R plotting devices}
\usage{
X11(
  display = "",
  width,
  height,
  pointsize,
  gamma,
  bg,
  canvas,
  fonts,
  family,
  xpos,
  ypos,
  title,
  type,
  antialias,
  symbolfamily
)

x11(
  display = "",
  width,
  height,
  pointsize,
  gamma,
  bg,
  canvas,
  fonts,
  family,
  xpos,
  ypos,
  title,
  type,
  antialias,
  symbolfamily
)

windows(
  width = getOption("rk.screendevice.width"),
  height = getOption("rk.screendevice.height"),
  pointsize = 12,
  bg,
  title,
  antialias
)

win.graph(
  width = getOption("rk.screendevice.width"),
  height = getOption("rk.screendevice.height"),
  pointsize = 12,
  bg,
  title,
  antialias
)

quartz(
  title,
  width,
  height,
  pointsize,
  family,
  antialias,
  type,
  file = NULL,
  bg,
  canvas,
  dpi
)
}
\arguments{
\item{display}{the display on which the graphics window will appear.
    The default is to use the value in the user's environment variable
    \env{DISPLAY}.  This is ignored (with a warning) if an X11 device is
    already open on another display.}

\item{width, height}{the width and height of the plotting window, in
    inches.  If \code{NA}, taken from the resources and if
    not specified there defaults to \code{7} inches.  See also
    \sQuote{Resources}.}

\item{pointsize}{the default pointsize to be used.  Defaults to \code{12}.}

\item{gamma}{gamma correction fudge factor.
    Colours in R are \abbr{sRGB};  if your monitor does not conform to
    \abbr{sRGB}, you might be able to improve things by tweaking this
    parameter to apply additional gamma correction to the RGB channels.
    By default 1 (no additional gamma correction).}

\item{bg}{colour, the initial background colour.  Default
    \code{"transparent"}.}

\item{canvas}{colour.  The colour of the canvas, which is visible only
    when the background colour is transparent.  Should be an opaque colour
    (and any alpha value will be ignored).  Default \code{"white"}.}

\item{fonts}{for \code{type = "Xlib"} only:
    X11 font description strings into which weight, slant and
    size will be substituted.  There are two, the first for fonts 1 to 4
    and the second for font 5, the symbol font.  See section \sQuote{Fonts}.}

\item{family}{The default family: a length-one character string.  This
    is primarily intended for cairo-based devices, but for \code{type =
    "Xlib"}, the \code{\link[grDevices]{X11Fonts}()} database is used to map family
    names to \code{fonts} (and this argument takes precedence over that
    one).}

\item{xpos, ypos}{integer: initial position of the top left corner of the
    window, in pixels.  Negative values are from the opposite corner,
    e.g.\ifelse{latex}{\out{~}}{ }{}\code{xpos = -100} says the top right corner should be 100 pixels
    from the right edge of the screen.  If \code{NA} (the default),
    successive devices are cascaded in 20 pixel steps from the top left.
    See also \sQuote{Resources}.}

\item{title}{character string, up to 100 bytes.  With the default,
    \code{""}, a suitable title is created internally.  A C-style format
    for an integer will be substituted by the device number (see the
    \code{file} argument of \code{\link{df}} for further
    details).  How non-ASCII titles are handled is
    implementation-dependent.}

\item{type}{character string, one of \code{"Xlib"}, \code{"cairo"},
    \code{"nbcairo"} or \code{"dbcairo"}.  Only the first will be
    available if the system was compiled without support for
    cairographics.  The default is \code{"cairo"} where \R was built
    using \code{pangocairo} (often not the case on macOS), otherwise
    \code{"Xlib"}.}

\item{antialias}{for cairo types, the type of anti-aliasing (if any)
    to be used.  One of \code{c("default", "none", "gray", "subpixel")}.}

\item{symbolfamily}{for cairo-based devices only:
      a length-one character string that specifies the font family to
      be used as the "symbol" font (e.g., for \link[grDevices]{plotmath} output).
      The default value is "default", which means that R will choose
      a default "symbol" font based on the graphics device capabilities.}

\item{file}{an optional target for the graphics device. The default,
    \code{NULL}, selects a default name where one is needed.  See
    \sQuote{Details} for more information.}

\item{dpi}{resolution of the output.  The default (\code{NA_real_})
    for an on-screen display defaults to the resolution of
    the main screen, and to 72 dpi otherwise.  See \sQuote{Details}.}
}
\description{
These functions override the platform specific on-screen plotting devices by the same names.
The exact behavior depends on configuration settings, and can be one of: The original R device,
the original R device embedded using \code{rk.embed.device()}, or the call can be re-directed
to the \code{RK()} device. In the last case not all function arguments may be honored.
}
\note{
If you want to use the \link{RK} device, you should call that, explicitly. These
      overrides are provided to make it easy to use scripts that refer to the platform specific
      plotting devices provided by R.
}
\seealso{
\code{\link[rkward:RK]{RK}},
  \code{\link[rkward:rk.embed.device]{rk.embed.device}},
  \code{\link[grDevices:X11]{X11}},
  \code{\link[grDevices:windows]{windows}},
  \code{\link[grDevices:win.graph]{win.graph}},
  \code{\link[grDevices:quartz]{quartz}}
}
