/*
*  RAL -- Rubrica Addressbook Library
*  file: groups.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_GROUP_BOX_H
#define _R_GROUP_BOX_H

#include <glib.h>
#include <glib-object.h>

#include "group.h"

#define R_GROUP_BOX_TYPE           (r_group_box_get_type())

#define R_GROUP_BOX(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),     \
                                    R_GROUP_BOX_TYPE, RGroupBox))

#define R_GROUP_BOX_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),      \
                                    R_GROUP_BOX_TYPE, RGroupBoxClass))

#define IS_R_GROUP_BOX(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),     \
                                    R_GROUP_BOX_TYPE))

#define IS_R_GROUP_BOX_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),        \
                                    R_GROUP_BOX_TYPE))

#define R_GROUP_BOX_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),      \
			            R_GROUP_BOX_TYPE, RGroupBoxClass))



typedef struct _RGroupBox        RGroupBox;
typedef struct _RGroupBoxClass   RGroupBoxClass;
typedef struct _RGroupBoxPrivate RGroupBoxPrivate;


struct _RGroupBox {
  GObject parent;
  
  RGroupBoxPrivate* priv;  
};


struct _RGroupBoxClass {
  GObjectClass parent;

  void (*group_added)   (RGroupBox* box, gpointer group);
  void (*group_removed) (RGroupBox* box, gint id);
  void (*group_renamed) (RGroupBox* box, gpointer group);
};



GType      r_group_box_get_type (void);



RGroupBox* r_group_box_new          (void);
void       r_group_box_free         (RGroupBox* box);

gboolean   r_group_box_is_empty     (RGroupBox* box);

gpointer   r_group_box_find         (RGroupBox* box, gchar* group_name);
gboolean   r_group_box_owns_group   (RGroupBox* box, const gchar* group_name);
gboolean   r_group_box_add_group    (RGroupBox* box, RGroup* group);
gboolean   r_group_box_rename_group (RGroupBox* box, gchar* oldname,
				     gchar* newname);

void       r_group_box_disable_all   (RGroupBox* box);
void       r_group_box_enable_group  (RGroupBox* box, RGroup* group);
void       r_group_box_disable_group (RGroupBox* box, RGroup* group);

gboolean   r_group_box_delete_group         (RGroupBox* box, RGroup* group);
gboolean   r_group_box_delete_group_by_name (RGroupBox* box, gchar* name);

GList*     r_group_box_find_groups_owned_by (RGroupBox* box,
					     const gchar* owner);

void       r_group_box_reset          (RGroupBox* box);
RGroup*    r_group_box_get_group      (RGroupBox* box);
RGroup*    r_group_box_get_next_group (RGroupBox* box);
RGroup*    r_group_box_get_prev_group (RGroupBox* box);

RGroupBox* r_group_box_merge_boxes    (RGroupBox* box, RGroupBox* second);
#endif
