<?php

/***************************************************************************\
 *  SPIP, Système de publication pour l'internet                           *
 *                                                                         *
 *  Copyright © avec tendresse depuis 2001                                 *
 *  Arnaud Martin, Antoine Pitrou, Philippe Rivière, Emmanuel Saint-James  *
 *                                                                         *
 *  Ce programme est un logiciel libre distribué sous licence GNU/GPL.     *
\***************************************************************************/

if (!defined('_ECRIRE_INC_VERSION')) {
	return;
}

include_spip('inc/actions');
include_spip('inc/editer');
include_spip('inc/documents');
include_spip('inc/config');

function formulaires_editer_document_charger_dist(
	$id_document = 'new',
	$id_parent = '',
	$retour = '',
	$lier_trad = 0,
	$config_fonc = 'documents_edit_config',
	$row = [],
	$hidden = ''
) {
	$valeurs = formulaires_editer_objet_charger('document', $id_document, $id_parent, $lier_trad, $retour, $config_fonc, $row, $hidden);


	if (intval($id_document) and !autoriser('modifier', 'document', intval($id_document))) {
		$valeurs['editable'] = '';
	}

	// relier les parents
	$valeurs['parents'] = [];
	$valeurs['_hidden'] = '';
	$parents = sql_allfetsel('objet,id_objet', 'spip_documents_liens', 'id_document=' . intval($id_document));
	foreach ($parents as $p) {
		if (in_array($p['objet'], ['article', 'rubrique']) and $p['id_objet'] > 0) {
			$valeurs['parents'][] = $p['objet'] . '|' . $p['id_objet'];
		} else {
			$valeurs['_hidden'] .= "<input type='hidden' name='parents[]' value='" . $p['objet'] . '|' . $p['id_objet'] . "' />";
		}
	}

	// en fonction de la config du site on a le droit ou pas de modifier la date
	if ($valeurs['_editer_date'] = (lire_config('documents_date') == 'oui' ? ' ' : '')) {
		$valeurs['saisie_date'] = affdate($valeurs['date'], 'd/m/Y');
		$valeurs['saisie_heure'] = affdate($valeurs['date'], 'H:i');
	} elseif (isset($valeurs['date'])) {
		unset($valeurs['date']);
	}

	// en fonction du format
	$valeurs['_editer_dimension'] = autoriser('tailler', 'document', $id_document) ? ' ' : '';

	// type du document et inclusion
	$row = sql_fetsel(
		'titre as type_document,inclus',
		'spip_types_documents',
		'extension=' . sql_quote($valeurs['extension'])
	);
	$valeurs['type_document'] = $row['type_document'];
	$valeurs['_inclus'] = $row['inclus'];
	if (in_array($valeurs['extension'], ['jpg', 'gif', 'png', 'svg'])) {
		$valeurs['apercu'] = get_spip_doc($valeurs['fichier']);
	}

	// verifier les infos de taille et dimensions sur les fichiers locaux
	// cas des maj de fichier directes par ftp
	if ($valeurs['distant'] !== 'oui') {
		include_spip('inc/renseigner_document');
		$infos = renseigner_taille_dimension_image(get_spip_doc($valeurs['fichier']), $valeurs['extension']);
		if ($infos and is_array($infos) and isset($infos['taille'])) {
			if (
				$infos['taille'] != $valeurs['taille']
				or ($infos['type_image'] && ($infos['largeur'] != $valeurs['largeur']))
				or ($infos['type_image'] && ($infos['hauteur'] != $valeurs['hauteur']))
			) {
				$valeurs['_taille_modif'] = $infos['taille'];
				$valeurs['_largeur_modif'] = $infos['largeur'];
				$valeurs['_hauteur_modif'] = $infos['hauteur'];
				$valeurs['_hidden'] .=
					"<input type='hidden' name='_taille_modif' value='" . $infos['taille'] . "' />"
					. "<input type='hidden' name='_largeur_modif' value='" . $infos['largeur'] . "' />"
					. "<input type='hidden' name='_hauteur_modif' value='" . $infos['hauteur'] . "' />";
			}
		}
	}


	// pour l'upload d'un nouveau doc
	if ($valeurs['fichier']) {
		$charger = charger_fonction('charger', 'formulaires/joindre_document');
		$valeurs = array_merge($valeurs, $charger($id_document, 0, '', 'choix'));
		$valeurs['_hidden'] .= "<input name='id_document' value='$id_document' type='hidden' />";
	}

	return $valeurs;
}

// Choix par defaut des options de presentation
function documents_edit_config($row) {
	global $spip_lang;

	$config = [];//$GLOBALS['meta'];
	$config['lignes'] = 8;
	$config['langue'] = $spip_lang;

	$config['restreint'] = ($row['statut'] == 'publie');

	return $config;
}

function formulaires_editer_document_verifier_dist(
	$id_document = 'new',
	$id_parent = '',
	$retour = '',
	$lier_trad = 0,
	$config_fonc = 'documents_edit_config',
	$row = [],
	$hidden = ''
) {
	$erreurs = formulaires_editer_objet_verifier('document', $id_document, is_numeric($id_document) ? [] : ['titre']);

	// verifier l'upload si on a demande a changer le document
	if (_request('joindre_upload') or _request('joindre_ftp') or _request('joindre_distant')) {
		if (_request('copier_local')) {
		} else {
			$verifier = charger_fonction('verifier', 'formulaires/joindre_document');
			$erreurs = array_merge($erreurs, $verifier($id_document));
		}
	}

	// On ne vérifie la date que si on avait le droit de la modifier
	if (lire_config('documents_date') == 'oui') {
		if (
			!$date = recup_date(_request('saisie_date') . ' ' . _request('saisie_heure') . ':00')
			or !($date = mktime($date[3], $date[4], 0, $date[1], $date[2], $date[0]))
		) {
			$erreurs['saisie_date'] = _T('medias:format_date_incorrect');
		} else {
			set_request('saisie_date', date('d/m/Y', $date));
			set_request('saisie_heure', date('H:i', $date));
			set_request('date', date('Y-m-d H:i:s', $date));
		}
	}

	return $erreurs;
}

function formulaires_editer_document_traiter_dist(
	$id_document = 'new',
	$id_parent = '',
	$retour = '',
	$lier_trad = 0,
	$config_fonc = 'documents_edit_config',
	$row = [],
	$hidden = ''
) {
	$rename = null;
	if (is_null(_request('parents'))) {
		set_request('parents', []);
	}

	// verifier les infos de taille et dimensions sur les fichiers locaux
	// cas des maj de fichier directes par ftp
	foreach (['taille', 'largeur', 'hauteur'] as $c) {
		if (($v = _request("_{$c}_modif")) and !_request($c)) {
			set_request($c, $v);
		}
	}

	$res = formulaires_editer_objet_traiter('document', $id_document, $id_parent, $lier_trad, $retour, $config_fonc, $row, $hidden);
	set_request('parents');
	$autoclose = "<script type='text/javascript'>if (window.jQuery) jQuery.modalboxclose();</script>";
	$mode = sql_getfetsel('mode', 'spip_documents', "id_document = $id_document");
	if (
		_request('copier_local')
		or _request('joindre_upload')
		or _request('joindre_ftp')
		or _request('joindre_distant')
		or _request('joindre_zip')
	) {
		$autoclose = '';
		if (_request('copier_local')) {
			$copier_local = charger_fonction('copier_local', 'action');
			$res = ['editable' => true];
			if (($err = $copier_local($id_document)) === true) {
				$res['message_ok'] = (isset($res['message_ok']) ? $res['message_ok'] . '<br />' : '') . _T('medias:document_copie_locale_succes');
			} else {
				$res['message_erreur'] = (isset($res['message_erreur']) ? $res['message_erreur'] . '<br />' : '') . $err;
			}
			set_request('credits'); // modifie par la copie locale
		} else {
			// liberer le nom de l'ancien fichier pour permettre le remplacement par un fichier du meme nom
			if (
				$ancien_fichier = sql_getfetsel('fichier', 'spip_documents', 'id_document=' . intval($id_document))
				and !tester_url_absolue($ancien_fichier)
				and @file_exists($rename = get_spip_doc($ancien_fichier))
			) {
				@rename($rename, "$rename--.old");
			}
			$traiter = charger_fonction('traiter', 'formulaires/joindre_document');
			$res2 = $traiter($id_document, 0, '', $mode);
			if (isset($res2['message_erreur'])) {
				$res['message_erreur'] = $res2['message_erreur'];
				// retablir le fichier !
				if ($rename) {
					@rename("$rename--.old", $rename);
				}
			} else // supprimer vraiment le fichier initial
			{
				spip_unlink("$rename--.old");
			}
		}
		// on annule les saisies largeur/hauteur : l'upload a pu charger les siens
		set_request('largeur');
		set_request('hauteur');
	} else {
		// regarder si une demande de rotation a eu lieu
		// c'est un bouton image, dont on a pas toujours le name en request, on fait avec
		$angle = 0;
		if (_request('tournerL90') or _request('tournerL90_x')) {
			$angle = -90;
		}
		if (_request('tournerR90') or _request('tournerR90_x')) {
			$angle = 90;
		}
		if (_request('tourner180') or _request('tourner180_x')) {
			$angle = 180;
		}
		if ($angle) {
			$autoclose = '';
			$tourner = charger_fonction('tourner', 'action');
			action_tourner_post($id_document, $angle);
		}
	}

	if (!isset($res['redirect'])) {
		$res['editable'] = true;
	}
	if (!isset($res['message_erreur'])) {
		$res['message_ok'] = _T('info_modification_enregistree') . $autoclose;
	}

	if ($res['message_ok']) {
		if (strpos($mode, 'logo') === false) {
			$res['message_ok'] .= '<script type="text/javascript">if (window.jQuery) ajaxReload("document_infos");</script>';
		} else {
			$res['message_ok'] .= '<script type="text/javascript">if (window.jQuery) ajaxReload("navigation");</script>';
		}
	}

	return $res;
}
