%----------------------------------------------------------------------
% Tests abolishing suspensions and early completion.  The idea is that
% negation suspensions should not be abolished and early completion
% cannot be performed when only unconditional answers are derived.
%
% In this program all answers are conditional; furthermore, no
% simplification is applicable and thus the residual program is
% identical to those without the writelns.  Nice example for
% displaying conditional answers...
%----------------------------------------------------------------------

:- table t/0, a/0, b/0.

test :- abolish_all_tables, fail.
test :- t, fail.
test.

t :- a, writeln('t: a''s answer returned'), tnot(t),
     writeln('t: gets a conditional answer from its first clause').
t :- b, tnot(a), tnot(t),
     writeln('t: gets a conditional answer from its second clause').
t :- tnot(a), tnot(t),
     writeln('t: gets a conditional answer from its third clause').

a :- tnot(b), writeln('a: after 1st b'), tnot(b), writeln('a: after 2nd b').

b :- t, tnot(b), writeln('b: gets a conditional answer').

