; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le < %s | FileCheck %s

; When fpext is free, we should look through it for optimizations
; even if it has multiple uses and produce an 'fadd' here.
; Y - (fpext(-X)) --> Y + fpext(X)

define double @neg_ext_op1_extra_use(float %x, double %y) nounwind {
; CHECK-LABEL: neg_ext_op1_extra_use:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsnegdp 0, 1
; CHECK-NEXT:    xsadddp 1, 2, 1
; CHECK-NEXT:    xsdivdp 1, 0, 1
; CHECK-NEXT:    blr
  %t1 = fsub float -0.0, %x
  %t2 = fpext float %t1 to double
  %t3 = fsub double %y, %t2
  %t4 = fdiv double %t2, %t3
  ret double %t4
}

