/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#include "SmartScopesClientTest.h"
#include <QTest>
#include <QUrlQuery>

#include "SmartScopesClient.h"

void SmartScopesClientTest::buildSearchUrlTest()
{
    SmartScopesClient cli("pl");

    QStringList scopes;
    scopes << "a.scope" << "b.scope";

    QStringList removedScopes;
    removedScopes << "c.scope" << "d.scope";

    auto url = cli.buildSearchUrl("foo", scopes, removedScopes, "abcdef-1234", "foobar.scope");
    auto query = QUrlQuery(url.query());

    QCOMPARE(query.queryItemValue("locale"), QString("pl"));
    QCOMPARE(query.queryItemValue("scopes"), QString("a.scope,b.scope"));
    QCOMPARE(query.queryItemValue("removed_scopes"), QString("c.scope,d.scope"));
    QCOMPARE(query.queryItemValue("session_id"), QString("abcdef-1234"));
    QCOMPARE(query.queryItemValue("origin"), QString("foobar.scope"));
    QCOMPARE(query.queryItemValue("q"), QString("foo"));

    url = cli.buildSearchUrl("bar", scopes, QStringList(), "abcdef-1234", "foobar.scope");
    query = QUrlQuery(url.query());

    QCOMPARE(query.queryItemValue("locale"), QString("pl"));
    QCOMPARE(query.queryItemValue("scopes"), QString("a.scope,b.scope"));
    QCOMPARE(query.queryItemValue("removed_scopes"), QString(""));
    QCOMPARE(query.queryItemValue("session_id"), QString("abcdef-1234"));
    QCOMPARE(query.queryItemValue("origin"), QString("foobar.scope"));
    QCOMPARE(query.queryItemValue("q"), QString("bar"));
}

QTEST_MAIN(SmartScopesClientTest)
