/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */




#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>

#include <xview/icon.h>

#include <unistd.h>
#include <ctype.h>

#include "bc_file.h"

/* local globals */

#define KEY_OK 101
#define VALUE_OK 102
#define END_OF_ITEM 103
#define FIELD_OK 104

char           *preamble;

char            value[BUFSIZ], buffer[BUFSIZ], entry[BUFSIZ], key[BUFSIZ],
                label[BUFSIZ], old_label[BUFSIZ] = {'\n'};
char            obracket, cbracket;
char            value_obracket, value_cbracket;

int             count, nextout;
int             load_flag;
int             line_count;

Ref            *aux;

static int      getbuf();



extern char    *
strip_space(s)
	char           *s;

{
	int             j, i, n, m;

	i = 0;

	while (s[i] == ' ' || s[i] == '\t')
		i++;

	j = strlen(s) - 1;

	while ((s[j] == ' ' || s[j] == '\t') && j >= i) {
		s[j] = ' ';
		s[j--] = '\0';
	}

#ifdef STRIP_ALL_SPACES
	for (n = i; n < j; n++) {
		while (((s[n] == ' ') || (s[n] == '\t')) && ((s[n + 1] == ' ') || (s[n + 1] == '\t'))) {
			if (s[n] == '\t')
				s[n] = ' ';
			for (m = n; m <= j; m++) {
				s[m] = s[m + 1];
			}
		}
	}
#endif

	return ((char *) (s + i));
}



#ifdef SHOW_ERROR_IN_LINE
static void
show_error_in_line()
{
	fprintf(PRINT_TO, "bibcard: This ERROR occured in line %d (first is 1). \n", line_count + 1);
}
#endif



static int
getch()
{				/* returns next char or EOF */
	if (count > 0) {
		count--;
#ifdef SHOW_ERROR_IN_LINE
		if (buffer[nextout] == '\n')
			line_count++;
#endif
		return buffer[nextout++];
	} else if (count == 0) {
		return (getbuf());
	} else
		return (EOF);
}



static int
getbuf()
{				/* fills buffer, sets count & nextout and
				 * returns 1st char or EOF */
	count = fread(buffer, 1, BUFSIZ, infile);
	if (count == 0)
		return (EOF);
	nextout = 0;
	return (getch());
}



static int
scan_to(target_chr)
	int             target_chr;
{
	int             ch;

	ch = getch();
	while ((ch != target_chr) && (ch != EOF))
		ch = getch();
	return ch;
}



static int
open_bracket(ch)
	int             ch;
{
	return ((int) strchr("{[(<", ch));
}



static int
close_bracket(ch)
	int             ch;
{
	/* returns true if ch is the current close bracket */
	return (ch == cbracket);
}



static int
match_bracket(ch)
	int             ch;
{
	switch (ch) {

	case '{':
		return ('}');
		break;
	case '[':
		return (']');
		break;
	case '(':
		return (')');
		break;
	case '<':
		return ('>');
		break;
	}
	return (NULL);
}



static int
set_brackets()
{
	int             ch;

	if (obracket == '\0') {

		if ((ch = getch()) == EOF)
			return (EOF);

		while (!isgraph(ch)) {
			if ((ch = getch()) == EOF)
				return (EOF);
		}

		if (open_bracket(ch)) {
			obracket = ch;


		} else {	/* something is wrong */
			fprintf(PRINT_TO, "bibcard: no open bracket for: %s\n", entry);
			return (EOF);
		}
	}
	cbracket = match_bracket(obracket);
	return (cbracket);
}




/*
 * search a PATH for a FILE which can be sent to fopen with MODE. PATH should
 * be a colon separated path variable in the style of unix shells, file
 * should be a file name (or path name segment) and MODE should be in the
 * style of fopen, except that "x" can also be included to see if a file can
 * be executed.  exec already handles path search, but this might well be
 * handy for dynamic loading or some such.
 * 
 * the full path name of the first file that satisfies the mode criterion is
 * returned in a newly cons'ed area that the caller must deallocate.
 */


static char    *
find_in_path(path, name, mode)
	char            path[], name[], mode[];
{
	char           *filename_loc;
	char           *p, *q;
	int             access_mode;

	access_mode = 0;
	p = mode;
	while ((*p) != '\0') {
		switch ((int) p) {
		case (int) 'r':
			access_mode |= R_OK;
			break;
		case (int) 'w':
		case (int) 'a':
		case (int) '+':
			access_mode |= W_OK;
			break;
		case (int) 'x':
			access_mode |= X_OK;
		}
		p++;		/* scan to next mode */
	}

	filename_loc = malloc(strlen(path) + strlen(path) + 2);

	p = path;
	while (p) {
		strcpy(filename_loc, p);
		q = strchr(filename_loc, ':');
		if (q == NULL) {
			q = filename_loc + strlen(filename_loc);
		}
		sprintf(q, "/%s", name);	/* double slash is ok on unix */
		if (access(filename_loc, access_mode) == 0) {
			return (filename_loc);
		}
		p = strchr(p, ':');
		if (p)
			p++;
	}

	free((char *) filename_loc);
	return (NULL);
}



static void
toLower(s)
	char           *s;
{
	char           *aux = s;

	while (*aux) {
		*aux = isupper(*aux) ? tolower(*aux) : *aux;
		*aux++;
	}
}



static void
toUpper(s)
	char           *s;
{
	char           *aux = s;

	while (*aux) {
		*aux = islower(*aux) ? toupper(*aux) : *aux;
		*aux++;
	}
}



static int
isNumber(s)
	char           *s;
{
	char           *aux = s;

	while (*aux) {
		if (isgraph(*aux))
			if (!isdigit(*aux))
				return (FALSE);
		*aux++;
	}
	return (TRUE);
}



extern void
new_bib()
{
	int             i, n;
	int             list_popup_show_flag;
	Ref             ref;


	xv_set(Bc_base_window->base_window, FRAME_BUSY, TRUE, NULL);

	/* clear list */
	if (last_item != NULL) {
		ref = last_item->prev;
		while (ref != NULL) {
			free(ref->next);
			ref->next = NULL;
			ref = ref->prev;
		}
	}
	if ((ref = (Ref) malloc(sizeof(Reference))) == NULL) {
		fprintf(PRINT_TO, "bibcard: no memory for load\n");
		exit(ERROR);
	}
	bzero((char *) ref, sizeof(Reference));

	first_item = current_item = last_item = ref;

	/* set default ns fields */
	i = (int) xv_get(Bc_properties_popup->properties_popup_textplane, TEXTSW_CONTENTS, NULL, value, BUFSIZ - 1);
	if (i == BUFSIZ -1) {
	  fprintf (PRINT_TO, "bibcard: default for non standard fields is too long. \n");
	} 
	if (i != 0) {
	  SET_STR (ref->nsfield, value);
	}

	/* set ref_type to default_ref_type */
	strcpy(ref->ref_type, ref_types_show_fct[default_ref_type].ref_type_token);
	ref->next = NULL;
	ref->prev = NULL;
	show_current_item();

	/* clear the abbrevation panel */
	textsw_delete(Bc_abbrev_popup->abbrev_popup_textplane, NULL, TEXTSW_INFINITY);

	/* clear cite list */
	n = (int) xv_get(Bc_list_popup->list_popup_list, PANEL_LIST_NROWS);

	list_popup_show_flag = (int) xv_get(Bc_list_popup->list_popup_list, XV_SHOW);
	xv_set(Bc_list_popup->list_popup_list, XV_SHOW, FALSE, NULL);

	if (n > 0)
		for (i = n - 1; i >= 0; i--)
			xv_set(Bc_list_popup->list_popup_list, PANEL_LIST_DELETE, i, NULL);

	xv_set(Bc_list_popup->list_popup_list, XV_SHOW, list_popup_show_flag, NULL);

	mod_flag = FALSE;
	get_path(pathname);
	sprintf(filename, "%s/%s", pathname, NEW_BIB_NAME);
	do_title();
	xv_set(Bc_base_window->base_window, FRAME_BUSY, FALSE, NULL);
}



extern int
openFile(filename_loc)
	char            filename_loc[BUFSIZ];
{
	char            value[BUFSIZ], message[BUFSIZ], sys_command[BUFSIZ], tmpfile[MAXPATHLEN];
	int             i, result;

	strcpy(value, filename_loc);

	if (access(value, F_OK) == 0) {
		sprintf(message, "file %s already exists\n", value);

		result = notice_prompt(Bc_base_window->base_window_controls, NULL,
				       NOTICE_MESSAGE_STRINGS,
				       message,
				       "OK to overwrite it?", NULL,
				       NOTICE_BUTTON_YES, "OK, Make Backup",
				       NOTICE_BUTTON, "OK, No Backup", 101,
				       NOTICE_BUTTON_NO, "Cancel",
				       NULL);
		if (result == NOTICE_NO)
			return (ERROR);
		else if (result == NOTICE_YES) {
			i = 1;
			sprintf(tmpfile, "%s.~%d~", value, i);
			while (access(tmpfile, F_OK) == 0) {
				i++;
				sprintf(tmpfile, "%s.~%d~", value, i);
			}
			sprintf(sys_command, "mv %s %s", value, tmpfile);
			system(sys_command);
		}
	}
	if ((infile = fopen(value, "w")) == NULL) {
		sprintf(message, "file %s  could not be opened\n", value);
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_MESSAGE_STRINGS,
			      message, NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      NULL);
		return (ERROR);
	}
	if (!selection_print_flag && !merge_flag && !paste_flag)
		strcpy(filename, value);
	return (OK);
}



extern void
print_item(ref)
	Ref             ref;
{
	int             j;
	char           *str;
	char           *tmp;
	int             file_offset_field = (int) xv_get(Bc_properties_popup->properties_popup_file_offset_field, PANEL_VALUE, NULL);
	int             file_offset_token = (int) xv_get(Bc_properties_popup->properties_popup_file_offset_token, PANEL_VALUE, NULL);

	fprintf(infile, "\n@%s{%s", ref->ref_type, ref->field[citekey_id]);
	for (j = 0; j < num_of_fields; j++)
		if (j != citekey_id) {

			if (ref->field[j]) {
				if (strlen(ref->field[j]) > 0) {
					str = (char *) strip_space(ref->field[j]);
					if (str[0] != ABBREVCODE) {
						if ((!open_bracket(ref->open_char[j])) || (ref->open_char[j] != '"')) {
							ref->open_char[j] = FIELDLEFT;
							ref->close_char[j] = FIELDRIGHT;
						}
						fprintf(infile, ",\n%*s%-*s = %c%s%c", file_offset_token, "", file_offset_field,
							text_fields[j][0], ref->open_char[j], ref->field[j], ref->close_char[j]);
					} else
						fprintf(infile, ",\n%*s%-*s = %s", file_offset_token, "", file_offset_field,
						text_fields[j][0], str + 1);
				}
			}
		}
	if (ref->annote) {
		if ((!open_bracket(ref->open_char[num_of_fields])) || (ref->open_char[num_of_fields] != '"')) {
			ref->open_char[j] = FIELDLEFT;
			ref->close_char[j] = FIELDRIGHT;
		}
		fprintf(infile, ",\n%*s%-*s = %c%s%c", file_offset_token, "", file_offset_field, ANNOTE_TOKEN
			,ref->open_char[num_of_fields], strip_space(ref->annote), ref->close_char[num_of_fields]);
	}
	if (ref->nsfield) {
		tmp = strdup(ref->nsfield);
		strtok(tmp, "\n");

#if defined STRIP_OTHER_FIELDS
		fprintf(infile, ",\n%*s%s", file_offset_token, "", strip_space(tmp));
		while ((str = (char *) strtok(0, "\n")) != 0)
			fprintf(infile, "\n%*s%s", file_offset_token, "", strip_space(str));
#else
		fprintf(infile, ",\n%*s%s", file_offset_token, "", tmp);
		while ((str = (char *) strtok(0, "\n")) != 0)
			fprintf(infile, "\n%*s%s", file_offset_token, "", str);
#endif
		free(tmp);

	}
	fprintf(infile, "\n}\n");
}



static void
writeAbbrev()
{
	char           *str, value[BUFSIZ];
	int             i, n, lastcr;

	i = (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_CONTENTS, NULL, value, BUFSIZ - 1);

	n = 0;
	while (i - n > 0) {
		if ((i - n) >= (BUFSIZ - 1)) {	/* position counter at last
						 * cr */
			value[BUFSIZ - 1] = '\0';
			lastcr = strlen(strrchr(value, '\n')) - 1;
			value[BUFSIZ - lastcr - 1] = '\0';
			i -= lastcr;
		}
		strtok(value, "\n");
		str = (char *) strip_space((char *) value);
		fprintf(infile, "\n@%s{%s}", STRING_TOKEN, strip_space(str));

		while ((str = (char *) strtok(0, "\n")))
			fprintf(infile, "\n@%s{%s}", STRING_TOKEN, strip_space(str));

		n = i;
		i = (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_CONTENTS, n, value, BUFSIZ - 1);
	}
	fprintf(infile, "\n");
}




extern void
print_selections()
{
	Ref             ref_list;
	SLIST           sel_list, prev, next;
	int             i;
	int             flag = NULL;

#define LIST_SEL        111
#define FIND_SEL        112
#define CANCEL_SEL      113

	if (selection_save_abbrev_flag == TRUE) {
		writeAbbrev();
	}
	if (xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == TRUE) {
		flag = LIST_SEL;
	} else if ((xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == FALSE) && (mod_for_find_flag == FALSE)) {
		flag = FIND_SEL;
	}
	if ((xv_get(Bc_list_popup->list_popup_list, XV_SHOW, NULL) == TRUE) && (mod_for_find_flag == FALSE)) {
		flag = notice_prompt(Bc_base_window->base_window_controls, NULL,
				     NOTICE_MESSAGE_STRINGS,
				     "Selections form list or find?", NULL,
				     NOTICE_BUTTON, "List", LIST_SEL,
				     NOTICE_BUTTON, "Find", FIND_SEL,
				     NOTICE_BUTTON, "Cancel", CANCEL_SEL,
				     NULL);
	}
	if (flag == LIST_SEL) {

		ref_list = first_item;
		sel_list = make_select_list();
		prev = sel_list;
		while (sel_list) {
			while (strcmp(sel_list->selection, ref_list->field[citekey_id]) != NULL) {
				ref_list = ref_list->next;
				if (ref_list == NULL)
					return;
			}
			print_item(ref_list);
			sel_list = sel_list->next;
		}

		next = prev->next;
		while (next) {
			free(prev);
			prev = next;
			next = prev->next;
		}
		free(prev);

	} else if (flag == FIND_SEL) {
		ref_list = first_item;
		for (i = 0; i < total; i++) {
			if (found_flag[i]) {
				print_item(ref_list);
			}
			ref_list = ref_list->next;
			if (ref_list == NULL)
				break;
		}
		if (i != total - 1) {
			notice_prompt(Bc_base_window->base_window_controls, NULL,
				      NOTICE_MESSAGE_STRINGS,
				      "Check the file!",
				      "Maybe there are wrong selections.",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      NULL);
		}
	} else if (flag == NULL) {
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_MESSAGE_STRINGS,
			      "Changed since last find!",
			      NULL,
			      NOTICE_BUTTON_YES, "Cancel",
			      NULL);
	}
}



extern int
writeFile(filename_loc)
	char            filename_loc[BUFSIZ];
{
	int             result;
	Ref             ref;
	char            tmp_name[BUFSIZ];


	strcpy(tmp_name, filename_loc);
#ifdef ADD_EXTENSION_IF_MISSING
	if (strcasecmp(tmp_name + (strlen(filename_loc) - 4), BIB_EXTENSION) == 0)
		sprintf(tmp_name, "%s", filename_loc);
	else
		sprintf(tmp_name, "%s%s", filename_loc, BIB_EXTENSION);
#endif
	if ((result = openFile(tmp_name)) == ERROR)
		return (ERROR);

	if (selection_print_flag) {
		print_selections();
		selection_print_flag = FALSE;

	} else {

		if (preamble)
			if (strlen(preamble) > 0)
				fprintf(infile, "\n@%s{%s}\n", PREAMBLE_TOKEN, preamble);

		writeAbbrev();

		ref = first_item;
		while (ref) {
			print_item(ref);
			ref = ref->next;
		}
		mod_flag = FALSE;
		do_title();
	}
	fclose(infile);
	return (OK);
}



static int
get_entry_type()
{
	int             ch, wcount = 0;

	obracket = '\0';

	if ((ch = getch()) == EOF)
		return (EOF);

	while (!isgraph(ch)) {
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	entry[wcount++] = ch;

	if ((ch = getch()) == EOF)
		return (EOF);

	while (isgraph(ch)) {
		if (open_bracket(ch)) {
			obracket = ch;
			break;
		}
		entry[wcount++] = ch;
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	entry[wcount++] = '\0';
	return (ch);
}




static int
get_key()
{
	int             ch, wcount = 0;

	if ((ch = getch()) == EOF)
		return (EOF);

	while (!isgraph(ch)) {
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	key[wcount++] = ch;

	if ((ch = getch()) == EOF)
		return (EOF);

	while (isgraph(ch)) {
		if (ch == ',') {
			break;
		}
		key[wcount++] = ch;
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	if (ch != ',')
		scan_to(',');

	key[wcount++] = '\0';
	return (KEY_OK);
}




static int
get_label()
{
	int             ch, wcount = 0;

	if ((ch = getch()) == EOF)
		return (EOF);

	while (!isgraph(ch)) {
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	if (ch == cbracket)
		return (ch);


	label[wcount++] = ch;
	if ((ch = getch()) == EOF) {
		return (EOF);
	}
	while (isgraph(ch)) {
		if (ch == '=')
			break;

		label[wcount++] = ch;
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	label[wcount++] = '\0';
	return ch;
}




static void
store_field(ref)
	Ref             ref;
{
	int             i;
	char            temp[BUFSIZ * 2];
	char           *temp_char;

	i = 1;
	while (i < num_of_fields + 1) {

		if (i == num_of_fields) {

			if (strcasecmp(label, ANNOTE_TOKEN) == NULL) {
				ADD_TO(ref->annote, value);
				ref->open_char[i] = value_obracket;
				ref->close_char[i] = value_cbracket;

			} else {
				if (strcmp(old_label, label) == NULL) {
					temp_char = (char *) strrchr(ref->nsfield, value_cbracket);
					if (temp_char != NULL) {
						sprintf(temp_char, "");
					}
					sprintf(temp, "%s%c", value, value_cbracket);
					ADD_TO(ref->nsfield, temp);
				} else {
					if (ref->nsfield) {
						ADD_TO(ref->nsfield, ",\n");
					}
					sprintf(temp, "%s = %c%s%c", label, value_obracket, value, value_cbracket);
					ADD_TO(ref->nsfield, temp);
				}

			}
		} else if (strcasecmp(label, text_fields[i][0]) == 0) {
			ADD_TO(ref->field[i], value);
			ref->open_char[i] = value_obracket;
			ref->close_char[i] = value_cbracket;
			break;
		}
		i++;
	}			/* end of while  */

	strcpy(old_label, label);
}




static int
get_value()
{
	int             ch, i, wcount = 0;
	int             lparn, rparn, abrev, quote, ccount, extension;
	char            temp[BUFSIZ], temp2[BUFSIZ];

	extension = FALSE;
	lparn = rparn = abrev = quote = 0;
	if ((ch = getch()) == EOF)
		return (EOF);

	while (!isgraph(ch)) {
		if ((ch = getch()) == EOF)
			return (EOF);
	}

	while (TRUE != FALSE) {	/* loop until the value terminator has been
				 * found and we have returned */

		if (open_bracket(ch)) {
			value_obracket = ch;
			value_cbracket = match_bracket(ch);
			lparn = 1;
			if ((ch = getch()) == EOF)
				return (EOF);

		} else if (ch == '"') {
			quote = 1;
			value_obracket = '"';
			value_cbracket = '"';
			if ((ch = getch()) == EOF)
				return (EOF);

		} else
			abrev = 1;

		while (TRUE != FALSE) {

			if ((quote == 0) && lparn) {
				if (ch == value_cbracket)
					rparn++;
				else if (ch == value_obracket)
					lparn++;
				if (lparn == rparn)
					break;

			} else if (quote) {
				if (ch == '{')
					lparn++;
				else if (ch == '}')
					rparn++;
				if (ch == '"') {
					if (lparn == rparn)
						break;
				}
			} else {
				if ((ch == ',') || (ch == cbracket))
					break;
			}

			if (iscntrl(ch))	/* all control characters are
						 * treated as a space-- is
						 * this ok? */
				if (strcasecmp(label, ANNOTE_TOKEN) != 0)
					ch = ' ';
			value[wcount++] = ch;

			if (wcount == BUFSIZ - 1) {
				value[wcount] = '\0';
				store_field(ref);
				wcount = 0;
			}
			if ((ch = getch()) == EOF)
				return (EOF);
		}

		value[wcount] = '\0';
		if ((abrev) && (!extension) && (!isNumber(value))) {
			sprintf(temp, "%c%s", ABBREVCODE, value);
			strcpy(value, temp);
			wcount++;
		}
		/* look for comma, concat char, or close bracket */
		ccount = 0;
		if (lparn) {	/* read the next character so the test for
				 * close bracket will not succeed */
			temp[ccount++] = ch;
			if ((ch = getch()) == EOF)
				return (EOF);
		}
		while ((ch != ',') && (ch != cbracket) && (ch != '#')) {
			temp[ccount++] = ch;
			if ((ch = getch()) == EOF)
				return (EOF);
		}

		if (ch == cbracket) {
			return (END_OF_ITEM);

		} else if (ch == ',') {
			return (FIELD_OK);

		} else if (ch == '#') {	/* it has to be this */
			extension = TRUE;
			if (quote)	/* add back the open bracket
					 * character */
				value_obracket = '"';
			sprintf(temp2, "%c%s", value_obracket, value);
			strcpy(value, temp2);
			wcount++;

			/* add the intervening stuff */
			temp[ccount++] = ch;
			for (i = 0; i < ccount; i++) {
				value[wcount++] = temp[i];
				if (wcount == BUFSIZ - 1) {
					value[wcount] = '\0';
					store_field(ref);
					wcount = 0;
				}
			}

			/*
			 * and don't return but get next value
			 */

			lparn = rparn = abrev = quote = 0;
			if ((ch = getch()) == EOF)
				return (EOF);
			while (!isgraph(ch)) {
				value[wcount++] = ch;
				if (wcount == BUFSIZ - 1) {
					value[wcount] = '\0';
					store_field(ref);
					wcount = 0;
				}
				if ((ch = getch()) == EOF)
					return (EOF);
			}
		}
	}
}




static int
get_field(ref)
	Ref             ref;
{
	int             result;

	if ((result = get_label()) == EOF)
		return (EOF);

	if (close_bracket(result))
		return (END_OF_ITEM);

	if (result != '=') {
		if ((result = scan_to('=')) == EOF)
			return (EOF);
	}
	if ((result = get_value()) == EOF)
		return (EOF);

	store_field(ref);
	return result;
}



static int
get_item()
{
	int             result, i, ref_type_flag;

	if ((result = get_key()) == EOF)
		return (EOF);

	if ((ref = (Ref) malloc(sizeof(Reference))) == NULL) {
		fprintf(PRINT_TO, "bibcard: no memory for load\n");
		exit(ERROR);
	}
	bzero((char *) ref, sizeof(Reference));

	load_flag = TRUE;

	strcpy(ref->ref_type, entry);

#ifdef UPPERCASE
	toUpper(ref->ref_type);
#else
	toLower(ref->ref_type);
#endif

	ref_type_flag = FALSE;
	for (i = 0; i < NUM_OF_REF_TYPES; i++) {
		if (strcasecmp(ref->ref_type, ref_types_show_fct[i].ref_type_token) == NULL)
			ref_type_flag = TRUE;
	}

	if (!ref_type_flag) {
		fprintf(PRINT_TO, "bibcard: no valid reference type for %s. (=> %s)\n", key, ref_types_show_fct[default_ref_type].ref_type_token);
#ifdef SHOW_ERROR_IN_LINE
		show_error_in_line();
#endif
		strcpy(ref->ref_type, ref_types_show_fct[default_ref_type].ref_type_token);
	}
	SET_STR(ref->field[citekey_id], key);

	if (duplicate_cite_key(key)) {
		fprintf(PRINT_TO, "bibcard: duplicate cite key: %s\n", key);
#ifdef SHOW_ERROR_IN_LINE
		show_error_in_line();
#endif

	}
	if (first_item == NULL) {
		first_item = ref;
		last_item = first_item;
		current_item = first_item;
		prev = ref;

	} else {
		ref->next = prev->next;
		ref->prev = prev;
		prev->next = ref;
		prev = ref;
	}

	result = get_field(ref);
	while (result == FIELD_OK) {
		result = get_field(ref);
	}

	return (result);
}




static void
add_to_string(temp)
	char           *temp;
{
	char           *str;

#if defined STRIP_ALL_SPACES && defined STRIP_WHILE_LOADING
	str = (char *) strip_space((char *) temp);
#endif

	if (edit_count > 0)
		textsw_insert(Bc_abbrev_popup->abbrev_popup_textplane, "\n", 1);

	textsw_insert(Bc_abbrev_popup->abbrev_popup_textplane, temp, strlen(temp));
	edit_count = (int) xv_get(Bc_abbrev_popup->abbrev_popup_textplane, TEXTSW_EDIT_COUNT);
}



static int
get_string()
{
	int             ch, wcount = 0;
	int             lparn, rparn;
	char            temp[BUFSIZ];

	if ((ch = getch()) == EOF)
		return (EOF);

	lparn = 1;
	rparn = 0;

	while (lparn != rparn) {
		temp[wcount++] = ch;
		if (wcount == BUFSIZ - 1) {
			temp[wcount] = '\0';
			add_to_string(temp);
			wcount = 0;
		}
		if (ch == cbracket)
			rparn++;

		else if (ch == obracket)
			lparn++;

		if ((ch = getch()) == EOF)
			return (EOF);
	}

	temp[wcount - 1] = '\0';
	add_to_string(temp);
	return (NULL);
}



static int
get_preamble()
{
	int             ch, wcount = 0;
	int             lparn, rparn;
	char            temp[BUFSIZ];

	if ((ch = getch()) == EOF)
		return (EOF);
	lparn = 1;
	rparn = 0;

	while (lparn != rparn) {
		temp[wcount++] = ch;
		if (wcount == BUFSIZ - 1) {
			temp[wcount] = '\0';
			ADD_TO(preamble, temp);
			wcount = 0;
		}
		if (ch == cbracket)
			rparn++;

		else if (ch == obracket)
			lparn++;

		if ((ch = getch()) == EOF)
			return (EOF);
	}

	temp[wcount - 1] = '\0';
	ADD_TO(preamble, temp);
	return (NULL);
}



static int
load_bib()
{
	int             ch, i, item_flag;

	count = 0;
	line_count = 0;
	load_flag = FALSE;

	while (TRUE != FALSE) {
		obracket = '\0';
		/* scans to next @ */
		if ((ch = scan_to('@')) == EOF) {
			return (NULL);
		}
		if ((ch = get_entry_type()) == EOF) {
#ifdef SHOW_ERROR_IN_LINE
			show_error_in_line();
#endif
			return (LD_ERROR);
		}
		if ((ch = set_brackets()) == EOF) {
#ifdef SHOW_ERROR_IN_LINE
			show_error_in_line();
#endif
			return (LD_ERROR);
		}
		/* we have a @entry */
		if (strcasecmp(entry, STRING_TOKEN) == 0) {
			if ((ch = get_string()) == EOF) {
#ifdef SHOW_ERROR_IN_LINE
				show_error_in_line();
#endif
				return (LD_ERROR);
			}
		} else if (strcasecmp(entry, PREAMBLE_TOKEN) == 0) {
			if ((ch = get_preamble()) == EOF) {
#ifdef SHOW_ERROR_IN_LINE
				show_error_in_line();
#endif
				return (LD_ERROR);
			}
		} else {

			/* assume it is a new item */
			if ((ch = get_item()) == EOF) {
				/*
				 * #ifdef SHOW_ERROR_IN_LINE
				 * show_error_in_line(); #endif
				 */
				return (LD_ERROR);
			}
#if defined STRIP_ALL_SPACES && defined STRIP_WHILE_LOADING
			else {
				for (i = 0; i < num_of_fields; i++) {
					if (ref->field[i]) {
						if (strlen(ref->field[i]) > 0) {
							strcpy(ref->field[i], (char *) strip_space((char *) ref->field[i]));
						}
					}
				}
				if (ref->annote) {
					if (strlen(ref->annote) > 0) {
						strcpy(ref->annote, (char *) strip_space((char *) ref->annote));
					}
				}
#if defined STRIP_OTHER_FIELDS
				if (ref->nsfield) {
					if (strlen(ref->nsfield) > 0) {
						strcpy(ref->nsfield, (char *) strip_space((char *) ref->nsfield));
					}
				}
#endif

			}
#endif

		}
	}
}



extern int
loadFile(filename_loc)
	char            filename_loc[BUFSIZ];
{
	char            temp[BUFSIZ];
	char            errmsg[BUFSIZ];
	int             i;
	char           *temp_name, *p;

	strcpy(temp, filename_loc);

	if (strchr(filename_loc, ':'))
		temp_name = find_in_path(pathname, temp + strlen(pathname) + 1, "r");
	else
		temp_name = strdup(temp);

	if ((temp_name == NULL) || (infile = fopen(temp_name, "r")) == NULL) {
		sprintf(errmsg, "file %s  could not be opened", temp);
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_MESSAGE_STRINGS,
			      errmsg, NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      NULL);
		return (ERROR);
	}
	if (!merge_flag) {
		strcpy(filename, temp_name);

		/* first clear the abbrevation panel */
		textsw_delete(Bc_abbrev_popup->abbrev_popup_textplane, NULL, TEXTSW_INFINITY);
		edit_count = 0;

		/* clear preamble */
		if (preamble) {
			free(preamble);
			preamble = NULL;
		}
		/* clear list */
		if (last_item != NULL) {
			ref = last_item->prev;
			while (ref != NULL) {
				for (i = 0; i < num_of_fields; i++)
					if (ref->field[i]) {
						free(ref->field[i]);
						ref->field[i] = NULL;
					}
				if (ref->nsfield) {
					free(ref->nsfield);
					ref->nsfield = NULL;
				}
				if (ref->annote) {
					free(ref->annote);
					ref->annote = NULL;
				}
				free(ref->next);
				ref->next = NULL;
				ref = ref->prev;
			}
		}
		first_item = NULL;


	} else {


		/* we are merging so load at last_item unless we are empty */
		if ((strlen((char *) xv_get(Bc_base_window->base_window_citekey, PANEL_VALUE)) > 0) || (last_item != first_item)) {

			/* put it after the current_one */
			if (paste_flag) {
				ref = current_item;
			} else {
				ref = last_item;
			}
			prev = ref;

		} else {
			first_item = NULL;
		}
	}

	load_bib();

	if (load_flag == FALSE) {
		sprintf(errmsg, "file %s contained no Bib entries", filename_loc);
		notice_prompt(Bc_base_window->base_window_controls, NULL,
			      NOTICE_MESSAGE_STRINGS,
			      errmsg, NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      NULL);
		if (!merge_flag) {
			new_bib();
		}
		return (ERROR);
	}
	if (paste_flag) {
		if (ref->prev == last_item) {
			last_item = ref;
			current_item = current_item->next;
		} else if (first_item == last_item) {
			current_item = ref;
		} else {
			current_item = current_item->next;
		}

	} else {
		last_item = ref;
		current_item = first_item;
	}

	fclose(infile);
	if (!merge_flag) {
		mod_flag = FALSE;
	}
	show_current_item();
	if (update_flag == UPDATE_ON) {
	  update_cite_list();
	  }
#ifdef UPDATE_LIST_WHILE_LOADING_IF_UPDATE_IS_OFF
	else {
	    update_cite_list();
	  }
#endif
	free(temp_name);
	do_title();
	return (OK);
}



extern int
confirm_overwrite()
{
	int             result;

	if (mod_flag) {
		result = notice_prompt(Bc_base_window->base_window_controls, NULL,
				       NOTICE_MESSAGE_STRINGS,
		  "You have unsaved changes. What do you want to do?", NULL,
				       NOTICE_BUTTON_YES, "Save changes",
				       NOTICE_BUTTON, "Discard changes", 111,
				       NOTICE_BUTTON, "Cancel", 112,
				       NULL);

		if (result == NOTICE_YES)
			if (strcmp(filename + strlen(pathname) + 1, NEW_BIB_NAME) == NULL) {
				/*
				 * save_as();
				 */
				merge_flag = FALSE;
				get_path(pathname);
				gfm_activate(Gfm_Replace, pathname, gfm_filter, NULL, load_file_chooser, NULL, GFM_LOAD);
				return (TRUE);
			} else if (writeFile(filename) == OK)
				return (TRUE);
			else
				return (FALSE);

		else if (result == 111)
			return (FALSE);
		else
			return (TRUE);
	} else
		return (FALSE);
}



extern int
load_file_chooser(ip, dir, file)
	gfm_popup_objects *ip;
	char           *dir;
	char           *file;
{
	char            loc_filename[BUFSIZ];

	sprintf(loc_filename, "%s/%s",
		(char *) dir, (char *) file);
	if (loadFile(loc_filename) == ERROR)
		return GFM_ERROR;
	else
		return GFM_OK;
}

extern int
save_as_file_chooser(ip, dir, file)
	gfm_popup_objects *ip;
	char           *dir;
	char           *file;
{
	char            loc_filename[BUFSIZ];

	if (update_item() == OK) {
		sprintf(loc_filename, "%s/%s",
			(char *) dir, (char *) file);
		if (writeFile(loc_filename) == ERROR)
			return GFM_ERROR;
		else
			return GFM_OK;
	}
}
