/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Modified: January 2002
 *
 */

#include  <gtk/gtk.h>


/* This file contains those procedures called to perform cleaning operations
 * during the operation of the XBibFile code */



/* This procedure is called to close the current window */

void close_window(GtkWidget *widget)
{
  GtkWidget  *parent;

  parent = gtk_widget_get_ancestor(widget, GTK_TYPE_WINDOW);
  gtk_widget_destroy(parent);
}


/* This procedure exits the program */

void byebye(GtkWidget *widget)
{
  gtk_main_quit();
}


/* This procedure is called to close the entry being made */

void go_ahead(GtkWidget *widget, GtkWidget  *window)
{
  extern  int format;

  close_window(window);
  close_window(widget);
  format = 0;
}

void cancel(GtkWidget *widget)
{
  close_window(widget);
}

/* A dialogue to confirm cancellation request */

int closure_check(GtkWidget *widget)
{
  GtkTooltips *tooltips;
  GtkWidget  *window;
  GtkWidget  *decoration;
  GtkWidget  *totalPane;
  GtkWidget  *field0;
  GtkWidget  *key0;
  GtkWidget  *key1;
  GtkWidget  *label;
  void  cancel();
  void  go_ahead();

                  /* create the tooltip help feature */

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile security");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  decoration = gtk_frame_new("Checking request");
  gtk_widget_set_usize(GTK_WIDGET(window), 232, 100);
  gtk_container_add(GTK_CONTAINER(window), decoration);
  totalPane = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(decoration), totalPane);
  label = gtk_label_new("Confirm CLOSE request");
  gtk_box_pack_start(GTK_BOX(totalPane), label, FALSE, FALSE, 10);

  field0 = gtk_hbox_new(FALSE, 5);
  key1 = gtk_button_new_with_label("Go Ahead");
  gtk_widget_set_usize(GTK_WIDGET(key1), 90, -1);
  g_signal_connect(GTK_OBJECT(key1), "clicked",
                   G_CALLBACK(go_ahead), widget);
  gtk_tooltips_set_tip(tooltips, key1,
                       "Perform the CLOSE request", NULL);
  gtk_box_pack_start(GTK_BOX(field0), key1, FALSE, FALSE, 10);
  key0 = gtk_button_new_with_label("Cancel");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                   G_CALLBACK(cancel), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                        "Abort/Don't Do this request", NULL);
  gtk_box_pack_start(GTK_BOX(field0), key0, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(totalPane), field0, FALSE, TRUE, 10);

  gtk_widget_show_all(window);
}
