/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     October 1999
 * Renamed and reworked:   January 2002
 *
 */

/* History
 *
 *  Version    Date
 *    0.1      October 1999     Initial release with Join and Lookup
 *                                outputing to the console terminal window.
 *    0.2      December 1999    In an attempt to solve the limited fields
 *                                for some data entry, the code for assigning
 *                                field-lengths was generalised.
 *    0.3      May 2000         Added the URL field to reference type fields
 *                                and error corrections
 *    0.4      July 2000        Added the note field and commented out the
 *                                actions of the Join and Lookup buttons
 *    0.5      December 2000    Replace gtk_widget_show() with
 *                                gtk_widget_show_all(), and add tooltips for
 *                                help
 *    0.6      January 2002     Major revision of software layout and computer
 *                                graphics/human interface
 *    0.7      November 2002    Upgrade the Gtk routines used internally in the
 *                                source code from version 1.2 to 2.0
 */

/* This file initiates XBibFile */

#include  <stdio.h>
#include  <gtk/gtk.h>

#include  "xbibfile.h"


/* These memory locations contain the input text fields and labels
 * used by all the windows that enter the various BibTeX reference
 * types. */

int   format;                  /* the BibTeX format being currently used */
FILE  *finput;
FILE  *refFile;
char  slateX[SMALL];             /* search key */
int   lengthX;
int   length[40];                /* length of strings entered via windows */
char  slate0[LARGE];             /* file currently being used for receiving */
char  slate1[LARGE];             /* address */
char  slate2[LARGE];             /* note */
char  slate3[LARGE];             /* author */
char  slate4[LARGE];             /* booktitle */
char  slate5[TINY];              /* chapter */
char  slate6[SMALL];             /* edition */
char  slate7[LARGE];             /* editor */
char  slate8[SMALL];             /* howpublished */
char  slate9[SMALL];             /* institution */
char  slate10[SMALL];            /* journal */
char  slate11[SMALL];            /* key */
char  slate12[TINY];             /* month */
char  slate13[HUGE];             /* annote */
char  slate14[SMALL];            /* number */
char  slate15[LARGE];            /* organization */
char  slate16[LARGE];            /* pages */
char  slate17[LARGE];            /* publisher */
char  slate18[LARGE];            /* school */
char  slate19[SMALL];            /* series */
char  slate20[LARGE];            /* title */
char  slate21[TINY];             /* type */
char  slate22[LARGE];            /* URL */
char  slate23[TINY];             /* volume */
char  slate24[TINY];             /* year */
char  slate30[LARGE];            /* Up Link */
char  slate31[LARGE];            /* Cross Link */
char  slate32[LARGE];            /* External Link */
char  slate40[LARGE];            /* name of file for cross-reference forming */
GtkWidget  *root;                /* the widget that is the root of the current
                                  * tree */


int main(int argc, char *argv[])
{
  GtkTooltips  *tooltips;
  GtkWidget    *top, *panel, *buttonBox, *buttonFrame;
  GtkWidget    *button1, *button2, *button3;
  GtkWidget    *description1, *description2, *separator;
  int  i;
  extern  byebye(GtkWidget);        /* in cleanup.c */
  extern  file_select(GtkWidget);   /* in file filing.c */
  extern  ref_select(GtkWidget *);  /* in file filing.c */


  format = 0;      /* indicate start condition */
  strcpy(slate0, "GO BACK and SELECT a FILE");
  strcpy(slate40, "GO BACK and SELECT a REF FILE");
  length[0] = strlen(slate0);
  length[40] = strlen(slate40);
  finput = 0;
  refFile = 0;

                   /* initialise the string storage areas */
  for (i=0; i<40; i++) {
    length[i] = 0;
  }
  lengthX = 0;
/*  slateX = 1; */

                   /* create the initial window panel for the program */
  gtk_init(&argc, &argv);

                   /* create the tooltip help feature */
  tooltips = gtk_tooltips_new();

  top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(top), "XBibFile 0.7");
  gtk_window_set_default_size(GTK_WINDOW(top), 150, 250);
  panel = gtk_vbox_new(FALSE, 10);
  gtk_container_add(GTK_CONTAINER(top), panel);
  gtk_container_set_border_width(GTK_CONTAINER(top), 10);
  description1 = gtk_label_new("Build and handle the \nBibTeX database");
  gtk_box_pack_start_defaults(GTK_BOX(panel), description1);
  description2 = gtk_label_new("\nVersion 0.7.1\n");
  gtk_box_pack_start_defaults(GTK_BOX(panel), description2);
  buttonBox = gtk_vbox_new(FALSE, 10);
  gtk_widget_set_usize(GTK_WIDGET(buttonBox), 140, 130);
  gtk_box_pack_start_defaults(GTK_BOX(panel), buttonBox);

  button1 = gtk_button_new_with_label("Create New");
  gtk_widget_set_usize(GTK_WIDGET(button1), 100, 30);
  g_signal_connect(GTK_OBJECT(button1), "button-press-event",
                   G_CALLBACK(file_select), NULL);
  gtk_tooltips_set_tip(tooltips, button1,
                      "Create a new BibTeX database entry", NULL);

  gtk_box_pack_start_defaults(GTK_BOX(buttonBox), button1);

  button2 = gtk_button_new_with_label("Find Reference");
  gtk_widget_set_usize(GTK_WIDGET(button2), 100, 30);
  g_signal_connect(GTK_OBJECT(button2), "button-press-event",
                   G_CALLBACK(ref_select), NULL);
  gtk_tooltips_set_tip(tooltips, button2,
                      "Search database for an existing reference", NULL);
  gtk_box_pack_start_defaults(GTK_BOX(buttonBox), button2);

  separator = gtk_hseparator_new();
  gtk_box_pack_start_defaults(GTK_BOX(buttonBox), separator);

  button3 = gtk_button_new_with_label("exit");
  gtk_widget_set_usize(GTK_WIDGET(button3), 100, 30);
  g_signal_connect(GTK_OBJECT(button3), "button-press-event",
                   G_CALLBACK(byebye), NULL);
  gtk_tooltips_set_tip(tooltips, button3,
                       "Exit this program", NULL);
  gtk_box_pack_start_defaults(GTK_BOX(buttonBox), button3);

                   /* make this composite window visible on the screen */
             
  gtk_widget_show_all(top);

                   /* process all signals associated with this application */
  gtk_main();

                   /* The End */
  return(0);
}
