/*
** Datei: DVIHPLJ.C
** Autor: Ingo Eichenseher
**        Gerhard Wilhelms, 27.8.92
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dvihdcp.h"
#include "dviframe.h"

static void prstr(char *format, ...)
{
    char line[256], *p;
    va_list l;
    va_start(l,format);
    vsprintf(line,format,l);
    va_end(l);
    for (p=line; *p; p++) prbyte(*p);
}

static int vpos;

static void skpl_hplj(int skip)
{
    vpos += skip;
    prstr("\033*p%dY",vpos);
}

static void skpl_hpljlow(int skip)
{
    vpos += 3 * skip;
    prstr("\033*p%dY",vpos);
}

static int send_hplj(long addr, int words, int frame_width, int pos)
{
    int i, j, l, gleich, ungleich;
    register unsigned char huge *a = frame_ptr(addr);

    words += words;
    prstr("\033&f0S\033*p%dX",pos);
    prstr("\033*r1A"); /* Grafikdruck Anfang */
    for (l=0; l<24; l++)
    {
/*
        for( i = 0; i < words; i += gleich + ungleich )
        {
          gleich = ungleich = 0;
          for( j = i; j < words - 1; j++ )
          {
            if( a[j] == a[j+1] )
            {
              if( !ungleich && gleich < 255 )
                gleich++;
              else
                break;
            }
            else
            {
              if( !gleich )
                ungleich++;
              else
                break;
            }
          }
          if( gleich )
          {
            prstr( "\033*b1m2W" );
            prbyte( (unsigned char)( gleich++ ) );
            prbyte( a[i] );
          }
          else if( ungleich )
          {
            prstr( "\033*b0m%dW", ungleich );
            for( j = 0; j < ungleich; j++ )
              prbyte( a[i+j] );
          }
          else
          {
            printf( "error!\n" ); return 0;
          }
        }
        a += frame_width;
*/
        prstr("\033*b%dW",words);
        for(i=0; i<words; i++)
          prbyte(*a++);
        a += frame_width - words;
    }
    prstr("\033*rbC\033&f1S");
    return 0;
}

static int send_hpljlow(long addr, int words, int frame_width, int pos)
{
    int i,l;
    register unsigned char huge *a = frame_ptr(addr);

    words += words;
    prstr("\033&f0S\033*p%dX",3*pos);
    prstr("\033*r1A");
    for (l=0; l<24; l++)
    {
        prstr("\033*b%dW",words);
        for(i=0; i<words; i++)
          prbyte(*a++);
        a += frame_width - words;
    }
    prstr("\033*rbC\033&f1S");
    return 0;
}

static void init_hplj(void)
{
    vpos = 0;
    prstr("\033E\033*t300R\033&l0O");
}

static void init_hpljlow(void)
{
    vpos = 0;
    prstr("\033E\033*t100R\033&l0O");
}

static void exit_hplj(void)
{
    prstr("\014");
}

int hplj(void)
{
    return print_page(24,skpl_hplj,send_hplj,init_hplj,exit_hplj);
}

int hpljlow(void)
{
    return print_page(24,skpl_hpljlow,send_hpljlow,init_hpljlow,exit_hplj);
}
