		.MODEL large
		PUBLIC	_hgc_graphics

; Set graphics mode for hercules card. From the book
; Programmer's Guide to PC&PS/2 Video Systems by Richard Wilton

; changes by Gerhard Wilhelms:
;     converted to Turbo Assembler
;     converted for huge model caller
;     removed errors
;     automatic screen clear

		.DATA

; These are the parameters recommended by Hercules.
; They are based on 16 pixels/character and
; 4 scan lines per character.

CRTCParms	DB	00h,35h	; Horizontal Total:  54 characters
		DB	01h,2Dh	; Horizontal Displayed:  45 characters
		DB	02h,2Eh	; Horizontal Sync Position:  at 46th character
		DB	03h,07h	; Horizontal Sync Width:  7 character clocks

		DB	04h,5Bh	; Vertical Total:  92 characters (368 lines)
		DB	05h,02h	; Vertical Adjust:  2 scan lines
		DB	06h,57h	; Vertical Displayed:  87 character rows (348 lines)
		DB	07h,57h	; Vertical Sync Position:  after 87th char row

		DB	09h,03h	; Max Scan Line:  4 scan lines per char

CRTCParmsLen	EQU	9

BIOSData	DB	7	; CRT_MODE
		DW	80	; CRT_COLS
		DW	8000h	; CRT_LEN
		DW	0	; CRT_START
		DW	8 dup(0) ; CURSOR_POSN
		DW	0	; CURSOR_MODE
		DB	0	; ACTIVE_PAGE
CRTCAddr	DW	3B4h	; ADDR_6845
CRTMode		DB	0Ah	; CRT_MODE_SET (value for port 3B8h)
		DB	0	; CRT_PALETTE (unused)

BIOSDataLen	EQU	26

		.CODE
_hgc_graphics	PROC	FAR

		push	bp		; preserve caller registers
		mov	bp,sp
		push	si
		push	di
		push	ds
		push	es
		push	bx

; Update Video BIOS Data Area with reasonable values

		mov	ax,40h
		mov	es,ax
		mov	di,49h		; ES:DI := 0040:0049 (BIOS data area)

		mov	bx,SEG BIOSData
		mov	ds,bx
		mov	si,OFFSET BIOSData
		mov	cx,BIOSDataLen
		rep	movsb		; update BIOS data area

; Set Configuration Switch

		mov	dx,3BFh		; DX := Configuration Switch port
		mov	al,1		; AL bit 1 := 0 (exclude 2nd 32K of
					;		  video buffer)
					; AL bit 0 := 1 (allow graphics mode
		out	dx,al		;		 setting via 3B8h)

; Blank the screen to avoid interference during CRTC programming

		mov	dx,3B8h		; DX := CRTC Mode Control Register port
		xor	al,al		; AL bit 3 := 0 (disable video signal)
		out	dx,al		; blank the screen

; Program the CRTC

		sub	dl,4		; DX := CRTC Address Reg port 3B4h

		mov	bx,SEG CRTCParms
		mov	ds,bx
		mov	si,OFFSET CRTCParms
		mov	cx,CRTCParmsLen

L01:		lodsw			; AL := CRTC register number
					; AH := data for this register
		out	dx,ax
		loop	L01

; Set graphics mode

		add	dl,4		; DX := 3B8h (CRTC Mode Control Reg)
		mov	al,CRTMode	; AL bit 1 = 1 (enable graphics mode)
					;    bit 3 = 1 (enable video)
		out	dx,al

; Clear screen

		mov     bx,0B000h	; establish video addressing
		mov	es,bx
		xor	di,di
		xor	ax,ax		; fill pattern, blank
fill_loop:	mov	cx,1000h	; CX:=#words in each screen part
		rep	stosw		; fill buffer, increment DI by 2000h
		or	di,di
		jns	fill_loop	; jump, if DI<8000h

		pop	bx
		pop	es
		pop	ds
		pop	di		; restore registers and exit
		pop	si
		mov	sp,bp
		pop	bp
		ret

_hgc_graphics	ENDP


		END
