/**************************************************************************************************
 *            Modul:   dvimotif.c                                                                 *
 *            Autoren: Ingo Eichenseher, Gerhard Wilhelms 8/1992                                  * 
 *                     Ulrich Lechner 9/1994                                                      *
 **************************************************************************************************
*/
#include <stdio.h>
#include <stdarg.h>
#include <setjmp.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <sys/stat.h>
#include <time.h>
#include <X11/Xutil.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
                              
#include <Xm/CascadeB.h>               /* Motif Include Files (Widgets) */
#include <Xm/DrawingA.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Scale.h>
#include <Xm/LabelG.h>

#include "dvi.h"                       /* Dvi-Treiber Include Files                */                             
#include "dvidvi.h"
#include "dviframe.h"
#include "dvihdcp.h"
#include "dvimisc.h"
#include "dvisplin.h"
#include "dvidraw.h"
#include "dvishrink.h"

#define APPL_CLASS "Ndvi"              /* Name der Application-Klasse              */
#define X_MAGIC 0x21021961
#undef FRAME
#define DEFAULT_WIDTH   800
#define DEFAULT_HEIGHT  768
                                        /* XImage Typen                              */
#define IMG_MSB_4 0                     /* MSBFirst-bit-order und 4 Bits-per-Pixel     */
#define IMG_MSB_8 1                     /* MSBFirst-bit-order und 8 Bits-per-Pixel       */
#define IMG_OTHER 2                     /* Anderer Typ                                     */
#define IMG_16BPP 4                     /* 16 Bits pro Pixel                   */
#define IMG_24BPP 8                     /* 16 Bits pro Pixel                   */
#define IMG_32BPP 16                     /* 16 Bits pro Pixel                   */
#undef  HARDCODED                       /* Voreinstellungen ueber Application-Defaults-Datei */             

typedef struct
{
    char   *mask;
    void    (*callback) (char *name);
}       fileSel_t;
typedef struct
{
    void    (*callback) (char *string);
    char   *str_to_change;
    long   *long_to_change;
    real   *dimen_to_change;
    int     clean;
}       dialog_t;
typedef struct
{
    int     (*function) (void);
}       driver_t;


int     theScreen;                      /* Screen id                               */
static  Screen *defaultScreen;          /* Screen Zeiger                           */
GC      theGC;                          /* Graphic Context                         */
Display *theDisplay;                    /* Display                                 */
int     shape = XC_watch;               /* Cursor                                  */
Cursor  cursor;
XImage  *theImage;                      /* XImage = Zielbild                       */
static  byte *imagedata = NULL;         /* XImage Daten                            */
static  int img_bpl;                    /* XImage Bytes Per Line                   */
static  size_t  bytes;                  /* XImage Groesse in Bytes                 */
static  int imagetype = IMG_MSB_4;      /* XImage Typ                              */         
struct  SrcBmp srcbmp;                  /* Quell-Bitmap                            */
XColor  col[MAXCOLORS];                 /* Farben                                  */
Pixmap  px_center, px_right, px_left,   
        px_update, px_f_on, px_f_off;   /* Piktogramme  der Buttons                */
int     eff_width, eff_height;          /* Breite,Hoehe von XImage in Pixel */ 
UTYPE   u_shrinkfactor = SRC, 
        o_shrinkfactor = 0;             /* Shrinkfaktor, alter Shrinkfaktor        */  
static  unsigned long num_colors;       /* Zahl der Farben                         */                                             
Widget  graphicW, mainW;                /* Widgets                                 */
static  Widget textW, fileSelW, nameW, dispShell, PopupMenuW, sW, tst;
static  Widget traceMemW, traceFontsW, dviMemW, traceCharsW, showIMGW, landscapeW;
static  Widget sh_NULLW, sh_p6lowW, sh_p6highW, sh_p6midW, sh_fx80W; 
static  Widget sh_shipfileW, sh_hpljW, sh_hpljlowW, sh_bj300W, sh_null_deviceW;
static  Widget s_bar_ver, s_bar_hor, fw, textw, fw2, frb,scale, expandW,shrinkW; 

static  int last_page = 0;              /* Seitenzaehler     */
static  int o_page    = 0;      
int     PageIsOpen    = 0;              /* Flags             */
static  int nodestroy = 0;                       
static  int update    = 0;
static  int doexpose  = 0;
static  int drawframe = TRUE;           /* Rahmen            */
static  int Quickexpand = 0;            /* Vergroesserung.: Scanline(1), Convolution(0)*/
static  int Quickshrink = 0;            /* Verkleinerung: Scanline(1), Convolution(0)  */
static  struct stat oldstatus;          /* Dvi-Datei Status  */      
static  char *thePath;                  /* Pfad              */
char    printer_filename[512];           
static  XmString str;
static  XmString theString;
static  int pmon=0, Press_x, Press_y, Ipress_x, Ipress_y;
int     dst_width, dst_height; 
static  void (*currentFileSelCB) (char *name) = NULL;
static  jmp_buf halt_jmp;
char    opt_name[MAX_PATH_LEN] = "dvi.dvo";




/*
	Truecolor Support
*/
int	colortype; // 1 = Truecolor, sonst Palette
int	num_r , num_g , num_b;
int 	shift_r , shift_g , shift_b;

extern void    Out16bpp(XImage *, XColor * ,short, short);
extern void    Out24bpp(XImage *, XColor * ,short, short);
extern void    Out32bpp(XImage *, XColor * ,short, short);


/************************************************************************************************* 
 * Initialisierung und Freigabe der Filter 
 */
extern int  init_filter(unsigned long);
extern void kill_filter(void);

/*
 * Skalierungs-Prozeduren Scanline-Konvertierungsmethode: 
 * img4expand(): 4 bits_per_pixel XImage (IMG_MSB_4) 
 * fastexpand(): Vergroesserung aller Typen (IMG_MSB_4, IMG_MSB_8, IMG_OTHER) 
 * fastshrink(): Verkleinerung  aller Typen (IMG_MSB_4, IMG_MSB_8, IMG_OTHER)
 * Skalierungs-Prozedur Convolutions-Methode: 
 * do_shrink() Je nach Ausgabe-Prozedur fuer bestimmten XImage-Typ  
 * Parameter:  Quelle, Ziel, Ausgabe-Prozedur, Skalierungswert dst (Skalierungsfaktor dst/SRC),
 *             Bei do_shrink() zusaetzlich: Zeiger auf Farbvektor, Zahl der Farben
 */
extern void    fastshrink(struct SrcBmp,XImage *, void (*outfkt) (XImage *, short, short),UTYPE);
extern void    fastexpand(struct SrcBmp,XImage *, void (*outfkt) (XImage *, short, short),UTYPE);
extern void    do_shrink(struct SrcBmp,XImage *,void (*outfkt) (XImage *, XColor *, short, short),
                         UTYPE, XColor *, unsigned long);
/* Parameter:  Quelle, Ziel, Pixel-Wert von Schwarz, Skalierungswert dst */
extern void    img4expand(struct SrcBmp,XImage *, unsigned long ,UTYPE);

/* 
 * Ausgabe-Prozeduren fuer Convolution
 * Parameter:  Ziel, Zeiger auf Farbvektor, Zeile und Spalte 
 *                                          ab der dst x dst Punkte gesetzt werden sollen.
 */
extern void    OutGerade(XImage *, XColor *,  short, short);
extern void    OutUngerade(XImage *, XColor * , short, short);
extern void    OutXput(XImage *, XColor * ,short, short);
extern void    Out8bpp(XImage *, XColor * ,short, short);


/*
 * Prototypen 
 */ 
void    initWidgetTree();                     /* Ersten Widget-Baum initialisieren */
void    shipoutCB();
void    x2pix(void);
void    clr_Img_Pix(void);
void    clr_other(void);
void    whitepoint(XImage *, short, short);
void    blackpoint(XImage *, short, short);
void    initColors(Widget);                   /* Farben alloziieren                 */
void    exitColors(Widget widget);
void    shrink(void);                         /* Skalierung starten                 */
int     initImage(void);                      /* XImage erzeugen         */
static  void print_pages(int first, int last, int step);
static  void redraw(void);
static  void initDviOutWindow(void);          /* Zweiten Widget-Baum initialisieren */            
static  void set_sizes(void);
static  void initScale(Widget);               /* Skalierungsbereich initialisieren  */
static  void initGraphic(Widget);             /* Ausgabebereich initialisieren      */
static  void initFunctions(Widget);           /* Funktionsbereich initialisieren    */
static  void initPopupMenu();                 /* Popup-Menue initialisieren         */
static  void setslider(Widget);
static  void cursorbusy(void);
static  void exitImage(void);
static  void exitDviOutWindow(void);
void    cursornormal(void);
float   get_dimen(char *string, float old_value);
Widget  initForm(Widget);                     /* Informationsausgaberegion ereugen  */
Widget  initDispForm(Widget);
Widget  initMenu(Widget);                     /* Menue initialisieren               */
Widget  initFileSelector(Widget);
Widget  initTitle(Widget menuBarW, char *name);
Widget  initItem(Widget title, char *name, XtCallbackProc cb, XtPointer p);
Widget  initToggleItem(Widget title, int one_of_many, char *name, XtCallbackProc cb, XtPointer p);

/*
 * Callbacks und Eventhandler 
 */
static void exitCB(Widget, XtPointer, XtPointer);
static void destroyCB(Widget, XtPointer, XtPointer);
static void moveImageCB(Widget, XtPointer, XEvent *, Boolean *);
static void updateCB(Widget, int, XtPointer);
static void reloadCB(Widget, XtPointer, XtPointer);
static void exposeCB(Widget, XtPointer, XmDrawingAreaCallbackStruct *);
static void scaleCB(Widget, int, XmScaleCallbackStruct *);
static void centerCB(Widget, XtPointer, XmPushButtonCallbackStruct *);
static void magnifyCB(Widget widget, XtPointer clientDaten, XmPushButtonCallbackStruct * cbs);
static void frameCB(Widget, XtPointer, XmPushButtonCallbackStruct *);
static void goPageCB(Widget, int, XmAnyCallbackStruct *);
static void pPageCB(Widget, int, XmPushButtonCallbackStruct *);
static void nPageCB(Widget, int, XmPushButtonCallbackStruct *);
static void pageCB(char *);
static void newCB(Widget, XtPointer, XtPointer);
static void new_dvi_file(char *name);
static void read_opt_file(char *name);
static void write_opt_file(char *name);
static void new_log_file(char *name);
static void formatCB(char *string);
void   toggle_traceFonts(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_traceMemory(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_dviMemory(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_traceChars(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_showIMG(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_landscape(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_expand(Widget w, XtPointer clientData, XtPointer callData);
void   toggle_shrink(Widget w, XtPointer clientData, XtPointer callData);
void   doFileSelectorCB(Widget widget, XtPointer clientData, XtPointer callData);
void   doDialogCB(Widget widget, XtPointer clientData, XtPointer callData);
void   fileSelectedCB(Widget w, XtPointer clientData, XtPointer callData);
void   unmanageCB(Widget w, XtPointer clientData, XtPointer callData);
void   inputCB(Widget w, XtPointer clientData, XtPointer callData);
/*
 * Geraete
 */
static driver_t null_d = {NULL};
static driver_t p6low_d = {p6low};
static driver_t p6mid_d = {p6mid};
static driver_t p6high_d = {p6high};
static driver_t fx80_d = {fx80};
static driver_t shipfile_d = {shipfile};
static driver_t hplj_d = {hplj};
static driver_t hpljlow_d = {hpljlow};
static driver_t bj300_d = {bj300};
static driver_t null_device_d = {null_device};
/*
 * Dialoge zur Einstellung von Optionen usw.
 */
static dialog_t printer_dialog = {NULL, printer_filename, NULL, NULL, 0};       
static dialog_t page_dialog = {pageCB, NULL, NULL, NULL, 0};
static dialog_t maximum_dialog = {NULL, NULL, &op.maxmem, NULL, 1};
static dialog_t clippath_dialog = {NULL, NULL, &op.pathmem, NULL, 1};
static dialog_t pkpath_dialog = {NULL, op.pk_path, NULL, NULL, 1};
static dialog_t tfmpath_dialog = {NULL, op.tfm_path, NULL, NULL, 1};
static dialog_t vfpath_dialog = {NULL, op.vf_path, NULL, NULL, 1};
static dialog_t dvipath_dialog = {NULL, op.dvi_path, NULL, NULL, 1};
static dialog_t imgpath_dialog = {NULL, op.img_path, NULL, NULL, 0};
static dialog_t grpath_dialog = {NULL, op.input_path, NULL, NULL, 0};
static dialog_t mag_dialog = {NULL, NULL, &op.new_mag, NULL, 1};
static dialog_t hres_dialog = {NULL, NULL, &op.hres, NULL, 1};
static dialog_t vres_dialog = {NULL, NULL, &op.vres, NULL, 1};
static dialog_t callmf_dialog = {NULL, op.pk_callmf, NULL, NULL, 1};
static dialog_t hoff_dialog = {NULL, NULL, NULL, &op.hoffset, 1};
static dialog_t voff_dialog = {NULL, NULL, NULL, &op.voffset, 1};
static dialog_t hspread_dialog = {NULL, NULL, NULL, &op.hspread, 1};
static dialog_t vspread_dialog = {NULL, NULL, NULL, &op.vspread, 1};
static dialog_t format_dialog = {formatCB, NULL, NULL, NULL, 0};
/*
 * Dateiauswahl-Dialoge z.B. zum Laden einer neuen Dvi-Datei
 */
static fileSel_t fileSelDvi = {"*.dvi", new_dvi_file};
static fileSel_t fileSelRopt = {"*.dvo", read_opt_file};
static fileSel_t fileSelWopt = {"*.dvo", write_opt_file};
static fileSel_t fileSelLog = {"*.log", new_log_file};

/**************************************************************************************************
 *                                                                                                *
 * Erster Widget-Baum *** Autoren: Ingo Eichenseher, Gerhard Wilhelms 8/1992                      *
 *                                 Ulrich Lechner 9/1994                                          *
 *                                                                                                * 
 **************************************************************************************************
*/
/*
 * Initialisierungsphase
 * Xt-Intrinsics, Application-Kontext, Verbindung zum X-Server, 
 * Application-Shell, Main-Event-Loop
 */
int     main(int argc, char **argv)
{
    XtAppContext kontext;
    Widget  applShell;
    Cardinal argcTmp;
    String *argvTmp;
    int     i;
    Arg     args[10];
    char    ver[64];
    Cardinal n;

    
    thePath = getenv("PATH");
    sprintf(ver, "Dvi (Version %s)", version_string);

    gr_install();

    XtToolkitInitialize();                       /* Xt-Intrinsics initialisieren */
    kontext = XtCreateApplicationContext();      /* Application-Kontext erzeugen */
    argcTmp = argc;
    argvTmp = (String *) XtMalloc((Cardinal)(argc * sizeof(String)));
    for (i = 0; i < argc; i++)
        argvTmp[i] = XtNewString(argv[i]);

    /* Verbindung zum X-Server aufbauen, Ressourcen-Datenbasis wird erstellt
     */
    theDisplay = XtOpenDisplay(kontext, (String) NULL, argv[0],
            APPL_CLASS, (XrmOptionDescRec *) NULL, (Cardinal) 0, (&argc), argv);

    defaultScreen = DefaultScreenOfDisplay(theDisplay);

    if (theDisplay == NULL)
    {
        fprintf(stderr, "Cannot open display\n");
        exit(1);
    }

    /* Wurzel des Haupt-Widget-Baumes erzeugen: ApplicationShellWidget
     */
    n = 0;
    XtSetArg(args[n], XmNargc, argcTmp); n++;
    XtSetArg(args[n], XmNargv, argvTmp); n++;
    XtSetArg(args[n], XmNiconName, APPL_CLASS); n++;
    XtSetArg(args[n], XmNtitle, ver); n++;
    XtSetArg(args[n], XmNscreen, defaultScreen); n++;
    applShell = XtAppCreateShell(argv[0], APPL_CLASS,        
            applicationShellWidgetClass, theDisplay, args, n);

    theScreen = DefaultScreen(theDisplay);

    initWidgetTree(applShell);                   /* Ersten Widget-Baum erzeugen             */

    theGC = DefaultGCOfScreen(defaultScreen);    /* Graphic Context holen                   */

    XtRealizeWidget(applShell);                  /* Realisieren der ApplicationShellWidgets 
                                                  * Die Widgets des ersten Widget-Baumes
                                                  * werden sichtbar 
                                                  */
    argc--;
    argv++;
    while (argc > 0 && **argv == '-')
    {
        switch (tolower(argv[0][1]))
        {
            case 'o':
                strcpy( opt_name, argv[0] + 2 );
                break;
        }
        argc--;
        argv++;
    }
    if (argc > 0)
    {
        strcpy(dvi_name, *argv);
        argc--;
        argv++;
    }

    read_opt_file(opt_name);

    if (setjmp(halt_jmp) == 0)
        if (*dvi_name && shipout == NULL)
            print_pages(1, 1, 1);

    XtAppMainLoop(kontext);                      /* Eintritt in die Hauptereignisschleife   */
}

/*
 * Erzeugen des ersten Widget-Baumes
 */
void    initWidgetTree(Widget applShell)
{
    Widget  formW, menuW;             
    
    /* Container erzeugen: "mainwindow"  */ 
    mainW = XtCreateManagedWidget("mainwindow",xmMainWindowWidgetClass,applShell,(Arg *) NULL,0);
                              
    formW = initForm(mainW);                     /* Formular zur Informationsausgabe          */
    menuW = initMenu(mainW);                     /* Menue erzeugen                            */

    /* Formular und Menue an Container heften */
    XmMainWindowSetAreas(mainW, menuW, (Widget) NULL, (Widget) NULL, (Widget) NULL, formW);
}

/*
 * Erzeugen eines Formulars zur Informationsausgabe: "textwindow"
 * Der Text kann mit Scrollbars verschoben werden
 */
Widget  initForm(Widget parent)
{
    Arg     args[10];
    static char ver[64];
    Cardinal n;
    
    /* ScrolledText-Region erzeugen, nicht editierbar ! */
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNeditable, False); n++;
    XtSetArg(args[n], XmNautoShowCursorPosition, True); n++;
    XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
    textW = XmCreateScrolledText(parent, "textwindow", args, n);
    XtManageChild(textW);
    return XtParent(textW);
}

/*
 * Alle Menues werden erzeugt: Menueleiste "menubar", diversen Pulldown-Menues 
 * (Dateiauswahl), Option-Menues und zugehoerige Menuepunkten
 */  
Widget  initMenu(Widget parent)
{
    Widget  menuBarW, fileW, printW, setupW, margW, optionW, devW;
    Arg     args[10];
    Cardinal n;
    n = 0;
    menuBarW = XmCreateMenuBar(parent, "menubar", args, n);    /* Menueleiste   */
    XtManageChild(menuBarW);
    
    fileW = initTitle(menuBarW, "File");                       /* File-Menue    */
    printW = initTitle(menuBarW, "Print");                     /* Print-Menue   */
    setupW = initTitle(menuBarW, "Setup");                     /* Setup-Menue   */  
    margW = initTitle(menuBarW, "Margins");                    /* Margins-Menue */  
    optionW = initTitle(menuBarW, "Options");                  /* Options-Menue */
    devW = initTitle(menuBarW, "Devices");                     /* Devices-Menue */

    n = 0;
    XtSetArg(args[n], XmNradioBehavior, True);  n++;
    XtSetValues(devW, args, n);
    
    /* Erzeugen der Menuepunkte der verschiedenen Menues */     
 
    /* File-Menue 
     */
    initItem(fileW, "Select File", (XtCallbackProc) doFileSelectorCB, (XtPointer) & fileSelDvi);
    initItem(fileW, "Reload File", (XtCallbackProc) reloadCB, (XtPointer) NULL);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, fileW, NULL, 0);
    initItem(fileW, "Load Options", (XtCallbackProc) doFileSelectorCB, (XtPointer) & fileSelRopt);
    initItem(fileW, "Save Options", (XtCallbackProc) doFileSelectorCB, (XtPointer) & fileSelWopt);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, fileW, NULL, 0);
    initItem(fileW, "Log File", (XtCallbackProc) doFileSelectorCB, (XtPointer) & fileSelLog);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, fileW, NULL, 0);
    initItem(fileW, "Quit", (XtCallbackProc) exitCB, (XtPointer) NULL);
    
    /* Print-Menue   
     */
    initItem(printW, "Format Pages", (XtCallbackProc) doDialogCB, (XtPointer) & format_dialog);
    initItem(printW, "Magnification", (XtCallbackProc) doDialogCB, (XtPointer) & mag_dialog);

    /* Setup-Menue   
     */
    initItem(setupW, "Clippath Memory", (XtCallbackProc) doDialogCB, (XtPointer) & clippath_dialog);
    initItem(setupW, "Maximum  Memory", (XtCallbackProc) doDialogCB, (XtPointer) & maximum_dialog);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, setupW, NULL, 0);
    initItem(setupW, "PK  Font Path", (XtCallbackProc) doDialogCB, (XtPointer) & pkpath_dialog);
    initItem(setupW, "VF  Font Path", (XtCallbackProc) doDialogCB, (XtPointer) & vfpath_dialog);
    initItem(setupW, "TFM Font Path", (XtCallbackProc) doDialogCB, (XtPointer) & tfmpath_dialog);
    initItem(setupW, "IMG Image Path", (XtCallbackProc) doDialogCB, (XtPointer) & imgpath_dialog);
    initItem(setupW, "GR  Input Path", (XtCallbackProc) doDialogCB, (XtPointer) & grpath_dialog);
    initItem(setupW, "DVI Input Path", (XtCallbackProc) doDialogCB, (XtPointer) & dvipath_dialog);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, setupW, NULL, 0);               
    initItem(setupW, "Printer", (XtCallbackProc) doDialogCB, (XtPointer) & printer_dialog);     
   
    /* Margins-Menue
     */
    initItem(margW, "H-Offset", (XtCallbackProc) doDialogCB, (XtPointer) & hoff_dialog);
    initItem(margW, "V-Offset", (XtCallbackProc) doDialogCB, (XtPointer) & voff_dialog);
    initItem(margW, "H-Spread", (XtCallbackProc) doDialogCB, (XtPointer) & hspread_dialog);
    initItem(margW, "V-Spread", (XtCallbackProc) doDialogCB, (XtPointer) & vspread_dialog);

    /* Options-Menue
     */
    initItem(optionW, "H-Resolution", (XtCallbackProc) doDialogCB, (XtPointer) & hres_dialog);
    initItem(optionW, "V-Resolution", (XtCallbackProc) doDialogCB, (XtPointer) & vres_dialog);
    initItem(optionW, "CallMF Script", (XtCallbackProc) doDialogCB, (XtPointer) & callmf_dialog);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, optionW, NULL, 0);
    dviMemW = initToggleItem(optionW, 0, "Dvi in memory",  (XtCallbackProc) toggle_dviMemory, 
                                                           (XtPointer) NULL);
    traceFontsW = initToggleItem(optionW, 0, "Trace Fonts",(XtCallbackProc) toggle_traceFonts, 
                                                           (XtPointer) NULL);
    traceMemW   = initToggleItem(optionW, 0, "Trace Memory",(XtCallbackProc) toggle_traceMemory, 
                                                           (XtPointer) NULL);
    traceCharsW = initToggleItem(optionW, 0, "Trace Chars",(XtCallbackProc) toggle_traceChars, 
                                                           (XtPointer) NULL);
    showIMGW    = initToggleItem(optionW, 0, "Show Images",(XtCallbackProc) toggle_showIMG, 
                                                           (XtPointer) NULL);       
    landscapeW  = initToggleItem(optionW, 0, "Landscape",  (XtCallbackProc) toggle_landscape, 
                                                           (XtPointer) NULL);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, optionW, NULL, 0);    
    /*        
     * Optionen zur Wahl des Skalierungsverfahrens 
     */
    expandW = initToggleItem(optionW, 0, "Expand Simple", 
                                         (XtCallbackProc) toggle_expand, (XtPointer) NULL);   
    shrinkW = initToggleItem(optionW, 0, "Shrink Simple", 
                                         (XtCallbackProc) toggle_shrink, (XtPointer) NULL);
 
    /* Device-Menue
     */
    sh_NULLW   = initToggleItem(devW, 1,"Screen",(XtCallbackProc) shipoutCB,(XtPointer) & null_d);
    sh_p6lowW  = initToggleItem(devW, 1,"P6 Low",(XtCallbackProc) shipoutCB,(XtPointer) & p6low_d);
    sh_p6midW  = initToggleItem(devW, 1,"P6 Med",(XtCallbackProc) shipoutCB,(XtPointer) & p6mid_d);
    sh_p6highW = initToggleItem(devW, 1,"P6 High",(XtCallbackProc) shipoutCB, 
                                                   (XtPointer) & p6high_d);
    sh_fx80W        = initToggleItem(devW, 1, "Epson FX 80", (XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & fx80_d);
    sh_shipfileW    = initToggleItem(devW, 1, "File", (XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & shipfile_d);
    sh_hpljW        = initToggleItem(devW, 1, "HP Laserjet", (XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & hplj_d);
    sh_hpljlowW     = initToggleItem(devW, 1, "HP Laserjet Low",(XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & hpljlow_d);
    sh_bj300W       = initToggleItem(devW, 1, "Canon BJ300", (XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & bj300_d);
    sh_null_deviceW = initToggleItem(devW, 1, "NULL Device", (XtCallbackProc) shipoutCB, 
                                                             (XtPointer) & null_device_d);
    /* Initialisierung der Dateiauswahl-Dialogbox
     */
    initFileSelector(menuBarW);

    return menuBarW;
}

/* 
 * Ein einzelnes Pulldown-Menue und ein Button zum Herunterklappen des Menues wird erzeugt 
 */
Widget  initTitle(Widget menuBarW, char *name)
{
    Arg     args[10];
    Cardinal n;
    char tmp[50];
    Widget  title;
    strcpy(tmp,name);
    strcat(tmp,"_pane");
    n = 0;
    title = XmCreatePulldownMenu(menuBarW, tmp, args, n);                   /* Pulldown-Menue    */
    n = 0;
    XtSetArg(args[n], XmNsubMenuId, title); n++;
    XtCreateManagedWidget(name,xmCascadeButtonWidgetClass,menuBarW,args,n); /* Button z. Klappen */
    return title;
}

/*
 * Menuepunkt (XmPushButton) erzeugen, und je nach Parameter andere 
 * Callback-Prozedure an die XmNactivateCallback-Liste anhaengen
 */
Widget  initItem(Widget title, char *name, XtCallbackProc cb, XtPointer p)
{
    Arg     args[10];
    Cardinal n;
    Widget  item;
    n = 0;
    item = XtCreateManagedWidget(name, xmPushButtonWidgetClass, title, args, n);
    XtAddCallback(item, XmNactivateCallback, cb, p);
    tst=XtParent(item);
    return item;
}

/* 
 * Options-Menuepunkt erzeugen, der nur zwei Zustaende kennt: gesetzt und nicht gesetzt
 * Je nach Parameter wird eine andere Callback-Prozedur an die XmNvalueChangedCallback-
 * Liste angehaengt.
 */
Widget  initToggleItem(Widget title, int one_of_many, char *name, XtCallbackProc cb, XtPointer p)
{
    Arg     args[10];
    Cardinal n;
    Widget  item;
    n = 0;
    if (one_of_many)
        {XtSetArg(args[n], XmNindicatorType, XmONE_OF_MANY);n++;}
    XtSetArg(args[n], XmNvisibleWhenOff, True);n++;
    item = XtCreateManagedWidget(name, xmToggleButtonWidgetClass, title, args, n);
    XtAddCallback(item, XmNvalueChangedCallback, cb, p);
    return item;
}

/* 
 * Initialisierung der Dateiauswahl-Dialogbox
 * An den Ok-Button wird die Callback-Prozedur fileselectedCB() angehaengt
 */
Widget  initFileSelector(Widget parent)
{
    Arg     args[10];
    Cardinal n;
    n = 0;
    XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL);
    n++;
    fileSelW = XmCreateFileSelectionDialog(parent, "Load", args, n);
    XtAddCallback(fileSelW, XmNokCallback, (XtCallbackProc) fileSelectedCB, (XtPointer) NULL);
    XtAddCallback(fileSelW, XmNokCallback, (XtCallbackProc) unmanageCB, (XtPointer) NULL);
    XtAddCallback(fileSelW, XmNcancelCallback, (XtCallbackProc) unmanageCB, (XtPointer) NULL);
    XtUnmanageChild(XmSelectionBoxGetChild(fileSelW, XmDIALOG_HELP_BUTTON));
    return fileSelW;
}

/* 
 * Diese Callback-Prozedur haengt an den Menuepunkten, die zu einer Dateiauswahl fuehren. Dabei 
 * wird der FileSelector fileSelW gemanaged, der dann nach der Auswahl einer Datei die Prozedur 
 * fileSelectedCB() aufruft. Diese erhaelt als Parameter die bei den Menuepunkten festgelegt 
 * Prozedur z.B. zum Laden der betreffenden Datei
 */
void    doFileSelectorCB(Widget widget, XtPointer clientData, XtPointer callData)
{
    Arg     args[10];
    Cardinal n;
    XmString tcs;
    fileSel_t *fs = (fileSel_t *) clientData;
    tcs = XmStringLtoRCreate(fs -> mask, XmSTRING_DEFAULT_CHARSET);
    currentFileSelCB = fs -> callback;
    n = 0;
    XtSetArg(args[n], XmNdirMask, tcs);
    n++;
    XtSetValues(fileSelW, args, n);
    XtManageChild(fileSelW);
    XmStringFree(tcs);
}

/*
 * Diese Callback-Prozedur wird aufgerufen, sobald eine Datei ausgewaehlt wurde.
 * Abhaenig vom Parameter callData erfolgt der Aufruf einer Prozedur zum Laden
 * einer Datei (new_dvi, read_opt_file, ...)
 */
void    fileSelectedCB(Widget w, XtPointer clientData, XtPointer callData)
{
    XmFileSelectionBoxCallbackStruct *FSBinfos;
    String  dateiname;
    FSBinfos = (XmFileSelectionBoxCallbackStruct *) callData;
    XmStringGetLtoR(FSBinfos -> value, XmSTRING_DEFAULT_CHARSET, &dateiname);
    if (currentFileSelCB != NULL)
        (*currentFileSelCB) (dateiname); /* Bearbeiten der ausgewaehlten Datei (Laden) */
    XtFree(dateiname);
}

/* Diese Callback-Prozedur haengt an den Menuepunkten, die zur Einstellung von Zahlenwerten 
 * (Raender, Aufloesung, ...) dienen. Es wird ein Dialog zur Eingabe eines Wertes erzeugt.
 * Je nach clientData erhaelt eine bestimmte Variable einen neuen Wert. Dazu wird an die 
 * Callback-Liste des Ok-Buttons die Prozedur inputCB() angehaengt, die den eingegebenen 
 * String in das gewuenschte Format einer Variablen umwandelt.
 */
void    doDialogCB(Widget widget, XtPointer clientData, XtPointer callData)
{
    static Widget eingabeW = NULL, textW;
    static dialog_t *currentClientData;
    char    default_text[128];
    Arg     args[10];
    Cardinal n;
    currentClientData = (dialog_t *) clientData;
    if (eingabeW == NULL)
    {
        n = 0;
        XtSetArg(args[n], XmNautoUnmanage, True); n++;
        XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
        /*
         * Convenience-Funktion zur Erzeugung des Dialogs.
         */
        eingabeW = XmCreatePromptDialog(widget, "Input", args, n);
        XtAddCallback(eingabeW, XmNokCallback, (XtCallbackProc) inputCB, 
                               (XtPointer) & currentClientData);
        XtUnmanageChild(XmSelectionBoxGetChild(eingabeW, XmDIALOG_HELP_BUTTON));
        textW = XmSelectionBoxGetChild(eingabeW, XmDIALOG_TEXT);
    }
    if (currentClientData -> str_to_change != NULL)
        strcpy(default_text, currentClientData -> str_to_change);
    else
    if (currentClientData -> long_to_change != NULL)
        sprintf(default_text, "%ld", *currentClientData -> long_to_change);
    else
    if (currentClientData -> dimen_to_change != NULL)
        sprintf(default_text, "%fin", (double) *currentClientData -> dimen_to_change);
    else
        *default_text = '\0';
    XmTextSetString(textW, default_text);
    XtManageChild(eingabeW);
}
/* Umwandlung des oben genannten Strings in ein geeignetes Format */
void    inputCB(Widget widget, XtPointer clientData, XtPointer callData)
{
    XmSelectionBoxCallbackStruct *SBinfos;
    String  input_string;
    dialog_t *d = *(dialog_t **) clientData;
    SBinfos = (XmSelectionBoxCallbackStruct *) callData;
    XmStringGetLtoR(SBinfos -> value, XmSTRING_DEFAULT_CHARSET, &input_string);
    if (d -> callback != NULL)
        (*d -> callback) (input_string);
    if (d -> str_to_change != NULL)
        strcpy(d -> str_to_change, input_string);
    if (d -> long_to_change != NULL)
        *(d -> long_to_change) = atol(input_string);
    if (d -> dimen_to_change != NULL)
        *(d -> dimen_to_change) =
                get_dimen(input_string, *(d -> dimen_to_change));
    XtFree(input_string);
    if (d -> clean)
        exitDviOutWindow();
}

/* 
 * Callback-Prozeduren fuer die ToggleButtons der Options-Menues.Darin aendern jeweils nur Flags 
 * d.h. z.B. Options-Variable ihren Wert. Das Flag Quickexpand gibt an, mit welchem Verfahren 
 * vergroessert, das Flag Quickshrink gibt an, mit welchem Verfahren verkleinert wird.
 * Flag == 1 bedeutet Scanline-Methode.
 */   
void    toggle_traceFonts(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.showfonts = cb -> set ? 1 : 0;
}
void    toggle_traceMemory(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.tracemem = cb -> set ? 1 : 0;
}
void    toggle_dviMemory(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.dvimemory = cb -> set ? 1 : 0;
}
void    toggle_traceChars(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.tracechars = cb -> set ? 1 : 0;
}
void    toggle_showIMG(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.show_img = cb -> set ? 1 : 0;
}
void    toggle_landscape(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    op.landscape = cb -> set ? 1 : 0;
    reloadCB( w, clientData, callData );
}
void    toggle_expand(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    Quickexpand = cb -> set ? 1 : 0;
}
void    toggle_shrink(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *) callData;
    Quickshrink = cb -> set ? 1 : 0;
}

/*
 * In dieser Prozedur werden nach den Zustaenden der betreffenden Flags 
 * die Zustaende der ToggleButtons des Options-Menues und des Device-Menues gesetzt.
 * Dies ist z.B. nach dem Laden einer neuen Options-Datei noetig. 
 */
void    set_toggles(void)
{
    Arg     args[1];
    Cardinal n = 1;
    XtSetArg(args[0],XmNset,op.showfonts ? True : False);       XtSetValues(traceFontsW, args, n);
    XtSetArg(args[0],XmNset,op.tracemem ? True : False);        XtSetValues(traceMemW, args, n);
    XtSetArg(args[0],XmNset,op.dvimemory ? True : False);       XtSetValues(dviMemW, args, n);
    XtSetArg(args[0],XmNset,op.tracechars ? True : False);      XtSetValues(traceCharsW, args, n);    
    /* Epsf-Grafiken anzeigen ja-nein                           */
    XtSetArg(args[0],XmNset,op.show_img ? True : False);        XtSetValues(showIMGW, args, n);
    XtSetArg(args[0],XmNset,op.landscape ? True : False);       XtSetValues(landscapeW, args, n);        
    /* Convolution oder Scanline-Konvertierung fuer Skalierung */
    XtSetArg(args[0],XmNset,Quickexpand ? True : False);        XtSetValues(expandW, args, n);
    XtSetArg(args[0],XmNset,Quickshrink ? True : False);        XtSetValues(shrinkW, args, n);      
    XtSetArg(args[0],XmNset,shipout == NULL ? True : False);    XtSetValues(sh_NULLW, args, n);
    XtSetArg(args[0],XmNset,shipout == p6low ? True : False);   XtSetValues(sh_p6lowW, args, n);
    XtSetArg(args[0],XmNset,shipout == p6high ? True : False);  XtSetValues(sh_p6highW, args, n);
    XtSetArg(args[0],XmNset,shipout == p6mid ? True : False);   XtSetValues(sh_p6midW, args, n);
    XtSetArg(args[0],XmNset,shipout == fx80 ? True : False);    XtSetValues(sh_fx80W, args, n);
    XtSetArg(args[0],XmNset,shipout == shipfile ? True : False);XtSetValues(sh_shipfileW, args, n);
    XtSetArg(args[0],XmNset,shipout == hplj ? True : False);    XtSetValues(sh_hpljW, args, n);
    XtSetArg(args[0],XmNset,shipout == hpljlow ? True : False); XtSetValues(sh_hpljlowW, args, n);
    XtSetArg(args[0],XmNset,shipout == bj300 ? True : False);   XtSetValues(sh_bj300W, args, n);
    XtSetArg(args[0],XmNset,shipout == null_device ? True : False);
    XtSetValues(sh_null_deviceW, args, n);
}

/* 
 * Neuer .log-Dateiname
 */ 
static void new_log_file(char *name)
{
    dvi_clean();
    strcpy(op.log_name, name);
}
void    halt(char *format,...)
{
    va_list l;
/*    if(PageIsOpen)
        cursornormal();*/
    va_start(l, format);
    vprint(format, l);
    va_end(l);
    longjmp(halt_jmp, 1);
}
char   *itoa(int n)
{
    int     i, nr;
    long    div;
    static char    number[10];
    if (n == 0)
    {
        number[0] = '0';
        number[1] = '\0';
        return number;
    }
    nr = 0;
    div = 10000000;
    if (n < 0)
    {
        number[nr++] = '-';
        n = -n;
    }
    while (div > 0)
    {
        if (((n / div) > 0) || (nr))
        {
            number[nr++] = '0' + (n / div);
            n = n % div;
        }
        div = div / 10;
    }
    number[nr] = '\0';
    return number;
}

/*
 * Der Dvi-Dateiname wird verwendet um Titel und den
 * Ikon-Name des Widgets des Hauptformulars (2.Widgetbaum) zu setzen.
 */ 
void    set_filename(char *name)
{
    static char *old_name = NULL, *short_name = NULL;
    Arg     args[10];
    Cardinal n;
    if (old_name != NULL)
        XtFree(old_name);
    if (short_name != NULL)
        XtFree(short_name);
    old_name   = XtNewString(name);
    short_name = XtNewString(fname(name));
    n = 0;
    XtSetArg(args[n], XmNtitle, old_name); n++;
    XtSetArg(args[n], XmNiconName, short_name); n++;
    XtSetValues(dispShell, args, n);
}

/*
 * Ausgabe eines Textes in der ScrolledText-Region textw
 */
void    out_string(char *string)
{
    int     n;
    Arg     args[10];
    XmTextPosition pos;
    pos = XmTextGetLastPosition(textW);
    XmTextInsert(textW, pos, string);
    XmTextShowPosition(textW, pos);
    XmTextSetInsertionPosition(textW, pos);
}
void prbyte(int c)
{
        /* Dummy ie */
        static FILE *printer_fp = NULL;
        return;
}
void    out_newline(void)
{
        out_string("\n");
}
int     stop_key(void)
{
            return 0;
}
int     wait_for_sheet(void)
{
            return 0;
}
float    get_dimen(char *string, float old_value)
{
    char    c, *s;
    real    r, dimen;
    while (isspace(*string))
        string++;
    s = string;
    while (isdigit(*s) || *s == '.')
        s++;
    if (s == string)
        return old_value;

    strlwr(s);
    c = *s;
    *s = 0;
    r = atof(string);
    *s = c;
    while (isspace(*s))
        s++;
    if (r == 0.0 && *s == '\0')
        dimen = 0.0;
    else
    if (!strcmp(s, "in"))
        dimen = r;
    else
    if (!strcmp(s, "cm"))
        dimen = r / 2.54;
    else
    if (!strcmp(s, "pt"))
        dimen = r / 72.27;
    else
    if (!strcmp(s, "pc"))
        dimen = r * 12.0 / 72.27;
    else
    if (!strcmp(s, "bp"))
        dimen = r / 72.0;
    else
    if (!strcmp(s, "mm"))
        dimen = r / 25.4;
    else
    if (!strcmp(s, "dd"))
        dimen = r * 1238.0 / 72.27;
    else
    if (!strcmp(s, "cc"))
        dimen = r * 12 * 1238.0 / 72.27;
    else
    if (!strcmp(s, "sp"))
        dimen = r / 72.27 / 65536.0;
    else
        return old_value;

    return dimen;
}
/* 
 * In dieser Prozedur werden die Optionen in eine Datei geschrieben
*/ 
static void write_opt_file(char *name)
{
    FILE   *fp = fopen(name, "wb");
    if (fp != NULL)
    {
        op.magic = X_MAGIC;
        if (shipout == p6low)
            op.shipno = 1;
        else
        if (shipout == p6high)
            op.shipno = 2;
        else
        if (shipout == p6mid)
            op.shipno = 3;
        else
        if (shipout == fx80)
            op.shipno = 4;
        else
        if (shipout == shipfile)
            op.shipno = 5;
        else
        if (shipout == hplj)
            op.shipno = 6;
        else
        if (shipout == hpljlow)
            op.shipno = 7;
        else
        if (shipout == bj300)
            op.shipno = 8;
        else
        if (shipout == null_device)
            op.shipno = 9;
        else
            op.shipno = 0;
        fwrite(&op, sizeof(op), 1, fp);
        fclose(fp);
    }
}

/* 
 * In dieser Prozedur werden die Optionen aus einer Datei Datei gelesen
 */
static void read_opt_file(char *name)
{
    FILE   *fp = fopene(name, "rb", thePath, (char *) NULL);
    if (fp != NULL)
    {
        options new_op;
        size_t  bytes = fread(&new_op, sizeof(op), 1, fp);
        if (bytes != 1 || new_op.magic != X_MAGIC)
        {
            print("Invalid optionfile %s", name);
        }
        else
        {
            op = new_op;
            dvi_clean();
            set_toggles();
            strcpy(opt_name,name);
            switch (op.shipno)
            {
                case 1:
                    shipout = p6low;
                    break;
                case 2:
                    shipout = p6high;
                    break;
                case 3:
                    shipout = p6mid;
                    break;
                case 4:
                    shipout = fx80;
                    break;
                case 5:
                    shipout = shipfile;
                    break;
                case 6:
                    shipout = hplj;
                    break;
                case 7:
                    shipout = hpljlow;
                    break;
                case 8:
                    shipout = bj300;
                    break;
                case 9:
                    shipout = null_device;
                    break;
                default:
                    shipout = NULL;
            }
        }
    }
    else
        print("Cannot read Optionfile %s", name);
}
void    unmanageCB(Widget w, XtPointer clientData, XtPointer callData)
{
            XtUnmanageChild(w);
}
void    shipoutCB(Widget w, XtPointer clientData, XtPointer callData)
{
    XmToggleButtonCallbackStruct *t = (XmToggleButtonCallbackStruct *) callData;
    if (t -> set)
        shipout = ((driver_t *) clientData) -> function;
}
/*
 * Prozedur zum Formatieren der Dvi-Seiten
 */
static void formatCB(char *string)
{
    int     first, last, step = 1;
    char   *p = strtok(string, " \t\n,");
    if (p == NULL)
        first = 1, last = 9999;
    else
    {
        first = atoi(p);
        if (first < 1)
            first = 1;
        last = first;
        step = 1;
        if ((p = strtok(NULL, " \t\n,")) != NULL)
        {
            last = atoi(p);
            if (last < first)
                last = first;
            if ((p = strtok(NULL, " \t\n,")) != NULL)
            {
                step = atoi(p);
                if (step < 1)
                    step = 1;
            }
        }
    }
    doexpose=1;
    print_pages(first, last, step);
    if(PageIsOpen)
        XmTextFieldSetString(textw, itoa(last_page>0?last_page:1));
}

/* 
 * Diese Prozedur startet die Anzeige einer Dvi-Seite am Bildschirm. Dazu werden die 
 * Seiten formatiert, und eine Seite mit initDviOutWindow() angezeigt.
 */
static void print_pages(int first, int last, int step)
{
    if(*dvi_name == '\0')
        return;
    if(PageIsOpen)
        cursorbusy();
    if( !setjmp( halt_jmp ) )
    {  
      /*dvi_clean();*/
      last_page = format_pages(first, last, step); /* Seiten neu formatieren          */
      if (shipout == NULL)
        initDviOutWindow();                      /* Ausgabebereich oeffnen          */
      else
        exitDviOutWindow();
    } 
    if(PageIsOpen)
        cursornormal();    
}

/* 
 * In dieser Prozedur wird die neu ausgewaehlte Dvi-Datei mit print_pages() geladen
 */
static void new_dvi_file(char *name)
{
    exitDviOutWindow();                          /* Ausgabebereich schliessen       */
    strcpy(dvi_name, name);
    u_shrinkfactor = SRC, o_shrinkfactor = 0;    /* Shrinkfaktor zuruecksetzen      */
    last_page = 1;
    dvi_clean();
    read_opt_file(opt_name);
    if (setjmp(halt_jmp) == 0)
        if (*dvi_name && shipout == NULL) 
            print_pages(1, 1, 1);           /* Datei laden, Seite neu aufbauen */          
}





















/**************************************************************************************************
 **************************************************************************************************
 *                                                                                                *
 *            Zweiter Widget-Baum  ***  Autor: Ulrich Lechner  9/1994                             *
 *                                                                                                *
 **************************************************************************************************
 **************************************************************************************************
*/
/*
 * Initialsierung des Hauptformulars (Ausgabe-, Funktions- und Skalierungsbereich)
 */
static void initDviOutWindow(void)
{
    Arg     args[10];
    Cardinal n;
    Widget  mainW;

    if (!PageIsOpen)
    {
        /*
         * Die Wurzel des zweiten Haupt-Widget-Baumes erzeugen: Namen "dviPage"         
         */                         
        n = 0;
        XtSetArg(args[n],XmNiconName,"DviPage"); n++;      /* Ikon-Name             */
        XtSetArg(args[n],XmNscreen, defaultScreen); n++;   /* Screen                */
        dispShell = XtAppCreateShell("dviPage", APPL_CLASS, 
                                     topLevelShellWidgetClass, theDisplay, args, n);
         
        /* 
         * Callback-Prozedur fuer Aufraeumarbeiten, falls Widget ueber Close=Alt F4 
         * zerstoert wird 
         */
        XtAddCallback(dispShell, XmNdestroyCallback, (XtCallbackProc) destroyCB, NULL);

        if (dvi_name)
            set_filename(dvi_name);
        stat(dvi_name,&oldstatus);     /* Status der Dvi-Datei abfragen   */
        
        /*
         * Das Hauptformular erzeugen: Name "pageform"
         * Dieses Widget dient als Container fuer 
         * Ausgabe-, Funktions- und Skalierungbereich 
         */
        mainW = XtVaCreateWidget("pageform", xmFormWidgetClass, dispShell,
                XmNheight, 800,
                XmNwidth, 500,
                NULL);

        set_sizes();                   /* Breiten und Hoehen festlegen    */
        initScale(mainW);              /* Skalierungbereich erzeugen      */               
        initGraphic(mainW);            /* Ausgabebereich erzeugen         */
        initFunctions(mainW);          /* Funktionsbereich erzeugen       */
        initColors(mainW);             /* Farben initialisieren           */
        
        XtManageChild(mainW);          /* Hauptformular managen           */
        
        if(init_filter(num_colors)!=0) /* Filter Initialisieren           */
        {                   
            printf("ERROR in init_filter\n");
            exitCB(graphicW, (XtPointer) NULL, (XtPointer) NULL);
        }

        initPopupMenu(graphicW);       /* Popup-Menue fuer Ausgabebereich 
                                          erzeugen */
        /*
         * Eventhandler an Ausgabebereich binden. Zustaendig fuer:
         * Erscheinen von Popup-Menue und Verschieben des DrawingArea-Widgets
         */ 
        XtAddEventHandler(graphicW, Button1MotionMask | ButtonPressMask | ButtonReleaseMask,
                          False, moveImageCB, NULL);
        /*
         * Eventhandler an Haupformular binden. Nach Wiedereintritt der Maus
         * in das Fenster wird neu uebersetzte Dvi-Datei nachgeladen 
         */     
        XtAddEventHandler( mainW, EnterWindowMask, False, (XtEventHandler)newCB, NULL);
        
        cursor = XCreateFontCursor(theDisplay, shape); /* Busy-Cursor (Uhr) erzeugen  */
        
        XtRealizeWidget(dispShell);   /* Zweiten Widget-Baum komplett sichtbar machen */        
        
        setslider(s_bar_ver);         /* Scrollbars des ScrolledWindow setzen         */
        setslider(s_bar_hor);
        PageIsOpen = 1;

    }
    else
    {
        if (theImage == NULL)
        {
            set_sizes();
            if (initImage() != 0)
                exitCB(graphicW, (XtPointer) NULL, (XtPointer) NULL);
            if (doexpose == 0)
            {
                cursorbusy();
                shrink();
                cursornormal();
            }
            else
                exposeCB(graphicW, (XtPointer) NULL, (XtPointer) NULL);
        }
        else
            exposeCB(graphicW, (XtPointer) NULL, (XtPointer) NULL);
    }
    if (theImage == NULL)             /* XImage erzeugen */                     
        if (initImage() != 0)         
            exitCB(graphicW, (XtPointer) NULL, (XtPointer) NULL);
}


/* Breite und Hoehe von XImage und DrawingArea setzen */
static void set_sizes(void)
{
    int     width, height;
    width  = frame_width * 8;         /* Breite des Dvi-Frame_buffer in Pixel */
    height = frame_height;            /* Hoehe des  Dvi-Frame_buffer in Pixel */

    /* width und height  aufrunden */
    if (width % SRC != 0)
        dst_width = (width / SRC + 1) * SRC;
    else
        dst_width = width;
    if (height % SRC != 0)
        dst_height = (height / SRC + 1) * SRC;
    else
        dst_height = height;

    /* effektive Groessen von XImage */
    eff_width  = dst_width  * EXFACTOR;
    eff_height = dst_height * EXFACTOR;
}

/*
 * Erzeugen der Skala zur Wahl des Vergroesserungs- bzw.Verkleinerungsstufe. Dabei
 * werden an die linke Seite des "shrinkscale" Tickmarks gezeichnet. Ausserdem erhaelt
 * "shrinkscale" einen Rahmen . 
 */
static void initScale(Widget widget)
{
    String  sh_text[NUMTICKS];           /* Strings fuer Ticks */
    int     i, j;
    Arg     al[10];                      /* arg list           */
    int     ac = 0;                      /* arg count          */
    
    /* Rahmen um "scale" */
    fw = XtVaCreateWidget("frame", xmFrameWidgetClass, widget,
#ifdef HARDCODED            
            XmNrightAttachment, XmATTACH_FORM,   /* Kanten an Hauptformular binden */
            XmNrightOffset, 0,
            XmNtopAttachment, XmATTACH_FORM,
            XmNtopOffset, 0,
            XmNshadowType, XmSHADOW_ETCHED_IN,
#endif      
            NULL);
    /*
     * Erzeugen des "shrinkscale" 
     */
     /* XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;*/
     
#define SCALE_STEP 1

#if NUMTICKS > 32
XtSetArg(al[ac], XmNshowValue, True); ac++;                /* Skalenwert anzeigen */
XtSetArg(al[ac], XmNscaleHeight, 480); ac++;               /* Hoehe der Skala     */
XtSetArg(al[ac], XmNmaximum, MAX_VAL - SRC); ac++;         /* maximaler Wert      */   
XtSetArg(al[ac], XmNminimum, MIN_VAL - SRC); ac++;         /* minimaler Wert      */
XtSetArg(al[ac], XmNvalue, 0); ac++;                       /* Startwert           */
XtSetArg(al[ac], XmNscaleMultiple, SCALE_STEP); ac++;      /* Schrittweite        */
#else
XtSetArg(al[ac], XmNvalue, SRC); ac++;
XtSetArg(al[ac], XmNscaleMultiple, SCALE_STEP); ac++;
XtSetArg(al[ac], XmNmaximum, MAX_VAL); ac++;
XtSetArg(al[ac], XmNminimum, MIN_VAL); ac++;
#endif

scale = XmCreateScale(fw, "shrinkscale", al, ac);          /* Skala erzeugen      */

/* Labeltexte fuer die Tickmarks der Skala setzen */

i = NUMTICKS;                            /* Anzahl der TICKS */
#if NUMTICKS <=32
#if SRC == 32                            /* damit EXFACTOR == 1 */
sh_text[--i] = "         -";sh_text[--i] = "   6.25% -";sh_text[--i] = "         -";
sh_text[--i] = "  12.50% -";sh_text[--i] = "         -";sh_text[--i] = "  18.75% -";
sh_text[--i] = "         -";sh_text[--i] = "  25.00% -";sh_text[--i] = "         -";
sh_text[--i] = "  31.25% -";sh_text[--i] = "         -";sh_text[--i] = "  37.50% -";
sh_text[--i] = "         -";sh_text[--i] = "  43.75% -";sh_text[--i] = "         -";
sh_text[--i] = "  50.00% -";sh_text[--i] = "         -";sh_text[--i] = "  56.25% -";
sh_text[--i] = "         -";sh_text[--i] = "  62.50% -";sh_text[--i] = "         -";
sh_text[--i] = "  68.75% -";sh_text[--i] = "         -";sh_text[--i] = "  75.00% -";
sh_text[--i] = "         -";sh_text[--i] = "  81.25% -";sh_text[--i] = "         -";
sh_text[--i] = "  87.50% -";sh_text[--i] = "         -";sh_text[--i] = "  93.75% -";
sh_text[--i] = "         -";sh_text[--i] = " 100.00% -";
#elif SRC == 24                          /* damit EXFACTOR == 1 */
sh_text[--i] = "         -";sh_text[--i] = "   8.33% -";sh_text[--i] = "         -";
sh_text[--i] = "  16.67% -";sh_text[--i] = "         -";sh_text[--i] = "  25.00% -";
sh_text[--i] = "         -";sh_text[--i] = "  33.33% -";sh_text[--i] = "         -";
sh_text[--i] = "  41.67% -";sh_text[--i] = "         -";sh_text[--i] = "  50.00% -";
sh_text[--i] = "         -";sh_text[--i] = "  58.33% -";sh_text[--i] = "         -";
sh_text[--i] = "  66.67% -";sh_text[--i] = "         -";sh_text[--i] = "  75.00% -";
sh_text[--i] = "         -";sh_text[--i] = "  83.33% -";sh_text[--i] = "         -";
sh_text[--i] = "  91.67% -";sh_text[--i] = "         -";sh_text[--i] = " 100.00% -";
#elif SRC == 16
sh_text[--i] = "         -";sh_text[--i] = "  12.50% -";sh_text[--i] = "         -";
sh_text[--i] = "  25.00% -";sh_text[--i] = "         -";sh_text[--i] = "  37.50% -";
sh_text[--i] = "         -";sh_text[--i] = "  50.00% -";sh_text[--i] = "         -";
sh_text[--i] = "  62.50% -";sh_text[--i] = "         -";sh_text[--i] = "  75.00% -";
sh_text[--i] = "         -";sh_text[--i] = "  87.50% -";sh_text[--i] = "         -";
sh_text[--i] = " 100.00% -";
#if EXFACTOR == 2
sh_text[--i] = "         -";sh_text[--i] = " 112.50% -";sh_text[--i] = "         -";
sh_text[--i] = " 125.00% -";sh_text[--i] = "         -";sh_text[--i] = " 137.50% -";
sh_text[--i] = "         -";sh_text[--i] = " 150.00% -";sh_text[--i] = "         -";
sh_text[--i] = " 162.50% -";sh_text[--i] = "         -";sh_text[--i] = " 175.00% -";
sh_text[--i] = "         -";sh_text[--i] = " 187.50% -";sh_text[--i] = "         -";
sh_text[--i] = " 200.00% -";
#endif
#elif SRC == 8
#if EXFACTOR == 1
sh_text[--i] = "         -";sh_text[--i] = "  25.00% -";sh_text[--i] = "         -";
sh_text[--i] = "  50.00% -";sh_text[--i] = "         -";sh_text[--i] = "  75.00% -";
sh_text[--i] = "         -";sh_text[--i] = " 100.00% -";
#elif EXFACTOR == 2
sh_text[--i] = "         -";sh_text[--i] = "  25.00% -";sh_text[--i] = "         -";
sh_text[--i] = "  50.00% -";sh_text[--i] = "         -";sh_text[--i] = "  75.00% -";
sh_text[--i] = "         -";sh_text[--i] = " 100.00% -";sh_text[--i] = "         -";
sh_text[--i] = " 125.00% -";sh_text[--i] = "         -";sh_text[--i] = " 150.00% -";
sh_text[--i] = "         -";sh_text[--i] = " 175.00% -";sh_text[--i] = "         -";
sh_text[--i] = " 200.00% -";
#elif EXFACTOR == 3

/* Falls die Zahl der Tickmarks zu gross ist, werden nur die wichtigsten Ticks angebracht 
*/
for (j = --i; j >= 0; j--)               
    sh_text[j] = "          ";
sh_text[NUMTICKS - SRC * 2] = "   200%   ";
sh_text[NUMTICKS - SRC]     = "   100%   ";
sh_text[NUMTICKS - 1]       = " MINIMUM  ";
sh_text[0]                  = " MAXIMUM  ";
#else                                    /* EXFACTOR == 4 */
for (j = --i; j >= 0; j--)
    sh_text[j] = "          ";
sh_text[NUMTICKS - SRC * 3] = "   300%   ";
sh_text[NUMTICKS - SRC * 2] = "   200%   ";
sh_text[NUMTICKS - SRC]     = "   100%   ";
sh_text[NUMTICKS - 1]       = " MINIMUM  ";
sh_text[0]                  = " MAXIMUM  ";
#endif
#endif
#else                                    /* showvalue */
for (i = 0; i < NUMTICKS; i++)
    sh_text[i] = "       ";
sh_text[NUMTICKS - 1] = "   MIN ";
sh_text[0]            = "   MAX ";
#endif

/* Tickmarks erzeugen */
for (i = 0; i < NUMTICKS; i++)
    XtVaCreateManagedWidget(sh_text[i], xmLabelGadgetClass, scale, NULL);

/* Callback-Liste wird bearbeitet, wenn sich der Skalenwert geaendert hat. */
XtAddCallback(scale, XmNvalueChangedCallback, (XtCallbackProc)scaleCB, 0); 
XtManageChild(scale);
XtManageChild(fw);
}

/*
 * Initialisieren des Ausgabebereiches, d.h. des ScrolledWindow "scrolled_win" und der 
 * darunterliegenden DrawingArea "drawing_a". Die Variablen "s_bar_ver bzw. s_bar_hor" 
 * (vertikaler bzw. horizontaler Scrollbars des ScrolledWindow) werden identifiziert. 
 * Diese dienen spaeter zur Zentrierung der DrawingArea. 
 */
static void initGraphic(Widget parent)
{
    sW = XtVaCreateWidget("scrolled_win",             /* ScrolledWindow erzeugen         */
            xmScrolledWindowWidgetClass, parent,
            XmNscrollingPolicy, XmAUTOMATIC,          /* Automatisches Scrollen          */
            XmNscrollBarDisplayPolicy, XmAS_NEEDED,   /* Scrollbars nur dann wenn noetig */
            XmNrightWidget, fw,
#ifdef HARDCODED            
            XmNtopAttachment, XmATTACH_FORM,          /* Kantenbindung an Hauptformular  */
            XmNbottomAttachment, XmATTACH_FORM, 
            XmNleftAttachment, XmATTACH_FORM,
            XmNrightAttachment, XmATTACH_WIDGET,      /* Kantenbindung an Skala          */
            XmNrightOffset, 24,                       /* Offset zu Skala                 */
#endif
            NULL);

    graphicW = XtVaCreateManagedWidget("drawing_a",   /* DrawingArea erzeugen            */
            xmDrawingAreaWidgetClass, sW,
            XmNwidth, eff_width,                      /* Breite                          */
            XmNheight, eff_height,                    /* Hoehe                           */
            XmNresizePolicy, XmNONE,                  /* Feste Groesse                   */
            NULL);

    XtAddCallback(graphicW, XmNexposeCallback, (XtCallbackProc) exposeCB,
            (XtPointer) NULL);          /* exposeCB an DrawingArea heften (EXPOSE_EVENT) */

    XtManageChild(sW);

    /* Scrollbalken des ScrolledWindow identifizieren */
    XtVaGetValues(sW, XmNverticalScrollBar,  &s_bar_ver, NULL);
    XtVaGetValues(sW, XmNhorizontalScrollBar,&s_bar_hor, NULL);
}

/*
 * Popup-Menue fuer DrawingArea erzeugen. Callback-Prozeduren anhaengen, zum Wechsel auf die 
 * naechste, vorherige oder beliebige Seite im Dokument. Callback-Prozeduren zum Update der 
 * Seite (neue Optionen beruecksichtigen) und zum Beenden des Programm anhaengen.
 */
void    initPopupMenu(Widget parent)
{
    PopupMenuW = XmCreatePopupMenu(parent, "popupmenu", NULL, 0);    
    initItem(PopupMenuW, "Next Page", (XtCallbackProc) nPageCB, (XtPointer)1);
    initItem(PopupMenuW, "Prev Page", (XtCallbackProc) pPageCB, (XtPointer)1);
    initItem(PopupMenuW, "Goto Page", (XtCallbackProc) doDialogCB, (XtPointer) &page_dialog);
    initItem(PopupMenuW, "Update Page", (XtCallbackProc) updateCB, (XtPointer)1);
    XtCreateManagedWidget("Separator", xmSeparatorWidgetClass, PopupMenuW, NULL, 0);
    initItem(PopupMenuW, "Quit", (XtCallbackProc) exitCB, (XtPointer) NULL);
}
static void PostPopupMenu(Widget popup, XButtonPressedEvent * event)
{
    XmMenuPosition(popup, event);  /* Positionierung des Popup-Menues im Fenster 
                                      des DrawingAreaWidgets                     */
    XtManageChild(popup);          /* Popup-Menue anzeigen                       */                               
}

#define TOPOFF  4
#define LEFTOFF 8
#define RIGHTOFF LEFTOFF

/*
 * Initialisierung des Funktionsbereichs
 */
static void initFunctions(Widget parent)
{
    Widget  formw, pbc, rc, pbl, pbr, pbq, pbu, textlabel, sep;
    Widget  introframe, introlabel;
    
    /* Erzeugen der Pixmap fuer Center-Button: pbc  
     */
    px_center = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),
            center_bits, center_width, center_height,      /* Zeiger auf Bitmapdaten */
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));

    /* Erzeugen der Pixmap fuer NextPage-Button: pbr 
     */
    px_right = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),
            arrow_right_bits, arrow_right_width,           /* Zeiger auf Bitmapdaten */
            arrow_right_height, 
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));

    /* Erzeugen der Pixmap fuer PreviousPage-Button: pbl 
     */
    px_left = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),
            arrow_left_bits, arrow_left_width,             /* Zeiger auf Bitmapdaten */
            arrow_left_height, 
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));

    /* Erzeugen der Pixmap fuer Update-Button: pbu 
     */
    px_update = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),                   /* usw. */
            update_bits, update_width, update_height,   
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));
#ifdef FRAME
    /* Erzeugen der Pixmap fuer FrameOn-Button: frb 
     */
    px_f_on = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),
            f_on_bits, f_on_width, f_on_height, 
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));

    /* Erzeugen der Pixmap fuer FrameOffButton: frb 
     */
    px_f_off = XCreatePixmapFromBitmapData(theDisplay,
            RootWindowOfScreen(XtScreen(parent)),
            f_off_bits, f_off_width, f_off_height,      
            BlackPixelOfScreen(XtScreen(parent)),
            WhitePixelOfScreen(XtScreen(parent)),
            DefaultDepthOfScreen(XtScreen(parent)));
#endif
    /* Rahmen um alle Bedienelemente 
     */
    fw2 = XtVaCreateManagedWidget("frame_out", xmFrameWidgetClass, parent,
            XmNleftWidget, fw,
            XmNtopWidget, fw,   
#ifdef HARDCODED            
            XmNrightAttachment, XmATTACH_FORM,             /* Positionierung des Rahmens */
            XmNrightOffset, 0,                             /* im Hauptformular parent    */
            XmNtopAttachment, XmATTACH_WIDGET,          
            XmNtopOffset, 4,
            XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
            XmNleftOffset, 0,
            XmNshadowType, XmSHADOW_ETCHED_IN,             /* Art des Schattens          */
#endif      
            NULL);

    /* Formular zur Plazierung der Bedienelemente 
     */
    formw = XtVaCreateManagedWidget("func_form", xmFormWidgetClass, fw2,
            XmNbottomAttachment, XmATTACH_WIDGET,
            XmNbottomWidget, fw2,
            XmNtopOffset, 0,
            NULL);


    /* Rahmen fuer Ueberschrift: "PAGE CONTROL" 
     */
    introframe = XtVaCreateManagedWidget("frame_in", xmFrameWidgetClass, formw,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            XmNtopAttachment, XmATTACH_FORM,
            XmNtopOffset, TOPOFF,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            XmNshadowType, XmSHADOW_ETCHED_OUT,
            NULL);

    /* Ueberschrift fuer alle folgenden Buttons */
    introlabel = XtVaCreateManagedWidget("PAGE CONTROL", xmLabelGadgetClass, introframe,
    /*
     * XmNleftAttachment,XmATTACH_FORM, XmNleftOffset,LEFTOFF,
     * XmNrightAttachment,XmATTACH_FORM, XmNrightOffset,RIGHTOFF,
     * XmNtopAttachment,XmATTACH_WIDGET, XmNtopOffset,TOPOFF+4, 
     */
            NULL);
    
    /* Es folgen die Bedienelemente, dabei werden Kanten angebunden */
    /* Button zum Wechsel auf die vorherige Seite */
    pbl = XtVaCreateManagedWidget("prev", xmPushButtonWidgetClass, formw,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, px_left,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, introframe,
            XmNtopOffset, TOPOFF,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            NULL);
    
    /* Button zum Wechsel auf die naechste Seite */
    pbr = XtVaCreateManagedWidget("next", xmPushButtonWidgetClass, formw,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, px_right,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, introframe,
            XmNtopOffset, TOPOFF,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            NULL);
    
    /* Text zur Beschreibung des naechsten Widgets */
    textlabel = XtVaCreateManagedWidget("GOTO -->", xmLabelGadgetClass, formw,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, pbl,
            XmNtopOffset, TOPOFF + 4,
            NULL);

    /* Eingabefeld fuer die Seitennummer zum Sprung auf eine beliebige Seite */
    textw = XtVaCreateManagedWidget("textfield", xmTextFieldWidgetClass, formw,            
            XmNwidth, 6,            
            XmNautoShowCursorPosition,False,            
            XmNvalue, "1",                      /* Startwert */
            XmNmarginHeight, 4,
            XmNmarginWidth, 4,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, pbr,
            XmNtopOffset, TOPOFF,
            XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
            XmNleftWidget, pbr,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            NULL);
    
    /* Button zum Zentrieren einer Seite */
    pbc = XtVaCreateManagedWidget("center", xmPushButtonWidgetClass, formw,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, px_center,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, pbl,
            XmNtopOffset, TOPOFF * 10,
            NULL);

    /* Button zum Update einer Seite */
    pbu = XtVaCreateManagedWidget("update", xmPushButtonWidgetClass, formw,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, px_update,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, pbr,
            XmNtopOffset, TOPOFF * 10,
            NULL);

    /* Vertikale Linie zur optischen Trennung */
    sep = XtVaCreateManagedWidget("separator", xmSeparatorWidgetClass, formw,
            XmNseparatorType, XmSHADOW_ETCHED_OUT,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, 0,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, 0,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, pbc,
            XmNtopOffset, TOPOFF,
            NULL);

#ifdef FRAME
    /* Button aehnlich einem ToggleButton. Er zeigt an ob ein Rahmen um die Seite 
     * gezeichnet ist oder nicht. Bei Betaetigung wird ein Rahmen gezeichnet, falls
     * keiner vorhanden war, bzw. ein vorhandener Rahmen geloescht.
     */
    frb = XtVaCreateManagedWidget("frameonoff", xmPushButtonWidgetClass, formw,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, px_f_on,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, sep,
            XmNtopOffset, TOPOFF,
            NULL);
#else
frb=sep; /* wegen attachment fue quit */
#endif
    
    /* Button zum Beenden des Programms */
    pbq = XtVaCreateManagedWidget("Quit", xmPushButtonWidgetClass, formw,
            XmNleftAttachment, XmATTACH_FORM,
            XmNleftOffset, LEFTOFF,
            XmNrightAttachment, XmATTACH_FORM,
            XmNrightOffset, RIGHTOFF,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, frb,
            XmNtopOffset, TOPOFF,
            NULL);

    /* Callback-Prozeduren an die XmNactivateCallback-Liste der Buttons heften */ 
    XtAddCallback(pbc,  XmNactivateCallback, (XtCallbackProc)centerCB, (XtPointer)NULL);
    XtAddCallback(pbl,  XmNactivateCallback, (XtCallbackProc)pPageCB,  (XtPointer)1);
    XtAddCallback(pbr,  XmNactivateCallback, (XtCallbackProc)nPageCB,  (XtPointer)1);
    XtAddCallback(pbq,  XmNactivateCallback, (XtCallbackProc)exitCB, (XtPointer)NULL);
    XtAddCallback(pbu,  XmNactivateCallback, (XtCallbackProc)updateCB, (XtPointer)1);
    XtAddCallback(textw,XmNactivateCallback, (XtCallbackProc)goPageCB, (XtPointer)1);
#ifdef FRAME
    XtAddCallback(frb,  XmNactivateCallback, (XtCallbackProc)frameCB, (XtPointer)NULL); 
#endif    
}


/*
 * Diese Prozedur setzt die Werte des Sliders eines Scrollbars. Der Slider wird in die 
 * Mitte der Scrolling-Region gesetzt. Increment wird verringern, um in kleineren Schritte 
 * den Ausschnitt einer Seite waehlen zu koennen. 
 */
static void setslider(Widget scrollbar)
{
    int     pos, size, inc, pginc, max, min;
    /* Momentane Werte des "scrollbars" holen */
    XtVaGetValues(scrollbar, XmNmaximum, &max, XmNminimum, &min,
            XmNvalue, &pos, XmNsliderSize, &size,
            XmNincrement, &inc, XmNpageIncrement, &pginc,
            NULL);

    pos = (max - size) / 2;              /* Slider zentrieren */
    inc /= 3;                            /* Increment dritteln */
    if (inc < 0)
        inc = 1;
    XmScrollBarSetValues(scrollbar, pos, size, inc, pginc, TRUE);       /* Neue Werte setzen */
}

/*
 * Diese Prozedur setzt in allen Windows der Widgets den Mauszeiger auf Wartezustand 
 */
static void cursorbusy(void)
{
    if(PageIsOpen)
    {
        XDefineCursor(theDisplay, XtWindow(sW), cursor);
        XDefineCursor(theDisplay, XtWindow(scale), cursor);
        XDefineCursor(theDisplay, XtWindow(fw2), cursor);
        XFlush(theDisplay); /* Anfragen an X-Server sofort abschicken ! */
    }
}

/* 
 * Diese Prozedur setzt in allen Windows der Widgets den Mauszeiger zurueck in Normalzustand 
 */
void cursornormal(void)
{  
    if(PageIsOpen)
    {
        XUndefineCursor(theDisplay, XtWindow(sW));
        XUndefineCursor(theDisplay, XtWindow(scale));
        XUndefineCursor(theDisplay, XtWindow(fw2));
        XFlush(theDisplay); /* Anfragen an X-Server sofort abschicken ! */
    }
}

/*
 * Zerstoerung des Hauptformulars und damit aller Kind-Widgets
 * Freigabe des Speicherplatzes fuer die Filter. 
 * Freigabe von Pixmaps und Cursor (Ressourcen, die der X-Server verwaltet)
 */
static void exitDviOutWindow(void)
{
    nodestroy = 1;

    if (PageIsOpen)
    {
        kill_filter();                           /* Speicherplatz fuer die Filter freigeben */
        exitColors(dispShell);                   /* Farben "freigeben" -> vgl. exitColors() */      
        dvi_clean();                              
        exitImage();                             /* XImage zerstoeren                       */
        if(pmon)
 		pmon=0;  			 /*              */
        XFreePixmap(theDisplay, px_center);      /* Piktogramm-Pixmaps freigeben            */
        XFreePixmap(theDisplay, px_right);
        XFreePixmap(theDisplay, px_left);
        XFreePixmap(theDisplay, px_update);
#ifdef FRAME
        XFreePixmap(theDisplay, px_f_on);
        XFreePixmap(theDisplay, px_f_off);
#endif
        XFreeCursor(theDisplay, cursor);         /* Cursor freigeben                        */
        XtDestroyWidget(dispShell);              /* Hauptformular dispShell zerstoeren      */
        PageIsOpen = 0;
    }

}
/*
 * In dieser Funktion wird das XImage "theImage" vom Format ZPixmap  
 * erzeugt. Dessen Breite und Hoehe sind eff_width bzw. eff_height (setzizes()).
 */
int     initImage(void)
{
    int     planes;
    planes = DisplayPlanes(theDisplay, theScreen);    /* Tiefe des Displays */   
    
    /** Freigeben der XImage-Daten zur Sicherheit, falls noch nicht durch XDestroyImage geschehen
     */
    if (imagedata)
    {
        free(imagedata);
        imagedata = NULL;
    }

    /** Erzeugung des XImage 
    */
    if ((theImage = XCreateImage(theDisplay, DefaultVisual(theDisplay, theScreen), planes,
                            ZPixmap, 0, NULL, eff_width, eff_height, 16, 0)) == NULL)
    {
        printf("ERROR in initImage(XCreateImage)\n");
        return (1);
    }

    /** XImage-Typ "imagetype" setzen 
    */
    
    if (theImage -> byte_order == MSBFirst)
        if (theImage -> bits_per_pixel == 4)
            imagetype = IMG_MSB_4;                    /* MSBFirst-bit-order; 4 Bits-per-Pixel */
        else
        {
            if (theImage -> bits_per_pixel == 8)
                imagetype = IMG_MSB_8;                /* MSBFirst-bit-order; 8 Bits-per-Pixel */
        }
    else
        imagetype = IMG_OTHER;                        /* Anderer Typ                          */

/*
	Truecolor Support
*/
    if (theImage -> bits_per_pixel == 16)
    {
      imagetype = IMG_16BPP;
    }
    if (theImage -> bits_per_pixel == 24)
    {
      imagetype = IMG_24BPP;
    }
    if (theImage -> bits_per_pixel == 32)
    {
      imagetype = IMG_32BPP;
    }
//    printf(" %i\n", theImage -> bits_per_pixel );

    /** Speicher fuer XImage-Daten alloziieren 
    */
//    bytes = (size_t) theImage -> height * theImage -> width
//                     * (theImage -> bits_per_pixel/8);   
    bytes = (size_t) theImage-> bytes_per_line * theImage -> height;
    if ((imagedata = (byte *) malloc(bytes)) == NULL)
    {
        printf("ERROR in initImage(malloc)\n");
        return (2);
    }
    theImage->data = (char *)imagedata;                      /* Zeiger auf XImage-Daten             */

    pmon=1;
    clr_Img_Pix();                                    /* Loeschen von XImage         	      */
    return (0);
}

/*
 * Loeschen des XImage "theImage" je nach "imagetype" mit memset() bzw. clr_other()
 */
void    clr_Img_Pix(void)
{
    /* XImage loeschen */
    switch  (imagetype)
    {
        case IMG_MSB_4:           /* 4 bits_per_pixel   */
             memset(imagedata, 
                    (int) (WhitePixelOfScreen(XtScreen(graphicW)) | 
                    (WhitePixelOfScreen(XtScreen(graphicW)) << 4)), bytes);     
             break;
        case IMG_MSB_8:           /* 8 bits_per_pixel   */
             memset(imagedata, (int) WhitePixelOfScreen(XtScreen(graphicW)), bytes);
             break;
        case IMG_OTHER:           /* Anderer XImage-Typ */
             clr_other();
             break;
        case IMG_16BPP:           /* Anderer XImage-Typ */
             memset(imagedata, (int) 0xff , bytes);
             break;
        case IMG_24BPP:           /* Anderer XImage-Typ */
             memset(imagedata, (int) 0xff , bytes);
             break;
        case IMG_32BPP:           /* Anderer XImage-Typ */
             memset(imagedata, (int) 0xff , bytes);
             break;
    }

    
}

/* Loeschen des XImages "theImage" falls imagetype=IMG_OTHER  */
void    clr_other(void)
{
    short   iy, ix;
    byte   *dest = NULL;
    for (ix = 0; ix < theImage -> width; ix++)
        whitepoint(theImage, 0, ix);             /* Erste Linie weiss setzen */
    for (dest = imagedata + theImage->bytes_per_line, iy = 1; 
                       iy < theImage -> height; iy++, dest += theImage->bytes_per_line)
                       /* Erste Linie auf restliche Linien kopieren */
        memcpy(dest, imagedata, theImage->bytes_per_line);
}

/*
 * Setzen eines weissen Punktes im XImage "theImage" 
 * lpy Zeile, lpx Spalte
 */
void    whitepoint(XImage *theImage, short lpy, short lpx)
{
    XPutPixel(theImage, lpx, lpy, WhitePixelOfScreen(XtScreen(graphicW)));
}
/* Vergleiche whitepoint */
void    blackpoint(XImage *theImage, short lpy, short lpx)
{
    XPutPixel(theImage, lpx, lpy,BlackPixelOfScreen(XtScreen(graphicW)) );
}
/* Zerstoeren des XImage */
void exitImage(void)
{

    if(theImage != NULL)
    {
        XDestroyImage(theImage);         /* Zerstoeren */
//        XFree(theImage->data);
        XFlush(theDisplay);
    }
    theImage = NULL;
    imagedata = NULL;                    /* Speicherplatz fuer die XImage-Daten wird
                                            bei der Zerstoerung des XImage freigegeben */
}

/*
 * Mit dieser Prozedur wird das XImage "theImage" zentriert auf das Window kopiert. 
 * Ein Rahmen um die aktuell sichtbare Seite wird in Abhaengigkeit vom Flag drawframe gezeichnet.
 */
void x2pix(void)
{       
    int     w2draw, h2draw, off_width, off_height;
    w2draw = (dst_width * u_shrinkfactor) / SRC;     /* zu kopierende Breite */
    h2draw = (dst_height * u_shrinkfactor) / SRC;    /* zu kopierende Hoehe  */
    off_width = (eff_width - w2draw) / 2;            /* vertikaler Offset    */
    off_height = (eff_height - h2draw) / 2;          /* horizontaler Offset  */
    /* XImage auf Window kopieren */
			
    XPutImage(theDisplay, XtWindow(graphicW), theGC, theImage, 0, 0, off_width, off_height,
              w2draw, h2draw);
#ifdef FRAME
    /* Schwarzen Rahmen zeichen */
    if(drawframe==TRUE)
    {
        XSetForeground(theDisplay, theGC, BlackPixelOfScreen(XtScreen(graphicW)));
        XDrawRectangle(theDisplay,XtWindow(graphicW) , theGC, off_width, off_height, 
                       w2draw - 1, h2draw - 1);    
    }                 
#endif
}

/*
 * Das ganze XImage wird hier auf das Fenster des DrawingArea-Widgets kopiert.
 */
static void    redraw(void)
{
	x2pix();            
}

/*
 * Es werden read-only Colorcells der DefaultColormap alloziiert. Die Anzahl ist durch die 
 * Zahl der unterstuetzten Bitplanes festgelegt, und zus"atlich durch den Compiler-Schalter 
 * ENDCOL nach oben beschraenkt.
 * Es werden Graustufen alloziiert, die von weiss (0xffff) nach schwarz (0x0000) verlaufen.
 */
void    initColors(Widget widget)
{
    Colormap cmap = 0; 
    unsigned long i;
    unsigned short pixel = 0xffff, step, out_col, f_col;
    XVisualInfo *xvi,template;
    int num_infos;
  
    template.screen = XDefaultScreen( theDisplay );
    template.visualid = XVisualIDFromVisual( DefaultVisual( theDisplay, DefaultScreen(theDisplay)) );

    xvi = XGetVisualInfo( theDisplay, VisualIDMask | VisualScreenMask, &template,
    &num_infos);

  
    colortype = 0;
    if (xvi->class == TrueColor) colortype=1;
    if (xvi->class == DirectColor) colortype=1;

    if (colortype == 2)
    { 
      out_col = num_colors = 32;
      step = 0xffff / (out_col);                 /* Schrittweite von einem Grauwert zum anderen */
    }
 
    if (colortype == 0)
    {
      cmap = DefaultColormapOfScreen(XtScreen(widget));
    
      /* maximale Zahl unterschiedlicher Farbeintraege 
       */
      num_colors = 1L << DisplayPlanes(theDisplay, theScreen);
      if (ENDCOL > num_colors)
          out_col = num_colors;         /* resultierende Zahl der Farben ist maximal num_colors */
      else
          out_col = ENDCOL;
      f_col = num_colors / (out_col);
      step = 0xffff / (out_col);                 /* Schrittweite von einem Grauwert zum anderen */
      for (i = 0; i < num_colors; i++)
        {
          col[i].red = col[i].green = col[i].blue = pixel; /* RGB-Anteile bei Graustufen gleich */
          if(!XAllocColor(theDisplay, cmap, &col[i]))      /* Farbzelle alloziieren             */
             {printf("Less Colors !\n");return;}
          if (i % f_col == 0)  /* Ist schon bei i==0 erfuellt */                                          
              pixel -= step;
        }
    }
    else
    {
      shift_r = shift_g = shift_b = 0;
      num_r = xvi->red_mask;
      while ( (num_r & 1) != 1)
      {
        num_r >>= 1;
        shift_r++;
      }
      num_g = xvi->green_mask;
      while ( (num_g & 1) != 1)
      {
        num_g >>= 1;
        shift_g++;
      }
      num_b = xvi->blue_mask;
      while ( (num_b & 1) != 1)
      {
        num_b >>= 1;
        shift_b++;
      }
      num_colors = 256;
      for (i = 0; i < num_colors; i++)
      {
        col[i].red = col[i].green = col[i].blue = (num_colors-i) << 8; 
      }
    }
    
}

/* ""Freigabe" der Farbzellen */
void exitColors(Widget widget)
{
    /* Read-Only Colorcells werden bei Programmende automatisch "freigegeben". Im Programm 
     * duerfen sie nicht freigegeben werden, da sie mit anderen Clients geteilt werden
     *  (read-only!!!)       
     * XFreeColors(theDisplay, DefaultColormapOfScreen(XtScreen(widget)),
     *              col,num_colors,DisplayPlanes(theDisplay, theScreen));
     */ 
}

/*
 * Diese Prozedur startet die Vergroesserungs- bzw.Verkleinerungsprozeduren unter
 * Beachtung des Typs des XImage. Vorher wird das XImage geloescht.
 * Welches Verfahren Verwendung findet, hat der Benutzer ueber Optionen eingestellt.
 * Quickexpand, Quickshrink heissen die zugehoerigen Flags. Die Ausgabe-Prozedur wird
 * anhand des XImage-Typs gewaehlt. 
 */
void shrink()
{
    clr_Img_Pix();                     /* Loeschen des XImage                    */     
    srcbmp.frame_buffer=frame_buffer;  /* Quell-Bitmap festlegen                 */
    srcbmp.frame_width=frame_width;    /* hier wird die interpretierte Dvi-Seite */
    srcbmp.frame_height=frame_height;  /* in die Struktur SrcBmp gepackt         */
            
    /* Je nach XImage-Typ und Optionen wird hier die passende 
     * Verkleinerungs- bzw. Vergroesserungprozeduraufgerufen 
     */  
    
if (u_shrinkfactor > SRC)              /* Vergroesserung                    */
{
    if (Quickexpand)                   /* Scanline (Quickexpand = 1)        */
    switch (imagetype)                 /* Unterscheiden nach XImage-Typen   */
    {                                       
        /* schnelle Vergr. fuer XImage mit bits_per_pixel == 4 
         */
        case IMG_MSB_4: img4expand(srcbmp, theImage,
                                   BlackPixelOfScreen(XtScreen(graphicW)),u_shrinkfactor);
             break;
        /* schnelle Vergr. fuer XImage mit bits_per_pixel == 8
         */ 
        case IMG_MSB_8: fastexpand(srcbmp, theImage,blackpoint,u_shrinkfactor); 
             break;
        /* schnelle Vergr. fuer belibiges XImage 
         */
        case IMG_OTHER: fastexpand(srcbmp, theImage,blackpoint,u_shrinkfactor);                                           
             break;
        case IMG_16BPP: fastexpand(srcbmp, theImage,blackpoint,u_shrinkfactor);                                           
             break;
        case IMG_24BPP: fastexpand(srcbmp, theImage,blackpoint,u_shrinkfactor);                                           
             break;
        case IMG_32BPP: fastexpand(srcbmp, theImage,blackpoint,u_shrinkfactor);                                           
             break;
    }    
    else 
    switch (imagetype)                  /* Convolution (Quickexpand = 0)    */
    {
        /* XImage mit bits_per_pixel == 4
         */
        case IMG_MSB_4: 
             /* Skalierungswert dst ist gerade */
             if ((u_shrinkfactor % 2) == 0)
                 do_shrink(srcbmp, theImage, OutGerade, u_shrinkfactor, col, num_colors);
             else
                 do_shrink(srcbmp, theImage, OutUngerade, u_shrinkfactor, col, num_colors);
             break;
        /* XImage mit bits_per_pixel == 8
         */     
        case IMG_MSB_8:
             do_shrink(srcbmp, theImage, Out8bpp, u_shrinkfactor, col, num_colors);
             break;
        /* beliebiges XImage 
         */             
        case IMG_OTHER:
             do_shrink(srcbmp, theImage, OutXput, u_shrinkfactor, col, num_colors);
             break;
        case IMG_16BPP:
             do_shrink(srcbmp, theImage, Out16bpp, u_shrinkfactor, col, num_colors);
             break;
        case IMG_24BPP:
             do_shrink(srcbmp, theImage, Out24bpp, u_shrinkfactor, col, num_colors);
             break;
        case IMG_32BPP:
             do_shrink(srcbmp, theImage, Out32bpp, u_shrinkfactor, col, num_colors);
             break;
    }    
}    
else  /* Verkleinerung */  
{
    if(Quickshrink)                    /* Scanline (Quickexpand = 1)        */      
        fastshrink(srcbmp, theImage,blackpoint,u_shrinkfactor);
    else    
    switch (imagetype)
    {
        /* XImage mit bits_per_pixel == 4
         */ 
        case IMG_MSB_4:   
             if ((u_shrinkfactor % 2) == 0)  
                 do_shrink(srcbmp, theImage,OutGerade,u_shrinkfactor, col, num_colors);       
             else
                 do_shrink(srcbmp, theImage,OutUngerade,u_shrinkfactor, col, num_colors);     
             break;
        /* XImage mit bits_per_pixel == 8
         */
        case IMG_MSB_8:        
             do_shrink(srcbmp, theImage,Out8bpp,u_shrinkfactor, col, num_colors);     
             break;
        /* beliebiges XImage 
         */             
        case IMG_OTHER:
             do_shrink(srcbmp, theImage,OutXput,u_shrinkfactor, col, num_colors);     
	     break;
        case IMG_16BPP:
             do_shrink(srcbmp, theImage,Out16bpp,u_shrinkfactor, col, num_colors);     
             break;
        case IMG_24BPP:
             do_shrink(srcbmp, theImage,Out24bpp,u_shrinkfactor, col, num_colors);     
             break;
        case IMG_32BPP:
             do_shrink(srcbmp, theImage,Out32bpp,u_shrinkfactor, col, num_colors);     
             break;
    }   
}               
}

/* Berechnet den Schnitt von Intervall [le,re] mit [a,b] */
double  schnitt(double le, double re, double a, double b)
{
    double  lg = 0.0, rg = 0.0;
    /* Parametercheck */
    if (le > re || a > b)
    {
        printf("ERROR in SCHNITT\n");
        return (-1);
    }

    if ((le >= b) || (re <= a))          /* leerer Schnitt    */
    {
        lg = rg = 0.0;
    }
    else
    {
        lg = le, rg = re;
        if (le < a)
            lg = a;                      /* Kante abschneiden */
        if (re > b)
            rg = b;                      /* Kante abschneiden */
    }
    return (rg - lg);
}

/*************************************************************************************************
 *                                                                                               *
 *         Callback-Prozeduren und Event-Handler f"ur Widgets des zweiten Widget-Baumes          *
 *                                                                                               * 
 *************************************************************************************************
 */

/* Diese ExposeCallback-Prozedur haengt an der DrawingArea (Expose-Event), 
 * und wird in den folgenden Faellen direkt (von anderen Prozeduren, oder Expose-Event)
 * oder indirekt aufgerufen:
 * a) Eine neue Seite soll angezeigt oder fuer die aktuelle ein Update gemacht werden
 * b) Eine Seite soll skaliert und angezeigt werden
 * c) Ein anderer Ausschnitt der aktuellen Seite soll sichtbar werden (Expose-Event)
 * d) Es muss der Inhalt neu gezeichnet werden, da das Fenster des DrawingArea-Widgets
 *    von anderen Anwendungen oder z.B. vom Popup-Menue ueberlappt wurde. (Expose-Event)
 * In den letzten beiden Faellen reicht es aus, nur die betreffenden Ausschnitte
 * des XImage in das Fenster des DrawingArea-Widgets zu kopieren.
 */

static void exposeCB(Widget widget, XtPointer clientDaten, XmDrawingAreaCallbackStruct *cbs)
{    
    int w2draw, h2draw, off_width, off_height,ux,uy,lex,rex,oey,uey;
    if(theImage != NULL)
    {  
        if (o_shrinkfactor != u_shrinkfactor) /* Skalierungsfaktor geaendert ?           */
        {   
            cursorbusy();                     /* Cursor auf Uhr umschalten               */
            shrink();                         /* Skalierung der aktuellen Seite          */
            XClearWindow(XtDisplay(widget), XtWindow(widget));      
            redraw();                         /* Neuberechnete Seite auf Window kopieren */
        }
        else
        {
            if (o_page != last_page || doexpose == 1) /* Neue Seitennummer oder Update ? */
            {
                cursorbusy();                         /* Cursor auf Uhr umschalten       */
                shrink();                             /* Skalierung der neuen Seite      */      
                XClearWindow(XtDisplay(widget), XtWindow(widget));            
                if (doexpose == 1)
                {          
                    doexpose = 0;
                    redraw();                         /* Seite auf Window kopieren       */
                }
            }
            else
            {
            	#define TEST
            	#define max(a,b) ((a>b)?a:b)
            	#define min(a,b) ((a>b)?b:a)
            	#ifdef TEST   
                /* Fenster wurde  durch andere Anwendungen ueberlappt, oder ein neuer 
                 * Ausschnitt des Ausgabefensters soll sichtbar werden. Nur der 
                 * tatsaechlich ueberdeckte bzw. sichtbar werdende Teil wird neu vom 
                 * XImage in das Fenster des DrawingArea-Widget kopiert.
                 */  
                {
		w2draw = (dst_width * u_shrinkfactor) / SRC;     /* zu kopierende Breite */
    		h2draw = (dst_height * u_shrinkfactor) / SRC;    /* zu kopierende Hoehe  */
    		off_width = (eff_width - w2draw) / 2;            /* vertikaler Offset    */
    		off_height = (eff_height - h2draw) / 2;          /* horizontaler Offset  */
 		/* XImage auf Window kopieren 
 		 * Ueberlappung mit Textbereich schneiden
 		 * (lex,oey) linke obere Ecke, (rex,uey) rechte untere  Ecke
 		 */
 		
 		lex=max(cbs->event->xexpose.x,off_width);	
  		rex=min(cbs->event->xexpose.x+cbs->event->xexpose.width,off_width+w2draw);
    		oey=max(cbs->event->xexpose.y,off_height);
  		uey=min(cbs->event->xexpose.y+cbs->event->xexpose.height,off_height+h2draw);	
  		/* Im XImage befindet sich der Textteil immer ab der linken oberen
  		 * Ecke. Deshalb muss hier eine Translation stattfinden 
  		 * Die cbs->event->struktur gibt x,y immer in Bezug auf die ganze
  		 * Drawingarea an 
  		 */
  		ux=lex-off_width;
  		uy=oey-off_height;
	
  		if(lex>=rex||oey>=uey)
			; /*printf("NO INTERSECTION\n");*/
		else  		
      		{
      			XPutImage(theDisplay, XtWindow(graphicW), theGC, theImage, 
    			ux, uy,		/* Quelle */
    			lex, oey,	/* Ziel	  */
    			rex-lex,        /* Breite */
      			uey-oey);       /* Hoehe  */      			
      			#ifdef FRAME
      			if(drawframe==TRUE)
    			{
	        		XSetForeground(theDisplay, theGC, 
	        			BlackPixelOfScreen(XtScreen(graphicW)));
        			XDrawRectangle(theDisplay,XtWindow(graphicW) , theGC,
        			 	off_width, off_height, w2draw-1, h2draw-1);    
    			}
    			#endif
      		}
     		} 
     		#else                  
		redraw(); 
		#endif  		                                
            }
        }
        o_shrinkfactor = u_shrinkfactor;
        o_page = last_page;
    }
    else   
        XClearWindow(XtDisplay(widget), XtWindow(widget));      
    cursornormal();                                  /* Cursor auf Normalzustand setzen  */
}


/*
 * Diese Prozedur stellt einen Eventhandler fuer die DarwingArea dar.
 * Aufgabe: Beim Druecken der rechten Maustaste erscheint Popup-Menue im Fenster 
 *          Wird die linke Maustaste gedrueckt, angehalten und bewegt, und die Taste
 *          wieder losgelassen, so wird aus der Distanz (Druecken --- Loslassen)
 *          die DrawingArea unter dem ScrolledWindow verschoben.
 */
static void moveImageCB(Widget w, XtPointer client_data, XEvent * e, Boolean * ctdp)
{
    static int diff_x, diff_y;
    int     pos, size, inc, pginc;
    int     max, min;
    switch (e -> type)
    {
        case ButtonPress:                                 /* Taste gedrueckt       */ 
             if (e -> xbutton.button == 1)
             {
                Press_x = e -> xbutton.x;                 /* Startpunkt  x         */
                Press_y = e -> xbutton.y;                 /* Startpunkt  y         */
             }
             else
                PostPopupMenu(PopupMenuW, &e -> xbutton); /* Popup-Menue behandeln */ 
             break;

        case MotionNotify:
             diff_x = e -> xbutton.x - Press_x;            /* Differenz bestimmen   */
             diff_y = e -> xbutton.y - Press_y;
             break;

        case ButtonRelease:                                /* Maustaste losgelassen */
             if (diff_y != 0)
             {
                XtVaGetValues(s_bar_ver, XmNmaximum, &max, XmNminimum, &min,
                        XmNvalue, &pos, XmNsliderSize, &size,
                        XmNincrement, &inc, XmNpageIncrement, &pginc,
                        NULL);

                pos -= diff_y;
                if (pos < min)
                    pos = min;
                if (pos > (max - size))
                    pos = max - size;
                if (pos >= min && pos <= (max - size))     /* Vertikalen Scrollbar des 
                                                            * ScrolledWindow verschieben */
                    XmScrollBarSetValues(s_bar_ver, pos, size, inc, pginc, TRUE);
             }
             if (diff_x != 0)
             {
                XtVaGetValues(s_bar_hor, XmNmaximum, &max, XmNminimum, &min,
                        XmNvalue, &pos, XmNsliderSize, &size,
                        XmNincrement, &inc, XmNpageIncrement, &pginc,
                        NULL);

                pos -= diff_x;
                if (pos < min)
                    pos = min;
                if (pos > (max - size))
                    pos = max - size;                      /* Horizontalen Scrollbar des 
                                                            * ScrolledWindow verschieben */
                XmScrollBarSetValues(s_bar_hor, pos, size, inc, pginc, TRUE);
             }
             break;
    }
}
/*
 * Diese Callback-Prozedur fuehrt unter Beruecksichtigung neu eingestellter Optionen
 * ein Update der Dvi-Seite(n) durch. Sie haengt z.B. am Update-Button des Funktionsbereichs
 */
static void updateCB(Widget w, int makeexp, XtPointer callData)
{
    dvi_clean();                                 /* Aufraeumarbeiten */ 
    cursorbusy();
    exitImage();
    if(pmon)
        pmon=0;
    XFlush(theDisplay);
    if (makeexp == 1)
        doexpose = 1;
    else
        doexpose = 0;
    set_sizes();
    if (shipout == NULL)
    {
        if (last_page <= 0)
            last_page = 1;
        if( !setjmp( halt_jmp ) )  
            print_pages(last_page, last_page, 1);    /* Seite neu berechnen und Darstellen */
    }
    cursornormal();
}

/* Diese Callback-Prozedur wird aufgerufen, wenn die aktuelle Dvi-Datei komplett
 * neu geladen werden soll, und dazu der betreffende Menue-Punkt angewaehlt wurde.
 */
static void reloadCB(Widget widget, XtPointer clientData, XtPointer callData)
{
    if(dvi_name != NULL)
    {
        exitDviOutWindow();        /* Ausgabebereich schliessen          */
        u_shrinkfactor = SRC;
        o_shrinkfactor = 0;
        last_page = 1;
        if (shipout == NULL)
            print_pages(1, 1, 1);  /* Datei neu laden und Seite aufbauen */
    }
}

/* Diese Callback-Prozedur wird aufgerufen, sobald sich der Wert in der Skala shrinkscale 
 * zur Einstellung der Skalierungsfaktors aendert. Der Slider wird nachjustiert und mit 
 * dem Aufruf von exposeCB() die Skalierung und Darstellung der Seite ausgeloest.
 */
static void scaleCB(Widget scale, int dummy, XmScaleCallbackStruct * callback)
{
    if(callback -> reason == XmCR_VALUE_CHANGED)
    {
#if NUMTICKS > 32
         u_shrinkfactor = (UTYPE) callback -> value + SRC;
#else
         u_shrinkfactor = (UTYPE) callback -> value;
#endif
        XmScaleSetValue(scale, callback -> value);                  /* Slider nachjustieren */
        
        if (u_shrinkfactor != o_shrinkfactor)    
            exposeCB(graphicW, (XtPointer) NULL, (XtPointer) NULL); /* Skalierung und 
                                                                       Darstellung der Seite */     
        o_shrinkfactor = u_shrinkfactor; 
    }
}

/* Diese Callback-Prozedur wird aufgerufen, wenn der Benutzer die Seite zentrieren will.
 * Dazu werden die Scrollbars des ScrolledWindow explizit gesetzt. 
 */
static void centerCB(Widget widget, XtPointer clientDaten, XmPushButtonCallbackStruct * cbs)
{
    setslider(s_bar_ver);        /* Vertikalen Scrollbar zentrieren   */
    setslider(s_bar_hor);        /* Horizontalen Scrollbar zentrieren */
}

/* 
 * Diese Callback-Prozedur wird aufgerufen, wenn der Benutzer einen Rahmen 
 * um die Seite anzeigen oder loeschen will. Der zugehoerige Button wechselt
 * sein Piktogramm, um anzuzeigen ob der Rahmen gezeichnet ist oder nicht.
*/
static void frameCB(Widget widget, XtPointer clientDaten, XmPushButtonCallbackStruct * cbs)
{
    int     w2draw, h2draw, off_width, off_height;
    w2draw = (dst_width * u_shrinkfactor) / SRC;  /* zu kopierende Breite */
    h2draw = (dst_height * u_shrinkfactor) / SRC; /* zu kopierende Hoehe  */
    off_width = (eff_width - w2draw) / 2;         /* vertikaler Offset    */
    off_height = (eff_height - h2draw) / 2;       /* horizontaler Offset  */
    
    if (!drawframe)
    {
        /* Piktogramm wechseln und Vordergrundfarbe auf Schwarz aendern*/
        XtVaSetValues(frb, XmNlabelPixmap, px_f_on, NULL);
        XSetForeground(theDisplay, theGC, BlackPixelOfScreen(XtScreen(graphicW)));
    }
    else
    {
        /* Piktogramm wechseln und Vordergrundfarbe auf Weiss aendern*/
        XtVaSetValues(frb, XmNlabelPixmap, px_f_off, NULL);
        XSetForeground(theDisplay, theGC, WhitePixelOfScreen(XtScreen(graphicW)));     
    }
    /* Rahmen in der aktuellen Vordergrundfarbe in das Window zeichnen 
     */
    if(pmon && dvi_info.valid)
    {
    	XDrawRectangle(theDisplay,XtWindow(graphicW) , theGC, off_width, off_height, 
                       w2draw - 1, h2draw - 1);    
    }
    drawframe = !drawframe;
}

/*
 * Diese Callback-Prozedur wird aufgerufen, wenn sich die Seitennummer
 * des Textfeldes "textfield" geaendert hat. Die Zahl wird kontrolliert
 * und die Seite mit print_pages() neu berechnet und angezeigt.
 */
static void goPageCB(Widget widget, int makeexp, XmAnyCallbackStruct * cbs)
{
    char   *input;
    int     pg = 0;
    input = XmTextGetString(widget);   /* Neue Seitennummer aus Textfeld lesen */
    pg = atoi(input);       
    if (pg < 1)                        /* Kontrolle und Korrektur              */
        pg = 1;
    if (pg > dvi_info.pages)
        pg = dvi_info.pages;

    /* Eventuell korrigierte Seitennummer ins Textfeld schreiben               */    
    XmTextFieldSetString(textw, itoa(pg));     
    if (pg != last_page)
    {
        if (makeexp == 1)
            doexpose = 1;
        else
            doexpose = 0;
        print_pages(pg, pg, 1);        /* Neue Seite berechnen und darstellen */
    }
}

/*
 * Diese Callback-Prozedur wird aufgerufen, falls der Benutzer auf die vorherige Seite 
 * blaettern will. Die neue Seitennummer wird als String in das Textfeld geschrieben. 
 * Der expl. Aufruf von goPageCB() startet die Berechnung und Darstellung der neuen Seite.
 */
static void pPageCB(Widget widget, int makeexp, XmPushButtonCallbackStruct * cbs)
{
    int     pP;
    char   *in;
    if (shipout == NULL)
    {
        in = XmTextGetString(textw);               /* Aktuelle Seitennummer lesen              */
        pP = atoi(in) - 1;                         /* Seitennummer erniedrigen                 */
        if (frame_valid && last_page && dvi_info.valid && pP >= 1)
        {
            XmTextFieldSetString(textw, itoa(pP)); /* Neue Seitennummer ins Textfeld schreiben */
            goPageCB(textw, makeexp, NULL);        /* Anzeige der Seite starten                */
        }
    }
}

/*
 * Diese Callback-Prozedur wird aufgerufen, falls der Benutzer auf die
 * naechste Seite blaettern will (ansonsten wie pPage()).
 */
static void nPageCB(Widget widget, int makeexp, XmPushButtonCallbackStruct * cbs)
{
    int     nP;
    char   *in;
    if (shipout == NULL)
    {
        in = XmTextGetString(textw);               /* Aktuelle Seitennummer lesen              */
        nP = atoi(in) + 1;                         /* Seitennummer erhoehen                    */
        if (frame_valid && last_page && dvi_info.valid && nP <= dvi_info.pages)
        {
            XmTextFieldSetString(textw, itoa(nP)); /* Neue Seitennummer ins Textfeld schreiben */
            goPageCB(textw, makeexp, NULL);        /* Anzeige der Seite starten                */
        }
    }

}

/*
 * Diese Callback-Prozedur wird aufgerufen, wenn der Benutzer das Popup-Menue  verwendet, um auf 
 * eine beliebige Seite zu wechseln. Die neue Seitennummer wird in das Textfeld geschrieben. 
 * Der expl. Aufruf von goPageCB() startet die Berechnung und Darstellung der neuen Seite.
 */
static void pageCB(char *string)         
{
    int     pg;
    char   *in;
    if (shipout == NULL)
    {
        pg = atoi(string);
        if (frame_valid && last_page && dvi_info.valid && pg <= dvi_info.pages)
        {
            XmTextFieldSetString(textw, itoa(pg)); /* Neue Seitennummer ins Textfeld schreiben */
            goPageCB(textw, 1, NULL);              /* Anzeige der Seite starten                */
        }
    }
}

/*
 * Dieser Eventhandler wird aufgerufen, falls der Mauszeiger wieder in das Fenster des 
 * Hauptformulars "mainForm" eintritt.
 * Die Dvi-Datei wird nachgeladen, falls sie neu uebersetzt wurde. 
 */
static void newCB(Widget widget, XtPointer clientData, XtPointer callData)
{
    struct stat newstatus;
    int new_last_page;    
    
    if(dvi_name!=NULL)
        stat(dvi_name,&newstatus);                 /* Status der Dvi-Datei    */
    else
        return;
    
    if(newstatus.st_mtime!=oldstatus.st_mtime)     /* Statusabfrage           */
    {
        oldstatus.st_mtime=newstatus.st_mtime;
        dvi_clean();                              
        exitImage();                               /* XImage zerstoeren       */          
        if (shipout == NULL)
        {   
            cursorbusy();  
            if( !setjmp( halt_jmp ) )  
            { 
                new_last_page= format_pages(last_page,last_page,1); /* Seiten neu formatieren */
                if(new_last_page==last_page)
                {    
                     updateCB(widget,1,NULL);                           
                }
                else
                {    
                     if(last_page > dvi_info.pages) last_page=dvi_info.pages;
                     if(last_page<0) last_page=1;                      
                     updateCB(widget,1,NULL);
                }                              
                XmTextFieldSetString(textw,itoa(last_page));
                cursornormal();
             }
             else
                 cursornormal();                
        }       
    }
}


/*
 * Diese Callback-Prozedur erledigt diverse Aufraeumarbeiten vor Verlassen des Programms
 * Sie haengt z.B. am Quit-Button
 */ 
static void exitCB(Widget widget, XtPointer clientDaten, XtPointer aufrufDaten)
{
    if(PageIsOpen)
       exitDviOutWindow();             /* Freigabe von Speicherplatz und Pixmaps 
                                        * Zerstoeren des Haupformulars und seiner Kinder */
    else
        dvi_clean();
    gr_destall();
    exit(0);
}

/*
 * Diese Prozedur wird aufgerufen, wenn der Benutzer ueber Alt F4 = Close die Wurzel des
 * zweiten Widget-Baumes zerstoert. Dadurch werden Aufraeumarbeiten erledigt
 */
static void destroyCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    if(nodestroy == 0)
        exitDviOutWindow();            /* Aufraeumarbeiten */
    nodestroy = 0;
}
