/*
 *  TEX Device Driver  ver 2.26-
 *  copyright(c) 1988,89 by TSG, 1990-93 by SHIMA
 *
 *  buf.c : to read 2-4 byte values
 */

#include <stdio.h>
#define _DEF_STDIO_H_
#include "dd.h"


int _get_int(BUFFER **buf_ptr)
{
	BUFFER *ptr;
	int	d;

	d = *(ptr = *buf_ptr);
	*buf_ptr += 2;
	if(d & 0x80) d |= ~0xff;
	return (d<<8)|ptr[1];
}

int _get_uint(BUFFER **buf_ptr)
{
	BUFFER *ptr;
	int	d;

	d = *(ptr = *buf_ptr);
	*buf_ptr += 2;
	return (d<<8)|ptr[1];
}

long _get_mid(BUFFER **buf_ptr)
{
	BUFFER *ptr;
	long d;

	d = *(ptr = *buf_ptr);
	*buf_ptr += 3;
	if(d & 0x80) d |= ~0xffL;
	return (d<<16)|(((ulong)(ptr[1]))<<8)|ptr[2];
}

long _get_long(BUFFER **buf_ptr)
{
	BUFFER *ptr;
	long	d;

	d = *(ptr = *buf_ptr);
	*buf_ptr += 4;
	if(d & 0x80) d |= ~0xffL;
	return (d<<24)|(((ulong)(ptr[1]))<<16)|(((ulong)(ptr[2]))<<8)|ptr[3];
}

/* end of file : buf.c */
